/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.management.VersionConstants;
import weblogic.management.provider.internal.ConfigReader;
import weblogic.management.provider.internal.ConfigReaderContext;
import weblogic.management.provider.internal.DescriptorManagerHelperContext;
import weblogic.management.upgrade.ConfigFileHelper;

public final class DescriptorManagerHelper {
    public static DescriptorManager getDescriptorManager(boolean bl) {
        if (bl) {
            return EDIT_SINGLETON.instance;
        }
        return READONLY_SINGLETON.instance;
    }

    public static Descriptor loadDescriptor(InputStream inputStream, DescriptorManagerHelperContext descriptorManagerHelperContext) throws IOException, XMLStreamException {
        DescriptorManager descriptorManager = DescriptorManagerHelper.getDescriptorManager(descriptorManagerHelperContext.isEditable());
        if (descriptorManagerHelperContext.isTransform()) {
            ConfigReaderContext configReaderContext = new ConfigReaderContext();
            ConfigReader configReader = new ConfigReader(inputStream, configReaderContext);
            Descriptor descriptor = descriptorManager.createDescriptor((XMLStreamReader)((Object)configReader), descriptorManagerHelperContext.getErrors(), descriptorManagerHelperContext.isValidate());
            if (configReader.isModified()) {
                descriptorManagerHelperContext.setTransformed(true);
            }
            return descriptor;
        }
        return descriptorManager.createDescriptor(inputStream, descriptorManagerHelperContext.getErrors(), descriptorManagerHelperContext.isValidate());
    }

    public static Descriptor loadDescriptor(String string, boolean bl, boolean bl2, List list) throws IOException, XMLStreamException {
        DescriptorManagerHelperContext descriptorManagerHelperContext = new DescriptorManagerHelperContext();
        descriptorManagerHelperContext.setEditable(bl);
        descriptorManagerHelperContext.setValidate(bl2);
        descriptorManagerHelperContext.setTransform(true);
        descriptorManagerHelperContext.setErrors(list);
        if (bl) {
            descriptorManagerHelperContext.setEProductionModeEnabled(ConfigFileHelper.getProductionModeEnabled() || Boolean.getBoolean("weblogic.ProductionModeEnabled"));
        } else {
            descriptorManagerHelperContext.setRProductionModeEnabled(ConfigFileHelper.getProductionModeEnabled() || Boolean.getBoolean("weblogic.ProductionModeEnabled"));
        }
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        return DescriptorManagerHelper.loadDescriptor(fileInputStream, descriptorManagerHelperContext);
    }

    public static void saveDescriptor(Descriptor descriptor, OutputStream outputStream) throws IOException {
        EDIT_SINGLETON.instance.writeDescriptorAsXML(descriptor, outputStream);
    }

    private static void setSchemaLocationIfNeeded(EditableDescriptorManager editableDescriptorManager) {
        String string = System.getProperty("weblogic.configuration.schema.location.replace");
        if (string != null) {
            editableDescriptorManager.setSchemaLocation(string);
        }
    }

    private static class EDIT_SINGLETON {
        static EditableDescriptorManager instance = new EditableDescriptorManager();

        private EDIT_SINGLETON() {
        }

        static {
            instance.setProductionMode(ConfigFileHelper.getProductionModeEnabled() || Boolean.getBoolean("weblogic.ProductionModeEnabled"));
            DescriptorManagerHelper.setSchemaLocationIfNeeded(EDIT_SINGLETON.instance);
            instance.addInitialNamespace("sec", "http://xmlns.oracle.com/weblogic/security");
            instance.addInitialNamespace("wls", "http://xmlns.oracle.com/weblogic/security/wls");
            for (int i = 0; i < VersionConstants.NAMESPACE_MAPPING.length; ++i) {
                instance.addNamespaceMapping(VersionConstants.NAMESPACE_MAPPING[i][0], VersionConstants.NAMESPACE_MAPPING[i][1]);
            }
        }
    }

    private static class READONLY_SINGLETON {
        static DescriptorManager instance = new DescriptorManager();

        private READONLY_SINGLETON() {
        }

        static {
            instance.setProductionMode(ConfigFileHelper.getProductionModeEnabled() || Boolean.getBoolean("weblogic.ProductionModeEnabled"));
            for (int i = 0; i < VersionConstants.NAMESPACE_MAPPING.length; ++i) {
                instance.addNamespaceMapping(VersionConstants.NAMESPACE_MAPPING[i][0], VersionConstants.NAMESPACE_MAPPING[i][1]);
            }
        }
    }
}

