/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.security.AccessController;
import weblogic.cluster.singleton.DomainMigrationHistory;
import weblogic.cluster.singleton.ServerMigrationRuntimeMBeanImpl;
import weblogic.cluster.singleton.ServiceMigrationRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.DomainAccessSettable;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.internal.DomainRuntimeMBeanImpl;
import weblogic.management.provider.internal.RegistrationManagerImpl;
import weblogic.management.runtime.AppRuntimeStateRuntimeMBean;
import weblogic.management.runtime.CoherenceServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.runtime.DeploymentManagerMBean;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.management.runtime.MigratableServiceCoordinatorRuntimeMBean;
import weblogic.management.runtime.MigrationDataRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerMigrationRuntimeMBean;
import weblogic.management.runtime.ServiceMigrationDataRuntimeMBean;
import weblogic.management.runtime.ServiceMigrationRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerLifeCycleService;

public class DomainAccessImpl
extends RegistrationManagerImpl
implements DomainAccess,
DomainAccessSettable {
    private final long activationTime = System.currentTimeMillis();
    private DeployerRuntimeMBean deployerRuntime;
    private DeploymentManagerMBean deploymentManager;
    private ServerLifeCycleService lifecycleService;
    private MigratableServiceCoordinatorRuntimeMBean serverMigrationCoordinator;
    private DomainRuntimeMBean domainRuntime;
    private DomainRuntimeServiceMBean domainRuntimeService;
    private AppRuntimeStateRuntimeMBean appRuntimeStateRuntime;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private DomainMigrationHistory domainMigrationHistory;

    DomainAccessImpl() {
    }

    void initializeDomainRuntimeMBean() {
        try {
            this.domainRuntime = new DomainRuntimeMBeanImpl();
        }
        catch (ManagementException managementException) {
            throw new Error(managementException);
        }
    }

    public AppRuntimeStateRuntimeMBean getAppRuntimeStateRuntime() {
        return this.appRuntimeStateRuntime;
    }

    public DeployerRuntimeMBean getDeployerRuntime() {
        return this.deployerRuntime;
    }

    public DeploymentManagerMBean getDeploymentManager() {
        return this.deploymentManager;
    }

    public ServerLifeCycleRuntimeMBean[] getServerLifecycleRuntimes() {
        return this.lifecycleService.getServerLifecycleRuntimes();
    }

    public ServerLifeCycleRuntimeMBean lookupServerLifecycleRuntime(String string) {
        if (this.lifecycleService == null) {
            return null;
        }
        return this.lifecycleService.lookupServerLifecycleRuntime(string);
    }

    public CoherenceServerLifeCycleRuntimeMBean[] getCoherenceServerLifecycleRuntimes() {
        return this.lifecycleService.getCoherenceServerLifecycleRuntimes();
    }

    public CoherenceServerLifeCycleRuntimeMBean lookupCoherenceServerLifecycleRuntime(String string) {
        if (this.lifecycleService == null) {
            return null;
        }
        return this.lifecycleService.lookupCoherenceServerLifecycleRuntime(string);
    }

    public DomainRuntimeMBean getDomainRuntime() {
        return this.domainRuntime;
    }

    public long getActivationTime() {
        return this.activationTime;
    }

    public String[] getClusters() {
        ClusterMBean[] clusterMBeanArray = ManagementService.getRuntimeAccess(kernelId).getDomain().getClusters();
        String[] stringArray = new String[clusterMBeanArray.length];
        for (int i = 0; i < clusterMBeanArray.length; ++i) {
            ClusterMBean clusterMBean = clusterMBeanArray[i];
            stringArray[i] = clusterMBean.getName();
        }
        return stringArray;
    }

    public MigratableServiceCoordinatorRuntimeMBean getMigratableServiceCoordinatorRuntime() {
        return this.serverMigrationCoordinator;
    }

    public DomainRuntimeServiceMBean getDomainRuntimeService() {
        return this.domainRuntimeService;
    }

    public void setDomainRuntimeService(DomainRuntimeServiceMBean domainRuntimeServiceMBean) {
        this.domainRuntimeService = domainRuntimeServiceMBean;
    }

    public MigrationDataRuntimeMBean[] getMigrationDataRuntimes() {
        return this.domainMigrationHistory.getMigrationDataRuntimes();
    }

    public ServiceMigrationDataRuntimeMBean[] getServiceMigrationDataRuntimes() {
        if (this.domainMigrationHistory != null) {
            return this.domainMigrationHistory.getServiceMigrationDataRuntimes();
        }
        return null;
    }

    public ServerMigrationRuntimeMBean ServerMigrationRuntime() {
        return ServerMigrationRuntimeMBeanImpl.getInstance();
    }

    public ServiceMigrationRuntimeMBean ServiceMigrationRuntime() {
        return ServiceMigrationRuntimeMBeanImpl.getInstance();
    }

    public void setDeployerRuntime(DeployerRuntimeMBean deployerRuntimeMBean) {
        if (this.deployerRuntime != null) {
            throw new Error("DeployerRuntime may only be initialized onced during during server startup");
        }
        this.deployerRuntime = deployerRuntimeMBean;
    }

    public void setDeploymentManager(DeploymentManagerMBean deploymentManagerMBean) {
        if (this.deploymentManager != null) {
            throw new Error("DeploymentManager may only be initialized onced during during server startup");
        }
        this.deploymentManager = deploymentManagerMBean;
    }

    public void setLifecycleService(ServerLifeCycleService serverLifeCycleService) {
        if (this.lifecycleService != null) {
            throw new Error("Lifecycle Service may only be initialized onced during during server startup");
        }
        this.lifecycleService = serverLifeCycleService;
    }

    public void setDomainMigrationHistory(DomainMigrationHistory domainMigrationHistory) {
        this.domainMigrationHistory = domainMigrationHistory;
    }

    public void setServerMigrationCoordinator(MigratableServiceCoordinatorRuntimeMBean migratableServiceCoordinatorRuntimeMBean) {
        if (this.serverMigrationCoordinator != null) {
            throw new Error("The ServerMigrationCoordinator may only be initialized onced during during server startup");
        }
        this.serverMigrationCoordinator = migratableServiceCoordinatorRuntimeMBean;
    }

    public void setAppRuntimeStateRuntime(AppRuntimeStateRuntimeMBean appRuntimeStateRuntimeMBean) {
        if (this.appRuntimeStateRuntime != null) {
            throw new Error("The AppRuntimeStateRuntime may only be initialized onced during during server startup");
        }
        this.appRuntimeStateRuntime = appRuntimeStateRuntimeMBean;
    }
}

