/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import com.bea.xml.XmlValidationError;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.deploy.internal.adminserver.DeploymentManager;
import weblogic.deploy.service.ChangeDescriptor;
import weblogic.deploy.service.Deployment;
import weblogic.deploy.service.DeploymentException;
import weblogic.deploy.service.DeploymentProvider;
import weblogic.deploy.service.DeploymentRequest;
import weblogic.deploy.service.DeploymentServiceCallbackHandlerV2;
import weblogic.deploy.service.FailureDescription;
import weblogic.deploy.service.InvalidCreateChangeDescriptorException;
import weblogic.deploy.service.RequiresRestartFailureDescription;
import weblogic.deploy.service.Version;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.deploy.service.internal.adminserver.AdminRequestImpl;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorDiff;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.DescriptorUpdateFailedException;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.descriptor.internal.DescriptorImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.ManagementRuntimeException;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.ConfigurationExtensionMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.deploy.DeploymentTaskRuntime;
import weblogic.management.internal.PendingDirectoryManager;
import weblogic.management.internal.Utils;
import weblogic.management.provider.ActivateTask;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.EditChangesValidationException;
import weblogic.management.provider.EditFailedException;
import weblogic.management.provider.EditNotEditorException;
import weblogic.management.provider.EditSaveChangesFailedException;
import weblogic.management.provider.EditWaitTimedOutException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.management.provider.beaninfo.BeanInfoAccess;
import weblogic.management.provider.internal.ActivateTaskImpl;
import weblogic.management.provider.internal.ChangeUtils;
import weblogic.management.provider.internal.ConfigBackup;
import weblogic.management.provider.internal.ConfigReader;
import weblogic.management.provider.internal.ConfigurationContextImpl;
import weblogic.management.provider.internal.ConfigurationDeployment;
import weblogic.management.provider.internal.ConfigurationVersion;
import weblogic.management.provider.internal.DescriptorHelper;
import weblogic.management.provider.internal.DescriptorInfo;
import weblogic.management.provider.internal.DescriptorInfoUtils;
import weblogic.management.provider.internal.DescriptorManagerHelper;
import weblogic.management.provider.internal.EditLockManager;
import weblogic.management.provider.internal.ExternalConfigReader;
import weblogic.management.provider.internal.RuntimeAccessDeploymentReceiverService;
import weblogic.management.runtime.DeploymentRequestTaskRuntimeMBean;
import weblogic.management.upgrade.ConfigFileHelper;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.version;

public class EditAccessImpl
implements EditAccess,
DeploymentServiceCallbackHandlerV2 {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationEdit");
    private static final String SCHEMA_VALIDATION_ENABLED_PROP = "weblogic.configuration.schemaValidationEnabled";
    private static final boolean schemaValidationEnabled = EditAccessImpl.getBooleanProperty("weblogic.configuration.schemaValidationEnabled", true);
    private static int CANCEL = 1;
    private static int DEPLOY = 2;
    private static int COMMIT = 3;
    private EditLockManager lockMgr;
    private PendingDirectoryManager pendingDirMgr;
    private Descriptor editTree;
    private DomainMBean editDomainMBean;
    private Descriptor currentTree;
    private DomainMBean currentDomainMBean;
    private static final AuthenticatedSubject kernelIdentity = EditAccessImpl.obtainKernelIdentity();
    private Map activationTasksByRequest = Collections.synchronizedMap(new HashMap());
    private WeakHashMap oldActivationTasks = new WeakHashMap();
    private boolean preparing = false;
    private long preparingTimeout;
    private long preparingId;
    private String rootDirectoryPrefix;
    private boolean pendingChange = false;
    private WeakHashMap temporaryTrees = new WeakHashMap();

    private EditAccessImpl() {
        boolean bl;
        this.pendingDirMgr = PendingDirectoryManager.getInstance();
        File[] fileArray = this.pendingDirMgr.getAllFiles();
        if (fileArray != null && fileArray.length > 0 && (bl = DescriptorHelper.recoverPendingDirectory(fileArray))) {
            this.setPendingChange(true);
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Changes are pending in pending directory");
            }
        }
        this.lockMgr = new EditLockManager();
        this.rootDirectoryPrefix = new File(DomainDir.getRootDir()).getPath() + File.separator;
        if (!ManagementService.getPropertyService(kernelIdentity).isAdminServer()) {
            return;
        }
        try {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Registering with deployment service");
            }
            ConfigurationVersion configurationVersion = new ConfigurationVersion(true);
            DeploymentService.getDeploymentService().register(configurationVersion, this);
            if (ManagementService.getPropertyService(kernelIdentity).isAdminServer()) {
                RuntimeAccessDeploymentReceiverService.getService().registerHandler();
            }
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception occurred registering with deploy service", (Throwable)exception);
            }
            ManagementLogger.logDeploymentRegistrationFailed((Throwable)exception);
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Created edit access impl " + this);
        }
    }

    public static void initialize() {
        EditAccessImpl editAccessImpl = new EditAccessImpl();
        ManagementServiceRestricted.setEditAccess(editAccessImpl);
    }

    public DomainMBean getDomainBean() throws EditNotEditorException, EditFailedException {
        this.checkEditLock();
        if (this.editDomainMBean == null) {
            this.ensureBeanTreeLoaded();
        }
        return this.editDomainMBean;
    }

    public DomainMBean getCurrentDomainBean() throws EditFailedException {
        if (this.currentDomainMBean == null) {
            this.ensureBeanTreeLoaded();
        }
        return this.currentDomainMBean;
    }

    private AuthenticatedSubject acquireLock(int n, int n2, boolean bl) throws EditWaitTimedOutException, EditFailedException {
        boolean bl2;
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelIdentity);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Starting edit session for " + authenticatedSubject);
        }
        if ((bl2 = this.lockMgr.getEditLock(authenticatedSubject, n, n2, bl)) && this.editDomainMBean != null) {
            try {
                this.undoUnsavedChanges();
            }
            catch (EditNotEditorException editNotEditorException) {
                throw new AssertionError((Object)"Should have edit lock");
            }
        }
        return authenticatedSubject;
    }

    public DomainMBean startEdit(int n, int n2) throws EditWaitTimedOutException, EditFailedException {
        return this.startEdit(n, n2, false);
    }

    public DomainMBean startEdit(int n, int n2, boolean bl) throws EditWaitTimedOutException, EditFailedException {
        this.acquireLock(n, n2, bl);
        if (this.editDomainMBean == null) {
            this.ensureBeanTreeLoaded();
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Loaded bean tree");
            }
            String string = version.getReleaseBuildVersion();
            this.editDomainMBean.setConfigurationVersion(string);
        }
        return this.editDomainMBean;
    }

    public void stopEdit() throws EditNotEditorException, EditFailedException {
        AuthenticatedSubject authenticatedSubject = this.checkEditLock();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Stopping edit session for " + authenticatedSubject);
        }
        try {
            this.undoUnsavedChanges();
        }
        catch (EditNotEditorException editNotEditorException) {
            throw new AssertionError((Object)"Should have edit lock");
        }
        this.lockMgr.releaseEditLock(authenticatedSubject);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Stopped edit session");
        }
    }

    public synchronized void cancelEdit() throws EditFailedException {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelIdentity);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Canceling edit session for " + authenticatedSubject);
        }
        if (this.isPreparing()) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Cancel outstanding requests");
            }
            ActivateTaskImpl activateTaskImpl = this.lookupTask(this.preparingId);
            this.resetPreparingInfo();
            this.rollbackCurrent();
            if (activateTaskImpl != null) {
                activateTaskImpl.setError((Exception)((Object)new EditFailedException("Request canceled by cancelEdit operation")));
                activateTaskImpl.setState(5);
            }
        }
        this.lockMgr.cancelEditLock(authenticatedSubject);
        try {
            this.undoUnsavedChanges();
        }
        catch (EditNotEditorException editNotEditorException) {
            throw new AssertionError((Object)"Should have edit lock");
        }
        catch (EditFailedException editFailedException) {
            this.lockMgr.releaseEditLock(authenticatedSubject);
            throw editFailedException;
        }
        this.lockMgr.releaseEditLock(authenticatedSubject);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Cancelled edit session");
        }
    }

    public synchronized Iterator getUnsavedChanges() throws EditNotEditorException, EditFailedException {
        AuthenticatedSubject authenticatedSubject = this.checkEditLock();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Getting iterator of unsaved changes for " + authenticatedSubject);
        }
        if (this.editTree == null) {
            throw new AssertionError((Object)"Edit bean tree is null");
        }
        Descriptor descriptor = null;
        try {
            DescriptorDiff descriptorDiff;
            ArrayList arrayList = new ArrayList();
            boolean bl = this.areAnyExternalTreesModified(this.editTree);
            if (!this.editTree.isModified() && !bl) {
                return arrayList.iterator();
            }
            descriptor = this.loadBeanTreeFromPending();
            this.addTemporaryTree(descriptor, "getUnsavedChanges");
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Loaded pending tree " + descriptor + " compute diff with edit tree " + this.editTree);
            }
            if ((descriptorDiff = descriptor.computeDiff(this.editTree)) != null) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Returning iterator of unsaved changes");
                }
                for (Object object : descriptorDiff) {
                    arrayList.add(object);
                    if (!debugLogger.isDebugEnabled()) continue;
                    debugLogger.debug("Beanupdate event " + object);
                }
            }
            if (!bl) {
                return arrayList.iterator();
            }
            Iterator iterator = DescriptorInfoUtils.getDescriptorInfos(this.editTree);
            while (iterator != null && iterator.hasNext()) {
                Object object;
                object = (DescriptorInfo)iterator.next();
                Descriptor descriptor2 = ((DescriptorInfo)object).getDescriptor();
                if (!descriptor2.isModified()) continue;
                Descriptor descriptor3 = this.loadExternalBeanTree((DescriptorInfo)object, true, false);
                this.addTemporaryTree(descriptor3, "getUnsavedChanges." + ((DescriptorInfo)object).getDescriptorClass());
                DescriptorDiff descriptorDiff2 = descriptor3.computeDiff(descriptor2);
                if (descriptorDiff2 == null) continue;
                Iterator iterator2 = descriptorDiff2.iterator();
                while (iterator2.hasNext()) {
                    arrayList.add(iterator2.next());
                }
            }
            return arrayList.iterator();
        }
        catch (EditFailedException editFailedException) {
            throw editFailedException;
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in computing diff: ", (Throwable)exception);
            }
            throw new EditFailedException(exception);
        }
    }

    public synchronized void undoUnsavedChanges() throws EditNotEditorException, EditFailedException {
        AuthenticatedSubject authenticatedSubject = this.checkEditLock();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Undoing unsaved changes for " + authenticatedSubject);
        }
        if (this.editTree == null) {
            return;
        }
        Descriptor descriptor = null;
        try {
            if (this.editTree.isModified()) {
                descriptor = this.loadBeanTreeFromPending();
                this.addTemporaryTree(descriptor, "undoUnsavedChanges");
                this.editTree.prepareUpdate(descriptor, false);
                this.editTree.activateUpdate();
            }
            Iterator iterator = DescriptorInfoUtils.getDescriptorInfos(this.editTree);
            while (iterator != null && iterator.hasNext()) {
                Descriptor descriptor2;
                DescriptorInfo descriptorInfo = (DescriptorInfo)iterator.next();
                Descriptor descriptor3 = descriptorInfo.getDescriptor();
                if (!descriptor3.isModified() || (descriptor2 = this.loadExternalBeanTree(descriptorInfo, true, true)) == null) continue;
                this.addTemporaryTree(descriptor2, "undoUnsavedChanges." + descriptorInfo.getDescriptorClass());
                descriptor3.prepareUpdate(descriptor2, false);
                descriptor3.activateUpdate();
            }
            DescriptorInfoUtils.removeAllDeletedDescriptorInfos(this.editTree);
        }
        catch (IOException iOException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception loading tree ", (Throwable)iOException);
            }
            throw new EditFailedException(iOException);
        }
        catch (EditFailedException editFailedException) {
            throw editFailedException;
        }
        catch (ManagementException managementException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception running processors ", (Throwable)managementException);
            }
            throw new EditFailedException(managementException);
        }
        catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in prepare/activate: ", (Throwable)descriptorUpdateRejectedException);
            }
            throw new EditFailedException(descriptorUpdateRejectedException);
        }
        catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception activating in undo unsaved ", (Throwable)descriptorUpdateFailedException);
            }
            throw new EditFailedException(descriptorUpdateFailedException);
        }
        this.removePendingUpdateTasks();
    }

    private void removePendingUpdateTasks() {
        DeploymentManager deploymentManager = DeploymentManager.getInstance(kernelIdentity);
        Collection collection = deploymentManager.getPendingDeploymentsForEditLockOwner();
        if (collection != null && collection.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (weblogic.deploy.internal.Deployment deployment : collection) {
                DeploymentTaskRuntime deploymentTaskRuntime = deployment.getDeploymentTaskRuntime();
                if (deploymentTaskRuntime == null || deploymentTaskRuntime.getState() != 0) continue;
                arrayList.add(deploymentTaskRuntime.getId());
                deploymentTaskRuntime.remove();
            }
            deploymentManager.removeDeploymentsForTasks(arrayList);
        }
    }

    private void backupConfig() {
        block2: {
            try {
                ConfigBackup.saveVersioned();
            }
            catch (IOException iOException) {
                if (!debugLogger.isDebugEnabled()) break block2;
                debugLogger.debug("Exception backing up config ", (Throwable)iOException);
            }
        }
    }

    public String getEditor() {
        Object object = this.lockMgr.getLockOwner();
        if (object == null) {
            return null;
        }
        if (object instanceof AuthenticatedSubject) {
            return SubjectUtils.getUsername((AuthenticatedSubject)((AuthenticatedSubject)object));
        }
        return object.toString();
    }

    public boolean isEditor() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelIdentity);
        return this.lockMgr.isLockOwner(authenticatedSubject);
    }

    public long getEditorStartTime() {
        return this.lockMgr.getLockAcquisitionTime();
    }

    public long getEditorExpirationTime() {
        return this.lockMgr.getLockExpirationTime();
    }

    public boolean isEditorExclusive() {
        return this.lockMgr.isLockExclusive();
    }

    public synchronized void validateChanges() throws EditNotEditorException, EditChangesValidationException {
        AuthenticatedSubject authenticatedSubject = this.checkEditLock();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Validating changes for " + authenticatedSubject);
        }
        if (this.editTree == null) {
            throw new AssertionError((Object)"Edit bean tree is null");
        }
        try {
            this.editTree.validate();
            Iterator iterator = DescriptorInfoUtils.getDescriptorInfos(this.editTree);
            while (iterator != null && iterator.hasNext()) {
                DescriptorInfo descriptorInfo = (DescriptorInfo)iterator.next();
                Descriptor descriptor = descriptorInfo.getDescriptor();
                if (descriptor == this.editTree || !descriptor.isModified()) continue;
                descriptor.validate();
            }
        }
        catch (DescriptorValidateException descriptorValidateException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in validation: ", (Throwable)descriptorValidateException);
            }
            throw new EditChangesValidationException(descriptorValidateException);
        }
    }

    public synchronized void reload() throws EditNotEditorException, EditChangesValidationException {
        AuthenticatedSubject authenticatedSubject = this.checkEditLock();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Validating changes for " + authenticatedSubject);
        }
        if (this.editTree == null) {
            return;
        }
        Descriptor descriptor = null;
        try {
            descriptor = this.loadBeanTreeFromPending();
            this.addTemporaryTree(descriptor, "reload");
            this.editTree.prepareUpdate(descriptor, false);
            this.editTree.activateUpdate();
            Iterator iterator = DescriptorInfoUtils.getDescriptorInfos(this.editTree);
            while (iterator != null && iterator.hasNext()) {
                DescriptorInfo descriptorInfo = (DescriptorInfo)iterator.next();
                Descriptor descriptor2 = descriptorInfo.getDescriptor();
                Descriptor descriptor3 = this.loadExternalBeanTree(descriptorInfo, true, true);
                if (descriptor3 == null) continue;
                this.addTemporaryTree(descriptor3, "reload." + descriptorInfo.getDescriptorClass());
                descriptor2.prepareUpdate(descriptor3, false);
                descriptor2.activateUpdate();
            }
            DescriptorInfoUtils.removeAllDeletedDescriptorInfos(this.editTree);
        }
        catch (IOException iOException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception loading tree ", (Throwable)iOException);
            }
            throw new EditChangesValidationException(iOException);
        }
        catch (EditFailedException editFailedException) {
            throw new EditChangesValidationException((Throwable)((Object)editFailedException));
        }
        catch (ManagementException managementException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception running processors ", (Throwable)managementException);
            }
            throw new EditChangesValidationException(managementException);
        }
        catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in prepare/activate: ", (Throwable)descriptorUpdateRejectedException);
            }
            throw new EditChangesValidationException(descriptorUpdateRejectedException);
        }
        catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception activating in undo unsaved ", (Throwable)descriptorUpdateFailedException);
            }
            throw new EditChangesValidationException(descriptorUpdateFailedException);
        }
        this.removePendingUpdateTasks();
    }

    public synchronized void saveChanges() throws EditNotEditorException, EditSaveChangesFailedException, EditChangesValidationException {
        AuthenticatedSubject authenticatedSubject = this.checkEditLock();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Saving changes for " + authenticatedSubject);
        }
        if (this.editTree == null) {
            throw new AssertionError((Object)"Edit bean tree is null");
        }
        this.validateChanges();
        this.validatePreparingInfo();
        if (this.isPreparing()) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Attempted to save changes while preparing: ");
            }
            throw new EditSaveChangesFailedException("Can not save changes while prepare changes are still in progress");
        }
        try {
            boolean bl = DescriptorHelper.saveDescriptorTree(this.editTree, true, null);
            if (bl) {
                this.setPendingChange(true);
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Saved tree, changes are pending in pending directory");
                }
            }
            Iterator iterator = DescriptorInfoUtils.getDeletedDescriptorInfos(this.editTree);
            while (iterator != null && iterator.hasNext()) {
                DescriptorInfo descriptorInfo = (DescriptorInfo)iterator.next();
                String string = descriptorInfo.getConfigurationExtension().getDescriptorFileName();
                this.pendingDirMgr.deleteFile(string);
                if (!debugLogger.isDebugEnabled()) continue;
                debugLogger.debug("Deleting from pending directory - deleted descriptor file " + string);
            }
            DescriptorInfoUtils.removeAllDeletedDescriptorInfos(this.editTree);
        }
        catch (IOException iOException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in write: ", (Throwable)iOException);
            }
            throw new EditSaveChangesFailedException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivateTask activateChanges(long l) throws EditNotEditorException, EditFailedException {
        AuthenticatedSubject authenticatedSubject = this.checkEditLock();
        long l2 = 0L;
        DeploymentRequestTaskRuntimeMBean deploymentRequestTaskRuntimeMBean = null;
        Object object = this;
        synchronized (object) {
            this.validatePreparingInfo();
            if (this.isPreparing()) {
                throw new EditFailedException("Unable to start new activation while preparing");
            }
            l2 = l == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + l;
            this.backupConfig();
        }
        try {
            object = null;
            try {
                object = DeploymentService.getDeploymentService().createDeploymentRequest();
            }
            catch (ManagementException managementException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Failed to create deployment request with error: ", (Throwable)managementException);
                }
                throw new EditFailedException(managementException);
            }
            DescriptorDiff descriptorDiff = this.currentTree.prepareUpdateDiff(this.editTree, false);
            Iterator iterator = descriptorDiff.iterator();
            ConfigurationDeployment configurationDeployment = this.getConfigDeploymentPending(iterator);
            if (configurationDeployment != null) {
                object.addDeployment(configurationDeployment);
            }
            Set set = DeploymentService.getDeploymentService().getRegisteredDeploymentProviders();
            Iterator iterator2 = set.iterator();
            ConfigurationContextImpl configurationContextImpl = new ConfigurationContextImpl((DeploymentRequest)object);
            configurationContextImpl.addContextComponent("beanUpdateDescriptorDiffId", descriptorDiff);
            Map map = this.getExternalDescriptorDiffMap(false);
            configurationContextImpl.addContextComponent("externalDescritorDiffId", map);
            ArrayList arrayList = new ArrayList();
            this.combineDiffs(arrayList, descriptorDiff, map);
            while (iterator2 != null && iterator2.hasNext()) {
                DeploymentProvider deploymentProvider = (DeploymentProvider)iterator2.next();
                deploymentProvider.addDeploymentsTo((DeploymentRequest)object, configurationContextImpl);
            }
            object.setInitiator(authenticatedSubject);
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Deploying request : " + object);
            }
            boolean bl = false;
            if (configurationDeployment != null) {
                bl = true;
            }
            ActivateTaskImpl activateTaskImpl = this.createActivationTask(object.getId(), l, l2, bl, arrayList, authenticatedSubject, this.lockMgr, configurationDeployment);
            object.setTimeoutInterval(l);
            if (object.isStartControlEnabled()) {
                object.registerFailureListener(this);
            } else {
                if (configurationDeployment == null && !object.getDeployments().hasNext()) {
                    ((AdminRequestImpl)object).reset();
                    this.lockMgr.releaseEditLock(authenticatedSubject);
                    return activateTaskImpl;
                }
                deploymentRequestTaskRuntimeMBean = object.getTaskRuntime();
                deploymentRequestTaskRuntimeMBean.start();
                if (debugLogger.isDebugEnabled()) {
                    if (deploymentRequestTaskRuntimeMBean != null) {
                        debugLogger.debug("Started deployment request with id " + deploymentRequestTaskRuntimeMBean.getTaskId() + " isComplete " + deploymentRequestTaskRuntimeMBean.isComplete());
                    } else {
                        debugLogger.debug("Started deployment request task runtime is null");
                    }
                }
            }
            if (deploymentRequestTaskRuntimeMBean != null) {
                activateTaskImpl.setDeploymentRequestTaskRuntimeMBean(deploymentRequestTaskRuntimeMBean);
            }
            return activateTaskImpl;
        }
        catch (Exception exception) {
            this.resetPreparingInfo();
            this.rollbackCurrent();
            throw new EditFailedException(exception);
        }
    }

    public ActivateTask activateChangesAndWaitForCompletion(long l) throws EditNotEditorException, EditFailedException {
        ActivateTaskImpl activateTaskImpl = (ActivateTaskImpl)this.activateChanges(l);
        if (activateTaskImpl != null) {
            activateTaskImpl.waitForTaskCompletion();
            if (activateTaskImpl.getState() == 5 && activateTaskImpl.getError() == null) {
                activateTaskImpl.setError((Exception)((Object)new EditFailedException("Activate failed with unknown exception")));
            }
        }
        return activateTaskImpl;
    }

    public synchronized void undoUnactivatedChanges() throws EditNotEditorException, EditFailedException {
        AuthenticatedSubject authenticatedSubject = this.checkEditLock();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Undoing unactivated changes for " + authenticatedSubject);
        }
        if (this.editTree == null) {
            throw new AssertionError((Object)"Edit bean tree is null");
        }
        this.validatePreparingInfo();
        if (this.isPreparing()) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Attempted to undo activated changes while perpaaring: ");
            }
            throw new EditFailedException("Can not undo unactivated changes while an activate changes operation is still in progress");
        }
        try {
            Object object;
            Object object2;
            if (!this.deletePendingDirectory()) {
                throw new EditFailedException("Can not delete all the files in the pending directory");
            }
            this.setPendingChange(false);
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Undo unactivated tree, no changes are pending in pending directory");
                debugLogger.debug("Computing diff of unactivated changes");
                object2 = this.editTree.computeDiff(this.currentTree);
                if (object2 != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        debugLogger.debug("Beanupdate event " + object.next());
                    }
                }
            }
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Preparing revert of edit tree");
            }
            this.editTree.prepareUpdate(this.currentTree, false);
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Committing revert of edit tree");
            }
            this.editTree.activateUpdate();
            object2 = DescriptorInfoUtils.getDescriptorInfos(this.editTree);
            while (object2 != null && object2.hasNext()) {
                object = (DescriptorInfo)object2.next();
                Descriptor descriptor = ((DescriptorInfo)object).getDescriptor();
                Descriptor descriptor2 = this.loadExternalBeanTree((DescriptorInfo)object, true, true);
                if (descriptor2 == null) continue;
                this.addTemporaryTree(descriptor2, "undoUnactivatedChanges." + ((DescriptorInfo)object).getDescriptorClass());
                descriptor.prepareUpdate(descriptor2, false);
                descriptor.activateUpdate();
            }
            DescriptorInfoUtils.removeAllDeletedDescriptorInfos(this.editTree);
        }
        catch (IOException iOException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception loading tree ", (Throwable)iOException);
            }
            throw new EditFailedException(iOException);
        }
        catch (EditFailedException editFailedException) {
            throw editFailedException;
        }
        catch (ManagementException managementException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception running processors ", (Throwable)managementException);
            }
            throw new EditFailedException(managementException);
        }
        catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in prepare/activate: ", (Throwable)descriptorUpdateRejectedException);
            }
            throw new EditFailedException(descriptorUpdateRejectedException);
        }
        catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception activating in undo unactivated ", (Throwable)descriptorUpdateFailedException);
            }
            throw new EditFailedException(descriptorUpdateFailedException);
        }
    }

    public synchronized Iterator getUnactivatedChanges() throws EditNotEditorException, EditFailedException {
        AuthenticatedSubject authenticatedSubject = this.checkEditLock();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Getting unactivated changes for " + authenticatedSubject);
        }
        ArrayList arrayList = new ArrayList();
        if (!this.isPendingChange() && !this.isModified()) {
            return arrayList.iterator();
        }
        DescriptorDiff descriptorDiff = this.getUnactivatedChangesDiff();
        try {
            Map map = this.getExternalDescriptorDiffMap(true);
            this.combineDiffs(arrayList, descriptorDiff, map);
            return arrayList.iterator();
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in computing diff: ", (Throwable)exception);
            }
            throw new EditFailedException(exception);
        }
    }

    private void combineDiffs(ArrayList arrayList, DescriptorDiff descriptorDiff, Map map) {
        Iterator iterator;
        if (descriptorDiff != null) {
            iterator = descriptorDiff.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        if (!map.isEmpty()) {
            iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((ArrayList)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    arrayList.add(iterator2.next());
                }
            }
        }
    }

    private Map getExternalDescriptorDiffMap(boolean bl) throws EditFailedException, IOException {
        HashMap hashMap = new HashMap();
        Iterator iterator = DescriptorInfoUtils.getDescriptorInfos(this.editTree);
        while (iterator != null && iterator.hasNext()) {
            DescriptorDiff descriptorDiff;
            DescriptorInfo descriptorInfo = (DescriptorInfo)iterator.next();
            Descriptor descriptor = descriptorInfo.getDescriptor();
            Descriptor descriptor2 = this.getExternalCurrentTree(descriptorInfo);
            if (descriptor2 == null) {
                descriptor2 = this.loadExternalBeanTree(descriptorInfo, false, !bl);
            }
            if (descriptor2 == null || (descriptorDiff = descriptor2.computeDiff(descriptor)) == null) continue;
            ArrayList<BeanUpdateEvent> arrayList = new ArrayList<BeanUpdateEvent>();
            for (BeanUpdateEvent beanUpdateEvent : descriptorDiff) {
                arrayList.add(beanUpdateEvent);
                if (!debugLogger.isDebugEnabled()) continue;
                debugLogger.debug("Added external diff for bean: " + beanUpdateEvent.getSource() + " in external desc for: " + descriptorInfo.getDescriptorBean());
                BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
                for (int i = 0; i < propertyUpdateArray.length; ++i) {
                    debugLogger.debug("diff[" + i + "], updateType: " + propertyUpdateArray[i].getUpdateType() + ", propertyName: " + propertyUpdateArray[i].getPropertyName() + ", isDynamic: " + propertyUpdateArray[i].isDynamic());
                }
            }
            hashMap.put(descriptorInfo.getDescriptorBean(), arrayList);
        }
        return hashMap;
    }

    public boolean isModified() {
        if (this.editTree == null) {
            return false;
        }
        return this.editTree.isModified() || this.areAnyExternalTreesModified(this.editTree);
    }

    public boolean isPendingChange() {
        return this.pendingChange;
    }

    public synchronized void setPendingChange(boolean bl) {
        this.pendingChange = bl;
    }

    private synchronized DescriptorDiff getUnactivatedChangesDiff() throws EditFailedException {
        if (this.editTree == null) {
            throw new AssertionError((Object)"Edit bean tree is null");
        }
        try {
            DescriptorDiff descriptorDiff = this.currentTree.computeDiff(this.editTree);
            if (descriptorDiff == null) {
                return null;
            }
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Returning iterator of unactivated changes");
                Iterator iterator = descriptorDiff.iterator();
                while (iterator.hasNext()) {
                    debugLogger.debug("Beanupdate event " + iterator.next());
                }
            }
            return descriptorDiff;
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in diff: ", (Throwable)exception);
            }
            throw new EditFailedException(exception);
        }
    }

    public DomainMBean getDomainBeanWithoutLock() throws EditFailedException {
        if (this.editDomainMBean == null) {
            this.ensureBeanTreeLoaded();
        }
        return this.editDomainMBean;
    }

    public synchronized boolean isDomainBeanTreeLoaded() {
        return this.editDomainMBean != null;
    }

    EditLockManager getEditLockManager() {
        return this.lockMgr;
    }

    public String getHandlerIdentity() {
        return "Configuration";
    }

    public Deployment[] getDeployments(Version version2, Version version3, String string) {
        Deployment[] deploymentArray = null;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Get deployments for server " + string + " from version " + version2 + " to version " + version3);
        }
        if (version2 != null && ((Object)version2).equals(version3)) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Get deployments - from and to version are equal.");
            }
            deploymentArray = new Deployment[]{};
            return deploymentArray;
        }
        try {
            ConfigurationDeployment configurationDeployment = this.getConfigDeploymentCurrent(version2, version3);
            deploymentArray = configurationDeployment == null ? new Deployment[]{} : new ConfigurationDeployment[]{configurationDeployment};
        }
        catch (InvalidCreateChangeDescriptorException invalidCreateChangeDescriptorException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception getting current config deployment ", (Throwable)invalidCreateChangeDescriptorException);
            }
            throw new ManagementRuntimeException(invalidCreateChangeDescriptorException);
        }
        return deploymentArray;
    }

    public synchronized void deploySucceeded(long l, FailureDescription[] failureDescriptionArray) {
        block7: {
            try {
                FailureDescription[] failureDescriptionArray2;
                ArrayList<FailureDescription[]> arrayList = new ArrayList<FailureDescription[]>();
                ArrayList<FailureDescription[]> arrayList2 = new ArrayList<FailureDescription[]>();
                if (failureDescriptionArray != null) {
                    for (int i = 0; i < failureDescriptionArray.length; ++i) {
                        failureDescriptionArray2 = failureDescriptionArray[i];
                        if (failureDescriptionArray2 instanceof RequiresRestartFailureDescription) {
                            arrayList.add(failureDescriptionArray2);
                            continue;
                        }
                        arrayList2.add(failureDescriptionArray2);
                    }
                }
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Edit Access deploy succeeded for identifier " + l + " with " + arrayList2.size() + " deferred deployments and " + arrayList.size() + " requires restart deployments");
                }
                this.prepareCompleted(l);
                ActivateTaskImpl activateTaskImpl = this.lookupTask(l);
                if (activateTaskImpl == null) {
                    return;
                }
                failureDescriptionArray2 = new FailureDescription[arrayList2.size()];
                failureDescriptionArray2 = arrayList2.toArray(failureDescriptionArray2);
                activateTaskImpl.deploySucceeded(failureDescriptionArray2);
            }
            catch (Exception exception) {
                if (!debugLogger.isDebugEnabled()) break block7;
                debugLogger.debug("Edit Access deploy succeeded failed with exception ", (Throwable)exception);
            }
        }
    }

    public synchronized void deployFailed(long l, DeploymentException deploymentException) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Edit Access deploy failed for identifier " + l + " with reason:" + deploymentException);
        }
        this.failed(l, deploymentException != null ? deploymentException.getFailures() : null, DEPLOY);
    }

    public synchronized void commitFailed(long l, FailureDescription[] failureDescriptionArray) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Edit Access deploy encountered commit failures for identifier " + l + " to " + failureDescriptionArray.length + " targets");
            for (int i = 0; i < failureDescriptionArray.length; ++i) {
                debugLogger.debug("Edit Access commit failure " + failureDescriptionArray[i]);
            }
        }
        this.failed(l, failureDescriptionArray, COMMIT);
    }

    public synchronized void commitSucceeded(long l) {
        block4: {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Edit Access commit suceeded for identifier " + l);
            }
            try {
                ActivateTaskImpl activateTaskImpl = this.lookupTask(l);
                if (activateTaskImpl == null) {
                    return;
                }
                activateTaskImpl.commitSucceeded();
            }
            catch (Exception exception) {
                if (!debugLogger.isDebugEnabled()) break block4;
                debugLogger.debug("Edit Access commit succeeded failed with exception ", (Throwable)exception);
            }
        }
    }

    public synchronized void cancelSucceeded(long l, FailureDescription[] failureDescriptionArray) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Edit Access cancel suceeded for identifier " + l + " with " + failureDescriptionArray.length + " cancel delivery attempt failures");
        }
        this.failed(l, failureDescriptionArray, CANCEL);
    }

    public synchronized void cancelFailed(long l, DeploymentException deploymentException) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Edit Access cancel failed for identifier " + l + " with reason:" + deploymentException);
        }
        this.failed(l, deploymentException != null ? deploymentException.getFailures() : null, CANCEL);
    }

    public synchronized void receivedStatusFrom(long l, Serializable serializable, String string) {
        String string2;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Edit Access received status for identifier " + l + " for server " + string + " with status " + serializable);
        }
        if ((string2 = (String)((Object)serializable)).equals("COMMIT_PENDING")) {
            this.handleRequestStatusUpdate(l, string2, string);
        }
    }

    public synchronized void requestStatusUpdated(long l, String string, String string2) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Edit Access received request status update for identifier " + l + " for server " + string2 + " with status " + string);
        }
        this.handleRequestStatusUpdate(l, string, string2);
    }

    private void handleRequestStatusUpdate(long l, String string, String string2) {
        ActivateTaskImpl activateTaskImpl = this.lookupTask(l);
        if (activateTaskImpl == null) {
            return;
        }
        boolean bl = false;
        if (string.equals("PrepareSuccessReceived")) {
            bl = activateTaskImpl.updateServerState(string2, 2);
        } else if (string.equals("PrepareFailedReceived")) {
            bl = activateTaskImpl.updateServerState(string2, 5);
        } else if (string.equals("CommitSuccessReceived")) {
            bl = activateTaskImpl.updateServerState(string2, 4);
        } else if (string.equals("CommitFailedReceived")) {
            bl = activateTaskImpl.updateServerState(string2, 7);
        } else if (string.equals("CancelSuccessReceived")) {
            bl = activateTaskImpl.updateServerState(string2, 6);
        } else if (string.equals("CancelFailedReceived")) {
            bl = activateTaskImpl.updateServerState(string2, 6);
        } else if (string.equals("COMMIT_PENDING")) {
            bl = activateTaskImpl.updateServerState(string2, 3);
        }
        if ((activateTaskImpl.getState() == 2 || activateTaskImpl.getState() == 4 || bl) && this.isPreparing() && l == this.preparingId) {
            this.prepareCompleted(l);
        }
        if (bl) {
            activateTaskImpl.releaseAndSetCommitted();
        }
        if (!activateTaskImpl.isRunning()) {
            this.removeTask(activateTaskImpl);
        }
    }

    public synchronized void cancelActivate() throws EditFailedException {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelIdentity);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Canceling activate operation for " + authenticatedSubject);
        }
        if (this.isPreparing()) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Cancel outstanding requests");
            }
            ActivateTaskImpl activateTaskImpl = this.lookupTask(this.preparingId);
            this.resetPreparingInfo();
            this.rollbackCurrent();
            if (activateTaskImpl != null) {
                try {
                    activateTaskImpl.cancel();
                }
                catch (Exception exception) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Exception canceling task ", (Throwable)exception);
                    }
                    throw new EditFailedException(exception);
                }
            }
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Cancelled activate.");
        }
    }

    private void failed(long l, FailureDescription[] failureDescriptionArray, int n) {
        if (this.isPreparing() && l == this.preparingId) {
            this.resetPreparingInfo();
            this.rollbackCurrent();
        }
        boolean bl = false;
        ActivateTaskImpl activateTaskImpl = this.lookupTask(l);
        if (activateTaskImpl == null) {
            bl = true;
            activateTaskImpl = this.lookupOldTask(l);
            if (activateTaskImpl == null) {
                return;
            }
        }
        for (int i = 0; failureDescriptionArray != null && i < failureDescriptionArray.length; ++i) {
            activateTaskImpl.addFailedServer(failureDescriptionArray[i].getServer(), failureDescriptionArray[i].getReason());
        }
        if (activateTaskImpl.isWaitingForEndFailureCallback() || n == COMMIT || n == DEPLOY && activateTaskImpl.getState() == 6) {
            activateTaskImpl.setState(5);
            if (!bl) {
                this.removeTask(activateTaskImpl);
            }
        } else {
            activateTaskImpl.setWaitingForEndFailureCallback(true);
        }
    }

    private AuthenticatedSubject checkEditLock() throws EditNotEditorException {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelIdentity);
        if (!this.lockMgr.isLockOwner(authenticatedSubject)) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Subject " + authenticatedSubject + " does not have the edit lock");
            }
            throw new EditNotEditorException("Not edit lock owner");
        }
        return authenticatedSubject;
    }

    private static AuthenticatedSubject obtainKernelIdentity() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        return authenticatedSubject;
    }

    private synchronized ConfigurationDeployment getConfigDeploymentPending(Iterator iterator) throws InvalidCreateChangeDescriptorException {
        Object object;
        String string;
        int n;
        File[] fileArray = this.pendingDirMgr.getAllFiles();
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        ConfigurationVersion configurationVersion = new ConfigurationVersion(true);
        ConfigurationDeployment configurationDeployment = new ConfigurationDeployment(this.getHandlerIdentity());
        configurationDeployment.setProposedVersion(configurationVersion);
        boolean bl = this.pendingDirMgr.configExists();
        for (n = 0; n < fileArray.length; ++n) {
            string = fileArray[n].getPath();
            if (!bl || !this.pendingDirMgr.getConfigFile().getPath().equals(string) || n >= fileArray.length - 1) continue;
            object = fileArray[fileArray.length - 1];
            fileArray[fileArray.length - 1] = fileArray[n];
            fileArray[n] = object;
            break;
        }
        for (n = 0; n < fileArray.length; ++n) {
            string = fileArray[n].getPath();
            object = this.pendingDirMgr.removePendingDirectoryFromPath(string);
            String string2 = "update";
            String string3 = "config";
            if (!bl || !this.pendingDirMgr.getConfigFile().getPath().equals(string)) {
                string3 = this.isWLSExternalFile((String)object) ? "external" : "non-wls";
                File file = new File((String)object);
                if (!file.exists()) {
                    string2 = "add";
                }
            }
            configurationVersion.addOrUpdateFile(string, (String)object);
            string = this.removeRootDirectoryFromPath(string);
            object = this.removeRootDirectoryFromPath((String)object);
            this.addChangeDescriptor(string, (String)object, configurationDeployment, string2, configurationVersion, string3);
        }
        this.processBeanUpdateEvents(iterator, configurationDeployment, configurationVersion);
        this.addTargets(configurationDeployment);
        return configurationDeployment;
    }

    private boolean isWLSExternalFile(String string) {
        String string2 = this.removeRootDirectoryFromPath(string);
        String string3 = DomainDir.getRootDirNonCanonical() + "/" + string2;
        SystemResourceMBean[] systemResourceMBeanArray = this.editDomainMBean.getSystemResources();
        for (int i = 0; i < systemResourceMBeanArray.length; ++i) {
            if (!new File(systemResourceMBeanArray[i].getSourcePath()).getPath().equals(new File(string3).getPath())) continue;
            return true;
        }
        return false;
    }

    private ConfigurationDeployment getConfigDeploymentCurrent(Version version2, Version version3) throws InvalidCreateChangeDescriptorException {
        ConfigurationVersion configurationVersion = new ConfigurationVersion(true);
        if (version2 != null && ((Object)version2).equals(configurationVersion)) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("GetConfigDeploymentCurrent - from and source version are equal.");
            }
            return null;
        }
        ConfigurationDeployment configurationDeployment = new ConfigurationDeployment(this.getHandlerIdentity());
        configurationDeployment.setProposedVersion(configurationVersion);
        Map map = configurationVersion.getVersionComponents();
        Map map2 = version2.getVersionComponents();
        String string = BootStrap.getConfigDirectoryConfigFile().getPath();
        Iterator iterator = map.keySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = "external";
            if (string.equals(string2)) {
                string3 = "config";
            }
            boolean bl = true;
            String string4 = (String)map2.get(string2);
            if (string4 != null && string4.equals((String)map.get(string2))) {
                bl = false;
            }
            if (!bl) continue;
            string2 = this.removeRootDirectoryFromPath(string2);
            this.addChangeDescriptor(string2, string2, configurationDeployment, "update", configurationVersion, string3);
        }
        this.addTargets(configurationDeployment);
        return configurationDeployment;
    }

    private void addTargets(ConfigurationDeployment configurationDeployment) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelIdentity).getDomain();
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        for (int i = 0; serverMBeanArray != null && i < serverMBeanArray.length; ++i) {
            configurationDeployment.addTarget(serverMBeanArray[i].getName());
        }
    }

    private void addChangeDescriptor(String string, String string2, ConfigurationDeployment configurationDeployment, String string3, ConfigurationVersion configurationVersion, String string4) throws InvalidCreateChangeDescriptorException {
        String string5 = new File(string).getPath();
        String string6 = new File(string2).getPath();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Create change descriptor with target path " + string6);
            debugLogger.debug("Create change descriptor with src path " + string5);
        }
        ChangeDescriptor changeDescriptor = DeploymentService.getDeploymentService().createChangeDescriptor(string3, string6, string5, (Serializable)((Object)configurationVersion.toString()), string4);
        configurationDeployment.addChangeDescriptor(changeDescriptor);
    }

    private void processBeanUpdateEvents(Iterator iterator, ConfigurationDeployment configurationDeployment, ConfigurationVersion configurationVersion) throws InvalidCreateChangeDescriptorException {
        while (iterator != null && iterator.hasNext()) {
            BeanUpdateEvent beanUpdateEvent = (BeanUpdateEvent)iterator.next();
            String[] stringArray = ChangeUtils.getRestartRequiredServers(beanUpdateEvent);
            configurationDeployment.addServersToBeRestarted(stringArray);
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                Object object;
                BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                if (propertyUpdate.getUpdateType() != 3 || !((object = propertyUpdate.getRemovedObject()) instanceof ConfigurationExtensionMBean)) continue;
                ConfigurationExtensionMBean configurationExtensionMBean = (ConfigurationExtensionMBean)object;
                String string = DomainDir.getConfigDir() + File.separator + configurationExtensionMBean.getDescriptorFileName();
                configurationVersion.removeFile(string);
                string = this.removeRootDirectoryFromPath(string);
                this.addChangeDescriptor(string, string, configurationDeployment, "delete", configurationVersion, "external");
            }
        }
    }

    public String removeRootDirectoryFromPath(String string) {
        if (string.startsWith(this.rootDirectoryPrefix) || new File(string).getPath().startsWith(new File(this.rootDirectoryPrefix).getPath())) {
            return string.substring(this.rootDirectoryPrefix.length(), string.length());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureBeanTreeLoaded() throws EditFailedException {
        try {
            EditAccessImpl editAccessImpl = this;
            synchronized (editAccessImpl) {
                File file;
                if (this.editDomainMBean == null) {
                    file = BootStrap.getConfigDirectoryConfigFile();
                    if (!file.canWrite()) {
                        ManagementLogger.logConfigurationFileIsReadOnly((String)file.getPath());
                    }
                    this.editTree = this.loadBeanTreeFromPending();
                    this.editDomainMBean = (DomainMBean)this.editTree.getRootBean();
                }
                if (this.currentDomainMBean == null) {
                    file = BootStrap.getConfigDirectoryConfigFile();
                    this.currentTree = this.loadBeanTreeFromActive(file);
                    this.currentDomainMBean = (DomainMBean)this.currentTree.getRootBean();
                }
            }
        }
        catch (ManagementException managementException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception running processors ", (Throwable)managementException);
            }
            throw new EditFailedException(managementException);
        }
        catch (IOException iOException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception loading tree ", (Throwable)iOException);
            }
            throw new EditFailedException(iOException);
        }
    }

    private Descriptor loadBeanTreeFromActive(File file) throws IOException {
        Descriptor descriptor = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            DescriptorManager descriptorManager = DescriptorManagerHelper.getDescriptorManager(false);
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Loading bean tree from stream");
            }
            ArrayList arrayList = new ArrayList();
            descriptor = descriptorManager.createDescriptor((XMLStreamReader)((Object)new ConfigReader(fileInputStream)), arrayList, true);
            EditAccessImpl.checkErrors(file.getAbsolutePath(), arrayList);
            this.setProductionModeInfo(descriptor);
            Descriptor descriptor2 = descriptor;
            return descriptor2;
        }
        catch (XMLStreamException xMLStreamException) {
            IOException iOException = new IOException("Error loading " + file + ": " + xMLStreamException.getMessage());
            iOException.initCause(xMLStreamException);
            throw iOException;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Descriptor loadBeanTreeFromPending() throws EditFailedException, IOException, ManagementException {
        FileLock fileLock = Utils.getConfigFileLock();
        if (fileLock == null) {
            ManagementLogger.logCouldNotGetConfigFileLock();
        }
        try {
            InputStream inputStream = this.pendingDirMgr.getConfigAsStream();
            Descriptor descriptor = this.loadBeanTree(inputStream, BootStrap.getDefaultConfigFileName());
            ((DescriptorImpl)descriptor).setModified(false);
            this.setExternalTreesUnmodified(descriptor);
            Descriptor descriptor2 = descriptor;
            return descriptor2;
        }
        finally {
            if (fileLock != null) {
                Utils.releaseConfigFileLock();
            }
        }
    }

    private Descriptor loadExternalBeanTree(DescriptorInfo descriptorInfo, boolean bl, boolean bl2) throws EditFailedException, IOException {
        String string;
        FileLock fileLock = Utils.getConfigFileLock();
        if (fileLock == null) {
            ManagementLogger.logCouldNotGetConfigFileLock();
        }
        String string2 = null;
        InputStream inputStream = null;
        try {
            ConfigurationExtensionMBean configurationExtensionMBean = descriptorInfo.getConfigurationExtension();
            string = configurationExtensionMBean.getDescriptorFileName();
            DescriptorManager descriptorManager = descriptorInfo.getDescriptorManager();
            File file = new File(DomainDir.getPathRelativeConfigDir((String)string));
            string2 = string;
            if (bl && this.pendingDirMgr.fileExists(string) || file.exists()) {
                if (bl) {
                    string2 = configurationExtensionMBean.getDescriptorFileName();
                    inputStream = this.pendingDirMgr.getFileAsStream(configurationExtensionMBean.getDescriptorFileName());
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Loading external bean tree from stream");
                    }
                } else {
                    inputStream = new FileInputStream(file);
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Loading external bean tree from current file");
                    }
                }
                ArrayList arrayList = new ArrayList();
                Descriptor descriptor = descriptorManager.createDescriptor((XMLStreamReader)((Object)new ExternalConfigReader(inputStream)), arrayList, true);
                EditAccessImpl.checkErrors(file.getAbsolutePath(), arrayList);
                this.setProductionModeInfo(descriptor);
                Descriptor descriptor2 = descriptor;
                return descriptor2;
            }
            if (bl2) {
                Descriptor descriptor = null;
                return descriptor;
            }
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Creating external bean tree from class");
            }
            ArrayList arrayList = new ArrayList();
            Descriptor descriptor = descriptorManager.createDescriptorRoot(descriptorInfo.getDescriptorClass(), "UTF-8");
            EditAccessImpl.checkErrors(file.getAbsolutePath(), arrayList);
            this.setProductionModeInfo(descriptor);
            Descriptor descriptor3 = descriptor;
            return descriptor3;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new EditFailedException("Error loading " + string2, xMLStreamException);
        }
        catch (IOException iOException) {
            if (iOException instanceof FileNotFoundException) {
                string = null;
                return string;
            }
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in load external edit tree: ", (Throwable)iOException);
            }
            throw new EditFailedException("Error loading " + string2, iOException);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (fileLock != null) {
                Utils.releaseConfigFileLock();
            }
        }
    }

    private Descriptor loadBeanTree(InputStream inputStream, String string) throws EditFailedException, IOException {
        try {
            EditableDescriptorManager editableDescriptorManager = (EditableDescriptorManager)DescriptorManagerHelper.getDescriptorManager(true);
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Loading bean tree from stream");
            }
            ArrayList arrayList = new ArrayList();
            Descriptor descriptor = editableDescriptorManager.createDescriptor((XMLStreamReader)((Object)new ConfigReader(inputStream)), arrayList, false);
            EditAccessImpl.checkErrors(string, arrayList);
            this.setProductionModeInfo(descriptor);
            Descriptor descriptor2 = descriptor;
            return descriptor2;
        }
        catch (XMLStreamException xMLStreamException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in load edit tree: ", (Throwable)xMLStreamException);
            }
            throw new EditFailedException("Error loading " + string, xMLStreamException);
        }
        catch (IOException iOException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in load edit tree: ", (Throwable)iOException);
            }
            throw new EditFailedException(iOException);
        }
        finally {
            inputStream.close();
        }
    }

    private boolean isPreparing() {
        if (!this.preparing) {
            return false;
        }
        if (System.currentTimeMillis() >= this.preparingTimeout) {
            this.resetPreparingInfo();
            return false;
        }
        return true;
    }

    private void setPreparing(boolean bl) {
        this.preparing = bl;
    }

    private void resetPreparingInfo() {
        this.setPreparing(false);
        this.setPreparingTimeout(0L);
        this.preparingId = 0L;
    }

    private void validatePreparingInfo() {
        if (!this.isPreparing()) {
            return;
        }
        if (this.preparingId == 0L) {
            this.resetPreparingInfo();
            return;
        }
        ActivateTaskImpl activateTaskImpl = this.lookupTask(this.preparingId);
        if (activateTaskImpl == null) {
            activateTaskImpl = this.lookupOldTask(this.preparingId);
        }
        if (activateTaskImpl == null || !activateTaskImpl.isRunning()) {
            this.resetPreparingInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareCompleted(long l) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Prepare completed " + this.isPreparing() + " id " + l + " prepare id " + this.preparingId);
        }
        if (this.isPreparing() && l == this.preparingId) {
            Object object;
            RuntimeAccessDeploymentReceiverService.getService().commitAnyPendingRequests();
            if (!this.deletePendingDirectory()) {
                object = this.lookupTask(l);
                if (object != null) {
                    ((ActivateTaskImpl)object).setError((Exception)((Object)new EditFailedException("Can not delete all the files in the pending directory")));
                    ((ActivateTaskImpl)object).setState(5);
                }
            } else {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Prepare completed, no changes are pending in pending directory");
                }
                this.setPendingChange(false);
            }
            try {
                this.currentTree.activateUpdate();
                object = DescriptorInfoUtils.getDescriptorInfos(this.editTree);
                while (object != null && object.hasNext()) {
                    DescriptorInfo descriptorInfo = (DescriptorInfo)object.next();
                    Descriptor descriptor = descriptorInfo.getDescriptor();
                    Descriptor descriptor2 = this.getExternalCurrentTree(descriptorInfo);
                    if (descriptor2 == null) continue;
                    descriptor2.prepareUpdate(descriptor, false);
                    descriptor2.activateUpdate();
                }
                return;
            }
            catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
                if (!debugLogger.isDebugEnabled()) return;
                debugLogger.debug("Exception in prepare/activate of external current tree: ", (Throwable)descriptorUpdateFailedException);
                return;
            }
            catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
                if (!debugLogger.isDebugEnabled()) return;
                debugLogger.debug("Exception in prepare/activate of external current tree: ", (Throwable)descriptorUpdateRejectedException);
                return;
            }
            finally {
                this.resetPreparingInfo();
            }
        } else {
            if (l == this.preparingId || this.preparingId == 0L) return;
            ActivateTaskImpl activateTaskImpl = this.lookupTask(l);
            if (activateTaskImpl == null) {
                activateTaskImpl = this.lookupOldTask(l);
            }
            if (activateTaskImpl != null && !activateTaskImpl.isRunning()) return;
            ManagementLogger.logInvalidPrepareCallback((String)("" + l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deletePendingDirectory() {
        FileLock fileLock = Utils.getConfigFileLock();
        if (fileLock == null) {
            ManagementLogger.logCouldNotGetConfigFileLock();
        }
        try {
            int n;
            int n2 = 0;
            for (n = 0; n < 5 && n2 == 0; ++n) {
                n2 = this.pendingDirMgr.deleteAll() ? 1 : 0;
                if (n2 != 0) continue;
                try {
                    Thread.sleep(3000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            n = n2;
            return n != 0;
        }
        finally {
            if (fileLock != null) {
                Utils.releaseConfigFileLock();
            }
        }
    }

    private void setPreparingInfo(long l, long l2) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Set preparing id = " + l2 + " timeouttime = " + l);
        }
        this.setPreparing(true);
        this.setPreparingTimeout(l);
        this.preparingId = l2;
    }

    private void setPreparingTimeout(long l) {
        this.preparingTimeout = l;
    }

    private final synchronized ActivateTaskImpl createActivationTask(long l, long l2, long l3, boolean bl, ArrayList arrayList, AuthenticatedSubject authenticatedSubject, EditLockManager editLockManager, ConfigurationDeployment configurationDeployment) throws EditFailedException {
        if (!bl) {
            try {
                ActivateTaskImpl activateTaskImpl = new ActivateTaskImpl("Activate task with id: " + l, editLockManager, bl, arrayList, authenticatedSubject, l, l2, null);
                return activateTaskImpl;
            }
            catch (ManagementException managementException) {
                throw new EditFailedException(managementException);
            }
        }
        this.validatePreparingInfo();
        if (this.isPreparing()) {
            throw new EditFailedException("Unable to start new Activation while preparing.");
        }
        try {
            this.setPreparingInfo(l3, l);
            ActivateTaskImpl activateTaskImpl = new ActivateTaskImpl("Activate task with id: " + l, editLockManager, bl, arrayList, authenticatedSubject, l, l2, configurationDeployment.getTargets());
            this.activationTasksByRequest.put(new Long(l), activateTaskImpl);
            return activateTaskImpl;
        }
        catch (ManagementException managementException) {
            throw new EditFailedException(managementException);
        }
    }

    private ActivateTaskImpl lookupTask(long l) {
        return (ActivateTaskImpl)this.activationTasksByRequest.get(new Long(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivateTaskImpl lookupOldTask(long l) {
        try {
            WeakHashMap weakHashMap = this.oldActivationTasks;
            synchronized (weakHashMap) {
                Set set = this.oldActivationTasks.keySet();
                for (ActivateTaskImpl activateTaskImpl : set) {
                    if (activateTaskImpl.getTaskId() != l) continue;
                    return activateTaskImpl;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTask(ActivateTask activateTask) {
        this.activationTasksByRequest.remove(new Long(activateTask.getTaskId()));
        WeakHashMap weakHashMap = this.oldActivationTasks;
        synchronized (weakHashMap) {
            try {
                this.oldActivationTasks.put(activateTask, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean areAnyExternalTreesModified(Descriptor descriptor) {
        boolean bl = false;
        Iterator iterator = DescriptorInfoUtils.getDescriptorInfos(descriptor);
        while (iterator != null && iterator.hasNext() && !bl) {
            DescriptorInfo descriptorInfo = (DescriptorInfo)iterator.next();
            Descriptor descriptor2 = descriptorInfo.getDescriptor();
            if (!descriptor2.isModified()) continue;
            bl = true;
        }
        return bl;
    }

    private void setExternalTreesUnmodified(Descriptor descriptor) {
        Iterator iterator = DescriptorInfoUtils.getDescriptorInfos(descriptor);
        while (iterator != null && iterator.hasNext()) {
            DescriptorInfo descriptorInfo = (DescriptorInfo)iterator.next();
            Descriptor descriptor2 = descriptorInfo.getDescriptor();
            if (!descriptor2.isModified()) continue;
            ((DescriptorImpl)descriptor2).setModified(false);
        }
    }

    private void rollbackCurrent() {
        if (this.currentTree != null) {
            this.currentTree.rollbackUpdate();
        }
    }

    private Descriptor getExternalCurrentTree(DescriptorInfo descriptorInfo) {
        Iterator iterator = DescriptorInfoUtils.getDescriptorInfos(this.currentTree);
        while (iterator != null && iterator.hasNext()) {
            DescriptorInfo descriptorInfo2 = (DescriptorInfo)iterator.next();
            ConfigurationExtensionMBean configurationExtensionMBean = descriptorInfo2.getConfigurationExtension();
            ConfigurationExtensionMBean configurationExtensionMBean2 = descriptorInfo.getConfigurationExtension();
            if (configurationExtensionMBean == null || configurationExtensionMBean2 == null || !configurationExtensionMBean.getName().equals(configurationExtensionMBean2.getName()) || !configurationExtensionMBean.getDescriptorFileName().equals(configurationExtensionMBean2.getDescriptorFileName())) continue;
            return descriptorInfo2.getDescriptor();
        }
        return null;
    }

    public BeanInfo getBeanInfo(DescriptorBean descriptorBean) {
        BeanInfoAccess beanInfoAccess = ManagementService.getBeanInfoAccess();
        return beanInfoAccess.getBeanInfoForDescriptorBean(descriptorBean);
    }

    public PropertyDescriptor getPropertyDescriptor(BeanInfo beanInfo, String string) {
        BeanInfoAccess beanInfoAccess = ManagementService.getBeanInfoAccess();
        return beanInfoAccess.getPropertyDescriptor(beanInfo, string);
    }

    public boolean getRestartValue(PropertyDescriptor propertyDescriptor) {
        return ChangeUtils.getRestartValue(propertyDescriptor);
    }

    public static void checkErrors(String string, ArrayList arrayList) throws IOException {
        if (arrayList.size() > 0) {
            XmlValidationError xmlValidationError;
            int n = arrayList.size();
            for (Object object : arrayList) {
                if (object instanceof XmlValidationError) {
                    xmlValidationError = (XmlValidationError)object;
                    if (ConfigFileHelper.isAcceptableXmlValidationError(xmlValidationError)) {
                        --n;
                        continue;
                    }
                    ManagementLogger.logConfigurationValidationProblem((String)string, (String)xmlValidationError.getMessage());
                    continue;
                }
                ManagementLogger.logConfigurationValidationProblem((String)string, (String)object.toString());
            }
            if (schemaValidationEnabled && n > 0) {
                Object object;
                object = "-Dweblogic.configuration.schemaValidationEnabled=false";
                xmlValidationError = ManagementLogger.logConfigurationSchemaFailureLoggable((String)string, (String)object);
                throw new IOException(xmlValidationError.getMessage());
            }
        }
    }

    public static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public synchronized void shutdown() {
        if (this.temporaryTrees.isEmpty()) {
            return;
        }
        System.gc();
        for (String string : this.temporaryTrees.values()) {
            ManagementLogger.logTemporaryBeanTreeNotGarbageCollected((String)string);
        }
    }

    private void addTemporaryTree(Object object, String string) {
        this.temporaryTrees.put(object, string + "(" + new Date() + ")");
    }

    private void setProductionModeInfo(Descriptor descriptor) {
        DescriptorBean descriptorBean = descriptor.getRootBean();
        if (descriptorBean instanceof DomainMBean && ((DomainMBean)descriptorBean).isProductionModeEnabled()) {
            DescriptorHelper.setDescriptorTreeProductionMode(descriptor, true);
        } else {
            DescriptorHelper.setDescriptorTreeProductionMode(descriptor, false);
        }
    }
}

