/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.DomainDir;
import weblogic.management.ManagementLogger;
import weblogic.management.provider.EditWaitTimedOutException;
import weblogic.security.SubjectUtils;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionServiceException;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;

public class EditLockManager {
    private static final String EDIT_LOCK_FILENAME = "edit.lok";
    private static final String OWNER = "owner";
    private static final String ACQUIRED = "acquired";
    private static final String EXPIRES = "expires";
    private static final String EXCLUSIVE = "exclusive";
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationEdit");
    private static final AuthenticatedSubject kernelIdentity = EditLockManager.obtainKernelIdentity();
    private Object owner;
    private long lockAcquisitionTime;
    private long lockExpirationTime;
    private boolean lockExclusiveFlag;
    private LinkedList waiters = new LinkedList();
    private ClearOrEncryptedService encryptionService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EditLockManager() {
        FileInputStream fileInputStream = null;
        try {
            String string;
            String string2;
            String string3;
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Getting encryption service");
            }
            this.encryptionService = new ClearOrEncryptedService(SerializedSystemIni.getEncryptionService());
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Reading edit lock info from lock file");
            }
            Properties properties = new Properties();
            fileInputStream = new FileInputStream(this.getEditLockFilename());
            properties.load(fileInputStream);
            String string4 = properties.getProperty(OWNER);
            String string5 = this.decryptUser(string4);
            if (WLSPrincipals.isKernelUsername((String)string5)) {
                this.owner = kernelIdentity;
            } else if (WLSPrincipals.isAnonymousUsername((String)string5)) {
                this.owner = SubjectUtils.getAnonymousSubject();
            } else if (string5 != null) {
                string3 = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelIdentity, (String)SecurityServiceManager.getDefaultRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
                this.owner = string3.impersonateIdentity(string5, null);
            }
            string3 = properties.getProperty(EXPIRES);
            if (string3 != null) {
                this.lockExpirationTime = Long.parseLong(string3);
            }
            if ((string2 = properties.getProperty(ACQUIRED)) != null) {
                this.lockAcquisitionTime = Long.parseLong(string2);
            }
            if ((string = properties.getProperty(EXCLUSIVE)) != null) {
                this.lockExclusiveFlag = Boolean.valueOf(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Edit lock file was not found, ignoring");
            }
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception occurred reading edit lock file", (Throwable)exception);
            }
            ManagementLogger.logReadEditLockFileFailed((Throwable)exception);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Created edit lock manager " + this);
        }
    }

    synchronized boolean getEditLock(Object object, int n, int n2, boolean bl) throws EditWaitTimedOutException {
        boolean bl2 = false;
        Lock lock = null;
        long l = -1L;
        long l2 = -1L;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Attempting to get edit lock for owner " + object);
        }
        if (object == null) {
            throw new IllegalArgumentException("owner can not be null");
        }
        if (n != -1) {
            l2 = System.currentTimeMillis() + (long)n;
        }
        if (n2 != -1) {
            l = n2;
        }
        if (this.owner == null) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("No current owner - getting lock");
            }
            this.setOwner(object);
            this.setExpirationTime(l);
            this.setExclusive(bl);
            this.persistLock();
            return bl2;
        }
        while (!(this.ownersEqual(object, this.owner) && !this.isLockExclusive() && !bl || lock != null && lock.isRemoved())) {
            long l3 = System.currentTimeMillis();
            if (this.lockExpirationTime > 0L && l3 >= this.lockExpirationTime) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Getting lock - edit lock has expired at " + new Date(this.lockExpirationTime));
                }
                bl2 = true;
                this.clearOwner();
                this.setOwner(object);
                if (lock != null) {
                    this.waiters.remove(lock);
                }
                this.setExpirationTime(l);
                this.setExclusive(bl);
                this.persistLock();
                return bl2;
            }
            if (l2 != -1L && l3 >= l2) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Giving up, give up time was " + new Date(l2));
                }
                if (lock != null) {
                    this.waiters.remove(lock);
                }
                throw new EditWaitTimedOutException("Waited " + n + " milliseconds");
            }
            if (lock == null) {
                lock = new Lock(object, bl, l);
                this.waiters.add(lock);
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Adding owner to waiters list " + object);
                }
            }
            long l4 = -1L;
            if (this.lockExpirationTime > 0L) {
                l4 = this.lockExpirationTime - l3;
            }
            if (l2 != -1L && (l2 < this.lockExpirationTime || this.lockExpirationTime <= 0L)) {
                l4 = l2 - l3;
            }
            try {
                if (l4 == -1L) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Waiting until notified");
                    }
                    this.wait();
                    continue;
                }
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Waiting for " + l4 + " milliseconds");
                }
                this.wait(l4);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (lock != null && !lock.isRemoved()) {
            this.waiters.remove(lock);
        }
        this.setExpirationTime(l);
        this.setExclusive(bl);
        return bl2;
    }

    synchronized void releaseEditLock(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("owner can not be null");
        }
        if (this.owner == null) {
            return;
        }
        if (!this.ownersEqual(this.owner, object)) {
            throw new IllegalStateException("not owner, owner is " + this.owner);
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Release edit lock, owner is " + this.owner);
        }
        this.clearOwner();
        this.persistLock();
        if (!this.waiters.isEmpty()) {
            Lock lock = (Lock)this.waiters.removeFirst();
            lock.setRemoved(true);
            this.setOwner(lock.getLockOwner());
            this.setExclusive(lock.isExclusive());
            this.setExpirationTime(lock.getExpirationTime());
            this.persistLock();
            this.notifyAll();
            return;
        }
    }

    synchronized void cancelEditLock(Object object) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Canceling edit lock, setting new owner " + object);
        }
        if (object == null) {
            throw new IllegalArgumentException("owner can not be null");
        }
        this.clearOwner();
        this.setOwner(object);
        this.persistLock();
    }

    synchronized Object getLockOwner() {
        return this.owner;
    }

    synchronized long getLockAcquisitionTime() {
        return this.lockAcquisitionTime;
    }

    synchronized boolean isLockExclusive() {
        return this.lockExclusiveFlag;
    }

    synchronized long getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    synchronized boolean isLockOwner(Object object) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Checking lock owner for " + object);
            debugLogger.debug("Current owner is " + this.owner);
        }
        return this.ownersEqual(this.owner, object);
    }

    private void setOwner(Object object) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Setting owner to " + object);
        }
        this.owner = object;
        this.lockAcquisitionTime = System.currentTimeMillis();
    }

    private void setExpirationTime(long l) {
        this.lockExpirationTime = l == -1L ? 0L : System.currentTimeMillis() + l;
    }

    private void setExclusive(boolean bl) {
        this.lockExclusiveFlag = bl;
    }

    private void clearOwner() {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Clearing owner and times");
        }
        this.owner = null;
        this.lockAcquisitionTime = 0L;
        this.lockExpirationTime = 0L;
        this.lockExclusiveFlag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistLock() {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Persisting lock");
        }
        FileOutputStream fileOutputStream = null;
        try {
            Properties properties = new Properties();
            if (this.owner != null) {
                if (this.owner instanceof AuthenticatedSubject) {
                    properties.setProperty(OWNER, this.encryptUser(SubjectUtils.getUsername((AuthenticatedSubject)((AuthenticatedSubject)this.owner))));
                } else {
                    properties.setProperty(OWNER, this.encryptUser(this.owner.toString()));
                }
                properties.setProperty(ACQUIRED, "" + this.lockAcquisitionTime);
                properties.setProperty(EXPIRES, "" + this.lockExpirationTime);
                properties.setProperty(EXCLUSIVE, "" + this.lockExclusiveFlag);
            }
            File file = new File(this.getEditLockFilename());
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Writing edit lock to " + file);
            }
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "");
        }
        catch (Exception exception) {
            ManagementLogger.logWriteEditLockFileFailed((Throwable)exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean ownersEqual(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        if (object instanceof AuthenticatedSubject && object2 instanceof AuthenticatedSubject) {
            return SubjectUtils.getUsername((AuthenticatedSubject)((AuthenticatedSubject)object)).equals(SubjectUtils.getUsername((AuthenticatedSubject)((AuthenticatedSubject)object2)));
        }
        return object.equals(object2);
    }

    private String encryptUser(String string) {
        return this.encryptionService.encrypt(string);
    }

    private String decryptUser(String string) {
        if (string == null) {
            return string;
        }
        try {
            return this.encryptionService.decrypt(string);
        }
        catch (EncryptionServiceException encryptionServiceException) {
            ManagementLogger.logEditLockPropertyDecryptionFailure((String)this.getEditLockFilename(), (String)OWNER, (String)string, (String)encryptionServiceException.toString());
            return null;
        }
        catch (Exception exception) {
            ManagementLogger.logEditLockDecryptionFailure((String)this.getEditLockFilename(), (String)exception.toString());
            return null;
        }
    }

    private String getEditLockFilename() {
        return DomainDir.getPathRelativeRootDir((String)EDIT_LOCK_FILENAME);
    }

    private static AuthenticatedSubject obtainKernelIdentity() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        return authenticatedSubject;
    }

    private class Lock {
        private Object lockOwner;
        private boolean exclusive;
        private boolean removed;
        private long expirationTime;

        private Lock(Object object, boolean bl, long l) {
            this.lockOwner = object;
            this.exclusive = bl;
            this.expirationTime = l;
        }

        public Object getLockOwner() {
            return this.lockOwner;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        public void setRemoved(boolean bl) {
            this.removed = bl;
        }

        public boolean isRemoved() {
            return this.removed;
        }
    }
}

