/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.security.AccessController;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.version;

public class ManagementConfigProcessor
implements ConfigurationProcessor {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void updateConfiguration(DomainMBean domainMBean) {
        String string = version.getReleaseBuildVersion();
        domainMBean.setConfigurationVersion(string);
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            serverMBeanArray[i].unSet("ServerVersion");
        }
        if (!ManagementService.getPropertyService(kernelId).isAdminServer()) {
            return;
        }
        domainMBean.setAdminServerName(ManagementService.getPropertyService(kernelId).getServerName());
    }
}

