/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.deploy.internal.targetserver.datamanagement.ConfigData;
import weblogic.deploy.internal.targetserver.datamanagement.Data;
import weblogic.deploy.internal.targetserver.datamanagement.DataUpdateRequestInfo;
import weblogic.deploy.service.ChangeDescriptor;
import weblogic.deploy.service.Deployment;
import weblogic.deploy.service.DeploymentContext;
import weblogic.deploy.service.DeploymentReceiverV2;
import weblogic.deploy.service.DeploymentRequest;
import weblogic.deploy.service.RegistrationException;
import weblogic.deploy.service.internal.DeploymentService;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorCreationListener;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.DescriptorUpdateFailedException;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.Loggable;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.SpecialPropertiesProcessor;
import weblogic.management.configuration.ConfigurationExtensionMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.internal.ProductionModeHelper;
import weblogic.management.provider.MSIService;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.provider.UpdateException;
import weblogic.management.provider.internal.ConfigReader;
import weblogic.management.provider.internal.ConfigurationVersion;
import weblogic.management.provider.internal.DescriptorHelper;
import weblogic.management.provider.internal.DescriptorInfo;
import weblogic.management.provider.internal.DescriptorInfoUtils;
import weblogic.management.provider.internal.DescriptorManagerHelper;
import weblogic.management.provider.internal.EditAccessImpl;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class RuntimeAccessDeploymentReceiverService
extends AbstractServerService
implements DeploymentReceiverV2 {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationEdit");
    private final Data dataObject;
    private ServerRuntimeMBean serverBean;
    private long currRequestId;
    private long lastRequestId;
    private Descriptor currRequestTree;
    private Descriptor proposedConfigTree;
    private boolean prepareCalled;
    private HashMap proposedExternalTrees;
    private List currChangeDescriptors;
    private String callbackHandlerId;
    private static RuntimeAccessDeploymentReceiverService singleton;
    private DeploymentService deploymentService = null;
    private static AuthenticatedSubject kernelId;
    private static String localServerName;
    private ArrayList restartRequestList = new ArrayList();
    private WeakHashMap temporaryTrees = new WeakHashMap();
    private long pendingCommitRequestId = -1L;
    private Descriptor pendingCommitRequestTree;

    public RuntimeAccessDeploymentReceiverService() {
        if (singleton != null) {
            throw new AssertionError((Object)"RuntimeAccessDeploymentReceiverService already initialized");
        }
        this.dataObject = new ConfigData(DomainDir.getRootDir(), this.getLockFileName(), "stage");
        singleton = this;
    }

    public void start() throws ServiceFailureException {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Starting Runtime Access deployment receiver service " + this);
        }
        try {
            if (!ManagementService.getPropertyService(kernelId).isAdminServer()) {
                this.registerHandler();
            }
        }
        catch (RegistrationException registrationException) {
            MSIService.getMSIService().setAdminServerAvailable(false);
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Error registering deployment receiver: ", (Throwable)registrationException);
            }
            return;
        }
    }

    public void stop() {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Stopping Runtime Access deployment receiver service " + this);
        }
        DeploymentService.getDeploymentService().unregisterHandler(this.callbackHandlerId);
        if (this.temporaryTrees.isEmpty()) {
            return;
        }
        System.gc();
        for (String string : this.temporaryTrees.values()) {
            ManagementLogger.logTemporaryBeanTreeNotGarbageCollected((String)string);
        }
    }

    public void halt() {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Halting Runtime Access deployment receiver service " + this);
        }
        this.commitAnyPendingRequests();
    }

    public String getHandlerIdentity() {
        return this.callbackHandlerId;
    }

    public synchronized void prepare(DeploymentContext deploymentContext) {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        Descriptor descriptor = runtimeAccess.getDomain().getDescriptor();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Handling prepare of configuration deployment request for " + deploymentContext.getDeploymentRequest() + " with context " + deploymentContext);
        }
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        if (this.proposedConfigTree == null && this.proposedExternalTrees == null) {
            this.notifyPrepareSuccess(deploymentRequest, false);
            return;
        }
        try {
            Iterator iterator = deploymentRequest.getDeployments(this.callbackHandlerId);
            Deployment deployment = (Deployment)iterator.next();
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("RuntimeDeploymentReceiver: preparing deployment " + deployment);
            }
            Iterator iterator2 = this.currChangeDescriptors.iterator();
            while (iterator2 != null && iterator2.hasNext()) {
                ChangeDescriptor changeDescriptor = (ChangeDescriptor)iterator2.next();
                if (this.isConfigChange(changeDescriptor) || this.isNonWLSChange(changeDescriptor)) continue;
                this.handleExternalTreePrepare(deploymentContext, changeDescriptor, deployment);
            }
            if (this.proposedConfigTree != null) {
                descriptor.prepareUpdate(this.proposedConfigTree, false);
                this.prepareCalled = true;
            }
            this.notifyPrepareSuccess(deploymentRequest, deploymentContext.isRestartRequired());
        }
        catch (Throwable throwable) {
            Loggable loggable = ManagementLogger.logPrepareConfigUpdateFailedLoggable((Throwable)throwable);
            loggable.log();
            this.notifyPrepareFailure(deploymentRequest, (Exception)((Object)new UpdateException(loggable.getMessageBody(), throwable)));
        }
    }

    public synchronized void commit(DeploymentContext deploymentContext) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Handling commit of runtime configuration deployment for " + deploymentContext.getDeploymentRequest() + " with context " + deploymentContext);
        }
        DescriptorUpdateFailedException descriptorUpdateFailedException = null;
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        if (this.currRequestId != deploymentRequest.getId()) {
            if (deploymentRequest.getId() == this.lastRequestId) {
                this.notifyCommitSuccess(deploymentRequest);
            } else {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Commit request id " + deploymentRequest.getId() + " does not match outstanding request id " + this.currRequestId);
                this.notifyCommitFailure(deploymentRequest, illegalArgumentException);
                return;
            }
        }
        try {
            Object object;
            Object object2;
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("RuntimeDeploymentReceiver: committing changes");
            }
            Iterator iterator = null;
            if (this.currChangeDescriptors != null) {
                iterator = this.currChangeDescriptors.iterator();
            }
            while (iterator != null && iterator.hasNext()) {
                object2 = (ChangeDescriptor)iterator.next();
                if (object2.getChangeOperation().equals("delete")) {
                    this.dataObject.deleteFile(object2.getChangeTarget(), deploymentRequest.getId());
                    continue;
                }
                if (!this.isUpdateChange((ChangeDescriptor)object2) || this.isConfigChange((ChangeDescriptor)object2) || this.isNonWLSChange((ChangeDescriptor)object2)) continue;
                object = object2.getChangeTarget();
                try {
                    this.handleExternalTreeCommit((String)object, deploymentContext);
                }
                catch (RuntimeException runtimeException) {
                    if (runtimeException.getCause() instanceof DescriptorUpdateFailedException) {
                        descriptorUpdateFailedException = (DescriptorUpdateFailedException)runtimeException.getCause();
                        continue;
                    }
                    throw runtimeException;
                }
            }
            object2 = ManagementService.getRuntimeAccess(kernelId);
            object = object2.getDomain().getDescriptor();
            if (this.currRequestTree != null) {
                try {
                    AuthenticatedSubject authenticatedSubject = deploymentContext.getDeploymentRequest().getInitiator();
                    if (authenticatedSubject != null) {
                        Object object3 = SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction((Descriptor)object){
                            final /* synthetic */ Descriptor val$currTree;
                            {
                                this.val$currTree = descriptor;
                            }

                            public Object run() {
                                try {
                                    this.val$currTree.activateUpdate();
                                    return null;
                                }
                                catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
                                    throw new RuntimeException(descriptorUpdateFailedException);
                                }
                            }
                        });
                    } else {
                        object.activateUpdate();
                    }
                }
                catch (DescriptorUpdateFailedException descriptorUpdateFailedException2) {
                    descriptorUpdateFailedException = descriptorUpdateFailedException2;
                }
                catch (RuntimeException runtimeException) {
                    if (runtimeException.getCause() instanceof DescriptorUpdateFailedException) {
                        descriptorUpdateFailedException = (DescriptorUpdateFailedException)runtimeException.getCause();
                    }
                    throw runtimeException;
                }
            }
            this.dataObject.closeDataUpdate(deploymentRequest.getId(), true);
            DescriptorInfoUtils.removeAllDeletedDescriptorInfos(object);
            if (descriptorUpdateFailedException != null) {
                throw descriptorUpdateFailedException;
            }
            this.notifyCommitSuccess(deploymentRequest);
            this.resetState();
        }
        catch (Throwable throwable) {
            Loggable loggable = ManagementLogger.logCommitConfigUpdateFailedLoggable((Throwable)throwable);
            loggable.log();
            this.notifyCommitFailure(deploymentRequest, (Exception)((Object)new UpdateException(loggable.getMessageBody(), throwable)));
        }
    }

    private final ServerRuntimeMBean getServerBean() {
        if (this.serverBean == null) {
            this.serverBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        }
        return this.serverBean;
    }

    private final String getLocalServerName() {
        if (localServerName == null) {
            localServerName = ManagementService.getRuntimeAccess(kernelId).getServerName();
        }
        return localServerName;
    }

    private boolean containsLocalServer(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.getLocalServerName().equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean requiresRestart(Deployment deployment) {
        if (deployment == null) {
            return false;
        }
        if (this.getServerBean().isRestartRequired()) {
            return true;
        }
        return this.containsLocalServer(deployment.getServersToBeRestarted());
    }

    private boolean isConfigChange(ChangeDescriptor changeDescriptor) {
        return changeDescriptor.getIdentity() != null && changeDescriptor.getIdentity().equals("config");
    }

    private boolean isUpdateChange(ChangeDescriptor changeDescriptor) {
        return changeDescriptor.getChangeOperation().equals("update");
    }

    private boolean isNonWLSChange(ChangeDescriptor changeDescriptor) {
        return changeDescriptor.getIdentity() != null && changeDescriptor.getIdentity().equals("non-wls");
    }

    public synchronized void cancel(DeploymentContext deploymentContext) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Handling cancel of runtime configuration deployment for " + deploymentContext.getDeploymentRequest() + " with context " + deploymentContext);
        }
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        try {
            this.dataObject.cancelDataUpdate(deploymentRequest.getId());
            this.removeFromRestartList(deploymentRequest);
            if (this.currRequestId == deploymentRequest.getId() && this.currRequestTree != null && this.prepareCalled) {
                this.currRequestTree.rollbackUpdate();
            } else if (this.pendingCommitRequestId == deploymentRequest.getId()) {
                if (this.pendingCommitRequestTree != null) {
                    this.pendingCommitRequestTree.rollbackUpdate();
                }
                this.resetPendingCommitState();
            }
            Iterator iterator = deploymentRequest.getDeployments(this.callbackHandlerId);
            if (iterator.hasNext()) {
                Deployment deployment = (Deployment)iterator.next();
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("RuntimeDeploymentReceiver: handle cancel " + deployment);
                }
            }
            if (this.currRequestId == deploymentRequest.getId()) {
                this.resetState();
            }
            DeploymentService.getDeploymentService().notifyCancelSuccess(deploymentRequest.getId(), this.callbackHandlerId);
        }
        catch (Exception exception) {
            DeploymentService.getDeploymentService().notifyCancelFailure(deploymentRequest.getId(), this.callbackHandlerId, exception);
        }
    }

    private void removeFromRestartList(DeploymentRequest deploymentRequest) {
        if (deploymentRequest == null) {
            return;
        }
        if (this.restartRequestList.remove(new Long(deploymentRequest.getId())) && this.restartRequestList.isEmpty()) {
            this.getServerBean().setRestartRequired(false);
        }
    }

    public void prepareCompleted(DeploymentContext deploymentContext, String string) {
    }

    public void commitCompleted(DeploymentContext deploymentContext, String string) {
    }

    public void commitSkipped(DeploymentContext deploymentContext) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Handling commit skipped request for " + deploymentContext.getDeploymentRequest() + " with context " + deploymentContext);
        }
        this.commitAnyPendingRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateDeploymentContext(DeploymentContext deploymentContext) {
        Object object;
        DeploymentRequest deploymentRequest;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        Descriptor descriptor = runtimeAccess.getDomain().getDescriptor();
        this.proposedConfigTree = null;
        this.prepareCalled = false;
        this.proposedExternalTrees = null;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Handling update deployment of configuration deployment request for " + deploymentContext.getDeploymentRequest() + " with context " + deploymentContext);
        }
        if (this.currRequestId == (deploymentRequest = deploymentContext.getDeploymentRequest()).getId()) {
            this.notifyUpdateSuccess(deploymentRequest);
            return;
        }
        this.commitAnyPendingRequests();
        try {
            Object object2;
            List list;
            Iterator iterator = deploymentRequest.getDeployments(this.callbackHandlerId);
            if (iterator == null || !iterator.hasNext()) {
                this.notifyUpdateSuccess(deploymentRequest);
                return;
            }
            object = (Deployment)iterator.next();
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("RuntimeDeploymentReceiver: update deployment context " + object);
            }
            if (iterator.hasNext()) {
                this.notifyUpdateFailure(deploymentRequest, new IllegalArgumentException("Only one configuration deployment expected."));
                return;
            }
            this.currChangeDescriptors = list = object.getChangeDescriptors();
            if (list == null) {
                this.notifyUpdateFailure(deploymentRequest, new IllegalArgumentException("No changes found."));
                return;
            }
            this.downloadFiles(deploymentRequest.getId(), (Deployment)object);
            Iterator iterator2 = list.iterator();
            while (iterator2 != null && iterator2.hasNext()) {
                object2 = (ChangeDescriptor)iterator2.next();
                if (!this.isConfigChange((ChangeDescriptor)object2)) {
                    if (this.proposedExternalTrees == null) {
                        this.proposedExternalTrees = new HashMap();
                    }
                    this.handleExternalTreeLoad(deploymentRequest.getId(), (ChangeDescriptor)object2);
                    continue;
                }
                this.proposedConfigTree = this.handleConfigTreeLoad(deploymentContext, (ChangeDescriptor)object2, (Deployment)object);
                DomainMBean domainMBean = (DomainMBean)this.proposedConfigTree.getRootBean();
                if (ManagementService.getPropertyService(kernelId).isAdminServer()) {
                    if (ProductionModeHelper.isProductionModePropertySet()) {
                        domainMBean.setProductionModeEnabled(ProductionModeHelper.getProductionModeProperty());
                        continue;
                    }
                    if (!domainMBean.isProductionModeEnabled()) continue;
                    DescriptorHelper.setDescriptorTreeProductionMode(this.proposedConfigTree, true);
                    continue;
                }
                if (ProductionModeHelper.isGlobalProductionModeSet()) {
                    domainMBean.setProductionModeEnabled(ProductionModeHelper.getGlobalProductionMode());
                    continue;
                }
                if (!domainMBean.isProductionModeEnabled()) continue;
                DescriptorHelper.setDescriptorTreeProductionMode(this.proposedConfigTree, true);
            }
            if (this.proposedConfigTree != null) {
                this.addTemporaryTree(this.proposedConfigTree, "updateDeploymentContext");
                DescriptorInfoUtils.setDescriptorLoadExtensions(this.proposedConfigTree, true);
                object2 = (DomainMBean)this.proposedConfigTree.getRootBean();
                SpecialPropertiesProcessor.updateConfiguration((DomainMBean)object2);
                this.currRequestTree = descriptor;
                deploymentContext.addContextComponent("PROPOSED_CONFIGURATION", object2);
            }
            this.setCurrentRequestId(deploymentRequest.getId());
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Setting request id to " + this.currRequestId);
            }
            if (this.requiresRestart((Deployment)object)) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("RuntimeDeploymentReceiver: setting restart required for request " + deploymentRequest.getId());
                }
                deploymentContext.setRestartRequired(true);
                this.getServerBean().setRestartRequired(true);
                this.restartRequestList.add(new Long(deploymentRequest.getId()));
            }
            this.dataObject.commitDataUpdate();
            this.notifyUpdateSuccess(deploymentRequest);
        }
        catch (Throwable throwable) {
            object = ManagementLogger.logPrepareConfigUpdateFailedLoggable((Throwable)throwable);
            object.log();
            this.removeFromRestartList(deploymentRequest);
            this.dataObject.cancelDataUpdate(deploymentRequest.getId());
            this.notifyUpdateFailure(deploymentRequest, (Exception)((Object)new UpdateException(object.getMessageBody(), throwable)));
        }
        finally {
            this.dataObject.releaseLock(deploymentRequest.getId());
        }
    }

    public static RuntimeAccessDeploymentReceiverService getService() {
        return singleton;
    }

    public void registerHandler() throws RegistrationException, ServiceFailureException {
        this.callbackHandlerId = "Configuration";
        ConfigurationVersion configurationVersion = new ConfigurationVersion(true);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Registering handler for configuration with version " + configurationVersion);
        }
        this.deploymentService = DeploymentService.getDeploymentService();
        DeploymentContext deploymentContext = this.deploymentService.registerHandler(configurationVersion, this);
        this.handleRegistrationResponse(deploymentContext);
    }

    private void handleRegistrationResponse(DeploymentContext deploymentContext) throws ServiceFailureException {
        Object object;
        DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
        try {
            List list;
            Iterator iterator = deploymentRequest.getDeployments(this.callbackHandlerId);
            if (iterator == null || !iterator.hasNext()) {
                return;
            }
            object = (Deployment)iterator.next();
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("RuntimeDeploymentReceiver: handle registration " + object);
            }
            if ((list = object.getChangeDescriptors()) == null) {
                return;
            }
            this.updateFiles(deploymentRequest.getId(), (Deployment)object);
        }
        catch (Throwable throwable) {
            object = ManagementLogger.logRegisterConfigUpdateFailedLoggable((Throwable)throwable);
            object.log();
            this.dataObject.cancelDataUpdate(deploymentRequest.getId());
            throw new ServiceFailureException(object.getMessageBody(), throwable);
        }
        finally {
            this.dataObject.closeDataUpdate(deploymentRequest.getId(), true);
        }
    }

    private void notifyUpdateSuccess(DeploymentRequest deploymentRequest) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Update deployment context succeeded for " + deploymentRequest);
        }
        this.deploymentService.notifyContextUpdated(deploymentRequest.getId(), this.callbackHandlerId);
    }

    private void notifyUpdateFailure(DeploymentRequest deploymentRequest, Exception exception) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Update deployment context failed for " + deploymentRequest + " with exception:", (Throwable)exception);
        }
        this.deploymentService.notifyContextUpdateFailed(deploymentRequest.getId(), this.callbackHandlerId, exception);
    }

    private void notifyPrepareSuccess(DeploymentRequest deploymentRequest, boolean bl) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Prepare succeeded for " + deploymentRequest);
        }
        boolean bl2 = false;
        if (bl) {
            Iterator iterator = deploymentRequest.getDeployments();
            iterator.next();
            if (iterator.hasNext()) {
                this.savePendingCommitState();
                bl2 = true;
            }
        }
        this.deploymentService.notifyPrepareSuccess(deploymentRequest.getId(), this.callbackHandlerId);
        if (bl) {
            this.deploymentService.notifyStatusUpdate(deploymentRequest.getId(), this.callbackHandlerId, (Serializable)((Object)"COMMIT_PENDING"));
            if (!bl2) {
                this.dataObject.closeDataUpdate(this.currRequestId, true);
            }
            this.resetState();
        }
    }

    private void notifyPrepareFailure(DeploymentRequest deploymentRequest, Exception exception) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Prepare failed for " + deploymentRequest + " with exception:", (Throwable)exception);
        }
        this.removeFromRestartList(deploymentRequest);
        this.deploymentService.notifyPrepareFailure(deploymentRequest.getId(), this.callbackHandlerId, exception);
    }

    private void notifyCommitSuccess(DeploymentRequest deploymentRequest) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Commit succeeded for " + deploymentRequest);
        }
        this.deploymentService.notifyCommitSuccess(deploymentRequest.getId(), this.callbackHandlerId);
    }

    private void notifyCommitFailure(DeploymentRequest deploymentRequest, Exception exception) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Commit failed for " + deploymentRequest + " with exception:", (Throwable)exception);
        }
        this.deploymentService.notifyCommitFailure(deploymentRequest.getId(), this.callbackHandlerId, exception);
    }

    private void resetState() {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Resetting state for id: " + this.currRequestId);
        }
        this.lastRequestId = this.currRequestId;
        this.setCurrentRequestId(-1L);
        this.currRequestTree = null;
        this.currChangeDescriptors = null;
        this.proposedConfigTree = null;
        this.proposedExternalTrees = null;
        this.prepareCalled = false;
    }

    private void setCurrentRequestId(long l) {
        this.currRequestId = l;
    }

    private String getLockFileName() {
        return "config/config.lok";
    }

    private void updateFiles(long l, Deployment deployment) throws ManagementException {
        try {
            this.downloadFiles(l, deployment);
            this.dataObject.commitDataUpdate();
        }
        catch (Throwable throwable) {
            this.dataObject.cancelDataUpdate(l);
            if (throwable instanceof ManagementException) {
                throw (ManagementException)throwable;
            }
            throw new ManagementException(throwable);
        }
        finally {
            this.dataObject.closeDataUpdate(l, true);
        }
    }

    private void downloadFiles(final long l, Deployment deployment) throws ManagementException {
        Iterator iterator = deployment.getChangeDescriptors().iterator();
        if (iterator == null || !iterator.hasNext()) {
            return;
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            ChangeDescriptor changeDescriptor = (ChangeDescriptor)iterator.next();
            String string = changeDescriptor.getChangeSource();
            arrayList.add(string);
        }
        this.dataObject.initDataUpdate(new DataUpdateRequestInfo(){

            public List getDeltaFiles() {
                return arrayList;
            }

            public long getRequestId() {
                return l;
            }

            public boolean isStatic() {
                return false;
            }

            public boolean isDelete() {
                return false;
            }

            public boolean isPlanUpdate() {
                return false;
            }
        });
        this.dataObject.prepareDataUpdate(deployment.getDataTransferHandlerType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Descriptor handleConfigTreeLoad(DeploymentContext deploymentContext, ChangeDescriptor changeDescriptor, Deployment deployment) throws IOException, DescriptorUpdateRejectedException {
        Descriptor descriptor = null;
        String string = changeDescriptor.getChangeTarget();
        String string2 = changeDescriptor.getChangeOperation();
        InputStream inputStream = null;
        try {
            File file = this.dataObject.getFileFor(deploymentContext.getDeploymentRequest().getId(), string);
            inputStream = new FileInputStream(file);
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("RuntimeDeploymentReceiver: processing change, target: " + string);
            }
            if (!string2.equals("add") && !string2.equals("update")) {
                DeploymentRequest deploymentRequest = deploymentContext.getDeploymentRequest();
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Only update or add operations supported.");
                this.notifyUpdateFailure(deploymentRequest, illegalArgumentException);
                Descriptor descriptor2 = null;
                return descriptor2;
            }
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("RuntimeDeploymentReceiver: loading tree from stream, uri: " + string + " deployment: " + deployment);
            }
            DescriptorManager descriptorManager = DescriptorManagerHelper.getDescriptorManager(false);
            descriptorManager.setDescriptorCreationListener((DescriptorCreationListener)new RuntimeAccessDescriptorCreationListener());
            try {
                ArrayList arrayList = new ArrayList();
                descriptor = descriptorManager.createDescriptor((XMLStreamReader)((Object)new ConfigReader(inputStream)), arrayList, true);
                EditAccessImpl.checkErrors(string, arrayList);
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("RuntimeDeploymentReceiver: created proposed tree from IS : ");
                }
            }
            catch (XMLStreamException xMLStreamException) {
                IOException iOException = new IOException(xMLStreamException.getMessage());
                iOException.initCause(xMLStreamException);
                throw iOException;
            }
            finally {
                descriptorManager.setDescriptorCreationListener(null);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return descriptor;
    }

    private void handleExternalTreeLoad(long l, ChangeDescriptor changeDescriptor) throws IOException, DescriptorUpdateRejectedException {
        String string = changeDescriptor.getChangeTarget();
        String string2 = changeDescriptor.getChangeOperation();
        InputStream inputStream = null;
        try {
            Object object;
            inputStream = new FileInputStream(this.dataObject.getFileFor(l, string));
            if (debugLogger.isDebugEnabled()) {
                object = "RuntimeDeploymentReceiver: processing external tree load, target: " + string + " oper: " + string2;
                debugLogger.debug((String)object);
            }
            object = null;
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            object = runtimeAccess.getDomain().getDescriptor();
            if (string2.equals("update")) {
                Descriptor descriptor = null;
                DescriptorInfo descriptorInfo = this.findDescriptorInfoForFileName((Descriptor)object, string);
                if (descriptorInfo != null) {
                    DescriptorManager descriptorManager = descriptorInfo.getDescriptorManager();
                    ArrayList arrayList = new ArrayList();
                    descriptor = descriptorManager.createDescriptor((XMLStreamReader)((Object)new ConfigReader(inputStream)));
                    EditAccessImpl.checkErrors(string, arrayList);
                    this.proposedExternalTrees.put(string, descriptor);
                    this.addTemporaryTree(descriptor, "updateDeploymentContext." + string);
                    if (ManagementService.getPropertyService(kernelId).isAdminServer()) {
                        if (ProductionModeHelper.isProductionModePropertySet() || runtimeAccess.getDomain().isProductionModeEnabled()) {
                            DescriptorHelper.setDescriptorTreeProductionMode(descriptor, ProductionModeHelper.getProductionModeProperty());
                        }
                    } else if (ProductionModeHelper.isGlobalProductionModeSet() || runtimeAccess.getDomain().isProductionModeEnabled()) {
                        DescriptorHelper.setDescriptorTreeProductionMode(descriptor, ProductionModeHelper.getGlobalProductionMode());
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            IOException iOException = new IOException(xMLStreamException.getMessage());
            iOException.initCause(xMLStreamException);
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void handleExternalTreePrepare(DeploymentContext deploymentContext, ChangeDescriptor changeDescriptor, Deployment deployment) throws IOException, DescriptorUpdateRejectedException {
        String string = changeDescriptor.getChangeTarget();
        String string2 = changeDescriptor.getChangeOperation();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("RuntimeDeploymentReceiver: processing external prepare, target: " + string + " oper: " + string2);
        }
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        Descriptor descriptor = runtimeAccess.getDomain().getDescriptor();
        if (string2.equals("update")) {
            Descriptor descriptor2;
            DescriptorInfo descriptorInfo = this.findDescriptorInfoForFileName(descriptor, string);
            if (descriptorInfo != null && (descriptor2 = (Descriptor)this.proposedExternalTrees.get(string)) != null) {
                Descriptor descriptor3 = descriptorInfo.getDescriptor();
                descriptor3.prepareUpdate(descriptor2, false);
            }
        } else if (string2.equals("add")) {
            DescriptorManager descriptorManager = DescriptorManagerHelper.getDescriptorManager(false);
            FileInputStream fileInputStream = new FileInputStream(new File(DomainDir.getRootDir(), string));
            try {
                ArrayList arrayList = new ArrayList();
                Descriptor descriptor4 = descriptorManager.createDescriptor((XMLStreamReader)((Object)new ConfigReader(fileInputStream)), arrayList, true);
                EditAccessImpl.checkErrors(string, arrayList);
            }
            catch (XMLStreamException xMLStreamException) {
                IOException iOException = new IOException(xMLStreamException.getMessage());
                iOException.initCause(xMLStreamException);
                throw iOException;
            }
            finally {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
    }

    private void handleExternalTreeCommit(String string, DeploymentContext deploymentContext) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("RuntimeDeploymentReceiver: processing external commit, target: " + string);
        }
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        Descriptor descriptor = runtimeAccess.getDomain().getDescriptor();
        AuthenticatedSubject authenticatedSubject = deploymentContext.getDeploymentRequest().getInitiator();
        DescriptorInfo descriptorInfo = this.findDescriptorInfoForFileName(descriptor, string);
        if (descriptorInfo != null) {
            final Descriptor descriptor2 = descriptorInfo.getDescriptor();
            try {
                if (authenticatedSubject != null) {
                    Object object = SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(){

                        public Object run() {
                            try {
                                descriptor2.activateUpdate();
                                return null;
                            }
                            catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
                                throw new RuntimeException(descriptorUpdateFailedException);
                            }
                        }
                    });
                } else {
                    descriptor2.activateUpdate();
                }
            }
            catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
                throw new RuntimeException(descriptorUpdateFailedException);
            }
        }
    }

    private DescriptorInfo findDescriptorInfoForFileName(Descriptor descriptor, String string) {
        Iterator iterator = DescriptorInfoUtils.getDescriptorInfos(descriptor);
        while (iterator != null && iterator.hasNext()) {
            String string2;
            DescriptorInfo descriptorInfo = (DescriptorInfo)iterator.next();
            ConfigurationExtensionMBean configurationExtensionMBean = descriptorInfo.getConfigurationExtension();
            String string3 = new File(string).getPath();
            if (!string3.endsWith(string2 = new File(configurationExtensionMBean.getDescriptorFileName()).getPath())) continue;
            return descriptorInfo;
        }
        return null;
    }

    private void addTemporaryTree(Object object, String string) {
        this.temporaryTrees.put(object, string + "(" + new Date() + ")");
    }

    private void savePendingCommitState() {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Saving pending commit state info: " + this.currRequestId);
        }
        this.pendingCommitRequestId = this.currRequestId;
        this.pendingCommitRequestTree = this.currRequestTree;
    }

    private void resetPendingCommitState() {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Reset pending commit state info: " + this.pendingCommitRequestId);
        }
        this.pendingCommitRequestId = -1L;
        this.pendingCommitRequestTree = null;
    }

    public void commitAnyPendingRequests() {
        if (this.pendingCommitRequestId != -1L) {
            this.dataObject.closeDataUpdate(this.pendingCommitRequestId, true);
            this.resetPendingCommitState();
        }
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private class RuntimeAccessDescriptorCreationListener
    implements DescriptorCreationListener {
        private RuntimeAccessDescriptorCreationListener() {
        }

        public void descriptorCreated(Descriptor descriptor) {
            DescriptorInfoUtils.setDescriptorLoadExtensions(descriptor, false);
        }
    }
}

