/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import com.bea.xml.XmlError;
import com.bea.xml.XmlException;
import com.bea.xml.XmlValidationError;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXParseException;
import weblogic.common.internal.VersionInfo;
import weblogic.descriptor.BasicDescriptorManager;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorCache;
import weblogic.descriptor.DescriptorException;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.internal.DescriptorImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.Loggable;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.SpecialPropertiesProcessor;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.AdminServerMBeanProcessor;
import weblogic.management.internal.BootStrapStruct;
import weblogic.management.internal.ProductionModeHelper;
import weblogic.management.internal.Utils;
import weblogic.management.provider.AccessCallback;
import weblogic.management.provider.MSIService;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.provider.RuntimeAccessSettable;
import weblogic.management.provider.UpdateException;
import weblogic.management.provider.internal.BootStrapHelper;
import weblogic.management.provider.internal.ConfigBackup;
import weblogic.management.provider.internal.DescriptorHelper;
import weblogic.management.provider.internal.DescriptorManagerHelper;
import weblogic.management.provider.internal.DescriptorManagerHelperContext;
import weblogic.management.provider.internal.RegistrationManagerImpl;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.upgrade.ConfigFileHelper;
import weblogic.protocol.ConnectMonitorFactory;
import weblogic.rmi.extensions.ConnectEvent;
import weblogic.rmi.extensions.ConnectListener;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.Debug;

class RuntimeAccessImpl
extends RegistrationManagerImpl
implements RuntimeAccess,
RuntimeAccessSettable,
ConnectListener {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugConfigurationRuntime");
    private static final String ADMIN_HOST_PROP = "weblogic.management.server";
    private static final String OLD_ADMIN_HOST_PROP = "weblogic.admin.host";
    private static int ONE_MINUTE_TIMEOUT = 60000;
    private DomainMBean domain;
    private ServerMBean server;
    private ServerRuntimeMBean serverRuntime;
    private String adminHostProperty;
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private List<String> accessCallbackList = new ArrayList<String>();
    public static final String SCHEMA_VALIDATION_ENABLED_PROP = "weblogic.configuration.schemaValidationEnabled";
    private static final boolean schemaValidationEnabled = RuntimeAccessImpl.getBooleanProperty("weblogic.configuration.schemaValidationEnabled", true);

    public static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    RuntimeAccessImpl() throws ManagementException {
        this.adminHostProperty = System.getProperty(ADMIN_HOST_PROP);
        if (this.adminHostProperty == null) {
            this.adminHostProperty = System.getProperty(OLD_ADMIN_HOST_PROP);
        }
        try {
            long l = 0L;
            long l2 = 0L;
            if (debug.isDebugEnabled()) {
                l = System.currentTimeMillis();
            }
            this.domain = this.parseNewStyleConfig();
            if (debug.isDebugEnabled()) {
                l2 = System.currentTimeMillis();
                Debug.say((String)("CONFIG PARSE TOOK " + (l2 - l) + " milliseconds"));
            }
        }
        catch (ManagementException managementException) {
            throw managementException;
        }
        catch (Throwable throwable) {
            Loggable loggable = ManagementLogger.logConfigurationParseErrorLoggable((String)"config.xml", (String)this.getRootCauseMessage(throwable));
            throw new ManagementException(loggable.getMessage(), throwable);
        }
        String string = Utils.findServerName(this.domain);
        if (string == null) {
            String string2 = "Unable to find a default server";
            throw new ManagementException(string2);
        }
        this.server = this.domain.lookupServer(string);
        if (this.server == null) {
            ServerMBean[] serverMBeanArray = this.domain.getServers();
            String string3 = "{";
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                if (i > 0) {
                    string3 = string3 + ",";
                }
                string3 = string3 + serverMBeanArray[i].getName();
            }
            string3 = string3 + "}";
            Loggable loggable = ManagementLogger.logServerNameDoesNotExistLoggable((String)string, (String)string3);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
        if (this.isAdminServer()) {
            try {
                if (this.domain.isConfigBackupEnabled()) {
                    if (debug.isDebugEnabled()) {
                        Debug.say((String)"BACKUP");
                    }
                    ConfigBackup.saveOriginal();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getRootCauseMessage(Throwable throwable) {
        String string = throwable.getMessage();
        for (throwable = throwable.getCause(); throwable != null; throwable = throwable.getCause()) {
            String string2 = throwable.getMessage();
            if (string2 == null || string2.length() <= 0) continue;
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainMBean parseNewStyleConfig() throws ManagementException {
        DomainMBean domainMBean;
        InputStream inputStream;
        ArrayList arrayList;
        File file;
        DescriptorCache descriptorCache;
        block34: {
            DescriptorHelper.setSkipSetProductionMode(true);
            File file2 = new File(DomainDir.getConfigDir());
            if (!file2.exists()) {
                String string = file2.getAbsolutePath();
                if (!this.isAdminServer() && !this.isAdminServerAvailable()) {
                    Loggable loggable = ManagementLogger.logConfigurationDirMissingNoAdminLoggable((String)string);
                    throw new ManagementException(loggable.getMessage());
                }
                Loggable loggable = ManagementLogger.logConfigurationDirMissingLoggable((String)string);
                throw new ManagementException(loggable.getMessage());
            }
            Serializable serializable = new File(file2, "config.xml");
            if (!((File)serializable).exists()) {
                String string = file2.getAbsolutePath();
                if (!this.isAdminServer() && !this.isAdminServerAvailable()) {
                    Loggable loggable = ManagementLogger.logConfigFileMissingNoAdminLoggable((String)string, (String)"config.xml");
                    throw new ManagementException(loggable.getMessage());
                }
                Loggable loggable = ManagementLogger.logConfigFileMissingLoggable((String)string, (String)"config.xml");
                throw new ManagementException(loggable.getMessage());
            }
            boolean bl = ConfigFileHelper.getProductionModeEnabled();
            if (ProductionModeHelper.isProductionModePropertySet() && ManagementService.getPropertyService(kernelID).isAdminServer()) {
                if (bl && !ProductionModeHelper.getProductionModeProperty()) {
                    ManagementLogger.logDevelopmentModePropertyDiffersFromConfig();
                } else if (!bl && ProductionModeHelper.getProductionModeProperty()) {
                    ManagementLogger.logProductionModePropertyDiffersFromConfig();
                }
            }
            descriptorCache = DescriptorCache.getInstance();
            IOHelperImpl iOHelperImpl = new IOHelperImpl((File)serializable);
            boolean bl2 = bl || Boolean.getBoolean("weblogic.ProductionModeEnabled");
            iOHelperImpl.setProductionModeEnabled(bl2);
            file = new File(file2 + File.separator + "configCache");
            FileLock fileLock = Utils.getConfigFileLock(ONE_MINUTE_TIMEOUT);
            for (int i = 0; fileLock == null && i < 14; ++i) {
                ManagementLogger.logCouldNotGetConfigFileLockRetry((String)("" + ONE_MINUTE_TIMEOUT / 1000));
                fileLock = Utils.getConfigFileLock(ONE_MINUTE_TIMEOUT);
            }
            if (fileLock == null) {
                ManagementLogger.logCouldNotGetConfigFileLock();
            }
            arrayList = null;
            inputStream = null;
            try {
                String string = VersionInfo.theOne().getReleaseVersion();
                boolean bl3 = file.exists();
                boolean bl4 = descriptorCache.hasChanged(file, (DescriptorCache.IOHelper)iOHelperImpl);
                if (bl4 && !bl3 && new File(DomainDir.getInitInfoDir()).exists()) {
                    bl4 = false;
                }
                iOHelperImpl.setValidate(bl4);
                if (!bl4 && !descriptorCache.hasVersionChanged(file, string) || ConfigFileHelper.getConfigurationVersion() >= 11) {
                    iOHelperImpl.setNeedsTransformation(false);
                }
                inputStream = new FileInputStream((File)serializable);
                DomainMBean domainMBean2 = (DomainMBean)iOHelperImpl.parseXML(inputStream);
                arrayList = iOHelperImpl.getErrs();
                this.processSchemaErrors(arrayList, (File)serializable);
                if (iOHelperImpl.isNeedsTransformation() && arrayList != null && arrayList.size() == 0 && !iOHelperImpl.isTransformed()) {
                    descriptorCache.writeVersion(file, string);
                }
                DescriptorHelper.setSkipSetProductionMode(false);
                domainMBean = domainMBean2;
                if (fileLock == null) break block34;
            }
            catch (Throwable throwable) {
                try {
                    if (fileLock != null) {
                        try {
                            fileLock.release();
                            fileLock.channel().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (arrayList == null || arrayList.size() > 0) {
                        descriptorCache.removeCRC(file);
                        descriptorCache.removeVersion(file);
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (XMLStreamException xMLStreamException) {
                    DescriptorHelper.setSkipSetProductionMode(false);
                    throw this.convertXMLStreamException("config.xml", xMLStreamException);
                }
                catch (DescriptorException descriptorException) {
                    DescriptorHelper.setSkipSetProductionMode(false);
                    serializable = descriptorException.getCause();
                    if (serializable instanceof XmlException) {
                        throw this.convertXmlException("config.xml", (XmlException)((Object)serializable));
                    }
                    Loggable loggable = ManagementLogger.logConfigurationParseErrorLoggable((String)"config.xml", (String)this.getRootCauseMessage(descriptorException));
                    throw new ManagementException(loggable.getMessage(), (Throwable)descriptorException);
                }
                catch (IOException iOException) {
                    DescriptorHelper.setSkipSetProductionMode(false);
                    serializable = ManagementLogger.logConfigurationParseErrorLoggable((String)"config.xml", (String)this.getRootCauseMessage(iOException));
                    throw new ManagementException(serializable.getMessage(), (Throwable)iOException);
                }
            }
            try {
                fileLock.release();
                fileLock.channel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (arrayList == null || arrayList.size() > 0) {
            descriptorCache.removeCRC(file);
            descriptorCache.removeVersion(file);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return domainMBean;
    }

    private void processSchemaErrors(List list, File file) throws SchemaValidationException {
        if (list.size() > 0) {
            Object object;
            int n = list.size();
            for (Object object2 : list) {
                if (object2 instanceof XmlValidationError) {
                    object = (XmlValidationError)object2;
                    if (ConfigFileHelper.isAcceptableXmlValidationError(object)) {
                        --n;
                        continue;
                    }
                    ManagementLogger.logConfigurationValidationProblem((String)file.getAbsolutePath(), (String)object.getMessage());
                    continue;
                }
                ManagementLogger.logConfigurationValidationProblem((String)file.getAbsolutePath(), (String)object2.toString());
            }
            if (schemaValidationEnabled && this.isAdminServer() && n > 0) {
                Object object2;
                object2 = file.getAbsolutePath();
                object = "-Dweblogic.configuration.schemaValidationEnabled=false";
                Loggable loggable = ManagementLogger.logConfigurationSchemaFailureLoggable(object2, (String)object);
                throw new SchemaValidationException(loggable.getMessage());
            }
        }
    }

    private ParseException convertXmlException(String string, XmlException xmlException) {
        XmlError xmlError = xmlException.getError();
        if (xmlError != null) {
            int n = xmlError.getLine();
            int n2 = xmlError.getColumn();
            return this.getParseFailureException(string, n, n2, xmlException.getMessage(), xmlException);
        }
        return this.getParseFailureException(string, -1, -1, xmlException.getMessage(), xmlException);
    }

    private ParseException convertXMLStreamException(String string, XMLStreamException xMLStreamException) {
        int n = -1;
        int n2 = -1;
        Location location = xMLStreamException.getLocation();
        if (location != null) {
            n = location.getLineNumber();
            n2 = location.getColumnNumber();
        } else {
            Throwable throwable = xMLStreamException.getNestedException();
            if (throwable instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                n = sAXParseException.getLineNumber();
                n2 = sAXParseException.getColumnNumber();
            }
        }
        return this.getParseFailureException(string, n, n2, xMLStreamException.getMessage(), xMLStreamException);
    }

    private ParseException getParseFailureException(String string, int n, int n2, String string2, Throwable throwable) {
        if (n <= 0) {
            Loggable loggable = ManagementLogger.logConfigurationParseErrorLoggable((String)string, (String)string2);
            return new ParseException(loggable.getMessage(), throwable);
        }
        if (n2 <= 0) {
            Loggable loggable = ManagementLogger.logConfigurationParseError2Loggable((String)string, (int)n, (String)string2);
            return new ParseException(loggable.getMessage(), throwable);
        }
        Loggable loggable = ManagementLogger.logConfigurationParseError3Loggable((String)string, (int)n, (int)n2, (String)string2);
        return new ParseException(loggable.getMessage(), throwable);
    }

    void initialize() throws ManagementException {
        try {
            SpecialPropertiesProcessor.updateConfiguration(this.domain);
        }
        catch (UpdateException updateException) {
            throw new ManagementException((Throwable)((Object)updateException));
        }
        this.addAccessCallbackClass(AdminServerMBeanProcessor.class.getName());
        if (!ManagementService.getPropertyService(kernelID).isAdminServer()) {
            try {
                BootStrapHelper.getBootStrapStruct();
                if (ProductionModeHelper.isGlobalProductionModeSet()) {
                    this.domain.setProductionModeEnabled(ProductionModeHelper.getGlobalProductionMode());
                } else if (this.domain.isProductionModeEnabled()) {
                    DescriptorHelper.setDescriptorTreeProductionMode(this.domain.getDescriptor(), true);
                }
            }
            catch (ConfigurationException configurationException) {
                if (debug.isDebugEnabled()) {
                    debug.debug("Error in configuration: " + (Object)((Object)configurationException), (Throwable)configurationException);
                }
                if (configurationException instanceof BootStrapHelper.UnknownServerException) {
                    throw new ManagementException(configurationException.getMessage());
                }
                ConnectMonitorFactory.getConnectMonitor().addConnectListener((ConnectListener)this);
            }
        } else if (ProductionModeHelper.isProductionModePropertySet()) {
            this.domain.setProductionModeEnabled(ProductionModeHelper.getProductionModeProperty());
        } else if (this.domain.isProductionModeEnabled()) {
            DescriptorHelper.setDescriptorTreeProductionMode(this.domain.getDescriptor(), true);
        }
    }

    public void addAccessCallbackClass(String string) {
        this.accessCallbackList.add(string);
    }

    public AccessCallback[] initializeCallbacks(final DomainMBean domainMBean) {
        AccessCallback[] accessCallbackArray = (AccessCallback[])SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)kernelID, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return RuntimeAccessImpl.this._initializeCallbacks(domainMBean);
            }
        });
        return accessCallbackArray;
    }

    private AccessCallback[] _initializeCallbacks(DomainMBean domainMBean) {
        DescriptorImpl descriptorImpl = (DescriptorImpl)domainMBean.getDescriptor();
        boolean bl = descriptorImpl.isModified();
        AccessCallback[] accessCallbackArray = new AccessCallback[this.accessCallbackList.size()];
        for (int i = 0; i < accessCallbackArray.length; ++i) {
            String string = this.accessCallbackList.get(i);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(null);
                accessCallbackArray[i] = (AccessCallback)constructor.newInstance(null);
                accessCallbackArray[i].accessed(domainMBean);
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException("Failure Initializing Access Callbacks", exception);
            }
        }
        if (!bl && descriptorImpl.isModified()) {
            descriptorImpl.setModified(false);
        }
        return accessCallbackArray;
    }

    public DomainMBean getDomain() {
        return this.domain;
    }

    public ServerMBean getServer() {
        return this.server;
    }

    public String getServerName() {
        return this.server.getName();
    }

    public ServerRuntimeMBean getServerRuntime() {
        return this.serverRuntime;
    }

    public void setServerRuntime(ServerRuntimeMBean serverRuntimeMBean) {
        if (this.serverRuntime != null) {
            throw new AssertionError((Object)"ServerRuntimeMBean may only be set once.");
        }
        this.serverRuntime = serverRuntimeMBean;
    }

    public boolean isAdminServer() {
        return this.adminHostProperty == null;
    }

    public boolean isAdminServerAvailable() {
        return MSIService.getMSIService().isAdminServerAvailable();
    }

    public String getDomainName() {
        return this.domain.getName();
    }

    public String getAdminServerName() {
        String string = this.domain.getAdminServerName();
        try {
            return string != null ? string : (ManagementService.getPropertyService(kernelID).isAdminServer() ? ManagementService.getPropertyService(kernelID).getServerName() : BootStrapHelper.getBootStrapStruct().getAdminServerName());
        }
        catch (ConfigurationException configurationException) {
            return string;
        }
    }

    public void onConnect(ConnectEvent connectEvent) {
        block4: {
            if (!connectEvent.getServerName().equals(this.getAdminServerName())) {
                return;
            }
            try {
                ManagementService.getPropertyService(kernelID).waitForChannelServiceReady();
                if (MSIService.getMSIService().isAdminRequiredButNotSpecifiedOnBoot()) {
                    return;
                }
                BootStrapStruct bootStrapStruct = BootStrapHelper.getBootStrapStruct();
                ConnectMonitorFactory.getConnectMonitor().removeConnectListener((ConnectListener)this);
            }
            catch (ConfigurationException configurationException) {
                if (!debug.isDebugEnabled()) break block4;
                debug.debug("Error in configuration: " + (Object)((Object)configurationException), (Throwable)configurationException);
            }
        }
    }

    private class IOHelperImpl
    implements DescriptorCache.IOHelper {
        private File file;
        private ArrayList errs = new ArrayList();
        private boolean validate = true;
        private boolean needsTransformation = true;
        private boolean transformed = false;
        private boolean productionModeEnabled = false;

        public IOHelperImpl(File file) {
            this.file = file;
        }

        public InputStream openInputStream() throws IOException {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            return fileInputStream;
        }

        private DescriptorBean readCachedDescriptor(File file) throws IOException {
            ObjectInputStream objectInputStream = null;
            try {
                objectInputStream = new ObjectInputStream(new FileInputStream(file));
                DescriptorBean descriptorBean = (DescriptorBean)objectInputStream.readObject();
                return descriptorBean;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (IOException)new IOException(classNotFoundException.getMessage()).initCause(classNotFoundException);
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object readCachedBean(File file) throws IOException {
            DescriptorImpl descriptorImpl = DescriptorImpl.beginConstruction((boolean)false, (BasicDescriptorManager)READONLY_DESCRIPTOR_MANAGER_SINGLETON.instance, null, null);
            DescriptorBean descriptorBean = null;
            try {
                descriptorBean = this.readCachedDescriptor(file);
            }
            finally {
                DescriptorImpl.endConstruction((DescriptorBean)descriptorBean);
            }
            return descriptorBean;
        }

        public Object parseXML(InputStream inputStream) throws IOException, XMLStreamException {
            boolean bl;
            DescriptorManagerHelperContext descriptorManagerHelperContext = new DescriptorManagerHelperContext();
            descriptorManagerHelperContext.setEditable(false);
            descriptorManagerHelperContext.setValidate(this.validate);
            descriptorManagerHelperContext.setTransform(this.needsTransformation);
            descriptorManagerHelperContext.setErrors(this.errs);
            boolean bl2 = bl = ConfigFileHelper.getProductionModeEnabled() || Boolean.getBoolean("weblogic.ProductionModeEnabled");
            if (bl) {
                descriptorManagerHelperContext.setRProductionModeEnabled(bl);
                descriptorManagerHelperContext.setEProductionModeEnabled(bl);
            }
            DescriptorBean descriptorBean = DescriptorManagerHelper.loadDescriptor(inputStream, descriptorManagerHelperContext).getRootBean();
            this.transformed = descriptorManagerHelperContext.isTransformed();
            return descriptorBean;
        }

        protected ArrayList getErrs() {
            return this.errs;
        }

        public boolean useCaching() {
            return false;
        }

        void setValidate(boolean bl) {
            this.validate = bl;
        }

        void setNeedsTransformation(boolean bl) {
            this.needsTransformation = bl;
        }

        boolean isNeedsTransformation() {
            return this.needsTransformation;
        }

        boolean isTransformed() {
            return this.transformed;
        }

        void setProductionModeEnabled(boolean bl) {
            this.productionModeEnabled = bl;
        }

        boolean isProductionModeEnabled() {
            return this.productionModeEnabled;
        }
    }

    private static class READONLY_DESCRIPTOR_MANAGER_SINGLETON {
        static DescriptorManager instance = new DescriptorManager();

        private READONLY_DESCRIPTOR_MANAGER_SINGLETON() {
        }
    }

    public class ParseException
    extends ManagementException {
        public ParseException(String string) {
            super(string);
        }

        public ParseException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public class SchemaValidationException
    extends ManagementException {
        public SchemaValidationException(String string) {
            super(string);
        }
    }
}

