/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.security.AccessController;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.context.JMXContextAccessImpl;
import weblogic.management.context.JMXContextHelper;
import weblogic.management.provider.MSIService;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.internal.RuntimeAccessImpl;
import weblogic.management.provider.internal.RuntimeMBeanHelperImpl;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.RuntimeMBeanHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.version;

public class RuntimeAccessService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void start() throws ServiceFailureException {
        ManagementLogger.logStartupBuildName((String)version.getVersions());
        try {
            RuntimeAccessImpl runtimeAccessImpl = new RuntimeAccessImpl();
            ManagementService.initializeRuntime(runtimeAccessImpl);
            RuntimeMBeanHelperImpl runtimeMBeanHelperImpl = new RuntimeMBeanHelperImpl();
            RuntimeMBeanDelegate.setRuntimeMBeanHelper((RuntimeMBeanHelper)runtimeMBeanHelperImpl);
            ManagementService.getPropertyService(kernelId).doPostParseInitialization(runtimeAccessImpl.getDomain());
            ManagementService.getPropertyService(kernelId).initializeSecurityProperties(false);
            runtimeAccessImpl.initialize();
            if (!ManagementService.getPropertyService(kernelId).isAdminServer()) {
                MSIService.getMSIService().doPostParseInitialization(runtimeAccessImpl.getDomain());
            } else {
                DomainMBean domainMBean = runtimeAccessImpl.getDomain();
                String string = domainMBean.getAdminServerName();
                if (string == null) {
                    String string2 = "There is an attempt to boot Admin Server. However Admin Server Name is not specified in config.xml Please fix your config.xml before starting the Admin Server";
                    throw new ManagementException(string2);
                }
                String string3 = ManagementService.getPropertyService(kernelId).getServerName();
                if (!string3.equals(string)) {
                    String string4 = "Booting as admin server, but servername, " + string3 + ", does not match the admin server name, " + string;
                    throw new ManagementException(string4);
                }
            }
            JMXContextHelper.setJMXContextAccess(new JMXContextAccessImpl());
        }
        catch (RuntimeAccessImpl.SchemaValidationException schemaValidationException) {
            throw new ServiceFailureException(schemaValidationException.getMessage());
        }
        catch (RuntimeAccessImpl.ParseException parseException) {
            throw new ServiceFailureException(parseException.getMessage());
        }
        catch (ManagementException managementException) {
            throw new ServiceFailureException((Throwable)managementException);
        }
    }
}

