/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.provider.internal;

import java.security.AccessController;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RegistrationManager;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanHelper;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

class RuntimeMBeanHelperImpl
implements RuntimeMBeanHelper {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    RuntimeMBeanHelperImpl() {
    }

    public String getServerName() {
        return ManagementService.getRuntimeAccess(kernelId).getServerName();
    }

    public RuntimeMBean getDefaultParent() {
        return ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
    }

    public RegistrationManager getRegistrationManager() {
        return ManagementService.getRuntimeAccess(kernelId);
    }

    public boolean isParentRequired(RuntimeMBean runtimeMBean) {
        return !(runtimeMBean instanceof ServerRuntimeMBean) && !(runtimeMBean instanceof DomainRuntimeMBean);
    }

    public boolean isParentRequired(String string) {
        return !string.equals("ServerRuntime") && !string.equals("DomainRuntime");
    }
}

