/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.remote.common;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.naming.AuthenticationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.security.auth.Subject;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.remote.common.RMIServerWrapper;
import weblogic.management.remote.common.WLSRMIConnector;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.security.Security;

public class ClientProviderBase
implements JMXConnectorProvider {
    public static final String LOCALE_KEY = "weblogic.management.remote.locale";
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugJMXCore");

    public JMXConnector newJMXConnector(JMXServiceURL jMXServiceURL, Map map) throws IOException {
        String string;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Create new JMX connector for " + jMXServiceURL);
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.putAll(map);
        hashMap.put("jmx.remote.x.notification.fetch.timeout", new Long(1000L));
        boolean bl = true;
        if (jMXServiceURL.getProtocol().startsWith("iiop") && (string = System.getProperty("weblogic.system.iiop.enableClient")) != null && string.equals("false")) {
            bl = false;
        }
        if (bl && !hashMap.containsKey("jmx.remote.x.client.connection.check.period")) {
            hashMap.put("jmx.remote.x.client.connection.check.period", new Long(0L));
        }
        return this.makeConnection(jMXServiceURL, hashMap);
    }

    private RMIConnector makeConnection(JMXServiceURL jMXServiceURL, Map map) throws IOException {
        Object object;
        String[] stringArray;
        Object object2;
        String string;
        String string2 = jMXServiceURL.getURLPath();
        if (!string2.startsWith("/jndi/")) {
            throw new MalformedURLException("URL path must begin with /jndi/");
        }
        if (!map.containsKey("java.naming.provider.url") && System.getProperty("java.naming.provider.url") == null) {
            string = jMXServiceURL.getHost();
            boolean bl = string.indexOf(58) >= 0;
            object2 = jMXServiceURL.getProtocol() + "://" + (bl ? "[" : "") + jMXServiceURL.getHost() + (bl ? "]" : "") + ":" + jMXServiceURL.getPort();
            map.put("java.naming.provider.url", object2);
        }
        if (!map.containsKey("java.naming.factory.initial")) {
            map.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        }
        if (!map.containsKey("jmx.remote.credentials") && map.containsKey("java.naming.security.principal") && map.containsKey("java.naming.security.credentials")) {
            string = map.get("java.naming.security.principal");
            Object v = map.get("java.naming.security.credentials");
            if (string instanceof String && v instanceof String) {
                object2 = new String[]{string, (String)v};
                map.put("jmx.remote.credentials", object2);
            }
        }
        if (!map.containsKey("java.naming.security.principal") && map.containsKey("jmx.remote.credentials") && (string = map.get("jmx.remote.credentials")) != null && string instanceof String[] && (stringArray = (String[])String[].class.cast(string)).length == 2) {
            map.put("java.naming.security.principal", stringArray[0]);
            map.put("java.naming.security.credentials", stringArray[1]);
        }
        int n = 0;
        String string3 = "jmx.remote.x.request.waiting.timeout";
        if (map.containsKey(string3) && (object2 = map.get(string3)) instanceof Long) {
            n = ((Long)object2).intValue();
            if (n > 0) {
                map.put("weblogic.jndi.requestTimeout", object2);
                map.put("weblogic.rmi.clientTimeout", object2);
            } else {
                n = Integer.MAX_VALUE;
                map.put("weblogic.rmi.clientTimeout", new Long(n));
            }
        }
        if ((object2 = (Locale)map.remove(LOCALE_KEY)) == null) {
            object2 = ClientProviderBase.getSystemPropertyLocale();
        }
        Hashtable hashtable = ClientProviderBase.mapToHashtable(map);
        InitialContext initialContext = null;
        Subject subject = null;
        boolean bl = true;
        try {
            initialContext = new InitialContext(hashtable);
            object = initialContext.lookup(string2.substring(6));
            subject = Security.getCurrentSubject();
            if (n > 0) {
                bl = false;
            }
        }
        catch (NamingException namingException) {
            if (namingException instanceof AuthenticationException) {
                if (namingException.getCause() != null && namingException.getCause() instanceof SecurityException) {
                    throw (SecurityException)namingException.getCause();
                }
                throw new SecurityException(namingException.getCause());
            }
            if (namingException instanceof NoPermissionException) {
                throw new SecurityException("Anonymous attempt to get to a JNDI resource");
            }
            IOException iOException = new IOException(namingException.getMessage());
            iOException.initCause(namingException);
            throw iOException;
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        finally {
            if (initialContext != null && bl) {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {}
                initialContext = null;
            }
        }
        RMIServerWrapper rMIServerWrapper = new RMIServerWrapper(ClientProviderBase.narrowServer(object), subject, initialContext, (Locale)object2);
        return new WLSRMIConnector(rMIServerWrapper, map, subject);
    }

    private static RMIServer narrowServer(Object object) {
        try {
            return (RMIServer)PortableRemoteObject.narrow((Object)object, RMIServer.class);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private static Hashtable mapToHashtable(Map map) {
        Hashtable hashtable = new Hashtable(map.size());
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (k == null || v == null || !(v instanceof Serializable)) continue;
            hashtable.put(k, v);
        }
        return hashtable;
    }

    protected static Locale getSystemPropertyLocale() throws IllegalArgumentException {
        String string = System.getProperty(LOCALE_KEY);
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("-");
        if (stringArray.length == 1) {
            return new Locale(stringArray[0]);
        }
        if (stringArray.length == 2) {
            return new Locale(stringArray[0], stringArray[1]);
        }
        if (stringArray.length == 3) {
            return new Locale(stringArray[0], stringArray[1], stringArray[2]);
        }
        throw new IllegalArgumentException("Invalid value for -Dweblogic.management.remote.locale: " + string + " " + "Valid values are of the form lowercase two-letter ISO-639 code or " + "(lowercase two-letter ISO-639 code)-(upper-case, two-letter codes ISO-3166) or " + "(lowercase two-letter ISO-639 code)-(upper-case, two-letter codes ISO-3166)-(variant code) " + "For instance es or es-ES or es-ES-Traditional_WIN");
    }
}

