/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.remote.common;

import java.io.IOException;
import java.rmi.MarshalledObject;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.NotificationResult;
import javax.management.remote.rmi.RMIConnection;
import javax.security.auth.Subject;
import weblogic.management.context.JMXContext;
import weblogic.management.context.JMXContextHelper;
import weblogic.management.remote.common.RMIServerWrapper;
import weblogic.security.Security;

class RMIConnectionWrapper
implements RMIConnection {
    private RMIConnection connection;
    private boolean disconnected = false;
    private Subject subject = null;
    private Locale locale;
    private HashMap localeMap = new HashMap();
    private boolean defaultLocale = false;
    private RMIServerWrapper rmiServerWrapper = null;

    RMIConnectionWrapper(RMIConnection rMIConnection, Subject subject, Locale locale, RMIServerWrapper rMIServerWrapper) {
        this.subject = subject;
        this.connection = rMIConnection;
        this.rmiServerWrapper = rMIServerWrapper;
        if (locale == null) {
            this.locale = Locale.getDefault();
            this.defaultLocale = true;
        } else {
            this.locale = locale;
        }
    }

    public void disconnected() {
        this.disconnected = true;
    }

    public void close() throws IOException {
        if (!this.disconnected) {
            this.connection.close();
        }
        this.rmiServerWrapper.clearClientConnection(this);
    }

    public void setLocale(Locale locale) {
        this.setLocale(null, locale);
    }

    public void setLocale(Subject subject, Locale locale) {
        this.localeMap.put(subject, locale);
    }

    public String getConnectionId() throws IOException {
        String string = null;
        try {
            string = (String)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.getConnectionId();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return string;
    }

    public ObjectInstance createMBean(final String string, final ObjectName objectName, final Subject subject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectInstance objectInstance = null;
        try {
            objectInstance = (ObjectInstance)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.createMBean(string, objectName, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)exception;
            }
            if (exception instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return objectInstance;
    }

    public ObjectInstance createMBean(final String string, final ObjectName objectName, final ObjectName objectName2, final Subject subject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        ObjectInstance objectInstance = null;
        try {
            objectInstance = (ObjectInstance)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.createMBean(string, objectName, objectName2, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)exception;
            }
            if (exception instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return objectInstance;
    }

    public ObjectInstance createMBean(final String string, final ObjectName objectName, final MarshalledObject marshalledObject, final String[] stringArray, final Subject subject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectInstance objectInstance = null;
        try {
            objectInstance = (ObjectInstance)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.createMBean(string, objectName, marshalledObject, stringArray, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)exception;
            }
            if (exception instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return objectInstance;
    }

    public ObjectInstance createMBean(final String string, final ObjectName objectName, final ObjectName objectName2, final MarshalledObject marshalledObject, final String[] stringArray, final Subject subject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        ObjectInstance objectInstance = null;
        try {
            objectInstance = (ObjectInstance)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.createMBean(string, objectName, objectName2, marshalledObject, stringArray, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)exception;
            }
            if (exception instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return objectInstance;
    }

    public void unregisterMBean(final ObjectName objectName, final Subject subject) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    RMIConnectionWrapper.this.connection.unregisterMBean(objectName, subject);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
    }

    public ObjectInstance getObjectInstance(final ObjectName objectName, final Subject subject) throws InstanceNotFoundException, IOException {
        ObjectInstance objectInstance = null;
        try {
            objectInstance = (ObjectInstance)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.getObjectInstance(objectName, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return objectInstance;
    }

    public Set queryMBeans(final ObjectName objectName, final MarshalledObject marshalledObject, final Subject subject) throws IOException {
        Set set = null;
        try {
            set = (Set)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.queryMBeans(objectName, marshalledObject, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return set;
    }

    public Set queryNames(final ObjectName objectName, final MarshalledObject marshalledObject, final Subject subject) throws IOException {
        Set set = null;
        try {
            set = (Set)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.queryNames(objectName, marshalledObject, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return set;
    }

    public boolean isRegistered(final ObjectName objectName, final Subject subject) throws IOException {
        Boolean bl = null;
        try {
            bl = (Boolean)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.isRegistered(objectName, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return bl;
    }

    public Integer getMBeanCount(final Subject subject) throws IOException {
        Integer n = null;
        try {
            n = (Integer)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.getMBeanCount(subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return n;
    }

    public Object getAttribute(final ObjectName objectName, final String string, final Subject subject) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        Object object = null;
        try {
            this.initializeJMXContext(subject);
            object = Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.getAttribute(objectName, string, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        finally {
            this.removeJMXContext();
        }
        return object;
    }

    public AttributeList getAttributes(final ObjectName objectName, final String[] stringArray, final Subject subject) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList attributeList = null;
        try {
            this.initializeJMXContext(subject);
            attributeList = (AttributeList)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.getAttributes(objectName, stringArray, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        finally {
            this.removeJMXContext();
        }
        return attributeList;
    }

    public void setAttribute(final ObjectName objectName, final MarshalledObject marshalledObject, final Subject subject) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        try {
            this.initializeJMXContext(subject);
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    RMIConnectionWrapper.this.connection.setAttribute(objectName, marshalledObject, subject);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)exception;
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        finally {
            this.removeJMXContext();
        }
    }

    public AttributeList setAttributes(final ObjectName objectName, final MarshalledObject marshalledObject, final Subject subject) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList attributeList = null;
        try {
            this.initializeJMXContext(subject);
            attributeList = (AttributeList)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.setAttributes(objectName, marshalledObject, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        finally {
            this.removeJMXContext();
        }
        return attributeList;
    }

    public Object invoke(final ObjectName objectName, final String string, final MarshalledObject marshalledObject, final String[] stringArray, final Subject subject) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object object = null;
        try {
            this.initializeJMXContext(subject);
            object = Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.invoke(objectName, string, marshalledObject, stringArray, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        finally {
            this.removeJMXContext();
        }
        return object;
    }

    public String getDefaultDomain(final Subject subject) throws IOException {
        String string = null;
        try {
            string = (String)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.getDefaultDomain(subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return string;
    }

    public String[] getDomains(final Subject subject) throws IOException {
        String[] stringArray = null;
        try {
            stringArray = (String[])Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.getDomains(subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return stringArray;
    }

    private void initializeJMXContext(Subject subject) {
        JMXContext jMXContext;
        boolean bl;
        Locale locale = (Locale)this.localeMap.get(subject);
        boolean bl2 = bl = !this.defaultLocale || locale != null;
        if (locale == null) {
            locale = this.locale;
        }
        if ((jMXContext = JMXContextHelper.getJMXContext(true)).getLocale() == null || bl) {
            jMXContext.setLocale(locale);
        }
        JMXContextHelper.putJMXContext(jMXContext);
    }

    private void removeJMXContext() {
        JMXContextHelper.removeJMXContext();
    }

    public MBeanInfo getMBeanInfo(final ObjectName objectName, final Subject subject) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanInfo mBeanInfo = null;
        try {
            this.initializeJMXContext(subject);
            mBeanInfo = (MBeanInfo)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.getMBeanInfo(objectName, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IntrospectionException) {
                throw (IntrospectionException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        finally {
            this.removeJMXContext();
        }
        return mBeanInfo;
    }

    public boolean isInstanceOf(final ObjectName objectName, final String string, final Subject subject) throws InstanceNotFoundException, IOException {
        Boolean bl = null;
        try {
            bl = (Boolean)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.isInstanceOf(objectName, string, subject);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return bl;
    }

    public void addNotificationListener(final ObjectName objectName, final ObjectName objectName2, final MarshalledObject marshalledObject, final MarshalledObject marshalledObject2, final Subject subject) throws InstanceNotFoundException, IOException {
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    RMIConnectionWrapper.this.connection.addNotificationListener(objectName, objectName2, marshalledObject, marshalledObject2, subject);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
    }

    public void removeNotificationListener(final ObjectName objectName, final ObjectName objectName2, final Subject subject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    RMIConnectionWrapper.this.connection.removeNotificationListener(objectName, objectName2, subject);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
    }

    public void removeNotificationListener(final ObjectName objectName, final ObjectName objectName2, final MarshalledObject marshalledObject, final MarshalledObject marshalledObject2, final Subject subject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    RMIConnectionWrapper.this.connection.removeNotificationListener(objectName, objectName2, marshalledObject, marshalledObject2, subject);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
    }

    public Integer[] addNotificationListeners(final ObjectName[] objectNameArray, final MarshalledObject[] marshalledObjectArray, final Subject[] subjectArray) throws InstanceNotFoundException, IOException {
        Integer[] integerArray = null;
        try {
            integerArray = (Integer[])Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.addNotificationListeners(objectNameArray, marshalledObjectArray, subjectArray);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return integerArray;
    }

    public void removeNotificationListeners(final ObjectName objectName, final Integer[] integerArray, final Subject subject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    RMIConnectionWrapper.this.connection.removeNotificationListeners(objectName, integerArray, subject);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
    }

    public NotificationResult fetchNotifications(final long l, final int n, final long l2) throws IOException {
        NotificationResult notificationResult = null;
        try {
            notificationResult = (NotificationResult)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIConnectionWrapper.this.connection.fetchNotifications(l, n, l2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RuntimeException(exception == null ? privilegedActionException : exception);
        }
        return notificationResult;
    }
}

