/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.remote.common;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIServer;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import weblogic.management.remote.common.RMIConnectionWrapper;

class RMIServerWrapper
implements RMIServer {
    RMIServer rmiServer;
    private Subject subject;
    private Locale locale;
    List connectionList = new ArrayList();
    InitialContext ctx;

    public RMIServerWrapper(RMIServer rMIServer, Subject subject, InitialContext initialContext, Locale locale) {
        this.rmiServer = rMIServer;
        this.subject = subject;
        this.ctx = initialContext;
        this.locale = locale;
    }

    public String getVersion() throws RemoteException {
        return this.rmiServer.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMIConnection newClient(Object object) throws IOException {
        this.clearClientConnection(null);
        RMIConnection rMIConnection = this.rmiServer.newClient(object);
        RMIConnectionWrapper rMIConnectionWrapper = new RMIConnectionWrapper(rMIConnection, this.subject, this.locale, this);
        List list = this.connectionList;
        synchronized (list) {
            this.connectionList.add(new WeakReference<RMIConnectionWrapper>(rMIConnectionWrapper));
        }
        return rMIConnectionWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected() {
        List list = this.connectionList;
        synchronized (list) {
            Iterator iterator = this.connectionList.iterator();
            while (iterator.hasNext()) {
                RMIConnectionWrapper rMIConnectionWrapper = (RMIConnectionWrapper)((WeakReference)iterator.next()).get();
                if (rMIConnectionWrapper == null) continue;
                rMIConnectionWrapper.disconnected();
            }
            this.connectionList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearClientConnection(RMIConnectionWrapper rMIConnectionWrapper) {
        List list = this.connectionList;
        synchronized (list) {
            Iterator iterator = this.connectionList.iterator();
            while (iterator.hasNext()) {
                RMIConnectionWrapper rMIConnectionWrapper2 = (RMIConnectionWrapper)((WeakReference)iterator.next()).get();
                if (rMIConnectionWrapper2 != null && !rMIConnectionWrapper2.equals(rMIConnectionWrapper)) continue;
                iterator.remove();
            }
        }
    }
}

