/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.remote.common;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.remote.common.RMIConnectionWrapper;
import weblogic.management.remote.common.RMIServerWrapper;
import weblogic.management.remote.common.WLSJMXConnector;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitor;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.DisconnectMonitorUnavailableException;
import weblogic.security.Security;

public class WLSRMIConnector
extends RMIConnector
implements DisconnectListener,
WLSJMXConnector {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugJMXCore");
    private Subject subject;
    private RMIServerWrapper server;
    private DisconnectMonitor monitor;
    private static Method isLocalMethod;

    public WLSRMIConnector(RMIServerWrapper rMIServerWrapper, Map map, Subject subject) {
        super(rMIServerWrapper, map);
        this.subject = subject;
        this.server = rMIServerWrapper;
        if (this.checkLocalWithReflection(rMIServerWrapper)) {
            return;
        }
        try {
            this.monitor = DisconnectMonitorListImpl.getDisconnectMonitor();
            this.monitor.addDisconnectListener((Remote)rMIServerWrapper, (DisconnectListener)this);
        }
        catch (DisconnectMonitorUnavailableException disconnectMonitorUnavailableException) {
            // empty catch block
        }
    }

    private boolean checkLocalWithReflection(RMIServer rMIServer) {
        if (isLocalMethod != null) {
            try {
                return (Boolean)isLocalMethod.invoke(null, rMIServer);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
        return false;
    }

    public void onDisconnect(DisconnectEvent disconnectEvent) {
        try {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("WLSRMIConnector: onDisconnect ");
            }
            this.server.disconnected();
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void connect() throws IOException {
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    WLSRMIConnector.this.doConnect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void doConnect() throws IOException {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("WLSRMIConnector: doConnect ");
        }
        super.connect();
    }

    public synchronized void connect(Map map) throws IOException {
        final Map map2 = map;
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    WLSRMIConnector.this.doConnect(map2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private synchronized void doConnect(Map map) throws IOException {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("WLSRMIConnector: doConnect ");
        }
        super.connect(map);
    }

    public void close() throws IOException {
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    WLSRMIConnector.this.removeDisconnectListener();
                    WLSRMIConnector.this.doClose();
                    return null;
                }
            });
            if (this.server.ctx != null) {
                this.server.ctx.close();
                this.server.ctx = null;
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private void doClose() throws IOException {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("WLSRMIConnector: doClose ");
        }
        super.close();
    }

    private void removeDisconnectListener() {
        try {
            if (this.monitor != null) {
                this.monitor.removeDisconnectListener((Remote)this.server, (DisconnectListener)this);
            }
        }
        catch (DisconnectMonitorUnavailableException disconnectMonitorUnavailableException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MBeanServerConnection getMBeanServerConnection(Locale locale) throws IOException {
        MBeanServerConnection mBeanServerConnection = super.getMBeanServerConnection();
        if (this.server == null || this.server.connectionList == null) {
            return mBeanServerConnection;
        }
        String string = this.getConnectionId();
        List list = this.server.connectionList;
        synchronized (list) {
            Iterator iterator = this.server.connectionList.iterator();
            while (iterator.hasNext()) {
                RMIConnectionWrapper rMIConnectionWrapper = (RMIConnectionWrapper)((WeakReference)iterator.next()).get();
                if (rMIConnectionWrapper == null || !string.equals(rMIConnectionWrapper.getConnectionId())) continue;
                rMIConnectionWrapper.setLocale(locale);
                break;
            }
        }
        return mBeanServerConnection;
    }

    public synchronized MBeanServerConnection getMBeanServerConnection(Subject subject, Locale locale) throws IOException {
        MBeanServerConnection mBeanServerConnection = super.getMBeanServerConnection(subject);
        if (this.server == null || this.server.connectionList == null) {
            return mBeanServerConnection;
        }
        String string = this.getConnectionId();
        for (RMIConnectionWrapper rMIConnectionWrapper : this.server.connectionList) {
            if (!string.equals(rMIConnectionWrapper.getConnectionId())) continue;
            rMIConnectionWrapper.setLocale(subject, locale);
            break;
        }
        return mBeanServerConnection;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("weblogic.rmi.extensions.server.ServerHelper");
        }
        catch (ClassNotFoundException classNotFoundException) {
            isLocalMethod = null;
        }
        if (clazz != null) {
            Class[] classArray = new Class[]{Remote.class};
            try {
                isLocalMethod = clazz.getDeclaredMethod("isLocal", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                isLocalMethod = null;
            }
        }
    }
}

