/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.remote.iiop;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.server.ServerNotActiveException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.EndPoint;

public class IIOPServerImpl
extends RMIServerImpl {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugJMXCore");
    private final Map env;
    private Map disconnectListeners = new ConcurrentHashMap();

    public IIOPServerImpl(Map map) {
        super(map);
        this.env = map == null ? Collections.EMPTY_MAP : map;
    }

    protected void export() throws IOException {
        PortableRemoteObject.exportObject((Remote)this);
    }

    public Remote toStub() throws IOException {
        Remote remote = PortableRemoteObject.toStub((Remote)this);
        return remote;
    }

    protected RMIConnection makeClient(String string, Subject subject) throws IOException {
        if (string == null) {
            throw new NullPointerException("Null connectionId");
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Make client for " + string + " subject " + subject);
        }
        RMIConnectionImpl rMIConnectionImpl = new RMIConnectionImpl(this, string, this.getDefaultClassLoader(), subject, this.env);
        PortableRemoteObject.exportObject((Remote)rMIConnectionImpl);
        try {
            EndPoint endPoint = ServerHelper.getClientEndPoint();
            if (!endPoint.getHostID().isLocal()) {
                ConnectorListener connectorListener = new ConnectorListener(rMIConnectionImpl, endPoint);
                endPoint.addDisconnectListener(null, (DisconnectListener)connectorListener);
                this.disconnectListeners.put(rMIConnectionImpl, connectorListener);
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        return rMIConnectionImpl;
    }

    protected void closeClient(RMIConnection rMIConnection) throws IOException {
        DisconnectListener disconnectListener;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("IIOPServerImpl close client " + rMIConnection);
        }
        if ((disconnectListener = (DisconnectListener)this.disconnectListeners.remove(rMIConnection)) != null) {
            disconnectListener.onDisconnect(null);
        }
        PortableRemoteObject.unexportObject((Remote)rMIConnection);
    }

    protected String getProtocol() {
        return "iiop";
    }

    protected void closeServer() throws IOException {
        PortableRemoteObject.unexportObject((Remote)this);
    }

    private class ConnectorListener
    implements DisconnectListener {
        RMIConnection toMonitor;
        private EndPoint endPoint;

        ConnectorListener(RMIConnection rMIConnection, EndPoint endPoint) {
            this.toMonitor = rMIConnection;
            this.endPoint = endPoint;
        }

        public void onDisconnect(DisconnectEvent disconnectEvent) {
            try {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("IIOPServerImpl onDisconnect called");
                }
                try {
                    this.endPoint.removeDisconnectListener(null, (DisconnectListener)this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.toMonitor.close();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
    }
}

