/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.scripting;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.scripting.BrowseHelper;
import weblogic.management.scripting.ScriptException;
import weblogic.management.scripting.WLScriptContext;
import weblogic.management.scripting.utils.ErrorInformation;
import weblogic.management.scripting.utils.WLSTMsgTextFormatter;
import weblogic.utils.StringUtils;

public class BrowseHandler
extends BrowseHelper {
    private boolean currentlyResetting = false;
    private WLSTMsgTextFormatter txtFmt;
    private static final String DOTDOT = "..";
    private static final String NAME_KEY = "Name";
    private static final String SLASH = "/";
    private static final String BACKSLASH = "\\";
    private static final String EMPTY_STRING = "";
    int slipCdCount = 0;

    public BrowseHandler(WLScriptContext ctx) {
        this.ctx = ctx;
        this.txtFmt = ctx.getWLSTMsgFormatter();
    }

    void pop() throws ScriptException {
        try {
            if (this.ctx.domainType.equals("JNDI")) {
                this.handleJndiPop();
                return;
            }
            if (this.ctx.domainType.equals("DomainRuntime") && !this.ctx.isAdminServer ? this.ctx.prompts.size() == 2 : this.ctx.prompts.size() == 0 || this.ctx.beans.size() == 0) {
                return;
            }
            if (this.ctx.domainType.equals("Custom_Domain")) {
                this.handleCustomDomainPop();
                return;
            }
            if (this.ctx.domainType.equals("DomainCustom_Domain")) {
                this.handleDomainCustomDomainPop();
                return;
            }
            if (this.ctx.inNewTree()) {
                if (this.delegateToDomainRuntimeHandler(DOTDOT)) {
                    this.ctx.domainRuntimeHandler.pop();
                    return;
                }
                if (this.delegateToServerRuntimeHandler(DOTDOT)) {
                    this.ctx.serverRuntimeHandler.pop();
                    return;
                }
                this.ctx.newBrowseHandler.pop();
                return;
            }
            if (this.ctx.inMBeanType || this.ctx.inMBeanTypes) {
                this.changeToBeanLevel();
                this.popAndPeek();
            } else if (this.ctx.atBeanLevel) {
                this.popAndPeek();
                String prevName = (String)this.ctx.prompts.peek();
                Object obj = this.ctx.mbs.getAttribute(this.ctx.getObjectName(this.ctx.beans.peek()), prevName);
                if (obj instanceof ObjectName || obj instanceof ObjectName[]) {
                    if (obj instanceof ObjectName) {
                        this.ctx.wlInstanceObjName = (ObjectName)obj;
                        this.changeToMBeanTypeLevel();
                        this.populateNames(obj);
                    } else {
                        this.ctx.wlInstanceObjNames = (ObjectName[])obj;
                        this.changeToMBeanTypesLevel();
                        this.populateNames(obj);
                    }
                    this.ctx.prompt = this.ctx.evaluatePrompt();
                }
            }
            this.ctx.prompt = this.ctx.evaluatePrompt();
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException(this.txtFmt.getErrorCdingToBean(), th);
        }
    }

    private void splitPush(String[] strs, String delimiter) throws ScriptException {
        String curPrompt = this.ctx.prompt;
        for (int i = 0; i < strs.length; ++i) {
            try {
                if (this.slipCdCount > 0) {
                    for (int j = 0; j < this.slipCdCount; ++j) {
                        ++i;
                    }
                    this.slipCdCount = 0;
                }
                if (i >= strs.length) {
                    this.slipCdCount = 0;
                    continue;
                }
                if (incrementCdCount) {
                    incrementCdCount = false;
                    continue;
                }
                String restCdArgument = strs[i];
                if (i < strs.length - 1) {
                    nextCdValue = strs[i + 1];
                    for (int j = i + 1; j < strs.length; ++j) {
                        restCdArgument = restCdArgument + delimiter + strs[j];
                    }
                }
                this.regularPush(strs[i], restCdArgument);
                nextCdValue = EMPTY_STRING;
                continue;
            }
            catch (Throwable th) {
                this.resetCD(curPrompt);
                throw new ScriptException(this.txtFmt.getErrorCdingToBean(), th, "cd");
            }
        }
    }

    private void regularPush(String mname, String restCdArgument) throws ScriptException {
        if (this.cdDone) {
            return;
        }
        String currentPrompt = this.ctx.prompt;
        try {
            if (mname.equals(DOTDOT)) {
                if (this.ctx.domainType.equals("JNDI")) {
                    this.handleJndiPop();
                } else {
                    this.pop();
                }
                return;
            }
            String tree = this.ctx.getTreeFromArgument(mname + SLASH);
            if (tree != null) {
                this.jumpTree(tree);
                this.takeBackToRoot();
                return;
            }
            if (this.ctx.domainType.equals("JNDI")) {
                this.handleJndiCd(mname);
                return;
            }
            if (this.ctx.domainType.equals("Custom_Domain")) {
                this.cdToCustomBeanInstance(mname, restCdArgument);
                return;
            }
            if (this.ctx.domainType.equals("DomainCustom_Domain")) {
                this.cdToDomainCustomBeanInstance(mname, restCdArgument);
                return;
            }
            if (this.ctx.inMBeanType) {
                String name;
                boolean fnd = false;
                if (this.ctx.wlInstanceObjName == null) {
                    this.ctx.errorMsg = this.txtFmt.getAttributeNotFound(mname);
                    this.ctx.errorInfo = new ErrorInformation(this.ctx.errorMsg);
                    this.ctx.exceptionHandler.handleException(this.ctx.errorInfo);
                } else if (this.ctx.wlInstanceObjName.getKeyProperty(NAME_KEY).equals(mname) || this.ctx.wlInstanceObjName_name.equals(mname)) {
                    this.ctx.prompts.add(mname);
                    this.ctx.prompt = this.ctx.evaluatePrompt();
                    this.changeToBeanLevel();
                    this.ctx.wlcmo = this.ctx.getMBeanFromObjectName(this.ctx.wlInstanceObjName);
                    this.ctx.beans.push(this.ctx.wlcmo);
                    fnd = true;
                } else if (this.ctx.wlInstanceObjName.getKeyProperty(NAME_KEY).indexOf(SLASH) != -1 || this.ctx.wlInstanceObjName.getKeyProperty(NAME_KEY).indexOf(BACKSLASH) != -1 || this.ctx.wlInstanceObjName_name.indexOf(SLASH) != -1 || this.ctx.wlInstanceObjName_name.indexOf(BACKSLASH) != -1) {
                    this.ctx.printDebug(this.txtFmt.getMBeanHasSlash());
                    name = this.ctx.wlInstanceObjName.getKeyProperty(NAME_KEY);
                    if (name.equals(this.cdArgument) || this.ctx.wlInstanceObjName_name.equals(this.cdArgument)) {
                        this.ctx.prompts.add(this.ctx.wlInstanceObjName_name);
                        this.ctx.prompt = this.ctx.evaluatePrompt();
                        this.changeToBeanLevel();
                        this.ctx.wlcmo = this.ctx.getMBeanFromObjectName(this.ctx.wlInstanceObjName);
                        this.ctx.beans.push(this.ctx.wlcmo);
                        this.cdDone = true;
                        fnd = true;
                    }
                }
                if (!(fnd || this.ctx.wlInstanceObjName.getKeyProperty(NAME_KEY).indexOf(SLASH) == -1 && this.ctx.wlInstanceObjName.getKeyProperty(NAME_KEY).indexOf(BACKSLASH) == -1 && this.ctx.wlInstanceObjName_name.indexOf(SLASH) == -1 && this.ctx.wlInstanceObjName_name.indexOf(BACKSLASH) == -1)) {
                    this.ctx.printDebug(this.txtFmt.getMBeanHasSlash());
                    name = this.ctx.wlInstanceObjName.getKeyProperty(NAME_KEY);
                    if (this.ctx.wlInstanceObjName_name.equals(mname + SLASH + nextCdValue) || restCdArgument != null && restCdArgument.indexOf(this.ctx.wlInstanceObjName_name) != -1) {
                        this.ctx.prompts.add(this.ctx.wlInstanceObjName_name);
                        this.ctx.prompt = this.ctx.evaluatePrompt();
                        this.changeToBeanLevel();
                        this.ctx.wlcmo = this.ctx.getMBeanFromObjectName(this.ctx.wlInstanceObjName);
                        this.ctx.beans.push(this.ctx.wlcmo);
                        fnd = true;
                        this.slipCdCount = this.determineSlipCount(this.ctx.wlInstanceObjName_name);
                        this.slipCdCount = this.slipCdCount == 0 || this.slipCdCount == 1 ? 0 : --this.slipCdCount;
                    }
                }
                if (!fnd) {
                    this.ctx.throwWLSTException(this.txtFmt.getAttributeNotFound(mname));
                }
            } else if (this.ctx.inMBeanTypes) {
                ObjectName objName;
                Object _oname;
                ObjectName oname;
                int k;
                if (this.delegateToDomainRuntimeHandler(mname)) {
                    this.ctx.domainRuntimeHandler.cd(mname);
                    return;
                }
                if (this.ctx.wlInstanceObjNames == null) {
                    this.ctx.throwWLSTException(this.txtFmt.getAttributeNotFound(mname));
                }
                boolean fnd = false;
                for (k = 0; k < this.ctx.wlInstanceObjNames.length; ++k) {
                    if (this.ctx.wlInstanceObjNames[k] == null || !(oname = this.ctx.wlInstanceObjNames[k]).getKeyProperty(NAME_KEY).equals(this.cdArgument) && !this.ctx.wlInstanceObjNames_names[k].equals(this.cdArgument)) continue;
                    this.ctx.prompts.add(this.cdArgument);
                    this.ctx.prompt = this.ctx.evaluatePrompt();
                    this.changeToBeanLevel();
                    this.ctx.wlcmo = this.ctx.getMBeanFromObjectName(oname);
                    this.ctx.beans.push(this.ctx.wlcmo);
                    fnd = true;
                    this.cdDone = true;
                    break;
                }
                if (!fnd) {
                    for (int i = 0; i < this.ctx.wlInstanceObjNames.length; ++i) {
                        oname = this.ctx.wlInstanceObjNames[i];
                        if (this.ctx.wlInstanceObjNames[i] == null || !oname.getKeyProperty(NAME_KEY).equals(mname) && !this.ctx.wlInstanceObjNames_names[i].equals(mname)) continue;
                        for (int k2 = 0; k2 < this.ctx.wlInstanceObjNames.length; ++k2) {
                            _oname = this.ctx.wlInstanceObjNames[k2];
                            if (this.ctx.wlInstanceObjNames[k2] == null || !((ObjectName)_oname).getKeyProperty(NAME_KEY).equals(mname + SLASH + nextCdValue) && !this.ctx.wlInstanceObjNames_names[k2].equals(mname + SLASH + nextCdValue)) continue;
                            this.ctx.prompts.add(mname + SLASH + nextCdValue);
                            this.ctx.prompt = this.ctx.evaluatePrompt();
                            this.changeToBeanLevel();
                            this.ctx.wlcmo = this.ctx.getMBeanFromObjectName((ObjectName)_oname);
                            this.ctx.beans.push(this.ctx.wlcmo);
                            fnd = true;
                            incrementCdCount = true;
                            break;
                        }
                        if (fnd) continue;
                        this.ctx.prompts.add(mname);
                        this.ctx.prompt = this.ctx.evaluatePrompt();
                        this.changeToBeanLevel();
                        this.ctx.wlcmo = this.ctx.getMBeanFromObjectName(oname);
                        this.ctx.beans.push(this.ctx.wlcmo);
                        fnd = true;
                        break;
                    }
                }
                if (!fnd) {
                    for (int j = 0; j < this.ctx.wlInstanceObjNames.length; ++j) {
                        objName = this.ctx.wlInstanceObjNames[j];
                        String oname2 = objName.getKeyProperty(NAME_KEY);
                        _oname = this.ctx.wlInstanceObjNames_names[j];
                        if (oname2.indexOf(SLASH) == -1 && oname2.indexOf(BACKSLASH) == -1 && ((String)_oname).indexOf(SLASH) == -1 && ((String)_oname).indexOf(BACKSLASH) == -1 || !oname2.equals(this.cdArgument) && !((String)_oname).equals(this.cdArgument)) continue;
                        this.ctx.prompts.add(_oname);
                        this.ctx.prompt = this.ctx.evaluatePrompt();
                        this.changeToBeanLevel();
                        this.ctx.wlcmo = this.ctx.getMBeanFromObjectName(objName);
                        this.ctx.beans.push(this.ctx.wlcmo);
                        fnd = true;
                        this.cdDone = true;
                        break;
                    }
                }
                if (!fnd) {
                    for (k = 0; k < this.ctx.wlInstanceObjNames.length; ++k) {
                        objName = this.ctx.wlInstanceObjNames[k];
                        String oname3 = objName.getKeyProperty(NAME_KEY);
                        _oname = this.ctx.wlInstanceObjNames_names[k];
                        if (oname3.indexOf(SLASH) == -1 && oname3.indexOf(BACKSLASH) == -1 && ((String)_oname).indexOf(SLASH) == -1 && ((String)_oname).indexOf(BACKSLASH) == -1 || oname3.indexOf(mname) == -1 && ((String)_oname).indexOf(mname) == -1 || this.cdArgument.indexOf(oname3) == -1 && this.cdArgument.indexOf((String)_oname) == -1) continue;
                        this.ctx.prompts.add(_oname);
                        this.ctx.prompt = this.ctx.evaluatePrompt();
                        this.changeToBeanLevel();
                        this.ctx.wlcmo = this.ctx.getMBeanFromObjectName(objName);
                        this.ctx.beans.push(this.ctx.wlcmo);
                        fnd = true;
                        this.slipCdCount = this.determineSlipCount((String)_oname);
                        if (this.slipCdCount == 0 || this.slipCdCount == 1) {
                            this.slipCdCount = 0;
                            break;
                        }
                        --this.slipCdCount;
                        break;
                    }
                }
                if (!fnd) {
                    this.ctx.throwWLSTException(this.txtFmt.getAttributeNotFound(mname));
                }
            } else if (this.ctx.atBeanLevel) {
                Object obj = null;
                if (this.ctx.inNewTree()) {
                    if (this.delegateToDomainRuntimeHandler(mname)) {
                        this.ctx.domainRuntimeHandler.cd(mname);
                        return;
                    }
                    if (this.delegateToServerRuntimeHandler(mname)) {
                        this.ctx.serverRuntimeHandler.cd(mname);
                        return;
                    }
                    obj = this.ctx.getMBSConnection(this.ctx.domainType).getAttribute(this.ctx.getObjectName(), mname);
                } else {
                    obj = this.ctx.mbs.getAttribute(this.ctx.getObjectName(), mname);
                }
                if (obj == null || obj instanceof ObjectName || obj instanceof ObjectName[]) {
                    if (obj instanceof ObjectName) {
                        if (this.ctx.skipSingletons) {
                            this.ctx.prompts.add(mname);
                            this.ctx.prompt = this.ctx.evaluatePrompt();
                            this.changeToBeanLevel();
                            this.ctx.wlcmo = this.ctx.getMBeanFromObjectName((ObjectName)obj);
                            this.ctx.beans.push(this.ctx.wlcmo);
                            return;
                        }
                        this.ctx.wlInstanceObjName = (ObjectName)obj;
                        this.changeToMBeanTypeLevel();
                        this.populateNames(obj);
                    } else if (obj instanceof ObjectName[]) {
                        this.ctx.wlInstanceObjNames = (ObjectName[])obj;
                        this.changeToMBeanTypesLevel();
                        this.populateNames(obj);
                    } else if (this.ctx.isPlural(mname)) {
                        this.ctx.wlInstanceObjNames = (ObjectName[])obj;
                        this.changeToMBeanTypesLevel();
                    } else {
                        this.ctx.wlInstanceObjName = (ObjectName)obj;
                        this.changeToMBeanTypeLevel();
                    }
                    this.ctx.prompts.add(mname);
                    this.ctx.beans.push(this.ctx.wlcmo);
                    this.ctx.prompt = this.ctx.evaluatePrompt();
                } else {
                    this.ctx.throwWLSTException(this.txtFmt.getCannotCDToAttribute(mname));
                }
            }
        }
        catch (MBeanException e) {
            if (e.getTargetException() instanceof AttributeNotFoundException) {
                this.resetCD(currentPrompt);
                this.ctx.throwWLSTException(this.txtFmt.getAttributeNotFound(mname), e.getTargetException());
            } else {
                this.resetCD(currentPrompt);
                this.ctx.throwWLSTException(this.txtFmt.getMBeanExceptionOccurred(), e);
            }
        }
        catch (Throwable e) {
            this.resetCD(currentPrompt);
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            this.ctx.throwWLSTException(this.txtFmt.getErrorBrowsingBeans(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resetCD(String curPrompt) throws ScriptException {
        if (this.currentlyResetting) {
            return;
        }
        try {
            this.currentlyResetting = true;
            this.takeBackToRoot();
            this.cd(curPrompt);
        }
        finally {
            this.currentlyResetting = false;
        }
    }

    void jumpTree(String tree) throws ScriptException {
        if (this.ctx.getCurrentTree().equals(tree)) {
            return;
        }
        if (tree.equals("config")) {
            this.cdToConfig();
        }
        if (tree.equals("runtime")) {
            this.cdToRuntime();
        }
        if (tree.equals("adminConfig")) {
            this.adminConfig();
        }
        if (tree.equals("custom")) {
            this.custom(null);
        }
        if (tree.equals("domainCustom")) {
            this.domainCustom(null);
        }
        if (tree.equals("jndi")) {
            this.jndi(null);
        }
        if (tree.equals("serverConfig")) {
            this.ctx.newBrowseHandler.configRuntime();
        }
        if (tree.equals("serverRuntime")) {
            this.ctx.newBrowseHandler.runtimeRuntime();
        }
        if (tree.equals("domainConfig")) {
            this.ctx.newBrowseHandler.configDomainRuntime();
        }
        if (tree.equals("domainRuntime")) {
            this.ctx.newBrowseHandler.runtimeDomainRuntime();
        }
        if (tree.equals("edit")) {
            this.ctx.newBrowseHandler.configEdit();
        }
    }

    void custom(String pattern) throws ScriptException {
        try {
            if (!this.ctx.domainType.equals("Custom_Domain")) {
                this.ctx.println(this.txtFmt.getLocationChangedToCustomTree());
                this.ctx.println(this.txtFmt.getUseCustomHelp());
                this.ctx.newBrowseHandler.saveLastPlaceInPreviousTree();
                this.ctx.wlcmo = this.txtFmt.getNoStubAvailable();
                this.ctx.domainType = "Custom_Domain";
                this.initCommonVariables();
                this.ctx.atDomainLevel = true;
                this.ctx.customMBeanDomainObjNameMap = new TreeMap();
                this.ctx.getCustomMBeans(pattern);
                this.ctx.newBrowseHandler.goToLastPlaceInCurrentTree();
                this.ctx.mbs = this.ctx.getMBSConnection(null);
            } else {
                this.ctx.println(this.txtFmt.getAlreadyInTree("custom"));
            }
        }
        catch (Throwable e) {
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            this.ctx.throwWLSTException(this.txtFmt.getErrorBrowsingTree("custom"), e);
        }
    }

    void domainCustom(String pattern) throws ScriptException {
        if (!this.ctx.isAdminServer) {
            this.ctx.println(this.txtFmt.getDomainCustomCommandNotOnMS());
            return;
        }
        if (!this.ctx.isDomainRuntimeServerEnabled) {
            this.ctx.println(this.txtFmt.getDomainRuntimeServerNotEnabled());
            return;
        }
        try {
            if (!this.ctx.domainType.equals("DomainCustom_Domain")) {
                this.ctx.println(this.txtFmt.getLocationChangedToDomainCustomTree());
                this.ctx.println(this.txtFmt.getUseDomainCustomHelp());
                this.ctx.newBrowseHandler.saveLastPlaceInPreviousTree();
                this.ctx.wlcmo = this.txtFmt.getNoStubAvailable();
                this.ctx.domainType = "DomainCustom_Domain";
                this.initCommonVariables();
                this.ctx.atDomainLevel = true;
                this.ctx.domainCustomMBeanDomainObjNameMap = new TreeMap();
                this.ctx.getDomainCustomMBeans(pattern);
                this.ctx.newBrowseHandler.goToLastPlaceInCurrentTree();
                this.ctx.mbs = this.ctx.getMBSConnection(null);
            } else {
                this.ctx.println(this.txtFmt.getAlreadyInTree("domainCustom"));
            }
        }
        catch (Throwable e) {
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            this.ctx.throwWLSTException(this.txtFmt.getErrorBrowsingTree("domainCustom"), e);
        }
    }

    void takeBackToRoot() throws ScriptException {
        if (this.ctx.debug) {
            this.ctx.printDebug(this.txtFmt.getBrowsingBackToRoot());
        }
        this.reset();
    }

    private void handleJndiCd(String mname) throws ScriptException {
        try {
            if (this.ctx.prompts.size() == 0) {
                ServerRuntimeMBean[] beans = this.ctx.domainRuntimeServiceMBean.getServerRuntimes();
                for (int i = 0; i < beans.length; ++i) {
                    if (!beans[i].getName().equals(mname)) continue;
                    this.ctx.prompts.add(mname);
                    this.ctx.prompt = this.ctx.evaluatePrompt();
                    return;
                }
                this.ctx.throwWLSTException(this.txtFmt.getCannotFindJndiEntry(mname));
            }
            if (this.ctx.jndiNames.size() == 0) {
                this.ctx.infoHandler.handleJNDIls(false, "c");
            }
            if (this.ctx.jndiNames.size() == 0) {
                return;
            }
            for (String name : this.ctx.jndiNames) {
                if (!name.equals(mname)) continue;
                this.ctx.prompts.add(mname);
                this.ctx.prompt = this.ctx.evaluatePrompt();
                this.ctx.jndiNames = new ArrayList();
                return;
            }
            this.ctx.jndiNames = new ArrayList();
        }
        catch (Throwable e) {
            this.ctx.throwWLSTException(this.txtFmt.getErrorBrowsingTree("jndi"), e);
        }
    }

    void cd(String mname) throws ScriptException {
        this.cdArgument = mname;
        boolean slipCdCount = false;
        this.cdDone = false;
        if (mname.startsWith(SLASH)) {
            if (this.checkNameStartsWithSlash(mname)) {
                this.ctx.nameHasSlash = false;
                return;
            }
            String currentPrompt = this.ctx.prompt;
            try {
                this.takeBackToRoot();
                mname = mname.substring(1, mname.length());
                this.cd(mname);
            }
            catch (ScriptException e) {
                this.resetCD(currentPrompt);
                throw e;
            }
        } else if (mname.indexOf(BACKSLASH) != -1) {
            String[] strs = StringUtils.splitCompletely((String)mname, (String)BACKSLASH);
            if (strs.length == 0) {
                this.takeBackToRoot();
            }
            this.splitPush(strs, BACKSLASH);
        } else if (mname.indexOf(SLASH) != -1) {
            String[] strs = StringUtils.splitCompletely((String)mname, (String)SLASH);
            if (strs.length == 0) {
                this.takeBackToRoot();
            }
            this.splitPush(strs, SLASH);
        } else {
            if (mname.length() == 0) {
                return;
            }
            this.regularPush(mname, null);
        }
    }

    void cdToConfig() throws ScriptException {
        if (!this.ctx.isCompatabilityServerEnabled) {
            this.ctx.println(this.txtFmt.getCannotChangeToConfigTree());
            return;
        }
        try {
            if (!this.ctx.domainType.equals("DomainConfig")) {
                if (this.ctx.isAdminServer) {
                    this.ctx.newBrowseHandler.saveLastPlaceInPreviousTree();
                    this.ctx.domainType = "Domain";
                    this.ctx.wlcmo = this.ctx.home.getAdminMBean(this.ctx.domainName, "Domain");
                    if (!this.configNavigatedBefore) {
                        this.ctx.addCompatChangeListener();
                        this.ctx.println(this.txtFmt.getLocationChangedToConfigTree("Domain"));
                        this.configNavigatedBefore = true;
                    }
                } else {
                    this.ctx.newBrowseHandler.saveLastPlaceInPreviousTree();
                    this.ctx.domainType = "DomainConfig";
                    this.ctx.wlcmo = this.ctx.home.getConfigurationMBean(this.ctx.domainName, "DomainConfig");
                    if (!this.configNavigatedBefore) {
                        this.ctx.println(this.txtFmt.getLocationChangedToConfigTree("DomainConfig"));
                        this.configNavigatedBefore = true;
                    }
                }
                this.initCommonVariables();
                this.ctx.newBrowseHandler.goToLastPlaceInCurrentTree();
                this.ctx.mbs = this.ctx.getMBSConnection(null);
            } else {
                this.ctx.print(this.txtFmt.getAlreadyInTree("domainConfig"));
            }
        }
        catch (Throwable e) {
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            this.ctx.throwWLSTException(this.txtFmt.getErrorBrowsingTree("config"), e);
        }
    }

    void reset() throws ScriptException {
        this.ctx.lastPlaceInConfigRuntime = EMPTY_STRING;
        this.ctx.lastPlaceInRuntimeRuntime = EMPTY_STRING;
        this.ctx.lastPlaceInConfigDomainRuntime = EMPTY_STRING;
        this.ctx.lastPlaceInRuntimeDomainRuntime = EMPTY_STRING;
        this.ctx.lastPlaceInJNDI = EMPTY_STRING;
        this.ctx.lastPlaceInCustom = EMPTY_STRING;
        this.ctx.lastPlaceInDomainCustom = EMPTY_STRING;
        this.ctx.lastPlaceInEdit = EMPTY_STRING;
        this.ctx.lastPlaceInJSR77 = EMPTY_STRING;
        try {
            if (this.ctx.domainType.equals("DomainRuntime")) {
                if (this.ctx.isAdminServer) {
                    this.ctx.wlcmo = this.ctx.home.getRuntimeMBean(this.ctx.domainName, "DomainRuntime");
                    this.ctx.domainType = "DomainRuntime";
                    this.initCommonVariables();
                } else {
                    this.ctx.wlcmo = this.ctx.home.getRuntimeMBean(this.ctx.serverName, "ServerRuntime");
                    this.ctx.prompts = new Stack();
                    this.ctx.prompts.add("ServerRuntime");
                    this.ctx.prompts.add(this.ctx.serverName);
                    this.ctx.beans = new Stack();
                    this.ctx.beans.add(this.ctx.wlcmo);
                    this.ctx.prompt = this.ctx.evaluatePrompt();
                    this.ctx.domainType = "DomainRuntime";
                    this.changeToBeanLevel();
                }
            } else if (this.ctx.domainType.equals("Domain")) {
                this.ctx.wlcmo = this.ctx.home.getAdminMBean(this.ctx.domainName, "Domain");
                this.ctx.domainType = "Domain";
                this.initCommonVariables();
            } else if (this.ctx.domainType.equals("Custom_Domain")) {
                this.ctx.wlcmo = this.txtFmt.getNoStubAvailable();
                this.initCommonVariables();
                this.ctx.atDomainLevel = true;
            } else if (this.ctx.domainType.equals("DomainCustom_Domain")) {
                this.ctx.wlcmo = this.txtFmt.getNoStubAvailable();
                this.initCommonVariables();
                this.ctx.atDomainLevel = true;
            } else if (this.ctx.inNewTree()) {
                if (this.ctx.domainType.equals("RuntimeConfigServerDomain")) {
                    this.ctx.wlcmo = this.ctx.runtimeDomainMBean;
                    this.ctx.domainType = "RuntimeConfigServerDomain";
                    this.initCommonVariables();
                } else if (this.ctx.domainType.equals("RuntimeRuntimeServerDomain")) {
                    this.ctx.wlcmo = this.ctx.runtimeServerRuntimeMBean;
                    this.ctx.domainType = "RuntimeRuntimeServerDomain";
                    this.initCommonVariables();
                } else if (this.ctx.domainType.equals("RuntimeDomainRuntime")) {
                    this.ctx.wlcmo = this.ctx.runtimeDomainRuntimeDRMBean;
                    this.ctx.domainType = "RuntimeDomainRuntime";
                    this.initCommonVariables();
                } else if (this.ctx.domainType.equals("ConfigDomainRuntime")) {
                    this.ctx.wlcmo = this.ctx.configDomainRuntimeDRMBean;
                    this.ctx.domainType = "ConfigDomainRuntime";
                    this.initCommonVariables();
                } else if (this.ctx.domainType.equals("JNDI")) {
                    this.ctx.wlcmo = this.txtFmt.getNoStubAvailable();
                    this.ctx.domainType = "JNDI";
                    this.initCommonVariables();
                } else if (this.ctx.domainType.equals("ConfigEdit")) {
                    this.ctx.wlcmo = this.ctx.editDomainMBean;
                    this.ctx.domainType = "ConfigEdit";
                    this.initCommonVariables();
                } else if (this.ctx.domainType.equals("JSR77")) {
                    this.ctx.wlcmo = null;
                    this.ctx.domainType = "ConfigEdit";
                    this.initCommonVariables();
                }
            }
        }
        catch (InstanceNotFoundException e) {
            this.ctx.throwWLSTException(this.txtFmt.getCouldNotFindDomainRuntimeMBean(), e);
        }
        catch (Throwable e) {
            this.ctx.throwWLSTException("Unexpected Error: ", e);
        }
    }

    void cdToRuntime() throws ScriptException {
        if (!this.ctx.isCompatabilityServerEnabled) {
            this.ctx.println(this.txtFmt.getCannotChangeToRuntimeTree());
            return;
        }
        try {
            if (!this.ctx.domainType.equals("DomainRuntime")) {
                if (!this.runtimeNavigatedBefore) {
                    this.ctx.addCompatChangeListener();
                    this.ctx.println(this.txtFmt.getLocationChangedToRuntimeTree("DomainRuntime"));
                }
                this.runtimeNavigatedBefore = true;
                this.ctx.newBrowseHandler.saveLastPlaceInPreviousTree();
                this.ctx.domainType = "DomainRuntime";
                this.ctx.mbs = this.ctx.getMBSConnection(null);
                if (this.ctx.isAdminServer) {
                    this.ctx.wlcmo = this.ctx.home.getRuntimeMBean(this.ctx.domainName, "DomainRuntime");
                    this.initCommonVariables();
                    this.ctx.newBrowseHandler.goToLastPlaceInCurrentTree();
                } else {
                    if (!this.runtimeNavigatedBefore) {
                        this.ctx.println(this.txtFmt.getLocationChangedToRuntimeTree("ServerRuntime"));
                    }
                    this.runtimeNavigatedBefore = true;
                    this.ctx.wlcmo = this.ctx.home.getRuntimeMBean(this.ctx.serverName, "ServerRuntime");
                    this.ctx.prompts = new Stack();
                    this.ctx.prompts.add("ServerRuntime");
                    this.ctx.prompts.add(this.ctx.serverName);
                    this.ctx.beans = new Stack();
                    this.ctx.beans.add(this.ctx.wlcmo);
                    this.ctx.prompt = this.ctx.evaluatePrompt();
                    this.changeToBeanLevel();
                    this.ctx.newBrowseHandler.goToLastPlaceInCurrentTree();
                }
            } else {
                this.ctx.println(this.txtFmt.getAlreadyInTree("runtime"));
            }
        }
        catch (InstanceNotFoundException e) {
            this.ctx.throwWLSTException("Could not find the RuntimeMBean instance", e);
        }
        catch (Throwable e) {
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            this.ctx.throwWLSTException("Unexpected Error: ", e);
        }
    }

    private void cdToCustomBeanInstance(String mname, String restCdArgument) throws ScriptException {
        if (this.ctx.inMBeanType) {
            String inDomain = (String)this.ctx.prompts.peek();
            List oNames = (List)this.ctx.customMBeanDomainObjNameMap.get(inDomain);
            for (String on : oNames) {
                if (!on.equals(mname) && !on.equals(restCdArgument)) continue;
                if (!on.equals(mname)) {
                    this.ctx.prompts.add(restCdArgument);
                    this.slipCdCount = this.determineSlipCount(on);
                    this.slipCdCount = this.slipCdCount == 0 || this.slipCdCount == 1 ? 0 : --this.slipCdCount;
                } else {
                    this.ctx.prompts.add(mname);
                }
                this.ctx.prompt = this.ctx.evaluatePrompt();
                this.changeToBeanLevel();
                this.ctx.atDomainLevel = false;
                try {
                    this.ctx.wlcmo = this.ctx.getMBeanFromObjectName(new ObjectName(on));
                }
                catch (Throwable e) {
                    this.ctx.wlcmo = this.txtFmt.getNoStubAvailable();
                }
                this.ctx.beans.push(this.ctx.wlcmo);
                return;
            }
        }
        if (this.ctx.atDomainLevel) {
            TreeMap domains = new TreeMap();
            for (String dn : this.ctx.customMBeanDomainObjNameMap.keySet()) {
                if (!dn.equals(mname)) continue;
                this.ctx.prompts.add(mname);
                this.ctx.prompt = this.ctx.evaluatePrompt();
                this.ctx.atDomainLevel = false;
                this.changeToMBeanTypeLevel();
                this.ctx.wlcmo = this.txtFmt.getNoStubAvailable();
                this.ctx.beans.push(this.ctx.wlcmo);
                return;
            }
        }
        this.ctx.throwWLSTException(this.txtFmt.getAttributeNotFound(mname));
    }

    private void cdToDomainCustomBeanInstance(String mname, String restCdArgument) throws ScriptException {
        if (this.ctx.inMBeanType) {
            String inDomain = (String)this.ctx.prompts.peek();
            List oNames = (List)this.ctx.domainCustomMBeanDomainObjNameMap.get(inDomain);
            for (String on : oNames) {
                if (!on.equals(mname) && !on.equals(restCdArgument)) continue;
                if (!on.equals(mname)) {
                    this.ctx.prompts.add(restCdArgument);
                    this.slipCdCount = this.determineSlipCount(on);
                    this.slipCdCount = this.slipCdCount == 0 || this.slipCdCount == 1 ? 0 : --this.slipCdCount;
                } else {
                    this.ctx.prompts.add(mname);
                }
                this.ctx.prompt = this.ctx.evaluatePrompt();
                this.changeToBeanLevel();
                this.ctx.atDomainLevel = false;
                try {
                    this.ctx.wlcmo = this.ctx.getMBeanFromObjectName(new ObjectName(on));
                }
                catch (Throwable e) {
                    this.ctx.wlcmo = this.txtFmt.getNoStubAvailable();
                }
                this.ctx.beans.push(this.ctx.wlcmo);
                return;
            }
        }
        if (this.ctx.atDomainLevel) {
            TreeMap domains = new TreeMap();
            for (String dn : this.ctx.domainCustomMBeanDomainObjNameMap.keySet()) {
                if (!dn.equals(mname)) continue;
                this.ctx.prompts.add(mname);
                this.ctx.prompt = this.ctx.evaluatePrompt();
                this.ctx.atDomainLevel = false;
                this.changeToMBeanTypeLevel();
                this.ctx.wlcmo = this.txtFmt.getNoStubAvailable();
                this.ctx.beans.push(this.ctx.wlcmo);
                return;
            }
        }
        this.ctx.throwWLSTException(this.txtFmt.getAttributeNotFound(mname));
    }

    void jndi(String serverName) throws ScriptException {
        block7: {
            if (serverName == null || serverName.equals(this.ctx.serverName)) {
                try {
                    if (!this.ctx.domainType.equals("JNDI")) {
                        this.ctx.println(this.txtFmt.getLocationChangedToJndiTree());
                        this.ctx.newBrowseHandler.saveLastPlaceInPreviousTree();
                        this.ctx.wlcmo = this.txtFmt.getNoStubAvailable();
                        this.ctx.domainType = "JNDI";
                        this.initCommonVariables();
                        this.ctx.newBrowseHandler.goToLastPlaceInCurrentTree();
                        break block7;
                    }
                    this.ctx.println(this.txtFmt.getAlreadyInTree("jndi"));
                    this.ctx.jndiNames = new ArrayList();
                }
                catch (Throwable e) {
                    if (e instanceof ScriptException) {
                        throw (ScriptException)e;
                    }
                    this.ctx.throwWLSTException(this.txtFmt.getErrorBrowsingTree("jndi"), e);
                }
            } else if (!this.ctx.isAdminServer && !serverName.equals(this.ctx.serverName)) {
                this.ctx.println(this.txtFmt.getCannotBrowsJNDIOfOtherServer());
                return;
            }
        }
    }
}

