/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.scripting;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.stream.XMLStreamException;
import weblogic.deploy.internal.DeploymentType;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.JMSInteropModuleMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.LibraryMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.WLDFSystemResourceMBean;
import weblogic.management.provider.ManagementServiceClient;
import weblogic.management.provider.beaninfo.BeanInfoAccess;
import weblogic.management.scripting.ScriptException;
import weblogic.management.scripting.WLScriptContext;
import weblogic.management.security.ProviderMBean;
import weblogic.security.UserConfigFileManager;
import weblogic.security.UsernameAndPassword;
import weblogic.utils.Hex;
import weblogic.utils.StringUtils;

public class ConfigToScript {
    private DomainMBean domainMBean = null;
    private WLScriptContext ctx = null;
    private BeanInfoAccess beanInfoAccess = null;
    private List haveISeenYou = new ArrayList();
    private StringBuffer mainScriptBuffer = new StringBuffer();
    private StringBuffer coreFunctionCalls = new StringBuffer();
    private StringBuffer theScript = new StringBuffer();
    private StringBuffer theHeader = new StringBuffer();
    private StringBuffer theTail = new StringBuffer();
    private int beansCounter = 0;
    private List potentialTargetMBeanTypes = new ArrayList();
    private List functionNames = new ArrayList();
    private HashMap createdBeans = new HashMap();
    private List beanFunctionNameList = new ArrayList();
    private List referenceBeans = new ArrayList();
    private List referenceBeanArrays = new ArrayList();
    private HashMap createMethods = new HashMap();
    private List applicationBeans = new ArrayList();
    private List libraryBeans = new ArrayList();
    private List applicationDeploymentFunctionNames = new ArrayList();
    private StringBuffer applicationDeploymentScript = new StringBuffer();
    private StringBuffer applicationDeploymentFunctionCalls = new StringBuffer();
    private List dummyCreators = new ArrayList();
    private List excludedAttributeNames = new ArrayList();
    private HashMap jmsBeanToParentMap = new HashMap();
    private boolean debug = false;
    private boolean processedApplicationBeans = false;
    private boolean processedLibraryBeans = false;
    private boolean cds = false;
    private static final String RELATIONSHIP = "relationship";
    private static final String CONTAINMENT = "containment";
    private static final String CREATOR = "creator";
    private static final String DESTROYER = "destroyer";
    private static final String REFERENCE = "reference";
    private static final String TRANSIENT = "transient";
    private static final String DEPRECATED = "deprecated";
    private File configFile = null;
    private File pyFile = null;
    private File propertiesFile = null;
    private static String currentSystemResourceBeanName = null;
    private static boolean processingJMSBean = false;
    private String CONFIG_TO_SCRIPT_USER_CONFIG_FILE = null;
    private String CONFIG_TO_SCRIPT_SECRET_FILE = null;

    ConfigToScript(File configFile, String pathToPyFile, String overWrite, String propFile, String createDeploymentScript, String resourcesOnlyConversion, WLScriptContext wlctx) throws ScriptException {
        this.ctx = wlctx;
        this.configFile = configFile;
        this.cds = this.ctx.getBoolean(createDeploymentScript);
        if (pathToPyFile == null) {
            pathToPyFile = configFile.getParentFile() + File.separator + "config.py";
        }
        this.pyFile = new File(pathToPyFile);
        if (this.pyFile.isDirectory()) {
            this.pyFile = new File(this.pyFile.getAbsolutePath() + File.separator + "config.py");
        }
        if (!this.ctx.getBoolean(overWrite) && this.pyFile.exists()) {
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getScriptAlreadyExists(pathToPyFile));
        }
        this.propertiesFile = propFile == null ? new File(this.pyFile.getAbsolutePath() + ".properties") : new File(propFile);
        this.domainMBean = this.loadConfiguration();
        this.ctx = wlctx;
        this.setUpBeanInfoService();
        this.setupAllTargetTypes();
        this.setupDummyCreators();
        this.setExcludedAttributeNames();
    }

    private void setupDummyCreators() {
        this.dummyCreators.add("createJTAMigratableTarget");
    }

    private void setExcludedAttributeNames() {
        this.excludedAttributeNames.add("PasswordEncrypted");
    }

    ConfigToScript(String pathToDomainDir) throws ScriptException {
        this.configFile = new File(pathToDomainDir + File.separator + "config" + File.separator + "config.xml");
        this.domainMBean = this.loadConfiguration();
        this.setUpBeanInfoService();
    }

    private void print(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }

    private void setupAllTargetTypes() {
        this.potentialTargetMBeanTypes.add("ServerMBean");
        this.potentialTargetMBeanTypes.add("ClusterMBean");
        this.potentialTargetMBeanTypes.add("JTAMigratableTargetMBean");
        this.potentialTargetMBeanTypes.add("MigratableTargetMBean");
        this.potentialTargetMBeanTypes.add("JMSServerMBean");
        this.potentialTargetMBeanTypes.add("VirtualHostMBean");
    }

    private DomainMBean loadConfiguration() throws ScriptException {
        try {
            String msg = this.ctx.getWLSTMsgFormatter().getLoadingConfiguration(this.configFile.getCanonicalPath());
            this.ctx.println(msg);
            return ManagementServiceClient.getClientAccess().getDomain(this.configFile.getCanonicalPath(), false);
        }
        catch (FileNotFoundException e) {
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getCannotLocateConfigXml(), e);
        }
        catch (IOException e) {
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getIOExceptionLoadingConfig(), e);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getFailedToLoadConfigXml(), e);
        }
        return null;
    }

    private void setUpBeanInfoService() {
        this.beanInfoAccess = ManagementServiceClient.getBeanInfoAccess();
    }

    private void createDeploymentScript() throws ScriptException {
        try {
            File f = new File(this.pyFile.getParentFile().getAbsolutePath() + "/deploy.py");
            FileWriter out = new FileWriter(f);
            out.write(this.applicationDeploymentScript.toString());
            out.write(this.applicationDeploymentFunctionCalls.toString());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getIOExceptionWritingDeploymentScript(e.getMessage()), e);
        }
    }

    void convert() throws ScriptException {
        this.ctx.println(this.ctx.getWLSTMsgFormatter().getConvertingResources());
        this.walkTheTree("weblogic.management.configuration.DomainMBean", this.domainMBean, "");
        this.setBeanAttributes();
        this.nowGenerateTheScript();
        this.encryptDefaultUsernameAndPassword();
        this.createDefaultProperties(this.propertiesFile);
        this.writeFile(this.pyFile);
        if (this.cds) {
            this.createDeploymentScript();
        }
        String msg = this.ctx.getWLSTMsgFormatter().getConfigToScriptComplete(this.pyFile.getAbsolutePath(), this.propertiesFile.getAbsolutePath());
        this.ctx.println(msg);
        this.printPasswordDisclaimer();
    }

    private void printPasswordDisclaimer() {
        if (this.CONFIG_TO_SCRIPT_USER_CONFIG_FILE == null) {
            return;
        }
        String msg = this.ctx.getWLSTMsgFormatter().getPasswordDisclaimer(this.CONFIG_TO_SCRIPT_USER_CONFIG_FILE, this.CONFIG_TO_SCRIPT_SECRET_FILE);
        this.ctx.println(msg);
    }

    private void nowGenerateTheScript() {
        this.setupCommonFunctions();
        this.callCoreFunctions();
        this.processDeploymentBeans(this.libraryBeans, DeploymentType.LIBRARY);
        this.processDeploymentBeans(this.applicationBeans, DeploymentType.DEFAULT_APP);
        this.theScript.append(this.mainScriptBuffer.toString());
        this.theScript.append(this.applicationDeploymentScript.toString());
        this.theScript.append("try:\n");
        this.theScript.append(this.theHeader.toString());
        this.theScript.append(this.coreFunctionCalls.toString());
        this.theScript.append("  endTransaction()\n");
        this.theScript.append(this.applicationDeploymentFunctionCalls.toString());
        this.theScript.append(this.theTail.toString());
        this.theScript.append("finally:\n");
        this.theScript.append("  endOfConfigToScriptRun()\n");
    }

    private void callCoreFunctions() {
        for (FunctionNameBucket buck : this.beanFunctionNameList) {
            String createFName = buck.getCreateFunctionName();
            String setterFuncName = buck.getSetFunctionName();
            String path = buck.getPath();
            if (path.length() == 0) {
                path = "/";
            }
            this.coreFunctionCalls.append("  " + createFName + "(\"" + path + "\", \"" + buck.getBeanName() + "\")\n");
        }
        for (FunctionNameBucket buck : this.beanFunctionNameList) {
            String setterFuncName = buck.getSetFunctionName();
            if (!buck.callSetter()) continue;
            this.coreFunctionCalls.append("  " + setterFuncName + "()\n");
        }
        for (String fname : this.functionNames) {
            this.coreFunctionCalls.append("  " + fname + "()\n");
        }
    }

    private void headers() {
        this.theHeader.append("  initConfigToScriptRun()\n");
        this.theHeader.append("  startTransaction()\n");
    }

    private void tailers() {
    }

    private String addImports() {
        StringBuffer buf = new StringBuffer();
        buf.append("from weblogic.descriptor import BeanAlreadyExistsException\n");
        buf.append("from java.lang.reflect import UndeclaredThrowableException\n");
        buf.append("from java.lang import System\n");
        buf.append("import javax\n");
        buf.append("from javax import management\n");
        buf.append("from javax.management import MBeanException\n");
        buf.append("from javax.management import RuntimeMBeanException\n");
        buf.append("import javax.management.MBeanException\n");
        buf.append("from java.lang import UnsupportedOperationException\n");
        buf.append("\n");
        return buf.toString();
    }

    private void setupCommonFunctions() {
        this.theScript.append(this.header());
        this.theScript.append(this.tail());
        this.headers();
        this.tailers();
    }

    private void walkTheTree(String root, DescriptorBean parentBean, String path) throws ScriptException {
        try {
            BeanInfo beanInfo = this.beanInfoAccess.getBeanInfoForInterface(root, false, "9.0.0");
            if (this.haveISeenYou.contains(parentBean)) {
                return;
            }
            if (root.equals("weblogic.management.configuration.DomainMBean")) {
                this.createdBeans.put(parentBean, path);
            }
            this.haveISeenYou.add(parentBean);
            if (this.isSystemResourceMBean(parentBean)) {
                currentSystemResourceBeanName = this.getName(parentBean);
                processingJMSBean = false;
            }
            if (this.isJMSBean(parentBean)) {
                processingJMSBean = true;
            }
            PropertyDescriptor[] propDescInfos = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propDescInfos.length; ++i) {
                Object referredBean;
                String currentBeanPath;
                DescriptorBean theBean;
                Object[] obj;
                Method getMethod;
                PropertyDescriptor propDesc = propDescInfos[i];
                if (this.isExcluded(propDesc) || !parentBean.isSet(propDesc.getName()) && !this.isTransient(propDesc)) continue;
                if (this.isChild(propDesc)) {
                    if (this.applicationBean(propDesc, parentBean) || this.libraryBean(propDesc, parentBean)) continue;
                    this.print(this.ctx.getWLSTMsgFormatter().getBeanIsAChild(propDesc.getName()));
                    getMethod = propDesc.getReadMethod();
                    obj = null;
                    Object childs = getMethod.invoke((Object)parentBean, obj);
                    if (childs.toString().startsWith("[L")) {
                        obj = (Object[])childs;
                        DescriptorBean[] children = (DescriptorBean[])childs;
                        for (int j = 0; j < children.length; ++j) {
                            DescriptorBean bean = children[j];
                            if (this.isJMSBean(bean)) {
                                this.jmsBeanToParentMap.put(bean, parentBean);
                            }
                            String name = this.getName(obj[j]);
                            String currentBeanPath2 = "";
                            String templatedName = "";
                            boolean isTemplated = false;
                            if (!this.isTemplatingEnabled(propDesc.getName(), name)) {
                                currentBeanPath2 = "/" + propDesc.getName() + "/" + name;
                            }
                            if (path.length() == 0) {
                                this.createdBeans.put(obj[j], currentBeanPath2);
                            } else {
                                this.createdBeans.put(obj[j], path + currentBeanPath2);
                            }
                            if (!isTemplated) {
                                this.createBeanScript(name, propDesc, path, obj[j], isTemplated);
                            } else {
                                this.createBeanScript(templatedName, propDesc, path, obj[j], isTemplated);
                            }
                            this.walkTheTree(this.getInterfaceClassName(bean), bean, path + currentBeanPath2);
                        }
                        continue;
                    }
                    theBean = (DescriptorBean)childs;
                    if (this.isJMSBean(childs)) {
                        this.jmsBeanToParentMap.put(theBean, parentBean);
                    }
                    String name = this.getName(childs);
                    currentBeanPath = "";
                    String templatedName = "";
                    boolean isTemplated = false;
                    if (!this.isTemplatingEnabled(propDesc.getName(), name)) {
                        currentBeanPath = "/" + propDesc.getName() + "/" + name;
                    }
                    if (path.length() == 0) {
                        this.createdBeans.put(childs, currentBeanPath);
                    } else {
                        this.createdBeans.put(childs, path + currentBeanPath);
                    }
                    if (!isTemplated) {
                        this.createBeanScript(name, propDesc, path, childs, isTemplated);
                    } else {
                        this.createBeanScript(templatedName, propDesc, path, childs, isTemplated);
                    }
                    this.walkTheTree(this.getInterfaceClassName(theBean), theBean, path + currentBeanPath);
                    continue;
                }
                if (this.isDefaulted(propDesc)) {
                    String pname;
                    this.print(this.ctx.getWLSTMsgFormatter().getBeanIsDefaulted(propDesc.getName()));
                    getMethod = propDesc.getReadMethod();
                    obj = null;
                    referredBean = getMethod.invoke((Object)parentBean, obj);
                    theBean = (DescriptorBean)referredBean;
                    String name = null;
                    if (this.isJMSBean(theBean)) {
                        this.jmsBeanToParentMap.put(theBean, parentBean);
                    }
                    if ((name = this.getName(referredBean)).equals("NO_NAME")) {
                        if (processingJMSBean) {
                            name = this.getName(parentBean);
                            if (name.equals("NO_NAME")) {
                                name = currentSystemResourceBeanName;
                            }
                        } else {
                            name = currentSystemResourceBeanName;
                        }
                    }
                    currentBeanPath = "";
                    currentBeanPath = this.isSystemResourceMBean(parentBean) ? (!name.equals(pname = this.getName(parentBean)) ? "/" + propDesc.getName() + "/" + pname : "/" + propDesc.getName() + "/" + name) : "/" + propDesc.getName() + "/" + name;
                    if (path.length() == 0) {
                        this.createdBeans.put(referredBean, currentBeanPath);
                    } else {
                        this.createdBeans.put(referredBean, path + currentBeanPath);
                    }
                    this.walkTheTree(this.getInterfaceClassName(theBean), theBean, path + currentBeanPath);
                    continue;
                }
                if (this.isReferal(propDesc)) {
                    this.print(this.ctx.getWLSTMsgFormatter().getBeanIsAReference(propDesc.getName()));
                    if (!parentBean.isSet(propDesc.getName())) continue;
                    getMethod = propDesc.getReadMethod();
                    referredBean = getMethod.invoke((Object)parentBean, obj = null);
                    if (referredBean instanceof WebLogicMBean) {
                        String pathToReferredBean = this.getPathToBean(referredBean);
                        String pathToCurrentBean = path;
                        ReferenceBucket rb = new ReferenceBucket(pathToCurrentBean, pathToReferredBean, propDesc.getWriteMethod().getName());
                        this.referenceBeans.add(rb);
                        continue;
                    }
                    if (!(referredBean instanceof WebLogicMBean[])) continue;
                    Object[] objArray = (Object[])referredBean;
                    String[] paths = new String[objArray.length];
                    for (int k = 0; k < objArray.length; ++k) {
                        paths[k] = this.getPathToBean(objArray[k]);
                    }
                    String pathToCurrentBean = path;
                    ReferenceBucketArray rba = new ReferenceBucketArray(pathToCurrentBean, paths, propDesc.getWriteMethod().getName(), this.getClassName(propDesc.getPropertyType()).getName());
                    this.referenceBeanArrays.add(rba);
                    continue;
                }
                if (this.isTransient(propDesc)) {
                    getMethod = propDesc.getReadMethod();
                    obj = null;
                    referredBean = null;
                    try {
                        referredBean = getMethod.invoke((Object)parentBean, obj);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    if (referredBean == null || !(referredBean instanceof DescriptorBean)) continue;
                    theBean = (DescriptorBean)referredBean;
                    if (this.isJMSBean(theBean)) {
                        this.jmsBeanToParentMap.put(theBean, parentBean);
                    }
                    String name = this.getName(referredBean);
                    currentBeanPath = "/" + propDesc.getName() + "/" + name;
                    if (path.length() == 0) {
                        this.createdBeans.put(referredBean, currentBeanPath);
                    } else {
                        this.createdBeans.put(referredBean, path + currentBeanPath);
                    }
                    this.walkTheTree(this.getInterfaceClassName(theBean), theBean, path + currentBeanPath);
                    continue;
                }
                if (this.isReadonlyChild(propDesc) && !this.applicationBean(propDesc, parentBean) && !this.libraryBean(propDesc, parentBean)) continue;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getExceptionWalkingTree(), e);
        }
    }

    private boolean isTemplatingEnabled(String type, String name) {
        return false;
    }

    private boolean applicationBean(PropertyDescriptor pd, Object parentBean) throws ScriptException {
        String creator = (String)pd.getValue(CREATOR);
        String des = (String)pd.getValue(DESTROYER);
        boolean result = false;
        try {
            if (pd.getName().equals("AppDeployments") || creator != null && creator.equals("createAppDeployment") && des != null && des.equals("destroyAppDeployment")) {
                result = true;
                if (!this.processedApplicationBeans) {
                    Method mth = pd.getReadMethod();
                    Object[] obj = null;
                    Object[] appBeans = (Object[])mth.invoke(parentBean, obj);
                    for (int i = 0; i < appBeans.length; ++i) {
                        this.applicationBeans.add(appBeans[i]);
                    }
                    this.processedApplicationBeans = true;
                }
            }
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getErrorFindingAppBean(), th);
        }
        return result;
    }

    private boolean libraryBean(PropertyDescriptor pd, Object parentBean) throws ScriptException {
        String creator = (String)pd.getValue(CREATOR);
        String des = (String)pd.getValue(DESTROYER);
        boolean result = false;
        try {
            if (pd.getName().equals("Libraries") || creator != null && creator.equals("createLibrary") && des != null && des.equals("destroyLibrary")) {
                result = true;
                if (!this.processedLibraryBeans) {
                    Method mth = pd.getReadMethod();
                    Object[] obj = null;
                    Object[] libBeans = (Object[])mth.invoke(parentBean, obj);
                    for (int i = 0; i < libBeans.length; ++i) {
                        this.libraryBeans.add(libBeans[i]);
                    }
                    this.processedLibraryBeans = true;
                }
            }
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getErrorFindingAppBean(), th);
        }
        return result;
    }

    private String getSubDeployString(SubDeploymentMBean sbean) {
        TargetMBean[] targets = sbean.getTargets();
        String[] tgts = new String[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            tgts[i] = sbean.getName() + "@" + targets[i].getName();
        }
        return StringUtils.join((String[])tgts, (String)",");
    }

    private void processDeploymentBeans(List deploymentBeans, DeploymentType deploymentType) {
        Collections.sort(deploymentBeans, deploymentType);
        for (AppDeploymentMBean app : deploymentBeans) {
            boolean isLibraryModule = app instanceof LibraryMBean;
            if (app.isInternalApp()) continue;
            String appName = app.getName();
            String appPath = this.replaceEscapeCharacters(app.getAbsoluteSourcePath());
            String secModel = app.getSecurityDDModel();
            String stagingMode = app.getStagingMode();
            SubDeploymentMBean[] sbeans = app.getSubDeployments();
            String[] subTargets = new String[sbeans.length];
            for (int i = 0; i < sbeans.length; ++i) {
                subTargets[i] = this.getSubDeployString(sbeans[i]);
            }
            String targets = this.getTargetNames(app.getTargets());
            targets = targets == null || targets.length() == 0 ? StringUtils.join((String[])subTargets, (String)",") : targets + "," + StringUtils.join((String[])subTargets, (String)",");
            String fname = "deploy_" + appName + "_" + this.getCounter();
            fname = this.getFunctionNameFromResource(fname);
            this.applicationDeploymentFunctionNames.add(fname);
            this.applicationDeploymentScript.append("def " + fname + "():\n");
            this.applicationDeploymentScript.append("  try:\n");
            String depString = "deploy(\"" + appName + "\"," + "\"" + appPath + "\"," + "\"" + targets + "\",";
            if (stagingMode != null) {
                depString = depString + "stageMode=\"" + stagingMode + "\",";
            }
            if (secModel != null) {
                depString = depString + "securityModel=\"" + secModel + "\",";
            }
            if (isLibraryModule) {
                depString = depString + "libraryModule=\"true\",";
            }
            if (app.getDeploymentOrder() != 100) {
                depString = depString + "deploymentOrder=" + app.getDeploymentOrder() + ",";
            }
            depString = depString + "block=\"true\")";
            this.applicationDeploymentScript.append("    " + depString + "\n");
            this.applicationDeploymentScript.append("  except:\n");
            this.applicationDeploymentScript.append("    print \"Could not deploy application " + appName + "\"\n");
            this.applicationDeploymentScript.append("\n");
        }
        for (String _fname : this.applicationDeploymentFunctionNames) {
            this.applicationDeploymentFunctionCalls.append("  " + _fname + "()\n");
        }
    }

    private String getTargetNames(TargetMBean[] beans) {
        String[] sa = new String[beans.length];
        for (int i = 0; i < beans.length; ++i) {
            sa[i] = beans[i].getName();
        }
        return StringUtils.join((String[])sa, (String)",");
    }

    private Object getParentForBean(Object bean) throws ScriptException {
        try {
            Object[] obj = null;
            Class<?>[] clz = null;
            Method getParent = bean.getClass().getMethod("getParent", clz);
            return getParent.invoke(bean, obj);
        }
        catch (Throwable th) {
            String bs = bean == null ? null : bean.toString();
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getErrorFindingParent(bs), th);
            return null;
        }
    }

    private String getPathToBean(Object bean) {
        try {
            Stack<Object> beans = new Stack<Object>();
            beans.add(bean);
            Object par = this.getParentForBean(bean);
            while (par != null) {
                if (par instanceof DomainMBean) {
                    par = null;
                    continue;
                }
                par = this.getParentForBean(par);
                beans.add(par);
            }
            if (beans.size() == 1) {
                Object parent = this.getParentForBean(bean);
                BeanInfo info = this.beanInfoAccess.getBeanInfoForInstance(parent, false, "9.0.0");
                PropertyDescriptor[] pds = info.getPropertyDescriptors();
                String attrName = null;
                block3: for (int i = 0; i < pds.length; ++i) {
                    Object[] objs;
                    Method mth;
                    Object children;
                    PropertyDescriptor pd = pds[i];
                    String rel = (String)pd.getValue(RELATIONSHIP);
                    if (rel == null || !((String)pd.getValue(RELATIONSHIP)).equals(CONTAINMENT) || (children = (mth = pd.getReadMethod()).invoke(parent, objs = null)) == null || !children.toString().startsWith("[L")) continue;
                    Object[] childs = (Object[])children;
                    for (int j = 0; j < childs.length; ++j) {
                        if (!childs[j].equals(bean)) continue;
                        attrName = pd.getName();
                        continue block3;
                    }
                }
                if (attrName != null) {
                    String name = this.getName(bean);
                    return "/" + attrName + "/" + name;
                }
                System.out.println(this.ctx.getWLSTMsgFormatter().getUnexpectedError("null attribute"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean resolveReferences(Object bean, String path, StringBuffer buf) {
        boolean didResolve = false;
        for (ReferenceBucketArray rba : this.referenceBeanArrays) {
            String pathToBean = rba.getReferalPath();
            if (!path.equals(pathToBean)) continue;
            didResolve = true;
            String[] refPaths = rba.getReferentPath();
            String type = rba.getType();
            String methodName = rba.getMethodName();
            String gets = "";
            String val = "";
            for (int i = 0; i < refPaths.length; ++i) {
                val = val.length() > 0 ? val + "," + "refBean" + i : val + "refBean" + i;
                gets = gets + "  refBean" + i + " = getMBean(\"" + refPaths[i] + "\")\n";
            }
            buf.append(gets);
            buf.append("  theValue = jarray.array([" + val + "], Class.forName(\"" + type + "\"))\n");
            buf.append("  cmo." + methodName + "(theValue)\n");
            buf.append("\n");
        }
        for (ReferenceBucket rb : this.referenceBeans) {
            String pathToBean = rb.getReferalPath();
            if (!path.equals(pathToBean)) continue;
            didResolve = true;
            String pathToReferal = rb.getReferentPath();
            String methName = rb.getMethodName();
            buf.append("  bean = getMBean(\"" + pathToReferal + "\")\n");
            buf.append("  cmo." + methName + "(bean)\n");
            buf.append("\n");
        }
        return didResolve;
    }

    private Class getClassName(Class clz) throws ClassNotFoundException {
        if (clz.getName().startsWith("[L")) {
            return Class.forName(clz.getName().substring(2, clz.getName().length() - 1));
        }
        return clz;
    }

    private boolean isTransient(PropertyDescriptor pd) {
        Boolean rel = (Boolean)pd.getValue(TRANSIENT);
        if (rel == null) {
            return false;
        }
        return rel;
    }

    private boolean isDeprecated(PropertyDescriptor pd) {
        String rel = (String)pd.getValue(DEPRECATED);
        if (rel == null) {
            return false;
        }
        return Boolean.valueOf(rel);
    }

    private boolean isJMSBean(Object bean) {
        return bean instanceof JMSBean;
    }

    private String getNameForJMSBean(Object bean) {
        Object parent = this.jmsBeanToParentMap.get(bean);
        if (parent != null) {
            return ((JMSSystemResourceMBean)parent).getName();
        }
        return null;
    }

    private String getName(Object bean) throws ScriptException {
        try {
            Object[] obj = null;
            Method nameMethod = null;
            Method[] mths = bean.getClass().getMethods();
            for (int i = 0; i < mths.length; ++i) {
                if (!mths[i].getName().equals("getName")) continue;
                nameMethod = mths[i];
                break;
            }
            if (nameMethod == null) {
                if (this.isJMSBean(bean)) {
                    return this.getNameForJMSBean(bean);
                }
                return "NO_NAME";
            }
            String name = (String)nameMethod.invoke(bean, obj);
            if (name == null) {
                if (this.isJMSBean(bean)) {
                    return this.getNameForJMSBean(bean);
                }
                return "NO_NAME";
            }
            try {
                ObjectName on = new ObjectName(name);
                String x = on.getKeyProperty("Name");
                if (x != null) {
                    return x;
                }
            }
            catch (MalformedObjectNameException e) {
                return name;
            }
            return name;
        }
        catch (Throwable th) {
            String bs = bean == null ? "null" : bean.toString();
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getErrorGettingBeanName(bs), th);
            return null;
        }
    }

    private String getInterfaceClassName(DescriptorBean bean) {
        return (String)this.beanInfoAccess.getBeanInfoForInstance((Object)bean, false, "9.0.0").getBeanDescriptor().getValue("interfaceclassname");
    }

    private void setBeanAttributes() throws ScriptException {
        Set beans = this.createdBeans.keySet();
        for (Object obj : beans) {
            String path = (String)this.createdBeans.get(obj);
            this.createSetBeanAttributes(obj, path);
        }
    }

    private void encryptDefaultUsernameAndPassword() {
        this.createLocalStorageForPasswords("welcome1".toCharArray(), "weblogic.management", "weblogic");
    }

    private void createSetBeanAttributes(Object bean, String path) throws ScriptException {
        try {
            BeanInfo info = this.beanInfoAccess.getBeanInfoForInstance(bean, false, "9.0.0");
            StringBuffer buf = new StringBuffer();
            PropertyDescriptor[] propDescInfos = info.getPropertyDescriptors();
            Iterator iter = this.beanFunctionNameList.iterator();
            String funcName = null;
            FunctionNameBucket _buck = null;
            while (iter.hasNext()) {
                FunctionNameBucket buck = (FunctionNameBucket)iter.next();
                if (!buck.getBean().equals(bean)) continue;
                funcName = buck.getSetFunctionName();
                _buck = buck;
            }
            boolean didInc = false;
            String mbeanType = this.getTypeFromDecsriptor(info.getBeanDescriptor());
            if (funcName == null) {
                funcName = "setAttributes_" + mbeanType + "_" + this.getCounter();
                didInc = true;
            }
            buf.append("def " + funcName + "():\n");
            if (path.length() > 0) {
                buf.append("  cd(\"" + path + "\")\n");
            } else {
                buf.append("  cd(\"/\")\n");
            }
            buf.append("  print \"setting attributes for mbean type " + mbeanType + "\"\n");
            boolean didSet = false;
            for (int i = 0; i < propDescInfos.length; ++i) {
                DescriptorBean dBean = (DescriptorBean)bean;
                PropertyDescriptor propDesc = propDescInfos[i];
                String attrName = propDesc.getName();
                if (!dBean.isSet(attrName) || propDesc.getWriteMethod() == null) continue;
                if (this.isChild(propDesc) || this.isDefaulted(propDesc) || this.isReferal(propDesc) || bean instanceof WebLogicMBean && attrName.equals("Name")) {
                    this.print(this.ctx.getWLSTMsgFormatter().getContinueInBean());
                    continue;
                }
                Object[] objs = null;
                Object s = propDesc.getReadMethod().invoke(bean, objs);
                if (s == null) continue;
                if (s instanceof String) {
                    s = StringUtils.escapeString((String)((String)s));
                }
                if (this.isEncrypted(propDesc)) {
                    String propName = "c2s" + this.getCounter();
                    if (attrName.endsWith("Encrypted")) {
                        attrName = StringUtils.replaceGlobal((String)attrName, (String)"Encrypted", (String)"");
                        Class<?>[] clzz = null;
                        Method getP = bean.getClass().getMethod("get" + attrName, clzz);
                        Object[] p1 = null;
                        s = getP.invoke(bean, p1);
                    }
                    this.createLocalStorageForPasswords(s.toString().toCharArray(), propName, "");
                    buf.append("  setEncrypted(\"" + attrName + "\", \"" + propName + "\", \"" + this.CONFIG_TO_SCRIPT_USER_CONFIG_FILE + "\", \"" + this.CONFIG_TO_SCRIPT_SECRET_FILE + "\")\n");
                    didSet = true;
                    continue;
                }
                if (propDesc.getPropertyType().getName().equals("[B")) {
                    s = this.replaceByteArrayWithString(s);
                }
                this.print(this.ctx.getWLSTMsgFormatter().getAttributeSet(attrName, bean.toString()));
                if (s.getClass().isArray()) {
                    String _s = this.getArrayObject(s);
                    if (_s != null) {
                        buf.append("  set(\"" + attrName + "\", " + _s + ")\n");
                    }
                } else {
                    buf.append("  set(\"" + attrName + "\", \"" + s.toString() + "\")\n");
                }
                didSet = true;
            }
            boolean didSetReference = this.resolveReferences(bean, path, buf);
            if (_buck != null && !didSet && !didSetReference) {
                _buck.setCallSetter(false);
            }
            if (didSet || didSetReference) {
                if (_buck == null) {
                    this.functionNames.add(funcName);
                }
                buf.append("\n");
                this.mainScriptBuffer.append(buf.toString());
            } else if (didInc) {
                this.releaseCounter();
            }
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getErrorMakingSetBeans(), th);
        }
    }

    private String getArrayObject(Object obj) {
        if (obj instanceof String[]) {
            String[] values = (String[])obj;
            String s = "jarray.array([";
            for (int i = 0; i < values.length; ++i) {
                s = i != values.length - 1 ? s + "\"" + values[i] + "\"," : s + "\"" + values[i] + "\"";
            }
            s = s + "], String)";
            return s;
        }
        System.out.println("<DEBUG> ONLY String[] supported. If you see this Please file a CR.");
        return null;
    }

    private void createLocalStorageForPasswords(char[] passwordValue, String propertyName, String userName) {
        System.setProperty("weblogic.management.confirmKeyfileCreation", "true");
        File pf = this.pyFile.getParentFile();
        if (pf == null) {
            pf = new File(".");
        }
        this.CONFIG_TO_SCRIPT_USER_CONFIG_FILE = this.replaceEscapeCharacters(pf.getAbsolutePath() + "/" + "c2sConfig" + this.domainMBean.getName());
        this.CONFIG_TO_SCRIPT_SECRET_FILE = this.replaceEscapeCharacters(pf.getAbsolutePath() + "/" + "c2sSecret" + this.domainMBean.getName());
        UsernameAndPassword up = new UsernameAndPassword(userName, passwordValue);
        UserConfigFileManager.setUsernameAndPassword(up, this.CONFIG_TO_SCRIPT_USER_CONFIG_FILE, this.CONFIG_TO_SCRIPT_SECRET_FILE, propertyName);
    }

    private String getTypeFromDecsriptor(BeanDescriptor bd) {
        String pack = (String)bd.getValue("package");
        String inter = (String)bd.getValue("interfaceclassname");
        String val = inter.replaceAll(pack + ".", "");
        if (val.endsWith("MBean")) {
            val = val.substring(0, val.length() - 5);
        } else if (val.endsWith("Bean")) {
            val = val.substring(0, val.length() - 4);
        }
        return val;
    }

    private String replaceEscapeCharacters(Object s) {
        if (s == null) {
            return null;
        }
        String val = (String)s;
        val = StringUtils.replaceGlobal((String)val, (String)File.separator, (String)"/");
        return val;
    }

    private String replaceByteArrayWithString(Object s) {
        if (s == null) {
            return null;
        }
        String k = new String((byte[])s);
        return k;
    }

    private String getTypeFromCreateMethod(String cm) {
        return cm.substring(6, cm.length());
    }

    private void createBeanScript(String beanName, PropertyDescriptor pd, String path, Object bean, boolean isTemplated) {
        String creatorMethod = null;
        String baseCreatorMethod = (String)pd.getValue(CREATOR);
        String intfName = this.getInterfaceClassName((DescriptorBean)bean);
        if (intfName != null) {
            int pos = intfName.lastIndexOf(46) + 1;
            String subTypeName = intfName.substring(pos, intfName.length());
            creatorMethod = (String)pd.getValue("creator." + subTypeName);
        }
        if (creatorMethod == null) {
            creatorMethod = baseCreatorMethod;
        }
        String lookupMethod = baseCreatorMethod.replaceFirst("create", "lookup");
        if (this.dummyCreators.contains(creatorMethod)) {
            return;
        }
        String beanType = this.getTypeFromCreateMethod(creatorMethod);
        String funcName = "create_" + beanType + "_" + this.getCounter();
        funcName = this.getFunctionNameFromResource(funcName);
        String setterFuncName = "setAttributesFor_" + beanName + "_" + this.getCounter();
        setterFuncName = this.getFunctionNameFromResource(setterFuncName);
        String existingCreateFuncName = (String)this.createMethods.get(beanType);
        if (existingCreateFuncName != null) {
            funcName = existingCreateFuncName;
        }
        FunctionNameBucket bucket = new FunctionNameBucket(funcName, setterFuncName, bean, path, beanName);
        this.beanFunctionNameList.add(bucket);
        if (existingCreateFuncName != null) {
            return;
        }
        this.createMethods.put(beanType, funcName);
        this.mainScriptBuffer.append("def " + funcName + "(path, beanName):\n");
        this.mainScriptBuffer.append("  cd(path)\n");
        this.mainScriptBuffer.append("  try:\n");
        this.mainScriptBuffer.append("    print \"creating mbean of type " + this.getTypeFromCreateMethod(creatorMethod) + " ... \"\n");
        if (this.isSecurityMBean(bean)) {
            String interfaceClzName = this.getInterfaceClassName((DescriptorBean)bean);
            interfaceClzName = interfaceClzName.substring(0, interfaceClzName.length() - 5);
            if (pd.getName().equals("Adjudicator")) {
                this.mainScriptBuffer.append("    theBean = cmo.getAdjudicator()\n");
            } else {
                this.mainScriptBuffer.append("    theBean = cmo." + lookupMethod + "(beanName)\n");
            }
            this.mainScriptBuffer.append("    if theBean == None:\n");
            this.mainScriptBuffer.append("      cmo." + creatorMethod + "(beanName,\"" + interfaceClzName + "\")\n");
        } else if (this.isDeprecated(pd)) {
            this.mainScriptBuffer.append("    cmo." + creatorMethod + "(beanName)\n");
        } else {
            this.mainScriptBuffer.append("    theBean = cmo." + lookupMethod + "(beanName)\n");
            this.mainScriptBuffer.append("    if theBean == None:\n");
            if (!isTemplated) {
                this.mainScriptBuffer.append("      cmo." + creatorMethod + "(beanName)\n");
            } else {
                this.mainScriptBuffer.append("      cmo." + creatorMethod + "(beanName)\n");
            }
        }
        this.mainScriptBuffer.append("  except java.lang.UnsupportedOperationException, usoe:\n");
        this.mainScriptBuffer.append("    pass\n");
        this.mainScriptBuffer.append("  except weblogic.descriptor.BeanAlreadyExistsException,bae:\n");
        this.mainScriptBuffer.append("    pass\n");
        this.mainScriptBuffer.append("  except java.lang.reflect.UndeclaredThrowableException,udt:\n");
        this.mainScriptBuffer.append("    pass\n");
        if (creatorMethod.equals("createProperty")) {
            this.mainScriptBuffer.append("  except TypeError:\n");
            if (beanName == null) {
                this.mainScriptBuffer.append("    pass\n");
                this.createMethods.remove(beanType);
            } else {
                this.mainScriptBuffer.append("    prop = cmo.createProperty()\n");
                this.mainScriptBuffer.append("    prop.setName(beanName)\n");
            }
        }
        this.mainScriptBuffer.append("\n");
    }

    private boolean isSecurityMBean(Object bean) {
        return bean instanceof ProviderMBean;
    }

    private boolean isSystemResourceMBean(Object bean) {
        return bean instanceof JDBCSystemResourceMBean || bean instanceof WLDFSystemResourceMBean || bean instanceof JMSSystemResourceMBean || bean instanceof JMSInteropModuleMBean;
    }

    private String getFunctionNameFromResource(String resource) {
        byte[] bytes = null;
        try {
            bytes = resource.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            bytes = resource.getBytes();
        }
        byte[] funcNameBuf = new byte[bytes.length * 3];
        int pos = 0;
        block5: for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 97 && bytes[i] <= 122 || bytes[i] >= 65 && bytes[i] <= 90 || bytes[i] >= 48 && bytes[i] <= 57 || bytes[i] == 95) {
                funcNameBuf[pos++] = bytes[i];
                continue;
            }
            switch (bytes[i]) {
                case 32: 
                case 33: 
                case 36: 
                case 37: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 59: 
                case 61: 
                case 64: 
                case 91: 
                case 93: 
                case 94: 
                case 123: 
                case 124: 
                case 125: 
                case 126: {
                    funcNameBuf[pos++] = 95;
                    continue block5;
                }
                default: {
                    String hex = Hex.asHex((int)bytes[i]);
                    byte[] hexBytes = hex.getBytes();
                    System.arraycopy(hexBytes, 0, funcNameBuf, pos, hexBytes.length);
                    pos += hexBytes.length;
                }
            }
        }
        return new String(funcNameBuf, 0, pos);
    }

    private int getCounter() {
        int i = this.beansCounter++;
        return i;
    }

    private int releaseCounter() {
        int i = this.beansCounter--;
        return i;
    }

    private boolean isChild(PropertyDescriptor pd) {
        String rel = (String)pd.getValue(RELATIONSHIP);
        if (rel == null) {
            return false;
        }
        String creator = (String)pd.getValue(CREATOR);
        String des = (String)pd.getValue(DESTROYER);
        return rel.equals(CONTAINMENT) && creator != null && des != null;
    }

    private boolean isReadonlyChild(PropertyDescriptor pd) {
        String rel = (String)pd.getValue(RELATIONSHIP);
        if (rel == null) {
            return false;
        }
        return rel.equals(CONTAINMENT);
    }

    private boolean isDefaulted(PropertyDescriptor pd) {
        String rel = (String)pd.getValue(RELATIONSHIP);
        if (rel == null) {
            return false;
        }
        String creator = (String)pd.getValue(CREATOR);
        String des = (String)pd.getValue(DESTROYER);
        if (rel.equals(CONTAINMENT) && creator != null && des != null) {
            return false;
        }
        if (rel.equals(CONTAINMENT)) {
            return !pd.getName().equals("AppDeployments") && !pd.getName().equals("Libraries");
        }
        return false;
    }

    private boolean isEncrypted(PropertyDescriptor pd) {
        Boolean obj = (Boolean)pd.getValue("encrypted");
        if (obj != null) {
            return obj;
        }
        return false;
    }

    private boolean isExcluded(PropertyDescriptor pd) {
        Boolean obj = (Boolean)pd.getValue("exclude");
        if (obj != null) {
            return obj;
        }
        return false;
    }

    private boolean isReferal(PropertyDescriptor pd) {
        String rel = (String)pd.getValue(RELATIONSHIP);
        if (rel == null) {
            return false;
        }
        return rel.equals(REFERENCE);
    }

    private void writeFile(File file) throws ScriptException {
        try {
            FileWriter out = new FileWriter(file);
            out.write(this.theScript.toString());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getIOExceptionWritingFile(file.getAbsolutePath()), e);
        }
    }

    private String header() {
        StringBuffer sb1 = new StringBuffer();
        sb1.append("\"\"\"\n");
        sb1.append("This is a WLST script that is generated by the WebLogic Scripting Tool (WLST)\n");
        try {
            sb1.append("Configuration file converted               : " + this.replaceEscapeCharacters(this.configFile.getCanonicalPath()) + "\n");
            sb1.append("WLST script generated to file              : " + this.replaceEscapeCharacters(this.pyFile.getCanonicalPath()) + "\n");
            sb1.append("Properties file associated with the script : " + this.replaceEscapeCharacters(this.propertiesFile.getCanonicalPath()) + "\n");
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        sb1.append("\n");
        sb1.append("This script will first try to connect to a running server using the \nvalues in the properties file. If there is no server running, WLST\nwill start a server with the values in the properties file. You should change\nthese values to suit your environmental needs. After running the script, \nthe server that is started(if started one) will be shutdown. \nThis might exit you from your WLST shell.");
        sb1.append("\"\"\"\n");
        sb1.append("\n");
        sb1.append(this.addImports());
        sb1.append("\n");
        sb1.append("def initConfigToScriptRun():\n");
        sb1.append("  global startedNewServer\n");
        sb1.append("  loadProperties(\"" + this.replaceEscapeCharacters(this.propertiesFile.getAbsolutePath()) + "\"" + ")" + "\n");
        sb1.append("  hideDisplay()\n");
        sb1.append("  hideDumpStack(\"true\")\n");
        sb1.append("  # try connecting to a running server if it is already running ... \n");
        sb1.append("  if connected==\"false\":\n");
        sb1.append("    try:\n");
        sb1.append("      URL=\"t3://\"+adminServerListenAddress+\":\"+adminServerListenPort\n");
        sb1.append("      connect(userName, passWord, URL, userConfigFile=\"" + this.CONFIG_TO_SCRIPT_USER_CONFIG_FILE + "\", " + "userKeyFile" + "=\"" + this.CONFIG_TO_SCRIPT_SECRET_FILE + "\")\n");
        sb1.append("    except WLSTException:\n");
        sb1.append("      print 'No server is running at '+URL+', the script will start a new server'\n");
        sb1.append("  hideDumpStack(\"false\")\n");
        sb1.append("  if connected==\"false\":\n");
        sb1.append("    print 'Starting a brand new server at '+URL+' with server name '+adminServerName\n");
        sb1.append("    print 'Please see the server log files for startup messages available at '+domainDir\n");
        sb1.append("    # If a config.xml exists in the domainDir, WLST will use that config.xml to bring up the server. \n");
        sb1.append("    # If you would like WLST to overwrite this directory, you should specify overWriteRootDir='true' as shown below\n");
        sb1.append("    # startServer(adminServerName, domName, URL, userName, passWord,domainDir, overWriteRootDir='true')\n");
        sb1.append("    _timeOut = Integer(TimeOut)\n");
        sb1.append("    # If you want to specify additional JVM arguments, set them using startServerJvmArgs in the property file or below\n");
        sb1.append("    _startServerJvmArgs=startServerJvmArgs\n");
        sb1.append("    if (_startServerJvmArgs==\"\" and (System.getProperty(\"java.vendor\").find(\"Sun\")>=0 or System.getProperty(\"java.vendor\").find(\"Hewlett\")>=0)):\n");
        sb1.append("      _startServerJvmArgs = \" -XX:MaxPermSize=128m\"\n");
        sb1.append("    if overWriteRootDir=='true':\n");
        sb1.append("      startServer(adminServerName, domName, URL, userName, passWord,domainDir, timeout=_timeOut.intValue(), overWriteRootDir='true', block='true', jvmArgs=_startServerJvmArgs)\n");
        sb1.append("    else:\n");
        sb1.append("      startServer(adminServerName, domName, URL, userName, passWord,domainDir, timeout=_timeOut.intValue(), block='true', jvmArgs=_startServerJvmArgs)\n");
        sb1.append("    startedNewServer=1\n");
        sb1.append("    print \"Started Server. Trying to connect to the server ... \"\n");
        sb1.append("    connect(userName, passWord, URL, userConfigFile=\"" + this.CONFIG_TO_SCRIPT_USER_CONFIG_FILE + "\", " + "userKeyFile" + "=\"" + this.CONFIG_TO_SCRIPT_SECRET_FILE + "\")\n");
        sb1.append("    if connected=='false':\n");
        sb1.append("      stopExecution('You need to be connected.')\n");
        sb1.append("\n");
        sb1.append("def startTransaction():\n");
        sb1.append("  edit()\n");
        sb1.append("  startEdit()\n");
        sb1.append("\n");
        sb1.append("def endTransaction():\n");
        sb1.append("  startEdit()\n");
        sb1.append("  save()\n");
        sb1.append("  activate(block=\"true\")\n");
        sb1.append("\n");
        sb1.append("from javax.management import InstanceAlreadyExistsException\n");
        sb1.append("from java.lang import Exception\n");
        sb1.append("from jarray import array\n");
        sb1.append("\n");
        return sb1.toString();
    }

    private String tail() {
        StringBuffer sb2 = new StringBuffer();
        sb2.append("def endOfConfigToScriptRun():\n");
        sb2.append("  global startedNewServer\n");
        sb2.append("  #Save the changes you have made\n");
        sb2.append("  # shutdown the server you have started\n");
        sb2.append("  if startedNewServer==1:\n");
        sb2.append("    print 'Shutting down the server that is started... '\n");
        sb2.append("    shutdown(force='true', block='true')\n");
        sb2.append("  print 'Done executing the script.'\n");
        sb2.append("\n");
        return sb2.toString();
    }

    private void createDefaultProperties(File propFile) throws ScriptException {
        try {
            FileOutputStream oStream = new FileOutputStream(propFile);
            Properties props = new Properties();
            props.setProperty("userName", "");
            props.setProperty("passWord", "");
            props.setProperty("domainDir", "WLSTConfigToScriptDomain");
            String asName = this.domainMBean.getAdminServerName();
            props.setProperty("adminServerName", asName);
            ServerMBean sbean = this.domainMBean.lookupServer(asName);
            String la = sbean.getListenAddress();
            if (la == null || la.length() == 0) {
                la = "localhost";
            }
            props.setProperty("adminServerListenAddress", la);
            props.setProperty("adminServerListenPort", String.valueOf(sbean.getListenPort()));
            props.setProperty("domName", this.domainMBean.getName());
            props.setProperty("exitonerror", "false");
            props.setProperty("startedNewServer", "0");
            props.setProperty("overWriteRootDir", "true");
            props.setProperty("TimeOut", "240000");
            props.setProperty("startServerJvmArgs", "");
            props.store(oStream, "WLST ConfigToScript Default Properties file ");
            oStream.close();
        }
        catch (IOException ioe) {
            this.ctx.throwWLSTException(this.ctx.getWLSTMsgFormatter().getIOExceptionWritingFile(propFile.toString()), ioe);
        }
    }

    public static void main(String[] args) throws Exception {
        ConfigToScript cts = new ConfigToScript(args[0]);
        cts.convert();
    }

    class ReferenceBucketArray {
        String referalBeanPath;
        String[] referentBeanPath;
        String methodName;
        String type;

        ReferenceBucketArray(String referal, String[] referent, String methName, String type) {
            this.referalBeanPath = referal;
            this.referentBeanPath = referent;
            this.methodName = methName;
            this.type = type;
        }

        String getReferalPath() {
            return this.referalBeanPath;
        }

        String[] getReferentPath() {
            return this.referentBeanPath;
        }

        String getMethodName() {
            return this.methodName;
        }

        String getType() {
            return this.type;
        }
    }

    class ReferenceBucket {
        String referalBeanPath;
        String referentBeanPath;
        String methodName;

        ReferenceBucket(String referal, String referent, String methName) {
            this.referalBeanPath = referal;
            this.referentBeanPath = referent;
            this.methodName = methName;
        }

        String getReferalPath() {
            return this.referalBeanPath;
        }

        String getReferentPath() {
            return this.referentBeanPath;
        }

        String getMethodName() {
            return this.methodName;
        }
    }

    class FunctionNameBucket {
        String create_function_name;
        String set_function_name;
        Object bean;
        String path;
        String beanName;
        boolean callTheSetter = true;

        FunctionNameBucket(String se, String rt, Object res, String path, String beanName) {
            this.create_function_name = se;
            this.set_function_name = rt;
            this.bean = res;
            this.path = path;
            this.beanName = beanName;
        }

        String getCreateFunctionName() {
            return this.create_function_name;
        }

        String getSetFunctionName() {
            return this.set_function_name;
        }

        Object getBean() {
            return this.bean;
        }

        String getPath() {
            return this.path;
        }

        String getBeanName() {
            return this.beanName;
        }

        boolean callSetter() {
            return this.callTheSetter;
        }

        void setCallSetter(boolean bool) {
            this.callTheSetter = bool;
        }
    }
}

