/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.scripting;

import java.util.TreeMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.mbeanservers.Service;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.scripting.ScriptException;
import weblogic.management.scripting.WLScriptContext;
import weblogic.management.scripting.utils.WLSTMsgTextFormatter;

public class DomainRuntimeHandler {
    private WLScriptContext ctx = null;
    private WLSTMsgTextFormatter txtFmt;
    private static final String DOMAIN_SERVICES = "DomainServices";
    private static final String SERVER_SERVICES = "ServerServices";

    DomainRuntimeHandler(WLScriptContext ctx) {
        this.ctx = ctx;
        this.txtFmt = ctx.getWLSTMsgFormatter();
    }

    Object ls(String attribute) {
        String s = (String)this.ctx.prompts.peek();
        if (s.equals(DOMAIN_SERVICES)) {
            return this.listDomainServices();
        }
        if (s.equals(SERVER_SERVICES)) {
            return this.listActiveServers();
        }
        return this.listActiveServers();
    }

    void cd(String attribute) throws ScriptException {
        if (this.ctx.inMBeanTypes) {
            String s = (String)this.ctx.prompts.peek();
            if (s.equals(DOMAIN_SERVICES)) {
                boolean fnd = false;
                Service[] sBeans = this.ctx.domainRuntimeServiceMBean.getServices(null);
                for (int i = 0; i < sBeans.length; ++i) {
                    if (!sBeans[i].getName().equals(attribute)) continue;
                    this.ctx.prompts.add(attribute);
                    this.ctx.prompt = this.ctx.evaluatePrompt();
                    this.ctx.browseHandler.changeToBeanLevel();
                    this.ctx.wlcmo = sBeans[i];
                    this.ctx.beans.push(this.ctx.wlcmo);
                    fnd = true;
                    break;
                }
                if (!fnd) {
                    this.ctx.throwWLSTException(this.txtFmt.getAttributeNotFound(attribute));
                }
            } else if (s.equals(SERVER_SERVICES)) {
                boolean fnd = false;
                ServerRuntimeMBean[] sBeans = this.getServerRuntimes();
                for (int i = 0; i < sBeans.length; ++i) {
                    if (!sBeans[i].getName().equals(attribute)) continue;
                    fnd = true;
                    break;
                }
                if (!fnd) {
                    this.ctx.throwWLSTException(this.txtFmt.getAttributeNotFound(attribute));
                }
                Service[] beans = this.ctx.domainRuntimeServiceMBean.getServices(attribute);
                ObjectName[] onames = new ObjectName[beans.length];
                for (int i = 0; i < beans.length; ++i) {
                    onames[i] = this.ctx.getObjectName(beans[i]);
                }
                this.ctx.wlInstanceObjNames = onames;
                this.ctx.prompts.add(attribute);
                this.ctx.prompt = this.ctx.evaluatePrompt();
                this.ctx.browseHandler.changeToMBeanTypesLevel();
                this.ctx.beans.push(this.ctx.wlcmo);
                this.ctx.browseHandler.populateNames(onames);
            } else {
                boolean fnd = false;
                ServerRuntimeMBean[] srBeans = this.getServerRuntimes();
                for (int i = 0; i < srBeans.length; ++i) {
                    if (!srBeans[i].getName().equals(attribute)) continue;
                    this.ctx.prompts.add(attribute);
                    this.ctx.prompt = this.ctx.evaluatePrompt();
                    this.ctx.browseHandler.changeToBeanLevel();
                    this.ctx.wlcmo = MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)this.ctx.getMBSConnection(this.ctx.domainType), (ObjectName)srBeans[i].getObjectName());
                    this.ctx.beans.push(this.ctx.wlcmo);
                    fnd = true;
                    break;
                }
                if (!fnd) {
                    this.ctx.throwWLSTException(this.txtFmt.getAttributeNotFound(attribute));
                }
            }
        } else {
            this.ctx.prompts.add(attribute);
            this.ctx.prompt = this.ctx.evaluatePrompt();
            this.ctx.browseHandler.changeToMBeanTypesLevel();
            this.ctx.beans.push(this.ctx.wlcmo);
        }
    }

    ServerRuntimeMBean[] getServerRuntimes() {
        return this.ctx.domainRuntimeServiceMBean.getServerRuntimes();
    }

    Object listActiveServers() {
        ServerRuntimeMBean[] srBeans = this.getServerRuntimes();
        TreeMap<String, String> attribPerms = new TreeMap<String, String>();
        String perm = this.ctx.infoHandler.getPermission();
        for (int i = 0; i < srBeans.length; ++i) {
            attribPerms.put(srBeans[i].getName(), perm);
        }
        return this.ctx.printAttributes(attribPerms);
    }

    Object listDomainServices() {
        Service[] srBeans = this.ctx.domainRuntimeServiceMBean.getServices(null);
        TreeMap<String, String> attribPerms = new TreeMap<String, String>();
        String perm = this.ctx.infoHandler.getPermission();
        for (int i = 0; i < srBeans.length; ++i) {
            attribPerms.put(srBeans[i].getName(), perm);
        }
        return this.ctx.printAttributes(attribPerms);
    }

    Object handleServerServicesNodeForLs() {
        return this.listActiveServers();
    }

    boolean isDomainRuntimeService(String name) {
        return DOMAIN_SERVICES.equals(name) || SERVER_SERVICES.equals(name);
    }

    void pop() throws ScriptException {
        if (this.ctx.atBeanLevel) {
            this.ctx.prompts.pop();
            this.ctx.beans.pop();
            this.ctx.browseHandler.changeToMBeanTypesLevel();
            this.ctx.prompt = this.ctx.evaluatePrompt();
        } else {
            String s1 = (String)this.ctx.prompts.elementAt(0);
            if (s1.equals(SERVER_SERVICES) && this.ctx.prompts.size() > 1) {
                this.ctx.browseHandler.changeToMBeanTypesLevel();
                this.ctx.browseHandler.popAndPeek();
                this.ctx.prompt = this.ctx.evaluatePrompt();
                return;
            }
            this.ctx.browseHandler.popAndPeek();
            this.ctx.browseHandler.changeToBeanLevel();
            this.ctx.prompt = this.ctx.evaluatePrompt();
        }
    }
}

