/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.scripting;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import weblogic.descriptor.BeanAlreadyExistsException;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.MBeanCreationException;
import weblogic.management.NoAccessRuntimeException;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.scripting.ScriptException;
import weblogic.management.scripting.WLScriptContext;
import weblogic.management.scripting.utils.ErrorInformation;
import weblogic.management.scripting.utils.WLSTMsgTextFormatter;
import weblogic.management.security.RealmMBean;
import weblogic.security.UserConfigFileManager;
import weblogic.security.UsernameAndPassword;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.utils.StringUtils;

public class EditHandler {
    WLScriptContext ctx = null;
    private WLSTMsgTextFormatter txtFmt;
    List specialMBeans = new ArrayList();
    List creatableDescriptorBeans = new ArrayList();
    static final String REALM_MBEAN = "weblogic.management.security.RealmMBean";
    List baseSecurityProviderAttributeTypes = new ArrayList();
    static final String ADJ = "Adjudicator";
    static final String AUD = "Auditor";
    static final String ATN = "AuthenticationProvider";
    static final String ATZ = "Authorizer";
    static final String CPP = "CertPathProvider";
    static final String CDM = "CredentialMapper";
    static final String KST = "KeyStore";
    static final String RMP = "RoleMapper";
    private static final String CREATOR = "creator";
    private static final String DESTROYER = "destroyer";
    private static final String SLASH = "/";
    private static String[] CREATABLE_DESCRIPTOR_BEANS = new String[]{"weblogic.j2ee.descriptor.wl.JDBCPropertyBean", "weblogic.diagnostics.descriptor.WLDFHarvestedTypeBean", "weblogic.diagnostics.descriptor.WLDFImageNotificationBean", "weblogic.diagnostics.descriptor.WLDFInstrumentationMonitorBean", "weblogic.diagnostics.descriptor.WLDFJMXNotificationBean", "weblogic.diagnostics.descriptor.WLDFSMTPNotificationBean", "weblogic.diagnostics.descriptor.WLDFSNMPNotificationBean", "weblogic.diagnostics.descriptor.WLDFWatchNotificationBean", "weblogic.diagnostics.descriptor.WLDFJMSNotificationBean", "weblogic.diagnostics.descriptor.WLDFWatchNotificationBean", "weblogic.j2ee.descriptor.wl.JMSConnectionFactoryBean", "weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean", "weblogic.j2ee.descriptor.wl.PropertyBean"};
    private static String[] SPECIAL_BEANS = new String[]{"JMSSessionPool", "JMSConnectionConsumer"};

    public EditHandler(WLScriptContext ctx) {
        int i;
        this.ctx = ctx;
        this.txtFmt = ctx.getWLSTMsgFormatter();
        for (i = 0; i < SPECIAL_BEANS.length; ++i) {
            this.specialMBeans.add(SPECIAL_BEANS[i]);
        }
        this.baseSecurityProviderAttributeTypes.add(ADJ);
        this.baseSecurityProviderAttributeTypes.add(AUD);
        this.baseSecurityProviderAttributeTypes.add(ATN);
        this.baseSecurityProviderAttributeTypes.add(ATZ);
        this.baseSecurityProviderAttributeTypes.add(CPP);
        this.baseSecurityProviderAttributeTypes.add(CDM);
        this.baseSecurityProviderAttributeTypes.add(KST);
        this.baseSecurityProviderAttributeTypes.add(RMP);
        for (i = 0; i < CREATABLE_DESCRIPTOR_BEANS.length; ++i) {
            this.creatableDescriptorBeans.add(CREATABLE_DESCRIPTOR_BEANS[i]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object get(String attrName) throws ScriptException {
        try {
            ObjectName oname;
            String currenTree;
            String currentPwd;
            block15: {
                block14: {
                    currentPwd = this.ctx.prompt;
                    currenTree = this.ctx.getCurrentTree();
                    oname = this.ctx.getObjectName();
                    if (this.ctx.domainType.equals("Custom_Domain")) break block14;
                    if (!this.ctx.domainType.equals("DomainCustom_Domain")) break block15;
                }
                oname = new ObjectName((String)this.ctx.prompts.peek());
            }
            MBeanServerConnection connection = this.ctx.getMBSConnection(null);
            try {
                return connection.getAttribute(oname, attrName);
            }
            catch (AttributeNotFoundException e) {
                try {
                    Object retObj;
                    String[] attributes;
                    String tree = this.ctx.getTreeFromArgument(attrName);
                    if (tree != null) {
                        attrName = this.ctx.removeTreeFromArgument(attrName);
                        this.ctx.browseHandler.jumpTree(tree);
                    }
                    if ((attributes = StringUtils.splitCompletely((String)attrName, (String)SLASH)).length <= 1) throw e;
                    String attributeName = attributes[attributes.length - 1];
                    attributes[attributes.length - 1] = "";
                    String attribute = StringUtils.join((String[])attributes, (String)SLASH);
                    if (attrName.startsWith(SLASH)) {
                        attribute = SLASH + attribute;
                    }
                    this.ctx.browseHandler.cd(attribute);
                    Object object = retObj = this.get(attributeName);
                    return object;
                }
                finally {
                    this.ctx.browseHandler.jumpTree(currenTree);
                    this.ctx.browseHandler.takeBackToRoot();
                    this.ctx.browseHandler.cd(currentPwd);
                }
            }
        }
        catch (Throwable e2) {
            if (e2 instanceof ScriptException) {
                throw (ScriptException)e2;
            }
            this.ctx.throwWLSTException(this.txtFmt.getErrorGettingAttribute(attrName), e2);
            return null;
        }
    }

    private Object convertToRightObject(String theType, Object value) {
        if (theType.equals("java.lang.String")) {
            return (String)value;
        }
        if (theType.equals("java.lang.Integer")) {
            return new Integer((String)value);
        }
        if (theType.equals("java.lang.Boolean")) {
            return new Boolean((String)value);
        }
        if (theType.equals("java.util.Properties")) {
            return this.makePropertiesObject(value);
        }
        if (theType.equals("java.util.Map")) {
            return this.makeMapObject(value);
        }
        if (theType.equals("java.lang.Byte") || theType.equals("[B")) {
            return this.makeByteArray(value);
        }
        if (theType.equals("java.lang.Long")) {
            return this.makeLongObject(value);
        }
        if (theType.equals("java.lang.Double")) {
            return new Double((String)value);
        }
        if (theType.equals("javax.management.ObjectName")) {
            return this.ctx.getObjectName(value);
        }
        if (theType.equals("[Ljavax.management.ObjectName;")) {
            return this.ctx.getObjectNames(value);
        }
        return value;
    }

    private Long makeLongObject(Object val) {
        String theVal = (String)val;
        if (theVal.endsWith("L")) {
            theVal = theVal.replaceAll("L", "");
            long lo = Long.parseLong(theVal);
            return new Long(lo);
        }
        long lo1 = Long.parseLong(theVal);
        return new Long(lo1);
    }

    private byte[] makeByteArray(Object val) {
        String theVal = (String)val;
        if (theVal.startsWith("{3DES}")) {
            byte[] y = null;
            try {
                y = SerializedSystemIni.getEncryptionService().decryptBytes(theVal.getBytes());
            }
            catch (Exception e) {
                return theVal.getBytes();
            }
            return y;
        }
        return theVal.getBytes();
    }

    private Properties makePropertiesObject(Object val) {
        String propString = (String)val;
        Properties props = new Properties();
        if (propString.startsWith("{") && propString.endsWith("}")) {
            propString = propString.substring(1, propString.length() - 1);
        }
        String[] vals = StringUtils.splitCompletely((String)propString, (String)",");
        for (int i = 0; i < vals.length; ++i) {
            String[] realVals = StringUtils.splitCompletely((String)vals[i], (String)"=");
            props.setProperty(realVals[0], realVals[1]);
        }
        return props;
    }

    private Map makeMapObject(Object val) {
        String propString = (String)val;
        HashMap<String, String> props = new HashMap<String, String>();
        if (propString.startsWith("{") && propString.endsWith("}")) {
            propString = propString.substring(1, propString.length() - 1);
        }
        String[] vals = StringUtils.splitCompletely((String)propString, (String)",");
        for (int i = 0; i < vals.length; ++i) {
            String[] realVals = StringUtils.splitCompletely((String)vals[i], (String)"=");
            props.put(realVals[0], realVals[1]);
        }
        return props;
    }

    private Object getRealObject(String attribName, Object value) {
        try {
            MBeanInfo info = this.ctx.getMBeanInfo(this.ctx.wlcmo);
            MBeanAttributeInfo[] attrInfos = info.getAttributes();
            for (int i = 0; i < attrInfos.length; ++i) {
                MBeanAttributeInfo attrInfo = attrInfos[i];
                if (!attrInfo.getName().equals(attribName)) continue;
                this.ctx.printDebug("Value will be converted to type " + attrInfo.getType());
                return this.convertToRightObject(attrInfo.getType(), value);
            }
        }
        catch (Exception e) {
            return value;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getMBean(String mbeanPath) {
        Object result = null;
        try {
            String currentPwd = this.ctx.prompt;
            try {
                this.ctx.browseHandler.cd(mbeanPath);
                result = this.ctx.wlcmo;
                this.ctx.browseHandler.takeBackToRoot();
                this.ctx.browseHandler.cd(currentPwd);
            }
            finally {
                this.ctx.browseHandler.cd(currentPwd);
            }
            return result;
        }
        catch (Throwable th) {
            return result;
        }
    }

    void setEncrypted(String attrName, String propertyName, String configFile, String secretFile) throws ScriptException {
        if (configFile == null || secretFile == null) {
            this.ctx.printDebug("Looking for the default store ... ");
            UsernameAndPassword up = UserConfigFileManager.getUsernameAndPassword(propertyName);
            if (up == null) {
                throw new ScriptException(this.txtFmt.getUserConfigNotFound(), "setEncrypted");
            }
            this.ctx.printDebug("got the value and now setting ... ");
            this.set(attrName, new String(up.getPassword()));
        } else {
            this.ctx.printDebug("Looking for the property in the locations specified ... ");
            UsernameAndPassword up = UserConfigFileManager.getUsernameAndPassword(configFile, secretFile, propertyName);
            if (up == null) {
                String msg = this.txtFmt.getUserConfigPropertyNotFound(propertyName);
                throw new ScriptException(msg, "setEncrypted");
            }
            this.set(attrName, new String(up.getPassword()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean set(String attrName, Object value) throws ScriptException {
        result = false;
        currentPwd = this.ctx.prompt;
        currenTree = this.ctx.getCurrentTree();
        try {
            block14: {
                oname = this.ctx.getObjectName();
                connection = this.ctx.getMBSConnection(null);
                attr = new Attribute(attrName, this.getRealObject(attrName, value));
                try {
                    if (this.ctx.wlcmo instanceof DescriptorBean) {
                        connection.setAttribute(oname, attr);
                        break block14;
                    }
                    if (this.ctx.domainType.equals("Custom_Domain")) ** GOTO lbl-1000
                    if (!this.ctx.domainType.equals("DomainCustom_Domain")) {
                        connection.setAttribute(oname, attr);
                    } else lbl-1000:
                    // 2 sources

                    {
                        on = new ObjectName((String)this.ctx.prompts.peek());
                        connection.setAttribute(on, attr);
                    }
                }
                catch (AttributeNotFoundException anf) {
                    try {
                        tree = this.ctx.getTreeFromArgument(attrName);
                        if (tree != null) {
                            attrName = this.ctx.removeTreeFromArgument(attrName);
                            this.ctx.browseHandler.jumpTree(tree);
                        }
                        if ((attributes = StringUtils.splitCompletely((String)attrName, (String)"/")).length > 0) {
                            attributeName = attributes[attributes.length - 1];
                            attributes[attributes.length - 1] = "";
                            attribute = StringUtils.join((String[])attributes, (String)"/");
                            if (attrName.startsWith("/")) {
                                attribute = "/" + attribute;
                            }
                            this.ctx.browseHandler.cd(attribute);
                            oname = this.ctx.getObjectName();
                            connection = this.ctx.getMBSConnection(null);
                            attr = new Attribute(attributeName, this.getRealObject(attributeName, value));
                            connection.setAttribute(oname, attr);
                        }
                        throw anf;
                    }
                    finally {
                        this.ctx.browseHandler.jumpTree(currenTree);
                        this.ctx.browseHandler.takeBackToRoot();
                        this.ctx.browseHandler.cd(currentPwd);
                    }
                }
            }
            result = true;
        }
        catch (Throwable e) {
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            this.ctx.throwWLSTException(this.txtFmt.getErrorSettingAttribute(attrName), e);
        }
        return result;
    }

    Object invoke(String methodName, Object[] parameters, String[] signatures) throws ScriptException {
        try {
            if (this.ctx.inMBeanType || this.ctx.inMBeanTypes) {
                this.ctx.println(this.txtFmt.getInvokeNotApplicable());
            } else if (this.ctx.atBeanLevel) {
                ObjectName oname = this.ctx.getObjectName();
                if (oname != null) {
                    return this.ctx.getMBSConnection(this.ctx.domainType).invoke(oname, methodName, parameters, signatures);
                }
                this.ctx.printDebug("could be a custom mbean");
                ObjectName on = new ObjectName((String)this.ctx.prompts.peek());
                return this.ctx.getMBSConnection(this.ctx.domainType).invoke(on, methodName, parameters, signatures);
            }
        }
        catch (Throwable e) {
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            this.ctx.throwWLSTException(this.txtFmt.getErrorOnInvoke(), e);
        }
        return this.txtFmt.getInvokeNotApplicable();
    }

    private boolean checkForAdminServer(String cmdName) throws ScriptException {
        if (!this.ctx.isAdminServer) {
            this.ctx.throwWLSTException(this.txtFmt.getCannotUseCommandOnMS(cmdName));
            return false;
        }
        return true;
    }

    private boolean isEditOrConfigTree(String cmdName) throws ScriptException {
        block3: {
            block2: {
                if (this.ctx.domainType.equals("Domain")) break block2;
                if (this.ctx.domainType.equals("ConfigEdit")) break block2;
                if (this.ctx.domainType.equals("Custom_Domain")) break block2;
                if (!this.ctx.domainType.equals("DomainCustom_Domain")) break block3;
            }
            return true;
        }
        this.ctx.throwWLSTException(this.txtFmt.getCannotUseCommandUnlessEditConfig(cmdName));
        return false;
    }

    Object create(String mbeanName, String mbeanType, String providerType) throws ScriptException {
        String creator;
        Object obj;
        block24: {
            block23: {
                if (!this.checkForAdminServer("create")) {
                    return null;
                }
                if (!this.isEditOrConfigTree("create")) {
                    return null;
                }
                obj = null;
                if (mbeanType == null) {
                    if (this.ctx.atBeanLevel) {
                        this.ctx.throwWLSTException(this.txtFmt.getMBeanTypeMustBeNonNull());
                    }
                    mbeanType = (String)this.ctx.prompts.peek();
                }
                if (mbeanType.indexOf(".") != -1) {
                    return this.createSecurityMBean(mbeanName, mbeanType, providerType);
                }
                String type = this.getParentType();
                mbeanType = this.ctx.getRightType(mbeanType);
                creator = null;
                if (!this.isCreatePossible(type, mbeanType)) break block23;
                creator = this.getCreatorOrDestroyer(mbeanType, CREATOR);
                if (creator != null) break block24;
                this.ctx.throwWLSTException(this.txtFmt.getcouldNotDetermineCreate());
                break block24;
            }
            String creatorToTry = "create" + mbeanType;
            MBeanOperationInfo[] operInfos = this.ctx.getMBeanInfo(this.ctx.wlcmo).getOperations();
            for (int i = 0; i < operInfos.length; ++i) {
                if (!creatorToTry.equals(operInfos[i].getName())) continue;
                creator = creatorToTry;
                break;
            }
        }
        if (creator != null) {
            try {
                Method method = null;
                Object[] args = new Object[1];
                Class[] params = new Class[]{String.class};
                try {
                    method = this.ctx.wlcmo.getClass().getMethod(creator, params);
                }
                catch (NoSuchMethodException nsme) {
                    method = this.ctx.wlcmo.getClass().getMethod(creator, new Class[0]);
                    obj = method.invoke(this.ctx.wlcmo, new Object[0]);
                    this.ctx.println(this.txtFmt.getOptionalSingletonCreated(mbeanType));
                    return obj;
                }
                args[0] = mbeanName;
                obj = method.invoke(this.ctx.wlcmo, args);
            }
            catch (Throwable th) {
                if (th instanceof InvocationTargetException) {
                    InvocationTargetException ite = (InvocationTargetException)th;
                    UndeclaredThrowableException udTh = null;
                    if (ite.getTargetException() instanceof UndeclaredThrowableException) {
                        udTh = (UndeclaredThrowableException)ite.getTargetException();
                    } else if (ite.getTargetException() instanceof NoAccessRuntimeException) {
                        this.ctx.throwWLSTException(this.txtFmt.getCouldNotCreateMBean(), ite.getTargetException());
                    }
                    if (udTh != null) {
                        if (udTh.getUndeclaredThrowable() instanceof MBeanException) {
                            if (((MBeanException)udTh.getUndeclaredThrowable()).getTargetException() instanceof BeanAlreadyExistsException) {
                                String msg = this.txtFmt.getChooseDifferentName(mbeanType, mbeanName);
                                this.ctx.throwWLSTException(msg, th.getCause());
                            }
                            this.ctx.throwWLSTException("Unexpected Error: ", th);
                        }
                        throw (ScriptException)th;
                    }
                    throw (ScriptException)th;
                }
                throw (ScriptException)th;
            }
        } else if (this.specialMBeans.contains(mbeanType) || !this.ctx.inNewTree()) {
            try {
                obj = this.ctx.adminHome.createAdminMBean(mbeanName, mbeanType, this.ctx.domainName, (ConfigurationMBean)this.ctx.wlcmo);
            }
            catch (MBeanCreationException ex) {
                this.ctx.throwWLSTException(this.txtFmt.getCannotCreateUseEditTree(), ex);
            }
        } else {
            this.ctx.throwWLSTException(this.txtFmt.getCannotCreateNonChild1(mbeanType));
        }
        this.ctx.println(this.txtFmt.getMBeanCreatedSuccessfully(mbeanType, mbeanName));
        return obj;
    }

    Object lookup(String mbeanName, String mbeanType) throws ScriptException {
        block12: {
            try {
                Object[] args;
                String lookupName;
                if (mbeanType == null) {
                    if (this.ctx.atBeanLevel) {
                        this.ctx.errorMsg = this.txtFmt.getMBeanTypeMustBeNonNull();
                        this.ctx.errorInfo = new ErrorInformation(this.ctx.errorMsg);
                        this.ctx.exceptionHandler.handleException(this.ctx.errorInfo);
                    }
                    mbeanType = (String)this.ctx.prompts.peek();
                }
                if (mbeanType.indexOf(".") != -1) {
                    return null;
                }
                if (mbeanType.endsWith("ies")) {
                    mbeanType = mbeanType.substring(0, mbeanType.length() - 3) + "y";
                } else if (mbeanType.endsWith("sses")) {
                    mbeanType = mbeanType.substring(0, mbeanType.length() - 2);
                } else if (mbeanType.endsWith("s") && !mbeanType.endsWith("ss")) {
                    mbeanType = mbeanType.substring(0, mbeanType.length() - 1);
                }
                if (!this.isCreatePossible(this.getParentType(), mbeanType) || (lookupName = this.getLookup(mbeanType)) == null) break block12;
                Class[] params = new Class[]{String.class};
                Method[] mths = this.ctx.wlcmo.getClass().getMethods();
                Method method = this.ctx.wlcmo.getClass().getMethod(lookupName, params);
                Object bean = method.invoke(this.ctx.wlcmo, args = new Object[]{mbeanName});
                if (bean == null) {
                    this.ctx.throwWLSTException(this.txtFmt.getInstanceNotFound(mbeanName));
                    break block12;
                }
                return bean;
            }
            catch (Throwable e) {
                if (e instanceof ScriptException) {
                    throw (ScriptException)e;
                }
                this.ctx.throwWLSTException("Unexpected Error: ", e);
            }
        }
        return null;
    }

    void delete(String mbeanName, String mbeanType) throws ScriptException {
        block23: {
            if (!this.checkForAdminServer("delete")) {
                return;
            }
            if (!this.isEditOrConfigTree("delete")) {
                return;
            }
            try {
                if (mbeanType == null) {
                    if (this.ctx.atBeanLevel) {
                        this.ctx.throwWLSTException(this.txtFmt.getMBeanTypeMustBeNonNull());
                    }
                    mbeanType = (String)this.ctx.prompts.peek();
                }
                if (this.ctx.getMBeanServer().isInstanceOf(this.ctx.getObjectName(this.ctx.wlcmo), REALM_MBEAN)) {
                    String baseProvType = mbeanType;
                    if (baseProvType.endsWith("s")) {
                        baseProvType = this.removeS(baseProvType);
                    }
                    if (this.baseSecurityProviderAttributeTypes.contains(baseProvType)) {
                        this.deleteSecurityMBean(mbeanName, baseProvType);
                        return;
                    }
                }
                if (mbeanType.endsWith("ies")) {
                    mbeanType = mbeanType.substring(0, mbeanType.length() - 3) + "y";
                } else if (mbeanType.endsWith("sses")) {
                    mbeanType = mbeanType.substring(0, mbeanType.length() - 2);
                } else if (mbeanType.endsWith("s") && !mbeanType.endsWith("ss")) {
                    mbeanType = mbeanType.substring(0, mbeanType.length() - 1);
                }
                if (this.isCreatePossible(this.getParentType(), mbeanType)) {
                    String lookupName = this.getLookup(mbeanType);
                    String destroyName = this.getCreatorOrDestroyer(mbeanType, DESTROYER);
                    Method method = null;
                    if (lookupName != null) {
                        Method method1;
                        Object[] args;
                        Class[] params = new Class[]{String.class};
                        Method[] mths = this.ctx.wlcmo.getClass().getMethods();
                        method = this.ctx.wlcmo.getClass().getMethod(lookupName, params);
                        Object bean = method.invoke(this.ctx.wlcmo, args = new Object[]{mbeanName});
                        if (bean == null) {
                            this.ctx.throwWLSTException(this.txtFmt.getInstanceNotFound(mbeanName));
                        }
                        Class<?> clz = Class.forName(this.getInterfaceClassName(mbeanType));
                        Class[] params1 = new Class[]{clz};
                        try {
                            method1 = this.ctx.wlcmo.getClass().getMethod(destroyName, params1);
                        }
                        catch (NoSuchMethodException e) {
                            method1 = this.findDestroyMethod(destroyName, clz);
                        }
                        Object[] args1 = new Object[]{bean};
                        method1.invoke(this.ctx.wlcmo, args1);
                        this.ctx.println(this.txtFmt.getMBeanDeletedSuccessfully(mbeanType, mbeanName));
                        break block23;
                    }
                    if (destroyName != null) {
                        method = this.ctx.wlcmo.getClass().getMethod(destroyName, new Class[0]);
                        method.invoke(this.ctx.wlcmo, new Object[0]);
                        this.ctx.println(this.txtFmt.getMBeanDeletedSuccessfully1(mbeanType));
                    } else {
                        String msg = this.txtFmt.getCannotDeleteNonChild2(mbeanType, mbeanName);
                        this.ctx.throwWLSTException(msg);
                    }
                    break block23;
                }
                this.ctx.throwWLSTException(this.txtFmt.getCannotDeleteNonChild2(mbeanType, mbeanName));
            }
            catch (InstanceNotFoundException e) {
                this.ctx.throwWLSTException(this.txtFmt.getInstanceNotFound(mbeanName), e);
            }
            catch (Throwable e) {
                if (e instanceof ScriptException) {
                    throw (ScriptException)e;
                }
                this.ctx.throwWLSTException(this.txtFmt.getErrorDeletingABean(), e);
            }
        }
    }

    private Method findDestroyMethod(String destroyName, Class clz) {
        Class<?>[] superInterfaces;
        for (Class<?> superInterface : superInterfaces = clz.getInterfaces()) {
            try {
                Class[] params1 = new Class[]{superInterface};
                return this.ctx.wlcmo.getClass().getMethod(destroyName, params1);
            }
            catch (NoSuchMethodException e) {
                Method findMethod = this.findDestroyMethod(destroyName, superInterface);
                if (findMethod == null) continue;
                return findMethod;
            }
        }
        return null;
    }

    private String getParentType() {
        String type = this.ctx.getObjectName().getKeyProperty("Type");
        if (type != null) {
            return type;
        }
        return null;
    }

    private Object createSecurityMBean(String mbeanName, String providerType, String baseProviderType) throws ScriptException {
        this.ctx.printDebug("In creating security mbean with name " + mbeanName);
        if (providerType == null) {
            this.ctx.throwWLSTException(this.txtFmt.getParameterMayNotBeNull("providerType"));
        }
        if (baseProviderType == null) {
            if (this.ctx.atBeanLevel) {
                this.ctx.throwWLSTException(this.txtFmt.getParameterMayNotBeNull("baseProviderType"));
            }
            baseProviderType = (String)this.ctx.prompts.peek();
        }
        try {
            if (this.ctx.getMBeanServer().isInstanceOf(this.ctx.getObjectName(this.ctx.wlcmo), REALM_MBEAN)) {
                if (baseProviderType.endsWith("s")) {
                    baseProviderType = this.removeS(baseProviderType);
                }
                if (!this.baseSecurityProviderAttributeTypes.contains(baseProviderType)) {
                    this.ctx.throwWLSTException(this.txtFmt.getCannotCreateNonChild());
                }
                Object obj = this.nowCreateSecurityMBean(mbeanName, providerType, baseProviderType);
                this.ctx.println(this.txtFmt.getProviderCreatedSuccessfully(baseProviderType, providerType, mbeanName));
            } else {
                this.ctx.throwWLSTException(this.txtFmt.getCannotCreateNonChild());
            }
        }
        catch (InstanceNotFoundException infe) {
            this.ctx.throwWLSTException(this.txtFmt.getRealmInstanceNotFound(), infe);
        }
        catch (IOException io) {
            this.ctx.throwWLSTException(this.txtFmt.getRealmInstanceNotFound(), io);
        }
        return null;
    }

    private Object nowCreateSecurityMBean(String name, String providerType, String baseProviderType) throws ScriptException {
        try {
            RealmMBean rbean = (RealmMBean)this.ctx.wlcmo;
            if (baseProviderType.equals(ADJ)) {
                return rbean.createAdjudicator(name, providerType);
            }
            if (baseProviderType.equals(ATN)) {
                return rbean.createAuthenticationProvider(name, providerType);
            }
            if (baseProviderType.equals(ATZ)) {
                return rbean.createAuthorizer(name, providerType);
            }
            if (baseProviderType.equals(AUD)) {
                return rbean.createAuditor(name, providerType);
            }
            if (baseProviderType.equals(CPP)) {
                return rbean.createCertPathProvider(name, providerType);
            }
            if (baseProviderType.equals(KST)) {
                return rbean.createKeyStore(name, providerType);
            }
            if (baseProviderType.equals(RMP)) {
                return rbean.createRoleMapper(name, providerType);
            }
            if (baseProviderType.equals(CDM)) {
                return rbean.createCredentialMapper(name, providerType);
            }
        }
        catch (ClassNotFoundException cnf) {
            this.ctx.throwWLSTException(this.txtFmt.getProviderClassNotFound(), cnf);
        }
        catch (JMException jme) {
            this.ctx.throwWLSTException(this.txtFmt.getErrorCreatingProvider(), jme);
        }
        return null;
    }

    private String removeS(String baseType) {
        return baseType.substring(0, baseType.length() - 1);
    }

    private void deleteSecurityMBean(String name, String baseProviderType) throws ScriptException {
        RealmMBean rbean = (RealmMBean)this.ctx.wlcmo;
        if (baseProviderType.equals(ADJ)) {
            rbean.destroyAdjudicator();
        } else if (baseProviderType.equals(ATN)) {
            rbean.destroyAuthenticationProvider(rbean.lookupAuthenticationProvider(name));
        } else if (baseProviderType.equals(ATZ)) {
            rbean.destroyAuthorizer(rbean.lookupAuthorizer(name));
        } else if (baseProviderType.equals(AUD)) {
            rbean.destroyAuditor(rbean.lookupAuditor(name));
        } else if (baseProviderType.equals(CDM)) {
            rbean.destroyCredentialMapper(rbean.lookupCredentialMapper(name));
        } else if (baseProviderType.equals(CPP)) {
            rbean.destroyCertPathProvider(rbean.lookupCertPathProvider(name));
        } else if (baseProviderType.equals(KST)) {
            rbean.destroyKeyStore(rbean.lookupKeyStore(name));
        } else if (baseProviderType.equals(RMP)) {
            rbean.destroyRoleMapper(rbean.lookupRoleMapper(name));
        }
        this.ctx.println(this.txtFmt.getProviderDeletedSuccessfully(baseProviderType, name));
    }

    WebLogicMBean getTarget(String path) throws ScriptException {
        if (!this.checkForAdminServer("getTarget")) {
            return null;
        }
        if (!this.checkForCompatibilityTree()) {
            this.ctx.println(this.txtFmt.getGetTargetIsForconfig());
            return null;
        }
        try {
            String[] paths;
            if (this.ctx.debug) {
                this.ctx.println("The path passed in is " + path);
            }
            if ((paths = StringUtils.splitCompletely((String)path, (String)SLASH)).length != 2) {
                this.ctx.println(this.txtFmt.getMalformedMBeanPath());
                return null;
            }
            String name = paths[1];
            String type = paths[0];
            Set beans = this.ctx.home.getMBeansByType(type);
            for (WebLogicMBean mbean : beans) {
                if (!mbean.getName().equals(name)) continue;
                return mbean;
            }
            return this.ctx.home.getMBean(paths[1], paths[0]);
        }
        catch (InstanceNotFoundException e) {
            if (this.ctx.debug) {
                this.ctx.throwWLSTException(this.txtFmt.getInstanceNotFound(path), e);
            }
        }
        catch (Throwable e) {
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            this.ctx.throwWLSTException(this.txtFmt.getErrorGettingMBean(), e);
        }
        return null;
    }

    private boolean checkForCompatibilityTree() {
        block3: {
            block2: {
                if (this.ctx.domainType.equals("Domain")) break block2;
                if (this.ctx.domainType.equals("DomainConfig")) break block2;
                if (!this.ctx.domainType.equals("DomainRuntime")) break block3;
            }
            return true;
        }
        return false;
    }

    WebLogicMBean[] getTargetArray(String type, String values) throws ScriptException {
        try {
            if (this.ctx.debug) {
                this.ctx.println("The type passed in is " + type);
            }
            String[] valueArray = StringUtils.splitCompletely((String)values, (String)",");
            WebLogicMBean[] result = new WebLogicMBean[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                String path = type + SLASH + valueArray[i];
                result[i] = this.getTarget(path);
            }
            return result;
        }
        catch (Throwable e) {
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            this.ctx.throwWLSTException(this.txtFmt.getErrorGettingMBeanArray(), e);
            return null;
        }
    }

    private boolean isCreatePossible(String mbeanType, String childType) throws ScriptException {
        List list = null;
        try {
            list = this.ctx.infoHandler.getChildrenTypes();
            Iterator iter = list.iterator();
            String child = childType;
            while (iter.hasNext()) {
                String configString;
                String s = (String)iter.next();
                if (s.startsWith(configString = new String("weblogic.management.configuration"))) {
                    s = s.substring(configString.length() + 1, s.length() - 5);
                }
                if (!s.equals(child)) continue;
                return true;
            }
        }
        catch (Throwable ex) {
            this.ctx.throwWLSTException("Error determining if creating an MBean is possible", ex);
        }
        return false;
    }

    private String getLookup(String mbeanType) throws ScriptException {
        try {
            MBeanInfo info = this.ctx.getMBeanInfo(this.ctx.wlcmo);
            MBeanOperationInfo[] operInfo = info.getOperations();
            for (int i = 0; i < operInfo.length; ++i) {
                MBeanOperationInfo oInfo = operInfo[i];
                if (!oInfo.getName().equals("lookup" + mbeanType)) continue;
                return oInfo.getName();
            }
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException(this.txtFmt.getErrorOnLookup(), th);
        }
        return null;
    }

    private String getCreatorOrDestroyer(String attributeName, String whatever) throws ScriptException {
        try {
            String methodName;
            Descriptor desc;
            MBeanInfo info = this.ctx.getMBeanInfo(this.ctx.wlcmo);
            String pluralAttrName = attributeName;
            if (!this.ctx.isPlural(attributeName)) {
                pluralAttrName = this.ctx.getPlural(attributeName);
            }
            ModelMBeanInfo modelInfo = (ModelMBeanInfo)((Object)info);
            MBeanAttributeInfo[] attrInfo = modelInfo.getAttributes();
            for (int i = 0; i < attrInfo.length; ++i) {
                if (!pluralAttrName.equals(attrInfo[i].getName())) continue;
                desc = ((ModelMBeanAttributeInfo)attrInfo[i]).getDescriptor();
                methodName = null;
                methodName = whatever.equals(CREATOR) ? (String)desc.getFieldValue("com.bea.creator") : (String)desc.getFieldValue("com.bea.destroyer");
                if (methodName == null) continue;
                return methodName;
            }
            for (int j = 0; j < attrInfo.length; ++j) {
                if (!attrInfo[j].getName().startsWith(attributeName)) continue;
                desc = ((ModelMBeanAttributeInfo)attrInfo[j]).getDescriptor();
                methodName = null;
                methodName = whatever.equals(CREATOR) ? (String)desc.getFieldValue("com.bea.creator") : (String)desc.getFieldValue("com.bea.destroyer");
                if (methodName == null) continue;
                return methodName;
            }
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException("Error getting the creator/destroyer", th);
        }
        return null;
    }

    private String getInterfaceClassName(String mbeanType) throws ScriptException {
        try {
            MBeanInfo info = this.ctx.getMBeanInfo(this.ctx.wlcmo);
            ModelMBeanInfo modelInfo = (ModelMBeanInfo)((Object)info);
            MBeanAttributeInfo[] attrInfo = modelInfo.getAttributes();
            String retType = "weblogic.management.configuration." + mbeanType + "MBean";
            for (int i = 0; i < attrInfo.length; ++i) {
                Descriptor desc = ((ModelMBeanAttributeInfo)attrInfo[i]).getDescriptor();
                String intClzName = (String)((ModelMBeanAttributeInfo)attrInfo[i]).getDescriptor().getFieldValue("interfaceClassName");
                if (intClzName == null) continue;
                if (intClzName.startsWith("[L")) {
                    intClzName = intClzName.substring(2, intClzName.length() - 1);
                }
                if (!retType.equals(intClzName) && (intClzName.startsWith("weblogic.management.configuration.") || intClzName.indexOf(mbeanType) == -1)) continue;
                return intClzName;
            }
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException("Error getting the interfaceclassname", th);
        }
        return null;
    }

    Object encrypt(Object obj, String domainDir) throws ScriptException {
        try {
            EncryptionService es = null;
            ClearOrEncryptedService ces = null;
            if (domainDir != null) {
                File f = new File(domainDir);
                this.ctx.printDebug("Setting the root directory to " + f.getAbsolutePath());
                es = SerializedSystemIni.getEncryptionService(f.getAbsolutePath());
            } else {
                es = SerializedSystemIni.getExistingEncryptionService();
            }
            if (es == null) {
                this.ctx.errorMsg = this.txtFmt.getErrorInitializingEncryptionService();
                this.ctx.errorInfo = new ErrorInformation(this.ctx.errorMsg);
                this.ctx.exceptionHandler.handleException(this.ctx.errorInfo);
            }
            ces = new ClearOrEncryptedService(es);
            if (obj instanceof String) {
                return ces.encrypt((String)obj);
            }
            return ces.encryptBytes((byte[])obj);
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException(this.txtFmt.getErrorEncryptingValue(), th);
            return null;
        }
    }
}

