/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.scripting;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.Descriptor;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import weblogic.management.NoAccessRuntimeException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.mbeanservers.edit.ActivationTaskMBean;
import weblogic.management.mbeanservers.edit.Change;
import weblogic.management.mbeanservers.edit.EditTimedOutException;
import weblogic.management.mbeanservers.edit.NotEditorException;
import weblogic.management.mbeanservers.edit.ValidationException;
import weblogic.management.scripting.ScriptException;
import weblogic.management.scripting.WLScriptContext;
import weblogic.management.scripting.utils.WLSTMsgTextFormatter;
import weblogic.management.scripting.utils.WLSTUtil;

public class EditService
implements Serializable {
    private WLScriptContext ctx = null;
    private static final String ACTIVATE = "activate";
    private static final String UNDO = "undo";
    private static final String SAVE = "save";
    private static final String STOP_EDIT = "stopEdit";
    private static final String VALIDATE = "validate";
    private static final String SHOW_CHANGES = "showChanges";
    private WLSTMsgTextFormatter txtFmt;

    public EditService(WLScriptContext ctx) {
        this.ctx = ctx;
        this.txtFmt = ctx.getWLSTMsgFormatter();
    }

    private void validateTree() throws ScriptException {
        if (!this.ctx.domainType.equals("ConfigEdit")) {
            this.ctx.throwWLSTException(this.txtFmt.getCantCallEditFunctions());
        }
    }

    private boolean validateCall(String call) throws ScriptException {
        if (this.ctx.newBrowseHandler.doesUserHasLock()) {
            this.ctx.isEditSessionInProgress = true;
            return true;
        }
        if (this.ctx.isEditSessionInProgress && call.equals(STOP_EDIT)) {
            return true;
        }
        if (this.ctx.isEditSessionInProgress && !this.ctx.newBrowseHandler.doesUserHasLock()) {
            this.ctx.println(this.txtFmt.getEditSessionTerminated());
            this.cleanUp();
            return false;
        }
        if (!this.ctx.isEditSessionInProgress) {
            this.ctx.throwWLSTException(this.txtFmt.getNeedEditSessionFor(call));
            return false;
        }
        return true;
    }

    private void cleanUp() {
        this.ctx.resetEditSession();
        if (!WLSTUtil.runningWLSTAsModule()) {
            WLSTUtil.getWLSTInterpreter().exec("evaluatePrompt()");
        }
    }

    public DomainMBean startEdit(int waitTimeInMillis, int timeOutInMillis, String exclusive) throws ScriptException {
        this.ctx.commandType = "startEdit";
        this.validateTree();
        DomainMBean bean = null;
        this.ctx.println(this.txtFmt.getStartingEditSession());
        try {
            bean = this.ctx.configurationManager.startEdit(waitTimeInMillis, timeOutInMillis, this.ctx.getBoolean(exclusive));
            String prompt = this.ctx.getPrompt();
            this.ctx.wlcmo = bean;
            this.ctx.browseHandler.cd(prompt);
            this.ctx.println(this.txtFmt.getStartedEditSession());
            if (this.ctx.getBoolean(exclusive)) {
                this.ctx.print(this.txtFmt.getExclusiveSession());
                this.ctx.isEditSessionExclusive = true;
            }
            this.ctx.isEditSessionInProgress = true;
        }
        catch (EditTimedOutException eto) {
            String ce = this.ctx.configurationManager.getCurrentEditor();
            this.ctx.throwWLSTException(this.txtFmt.getEditLockHeld(ce), (Throwable)((Object)eto));
        }
        catch (NoAccessRuntimeException nar) {
            String user = new String(this.ctx.username_bytes);
            this.ctx.throwWLSTException(this.txtFmt.getNoPermissionForEdit(user), nar);
        }
        return bean;
    }

    public void save() throws ScriptException {
        this.ctx.commandType = SAVE;
        this.validateTree();
        if (!this.validateCall(SAVE)) {
            return;
        }
        this.ctx.println(this.txtFmt.getSavingChanges());
        try {
            this.ctx.configurationManager.save();
            this.ctx.println(this.txtFmt.getSavedChanges());
        }
        catch (NotEditorException ne) {
            this.ctx.throwWLSTException(this.txtFmt.getNoChangesYet(), (Throwable)((Object)ne));
        }
        catch (ValidationException ve) {
            this.ctx.throwWLSTException(this.txtFmt.getInvalidChanges(), (Throwable)((Object)ve));
        }
    }

    public ActivationTaskMBean activate(long timeout, String block) throws ScriptException {
        this.ctx.commandType = ACTIVATE;
        if (WLSTUtil.runningWLSTAsModule()) {
            block = "true";
        }
        this.validateTree();
        if (!this.validateCall(ACTIVATE)) {
            return null;
        }
        try {
            if (block.equalsIgnoreCase("true")) {
                this.ctx.println(this.txtFmt.getActivatingChanges());
                this.ctx.configurationManager.save();
                this.ctx.activationTask = this.ctx.configurationManager.activate(timeout);
                this.printServerRestartInfo(this.ctx.activationTask.getChanges());
                this.ctx.activationTask.waitForTaskCompletion(timeout);
                if (this.ctx.activationTask.getError() != null) {
                    throw this.ctx.activationTask.getError();
                }
                this.ctx.println(this.txtFmt.getActivationComplete());
                if (!WLSTUtil.runningWLSTAsModule()) {
                    WLSTUtil.getWLSTInterpreter().set("activationTask", this.ctx.activationTask);
                }
            } else {
                this.ctx.println(this.txtFmt.getActivatingChangesNonBlocking());
                this.ctx.configurationManager.save();
                this.ctx.activationTask = this.ctx.configurationManager.activate(timeout);
                this.printServerRestartInfo(this.ctx.activationTask.getChanges());
                WLSTUtil.getWLSTInterpreter().set("activationTask", this.ctx.activationTask);
                this.ctx.println(this.txtFmt.getActivationTaskCreated());
            }
            this.ctx.resetEditSession();
            return this.ctx.activationTask;
        }
        catch (NotEditorException ne) {
            this.ctx.throwWLSTException(this.txtFmt.getNoChangesYet(), (Throwable)((Object)ne));
        }
        catch (RuntimeException e) {
            SecurityException se;
            RemoteException re;
            boolean threwError = false;
            if (e.getCause() instanceof RemoteException && (re = (RemoteException)e.getCause()).getCause() instanceof SecurityException && (se = (SecurityException)re.getCause()).getMessage().indexOf(this.txtFmt.getAdministratorRequiredString()) != -1) {
                this.ctx.println(this.txtFmt.getReloginRequired());
                try {
                    this.ctx.dc("true");
                }
                catch (Throwable ex) {
                    this.ctx.throwWLSTException(this.txtFmt.getErrorDisconnecting(), ex);
                }
                threwError = true;
            }
            if (!threwError) {
                this.cleanUp();
                this.ctx.throwWLSTException(this.txtFmt.getErrorActivating(), e);
            }
        }
        catch (Throwable th) {
            this.cleanUp();
            this.ctx.throwWLSTException(this.txtFmt.getErrorActivating(), th);
        }
        this.ctx.resetEditSession();
        return this.ctx.activationTask;
    }

    private void printServerRestartInfo(Change[] unActivatedChanges) throws NotEditorException {
        if (unActivatedChanges.length < 1) {
            return;
        }
        HashMap<Object, String> beans = new HashMap<Object, String>();
        for (int i = 0; i < unActivatedChanges.length; ++i) {
            Change chg = unActivatedChanges[i];
            if (!chg.isRestartRequired()) continue;
            if (beans.isEmpty()) {
                beans.put(chg.getBean(), chg.getAttributeName());
                continue;
            }
            String attrNames = (String)beans.get(chg.getBean());
            if (attrNames == null) {
                beans.put(chg.getBean(), chg.getAttributeName());
                continue;
            }
            attrNames = attrNames + ", " + chg.getAttributeName();
            beans.put(chg.getBean(), attrNames);
        }
        if (beans.isEmpty()) {
            return;
        }
        this.ctx.println(this.txtFmt.getNonDynamicAttributes());
        this.ctx.isRestartRequired = true;
        for (Object bean : beans.keySet()) {
            this.ctx.println(this.txtFmt.getMBeanChanged(this.asString(bean)));
            this.ctx.println(this.txtFmt.getAttributesChanged(this.asString(beans.get(bean))));
            this.ctx.println("");
        }
    }

    public void undo(String unactivatedChanges) throws ScriptException {
        this.ctx.commandType = UNDO;
        this.validateTree();
        if (!this.validateCall(UNDO)) {
            return;
        }
        try {
            if (unactivatedChanges.equals("true")) {
                this.ctx.configurationManager.undoUnactivatedChanges();
                this.ctx.println(this.txtFmt.getDiscardedAllChanges());
            } else {
                this.ctx.configurationManager.undo();
                this.ctx.println(this.txtFmt.getDiscardedAllInMemoryChanges());
            }
        }
        catch (NotEditorException ne) {
            this.ctx.throwWLSTException(this.txtFmt.getNoChangesYet(), (Throwable)((Object)ne));
        }
    }

    public void cancelEdit() throws ScriptException {
        this.ctx.commandType = "cancelEdit";
        this.validateTree();
        this.ctx.configurationManager.cancelEdit();
        this.ctx.resetEditSession();
    }

    public boolean isRestartRequired(String attrName) throws ScriptException {
        this.ctx.commandType = "isRestartRequired";
        try {
            boolean displayed = false;
            if (attrName == null) {
                if (this.ctx.isEditSessionInProgress) {
                    Change[] changes = this.ctx.configurationManager.getUnactivatedChanges();
                    boolean restartRequired = false;
                    for (int i = 0; i < changes.length; ++i) {
                        if (!changes[i].isRestartRequired()) continue;
                        if (!displayed) {
                            this.ctx.println(this.txtFmt.getRestartRequired());
                        }
                        restartRequired = true;
                        displayed = true;
                    }
                    if (restartRequired) {
                        this.printServerRestartInfo(changes);
                        return true;
                    }
                    this.ctx.println(this.txtFmt.getRestartNotRequired());
                    return false;
                }
                return this.ctx.isRestartRequired;
            }
            this.validateTree();
            ModelMBeanInfo modelInfo = (ModelMBeanInfo)((Object)this.ctx.getMBeanInfo(this.ctx.wlcmo));
            ModelMBeanAttributeInfo[] attrInfos = (ModelMBeanAttributeInfo[])modelInfo.getAttributes();
            for (int i = 0; i < attrInfos.length; ++i) {
                Descriptor desc;
                ModelMBeanAttributeInfo info = attrInfos[i];
                if (info.getName().equals(attrName)) {
                    desc = info.getDescriptor();
                    Boolean dyn = (Boolean)desc.getFieldValue("com.bea.dynamic");
                    if (dyn != null && dyn.booleanValue()) {
                        this.ctx.println(this.txtFmt.getRestartNotRequiredFor(attrName));
                        return false;
                    }
                    this.ctx.println(this.txtFmt.getRestartRequiredFor(attrName));
                    return true;
                }
                if (!attrName.equals("*")) continue;
                displayed = true;
                desc = info.getDescriptor();
                String _attrName = info.getName();
                Boolean dyn = (Boolean)desc.getFieldValue("com.bea.dynamic");
                if (dyn != null && dyn.booleanValue()) {
                    this.ctx.println(this.txtFmt.getRestartNotRequiredFor(_attrName));
                }
                this.ctx.println(this.txtFmt.getRestartRequiredFor(_attrName));
            }
            if (!displayed) {
                this.ctx.println(this.txtFmt.getAttributeNotFound(attrName));
            }
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException(this.txtFmt.getErrorGettingRestartInfo(), th);
        }
        return false;
    }

    public boolean validate() throws ScriptException {
        this.ctx.commandType = VALIDATE;
        try {
            this.validateTree();
            if (!this.validateCall(VALIDATE)) {
                return false;
            }
            this.ctx.println(this.txtFmt.getValidatingChanges());
            this.ctx.configurationManager.validate();
            this.ctx.println(this.txtFmt.getValidationSuccess());
            return true;
        }
        catch (NotEditorException ne) {
            this.ctx.throwWLSTException(this.txtFmt.getNoChangesYet(), (Throwable)((Object)ne));
        }
        catch (ValidationException ne) {
            this.ctx.throwWLSTException(this.txtFmt.getValidationErrors(), (Throwable)((Object)ne));
        }
        return false;
    }

    public void stopEdit() throws ScriptException {
        this.ctx.commandType = STOP_EDIT;
        this.validateTree();
        if (!this.validateCall(STOP_EDIT)) {
            return;
        }
        try {
            this.ctx.configurationManager.stopEdit();
            this.ctx.resetEditSession();
        }
        catch (NotEditorException ne) {
            this.ctx.throwWLSTException(this.txtFmt.getNoChangesYet(), (Throwable)((Object)ne));
        }
    }

    public void showChanges(String onlyInMemory) throws ScriptException {
        this.ctx.commandType = SHOW_CHANGES;
        this.validateTree();
        if (!this.validateCall(SHOW_CHANGES)) {
            return;
        }
        try {
            Change[] unSavedChanges = this.ctx.configurationManager.getChanges();
            if (onlyInMemory.equals("true")) {
                this.ctx.println(this.txtFmt.getUnsavedChangesAre());
                this.printChanges(unSavedChanges);
                return;
            }
            Change[] unActivatedChanges = this.ctx.configurationManager.getUnactivatedChanges();
            if (unActivatedChanges != null && unActivatedChanges.length > 0) {
                this.ctx.println("");
                this.ctx.println(this.txtFmt.getUnactivatedChangesAre());
                this.printChanges(unActivatedChanges);
            }
        }
        catch (NotEditorException ne) {
            this.ctx.throwWLSTException(this.txtFmt.getNoChangesYet(), (Throwable)((Object)ne));
        }
    }

    private void printChanges(Change[] changes) {
        for (int i = 0; i < changes.length; ++i) {
            Change change = changes[i];
            this.ctx.println("");
            this.printChange(change);
            this.ctx.println("");
        }
    }

    private void printChange(Change change) {
        this.ctx.println(this.txtFmt.getMBeanChanged2(this.asString(change.getBean())));
        this.ctx.println(this.txtFmt.getOperationInvoked(this.asString(change.getOperation())));
        this.ctx.println(this.txtFmt.getAttributeModified(this.asString(change.getAttributeName())));
        this.ctx.println(this.txtFmt.getAttributesOldValue(this.asString(change.getOldValue())));
        this.ctx.println(this.txtFmt.getAttributesNewValue(this.asString(change.getNewValue())));
        this.ctx.println(this.txtFmt.getServerRestartRequired(this.asString(change.isRestartRequired())));
    }

    private String asString(boolean b) {
        return b ? "true" : "false";
    }

    private String asString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    public ActivationTaskMBean getActivationTask() throws ScriptException {
        this.ctx.commandType = "getActivationTask";
        this.validateTree();
        return this.ctx.activationTask;
    }
}

