/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.scripting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import weblogic.management.WebLogicMBean;
import weblogic.management.internal.Pair;
import weblogic.management.scripting.ScriptException;
import weblogic.management.scripting.WLSTPathUtil;
import weblogic.management.scripting.WLScriptContext;
import weblogic.utils.StringUtils;

public class FindUtil {
    WLScriptContext ctx = null;
    FindUtil util = null;
    List haveISeenYou = new ArrayList();
    List beanToAttribute = new ArrayList();
    String delimiter = "\t";
    List didIScanYou = new ArrayList();
    List matchedAttributes = new ArrayList();

    public FindUtil(WLScriptContext ctx) {
        this.ctx = ctx;
    }

    List findAttribute(String name, String searchInstancesOnly) throws ScriptException {
        this.ctx.println("Finding '" + name + "' in all registered MBean instances ... ");
        boolean searchTypes = this.ctx.getBoolean(searchInstancesOnly);
        List fromInstances = this.findAttributeInCurrentTree(name);
        if (searchTypes) {
            return fromInstances;
        }
        this.ctx.println("\nNow finding '" + name + "' in all MBean Types that can be instantiated ... ");
        List typeAttrs = this.findAttributeInTypes(name);
        if (typeAttrs.isEmpty()) {
            this.ctx.println("No results found in MBean Types");
            return fromInstances;
        }
        Iterator itr = typeAttrs.iterator();
        while (itr.hasNext()) {
            this.ctx.println((String)itr.next());
        }
        fromInstances.addAll(typeAttrs);
        return fromInstances;
    }

    List findTypeInTypes(String name) {
        this.didIScanYou = new ArrayList();
        this.matchedAttributes = new ArrayList();
        try {
            this.scanForTypes("weblogic.management.configuration.DomainMBean", name, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.matchedAttributes;
    }

    void scanForTypes(String interfaceName, String attrName, String parentAttr) throws ScriptException {
        if (this.didIScanYou.contains(interfaceName)) {
            return;
        }
        this.didIScanYou.add(interfaceName);
        try {
            ModelMBeanInfo modelInfo = this.ctx.mbeanTypeService.getMBeanInfo(interfaceName);
            MBeanAttributeInfo[] attrInfos = modelInfo.getAttributes();
            for (int j = 0; j < attrInfos.length; ++j) {
                ModelMBeanAttributeInfo attrInfo = (ModelMBeanAttributeInfo)attrInfos[j];
                Descriptor desc = attrInfo.getDescriptor();
                if (this.childOrReference(desc)) {
                    String interfaceClassName = this.getInterfaceClassName(desc);
                    if ("weblogic.management.WebLogicMBean".equals(interfaceClassName)) continue;
                    this.scanForTypes(interfaceClassName, attrName, parentAttr + "/" + attrInfo.getName());
                }
                if (attrInfo.getName().toLowerCase(Locale.US).indexOf(attrName.toLowerCase(Locale.US)) == -1) continue;
                String s = "";
                s = s + parentAttr + "/" + attrInfo.getName();
                if (!this.childOrReference(desc)) continue;
                this.matchedAttributes.add(s);
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
    }

    List findAttributeInTypes(String name) {
        this.didIScanYou = new ArrayList();
        this.matchedAttributes = new ArrayList();
        try {
            this.scanForAttributes("weblogic.management.configuration.DomainMBean", name, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.matchedAttributes;
    }

    void scanForAttributes(String interfaceName, String attrName, String parentAttr) throws ScriptException {
        if (this.didIScanYou.contains(interfaceName)) {
            return;
        }
        this.didIScanYou.add(interfaceName);
        try {
            ModelMBeanInfo modelInfo = this.ctx.mbeanTypeService.getMBeanInfo(interfaceName);
            MBeanAttributeInfo[] attrInfos = modelInfo.getAttributes();
            for (int j = 0; j < attrInfos.length; ++j) {
                ModelMBeanAttributeInfo attrInfo = (ModelMBeanAttributeInfo)attrInfos[j];
                Descriptor desc = attrInfo.getDescriptor();
                if (this.childOrReference(desc)) {
                    String interfaceClassName = this.getInterfaceClassName(desc);
                    if ("weblogic.management.WebLogicMBean".equals(interfaceClassName)) continue;
                    this.scanForAttributes(interfaceClassName, attrName, parentAttr + "/" + attrInfo.getName());
                }
                if (attrInfo.getName().toLowerCase(Locale.US).indexOf(attrName.toLowerCase(Locale.US)) == -1) continue;
                String s = "";
                s = s + parentAttr + this.ctx.calculateTabSpace(parentAttr) + " " + attrInfo.getName();
                this.matchedAttributes.add(s);
            }
        }
        catch (OperationsException oe) {
            this.ctx.printDebug("Warning: " + oe.getMessage() + ". The MBean is coming from " + parentAttr);
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException("Error in scanning for attributes", th);
        }
    }

    private boolean childOrReference(Descriptor desc) {
        String val = (String)desc.getFieldValue("com.bea.relationship");
        if (val != null && val.equals("containment")) {
            Boolean _val = (Boolean)desc.getFieldValue("com.bea.exclude");
            return _val == null || _val == false;
        }
        return false;
    }

    String getInterfaceClassName(Descriptor desc) {
        String intClzName = (String)desc.getFieldValue("interfaceClassName");
        if (intClzName.startsWith("[L")) {
            intClzName = intClzName.substring(2, intClzName.length() - 1);
        }
        return intClzName;
    }

    private void dumpDescriptorFields(Descriptor desc) {
        String[] fnames = desc.getFieldNames();
        for (int i = 0; i < fnames.length; ++i) {
            Object val = desc.getFieldValue(fnames[i]);
            System.out.println("\tThe name: " + fnames[i] + " Value: " + val);
        }
    }

    List findMBean(String name, String type, String searchInstancesOnly) throws ScriptException {
        this.ctx.println(this.ctx.getWLSTMsgFormatter().getFindBeanOfType(type));
        boolean bool = this.ctx.getBoolean(searchInstancesOnly);
        List list = this.findMBeanInCurrentTree(name, type);
        if (!bool) {
            this.ctx.println(this.ctx.getWLSTMsgFormatter().getNowFinding(type));
            List _list = this.findTypeInTypes(type);
            if (_list.isEmpty()) {
                this.ctx.println(this.ctx.getWLSTMsgFormatter().getFindByTypeResultEmpty());
                return list;
            }
            Iterator itr = _list.iterator();
            while (itr.hasNext()) {
                this.ctx.println((String)itr.next());
            }
            list.addAll(_list);
        }
        return list;
    }

    private List findAttributeInThisTree(String name, ObjectName root) throws ScriptException {
        this.haveISeenYou = new ArrayList();
        this.beanToAttribute = new ArrayList();
        this.walkTheTree(root, name);
        Iterator iter = this.beanToAttribute.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (iter.hasNext()) {
            String s;
            Pair pair = (Pair)iter.next();
            ObjectName on = (ObjectName)pair.getKey();
            Pair attrNameValue = (Pair)pair.getValue();
            String attrName = (String)attrNameValue.getKey();
            String value = null;
            if (attrNameValue.getValue() != null) {
                value = attrNameValue.getValue().toString();
            }
            if ((s = this.lookupPath(on)) == null || this.ctx.isAnythingInThisExcluded(s) || !this.doesThisBelongHere(s)) continue;
            if (s.startsWith("Domains") || s.startsWith("DomainRuntimes") || s.startsWith("ServerRuntimes")) {
                s = "";
            }
            s = "/" + s + this.ctx.calculateTabSpace(s) + " " + attrName + this.ctx.calculateTabSpace(attrName, 50) + " " + value;
            this.ctx.println(s);
            list.add(s);
        }
        if (list.isEmpty()) {
            this.ctx.println(this.ctx.getWLSTMsgFormatter().getFindByInstanceResultEmpty());
        }
        return list;
    }

    private boolean doesThisBelongHere(String path) {
        if (path == null) {
            return false;
        }
        if (this.ctx.domainType.equals("ConfigDomainRuntime") || this.ctx.domainType.equals("RuntimeConfigServerDomain")) {
            String[] mbeans = StringUtils.splitCompletely((String)path, (String)"/");
            for (int i = 0; i < mbeans.length; ++i) {
                if (!mbeans[i].endsWith("Runtime") && !mbeans[i].endsWith("Runtimes")) continue;
                return false;
            }
            return true;
        }
        if (this.ctx.domainType.equals("RuntimeDomainRuntime") || this.ctx.domainType.equals("RuntimeRuntimeServerDomain")) {
            String[] mbeans = StringUtils.splitCompletely((String)path, (String)"/");
            for (int i = 0; i < mbeans.length; ++i) {
                if (!mbeans[i].endsWith("Runtime") && !mbeans[i].endsWith("Runtimes")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private List findAttributeInCurrentTree(String name) throws ScriptException {
        WebLogicMBean root = this.ctx.getRootMBean(this.ctx.domainType);
        return this.findAttributeInThisTree(name, (ObjectName)root.getObjectName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void walkTheTree(ObjectName root, String name) throws ScriptException {
        MBeanServerConnection connection = this.ctx.getMBSConnection(this.ctx.domainType);
        MBeanAttributeInfo[] info = null;
        try {
            info = connection.getMBeanInfo(root).getAttributes();
        }
        catch (InstanceNotFoundException inf) {
            this.ctx.printDebug("MBean of Type '" + root.getKeyProperty("Type") + "' and ObjectName " + root + "is " + "EXCLUDED but its parents getter is Not excluded.");
            return;
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException("Error getting the attributes for MBean", th);
        }
        if (this.haveISeenYou.contains(root)) {
            return;
        }
        this.haveISeenYou.add(root);
        this.ctx.printDebug("Added " + root + " to the already seen list");
        try {
            int i = 0;
            while (i < info.length) {
                block17: {
                    MBeanAttributeInfo attrInfo;
                    block16: {
                        attrInfo = null;
                        ModelMBeanAttributeInfo model_ainfo = null;
                        attrInfo = info[i];
                        model_ainfo = (ModelMBeanAttributeInfo)attrInfo;
                        String attrName = attrInfo.getName();
                        this.ctx.printDebug("    Processing attribute " + attrName + " of " + root);
                        if (attrInfo.getName().toLowerCase(Locale.US).indexOf(name.toLowerCase(Locale.US)) != -1) {
                            Pair pair = null;
                            pair = this.ctx.infoHandler.isEncrypted(model_ainfo) ? new Pair(attrInfo.getName(), "******") : new Pair(attrInfo.getName(), connection.getAttribute(root, attrInfo.getName()));
                            Pair onToAttrNameValue = new Pair(root, pair);
                            this.beanToAttribute.add(onToAttrNameValue);
                        }
                        if (!attrInfo.getType().startsWith("[L") || attrInfo.getType().indexOf("ObjectName") == -1) break block16;
                        ObjectName[] beans = (ObjectName[])connection.getAttribute(root, attrInfo.getName());
                        if (beans != null) {
                            for (int j = 0; j < beans.length; ++j) {
                                this.walkTheTree(beans[j], name);
                            }
                        }
                        break block17;
                    }
                    if (!(attrInfo.getType().indexOf("ObjectName") == -1 || attrInfo.getType().equals("weblogic.management.WebLogicMBean") || attrInfo.getName().equals("Parent") || attrInfo.getName().equals("MBeanInfo"))) {
                        ObjectName bean = null;
                        Object retObj = connection.getAttribute(root, attrInfo.getName());
                        if (retObj != null) {
                            if (retObj instanceof ObjectName) {
                                bean = (ObjectName)retObj;
                            }
                            if (bean != null) {
                                try {
                                    this.walkTheTree(bean, name);
                                }
                                catch (Exception e) {
                                    System.out.println("%%%% an exception occured while walking " + bean + " ... " + e);
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            return;
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException("Error walking the tree", th);
        }
    }

    private List findMBeanInThisTree(String name, String type, MBeanServerConnection connection) throws ScriptException {
        if (name == null) {
            name = "*";
        }
        QueryExp exp = Query.match(Query.attr("Name"), Query.value(name));
        try {
            Set<ObjectName> objNames = connection.queryNames(new ObjectName("*:*"), exp);
            this.ctx.printDebug("Found " + objNames.size() + " mbeans in this tree ...");
            Iterator<ObjectName> iter = objNames.iterator();
            ArrayList<ObjectName> list = new ArrayList<ObjectName>();
            while (iter.hasNext()) {
                ObjectName on = iter.next();
                this.ctx.printDebug("  Observing mbean " + on);
                if (on.getKeyProperty("Type") == null || on.getKeyProperty("Type").toLowerCase(Locale.US).indexOf(type.toLowerCase(Locale.US)) == -1 || on.getKeyProperty("Type").equals("MessageDrivenControlEJBRuntime") && on.getKeyProperty("Name").equals("MessageDrivenControlEJBRuntime")) continue;
                this.ctx.printDebug("MBean " + on + " matched the query and added for further examination");
                list.add(on);
            }
            ArrayList<String> pathList = new ArrayList<String>();
            for (ObjectName objName : list) {
                this.ctx.printDebug("Evaluating path for " + objName);
                String path = this.lookupPath(objName);
                if (this.ctx.isAnythingInThisExcluded(path) || !this.doesThisBelongHere(path)) continue;
                pathList.add("/" + path);
            }
            if (pathList.isEmpty()) {
                this.ctx.println(this.ctx.getWLSTMsgFormatter().getFindByInstanceResultEmpty());
            }
            Iterator iterator = pathList.iterator();
            while (iterator.hasNext()) {
                this.ctx.println((String)iterator.next());
            }
            return pathList;
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException("Error finding the MBean", th);
            return null;
        }
    }

    private List findMBeanInCurrentTree(String name, String type) throws ScriptException {
        MBeanServerConnection connection = this.ctx.getMBSConnection(this.ctx.domainType);
        return this.findMBeanInThisTree(name, type, connection);
    }

    public String lookupPath(ObjectName on) {
        try {
            return WLSTPathUtil.lookupPath(this.ctx.getMBeanServer(), this.ctx.getDomainName(), on);
        }
        catch (Throwable th) {
            this.ctx.printDebug("Error while looking up the path ");
            return null;
        }
    }
}

