/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.scripting;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.python.core.ArgParser;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentConfiguration;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.tools.SessionHelper;
import weblogic.deploy.api.tools.deployer.ModuleTargetInfo;
import weblogic.deploy.api.tools.deployer.SubModuleTargetInfo;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.scripting.JSR88DeploymentConstants;
import weblogic.management.scripting.ScriptException;
import weblogic.management.scripting.WLScriptContext;
import weblogic.management.scripting.jsr88.WLSTPlan;
import weblogic.management.scripting.jsr88.WLSTPlanImpl;
import weblogic.management.scripting.jsr88.WLSTProgress;
import weblogic.management.scripting.jsr88.WLSTProgressImpl;
import weblogic.management.scripting.utils.WLSTMsgTextFormatter;
import weblogic.management.scripting.utils.WLSTUtil;
import weblogic.utils.StringUtils;

public class JSR88DeployHandler
extends JSR88DeploymentConstants {
    WLScriptContext ctx = null;
    private WLSTMsgTextFormatter txtFmt;
    private static String NONE = "None";
    private static String FALSE = "false";
    private static String TRUE = "true";
    private WebLogicDeploymentManager dm = null;
    private SessionHelper helper = null;

    public JSR88DeployHandler(WLScriptContext ctx) {
        this.ctx = ctx;
        this.txtFmt = ctx.getWLSTMsgFormatter();
    }

    public WebLogicDeploymentManager getWLDM(boolean remote) throws ScriptException {
        this.init(remote);
        return this.dm;
    }

    public WebLogicDeploymentManager getWLDM() throws ScriptException {
        this.init();
        return this.dm;
    }

    private void init() throws ScriptException {
        this.init(false);
    }

    private void init(boolean remote) throws ScriptException {
        if (this.dm != null) {
            this.dm.release();
            this.dm = null;
        }
        if (this.ctx.isConnected() && !this.ctx.isAdminServer) {
            throw new ScriptException(this.txtFmt.getNotConnectedAdminServer(), this.ctx.commandType);
        }
        try {
            if (!this.ctx.isConnected()) {
                this.dm = SessionHelper.getDisconnectedDeploymentManager();
            } else {
                String host = this.ctx.getListenAddress(this.ctx.url);
                String port = this.ctx.getListenPort(this.ctx.url);
                String protocol = this.ctx.getProtocol(this.ctx.url);
                this.dm = remote ? SessionHelper.getRemoteDeploymentManager(protocol, host, port, new String(this.ctx.username_bytes), new String(this.ctx.password_bytes)) : SessionHelper.getDeploymentManager(protocol, host, port, new String(this.ctx.username_bytes), new String(this.ctx.password_bytes));
            }
            if (this.helper != null) {
                this.helper.close();
                this.helper = null;
            }
            this.helper = SessionHelper.getInstance(this.dm);
        }
        catch (DeploymentManagerCreationException dme) {
            this.ctx.throwWLSTException(this.txtFmt.getCouldNotCreateDM(), dme);
        }
        catch (Throwable th) {
            this.ctx.throwWLSTException(this.txtFmt.getCouldNotCreateDM(), th);
        }
    }

    public WLSTPlan loadApplication(String appPath, String planPath, String createPlan) throws ScriptException {
        this.ctx.println(this.txtFmt.getLoadingAppFrom(appPath));
        this.init();
        WLSTPlanImpl wlstPlan = null;
        boolean isInstallDir = false;
        boolean planExists = false;
        File moduleObject = new File(appPath);
        this.ctx.printDebug(this.txtFmt.getEnsureSubdirOfApp());
        if (moduleObject.getParentFile().getName().equals("app")) {
            isInstallDir = true;
        }
        File planFile = null;
        if (planPath == null) {
            planPath = this.getPlanPath(moduleObject.getAbsolutePath(), isInstallDir);
            planFile = new File(planPath);
            if (!planFile.exists()) {
                if (this.ctx.getBoolean(createPlan)) {
                    this.ctx.println(this.txtFmt.getCreatePlan(planFile.getAbsolutePath()));
                } else {
                    this.ctx.throwWLSTException(this.txtFmt.getCouldNotFindPlan());
                }
            } else {
                planExists = true;
            }
        } else {
            planFile = new File(planPath);
            if (!planFile.exists()) {
                if (this.ctx.getBoolean(createPlan)) {
                    this.ctx.println(this.txtFmt.getCreatePlan(planFile.getAbsolutePath()));
                } else {
                    this.ctx.throwWLSTException(this.txtFmt.getCouldNotFindPlan());
                }
            } else {
                planExists = true;
            }
        }
        try {
            if (this.ctx.getBoolean(createPlan) && !planExists) {
                this.helper.initializeConfiguration(moduleObject, null);
            } else {
                this.helper.initializeConfiguration(moduleObject, planFile);
            }
            WebLogicDeploymentConfiguration wdc = this.helper.getConfiguration();
            wlstPlan = new WLSTPlanImpl(wdc, this.ctx, planFile.getAbsolutePath());
            if (this.ctx.getBoolean(createPlan) && !planExists) {
                wlstPlan.save();
            }
            String msg = this.txtFmt.getLoadedAppAndPlan(moduleObject.getAbsolutePath(), planFile.getAbsolutePath());
            this.ctx.println(msg);
            if (!WLSTUtil.runningWLSTAsModule()) {
                String planObjectName = "wlstPlan_" + wlstPlan.getDeploymentPlan().getApplicationName();
                planObjectName = planObjectName.replace('.', '_');
                WLSTUtil.getWLSTInterpreter().set(planObjectName, wlstPlan);
                this.ctx.println(this.txtFmt.getPlanVariableAssigned(planObjectName));
            }
        }
        catch (ConfigurationException ce) {
            this.ctx.throwWLSTException(this.txtFmt.getCouldNotInitConfig(), ce);
        }
        catch (IOException ce) {
            this.ctx.throwWLSTException(this.txtFmt.getCouldNotReadConfig(), ce);
        }
        catch (InvalidModuleException ce) {
            this.ctx.throwWLSTException(this.txtFmt.getInvalidModule(), ce);
        }
        return wlstPlan;
    }

    private String getExistingPlanPath(String appPath) {
        File file = new File(appPath);
        String planPath = file.getParentFile().getParentFile().getAbsolutePath() + "/plan/plan.xml";
        File f = new File(planPath);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private String getPlanPath(String appPath, boolean isInstallDir) {
        File file = new File(appPath);
        String planPath = null;
        if (isInstallDir) {
            this.ctx.printDebug(this.txtFmt.getAppPathIsDir(appPath));
            planPath = file.getParentFile().getParentFile().getAbsolutePath() + "/plan/plan.xml";
            File f = new File(planPath);
            if (!f.exists()) {
                this.ctx.printDebug(this.txtFmt.getPlanDoesNotExist(planPath));
                f = new File(file.getParentFile().getAbsolutePath() + "/plan.xml");
            }
            f.getParentFile().mkdirs();
            planPath = f.getAbsolutePath();
            this.ctx.printDebug(this.txtFmt.getPlanPathEvaluated(planPath));
            return planPath;
        }
        planPath = file.getParentFile().getAbsolutePath() + File.separator + "plan.xml";
        this.ctx.printDebug(this.txtFmt.getPlanPathEvaluated(planPath));
        return planPath;
    }

    private TargetModuleID[] createTmidsFromApp(String appName) {
        if (appName == null) {
            return new TargetModuleID[0];
        }
        TargetModuleID[] tmids = null;
        AppDeploymentMBean mbean = ApplicationVersionUtils.getAppDeployment(this.dm.getHelper().getDomain(), appName, null);
        if (mbean == null) {
            tmids = new TargetModuleID[]{};
            return this.createTmidForAdminServer(tmids, appName);
        }
        List l = this.dm.getServerConnection().getModules(mbean);
        tmids = l.toArray(new TargetModuleID[0]);
        return tmids;
    }

    private TargetModuleID[] createTmidForAdminServer(TargetModuleID[] tmids, String appName) {
        if (appName == null) {
            return new TargetModuleID[0];
        }
        TargetModuleID[] newTmids = new TargetModuleID[tmids.length + 1];
        if (0 != tmids.length) {
            System.arraycopy(tmids, 0, newTmids, 1, tmids.length);
        }
        String admin = this.dm.getHelper().getAdminServerName();
        Target[] allt = this.dm.getTargets();
        for (int i = 0; i < allt.length; ++i) {
            Target target = allt[i];
            if (!target.getName().equals(admin)) continue;
            newTmids[0] = this.dm.createTargetModuleID(appName, WebLogicModuleType.UNKNOWN, target);
            tmids = newTmids;
            return tmids;
        }
        return tmids;
    }

    private TargetModuleID[] getTMIDs(String tgtNames, WebLogicDeploymentManager dm, String name, String subModuleTargets) throws ScriptException {
        ArrayList<Target> tl = new ArrayList<Target>();
        Target[] allt = dm.getTargets();
        Target[] targets = new Target[]{};
        if (!(tgtNames != null && tgtNames.length() != 0 || subModuleTargets != null && subModuleTargets.length() != 0)) {
            return this.createTmidsFromApp(name);
        }
        if (tgtNames == null) {
            tgtNames = "";
        }
        String[] targetNames = StringUtils.splitCompletely((String)tgtNames, (String)",");
        String[] smTargetNames = null;
        if (subModuleTargets != null) {
            smTargetNames = StringUtils.splitCompletely((String)subModuleTargets, (String)",");
        }
        Set targetInfos = this.getTargetInfos(targetNames, smTargetNames);
        for (ModuleTargetInfo mti : targetInfos) {
            Target targ = this.findTarget(mti, allt);
            if (targ == null) {
                String msg = this.txtFmt.getCouldNotFindMatchingTargets(mti.getTarget(), subModuleTargets);
                this.ctx.throwWLSTException(msg);
            }
            tl.add(targ);
        }
        targets = tl.toArray(new Target[0]);
        List list = this.prepareTmids(targetInfos, targets, dm, name);
        return this.getTmids(list);
    }

    private Target findTarget(ModuleTargetInfo mti, Target[] allt) {
        for (int i = 0; i < allt.length; ++i) {
            Target target = allt[i];
            if (!target.getName().equals(mti.getTarget())) continue;
            return target;
        }
        return null;
    }

    private Set getTargetInfos(String[] modlist, String[] submodlist) {
        int i;
        HashSet<ModuleTargetInfo> targs = new HashSet<ModuleTargetInfo>();
        for (i = 0; i < modlist.length; ++i) {
            targs.add(new ModuleTargetInfo(modlist[i]));
        }
        if (submodlist != null) {
            for (i = 0; i < submodlist.length; ++i) {
                targs.add(new SubModuleTargetInfo(submodlist[i]));
            }
        }
        return targs;
    }

    private List prepareTmids(Set targetInfos, Target[] targets, WebLogicDeploymentManager dm, String name) {
        ArrayList<TargetModuleID> tmids = new ArrayList<TargetModuleID>();
        if (name == null) {
            return tmids;
        }
        for (ModuleTargetInfo mti : targetInfos) {
            tmids.add(mti.createTmid(name, this.findTarget(mti, targets), dm));
        }
        return tmids;
    }

    private TargetModuleID[] getTmids(List tmids) {
        return tmids.toArray(new TargetModuleID[0]);
    }

    public Object distributeApplication(PyObject[] args, String[] kw) throws ScriptException {
        ArgParser ap = new ArgParser("distributeApplication", args, kw, "appPath", "planPath", "targets");
        WLSTProgressImpl progress = null;
        try {
            String targets;
            String appPath = ap.getString(0);
            File app = new File(appPath);
            String planPath = ap.getString(1);
            File plan = null;
            if (planPath != null) {
                plan = new File(planPath);
            }
            if ((targets = ap.getString(2)) == null) {
                targets = this.ctx.serverName;
            }
            PyDictionary pyOptions = (PyDictionary)ap.getPyObject(3);
            String upload = pyOptions.get(DEPLOY_UPLOAD).toString();
            boolean doUpload = new Boolean(upload);
            WebLogicDeploymentManager dMgr = this.getWLDM(doUpload);
            DeploymentOptions depOptions = this.getDeploymentOptions();
            String subModuleTargets = this.getSubModuleTargets(pyOptions);
            TargetModuleID[] actualTargets = this.getTMIDs(targets, dMgr, app.getName(), subModuleTargets);
            if (pyOptions.items().__len__() > 0) {
                depOptions = this.getDeploymentOptions(pyOptions);
            }
            this.ctx.println(this.txtFmt.getDistributingApplication(app.getAbsolutePath(), targets));
            ProgressObject po = dMgr.distribute(actualTargets, app, plan, depOptions);
            String block = pyOptions.get(BLOCK).toString();
            progress = new WLSTProgressImpl(po, this.ctx);
            if (block == null || block.equals(NONE)) {
                block = TRUE;
            }
            if ((block = this.doBlock("distribution", block)).toLowerCase(Locale.US).toString().equals(TRUE)) {
                this.isDoneOrTimedOut(progress, pyOptions);
                if (progress.isFailed()) {
                    this.ctx.println(this.txtFmt.getFailedToDistributeApp(progress.getState()));
                    progress.printStatus();
                    this.ctx.throwWLSTException(this.txtFmt.getFailedToDistributeApp(progress.getState()));
                    return progress;
                }
                this.ctx.println(this.txtFmt.getAppDistributionComplete(progress.getState()));
                progress.printStatus();
                return progress;
            }
            this.ctx.println(this.txtFmt.getDistributionStarted());
        }
        catch (TargetException te) {
            this.ctx.throwWLSTException(this.txtFmt.getErrorDistributingApp(te.getMessage()), te);
        }
        return progress;
    }

    private String doBlock(String action, String block) {
        if (this.ctx.isEditSessionInProgress) {
            this.ctx.println(this.txtFmt.getEditSessionInProgress(action));
            return FALSE;
        }
        return block;
    }

    public Object deploy(PyObject[] args, String[] kw) throws ScriptException {
        this.ctx.commandType = "deploy";
        boolean createdPlan = false;
        boolean doCreatePlan = false;
        boolean doUpload = false;
        String block = FALSE;
        File plan = null;
        try {
            ArgParser ap = new ArgParser("deploy", args, kw, "appName", "path", "targets");
            String appName = ap.getString(0);
            String appPath = ap.getString(1);
            File app = new File(appPath);
            String planPath = ap.getString(4);
            if (planPath != null) {
                plan = new File(planPath);
            }
            String targets = ap.getString(2);
            String stageMode = ap.getString(3);
            PyDictionary pyOptions = (PyDictionary)ap.getPyObject(5);
            DeploymentOptions depOptions = this.getDeploymentOptions();
            ProgressObject po = null;
            String createPlan = pyOptions.get(CREATE_PLAN).toString();
            doCreatePlan = createPlan == null || createPlan.equals(NONE) ? false : this.ctx.getBoolean(createPlan);
            String upload = pyOptions.get(DEPLOY_UPLOAD).toString();
            doUpload = new Boolean(upload);
            String remote = pyOptions.get(REMOTE).toString();
            if (!TRUE.equalsIgnoreCase(remote) && !app.exists()) {
                throw new ScriptException(this.txtFmt.getApplicationPathNotFound(app.getAbsolutePath()), this.ctx.commandType);
            }
            WebLogicDeploymentManager dMgr = this.getWLDM(doUpload);
            boolean isInstallDir = false;
            if (app.getParentFile() != null && app.getParentFile().getName().equals("app")) {
                isInstallDir = true;
            }
            try {
                String _path;
                if (doCreatePlan) {
                    this.ctx.printDebug(this.txtFmt.getCreatePlanTrue());
                    if (plan == null) {
                        planPath = this.getPlanPath(app.getAbsolutePath(), isInstallDir);
                        plan = new File(planPath);
                    }
                    this.helper.initializeConfiguration(app, null);
                    WebLogicDeploymentConfiguration wdc = this.helper.getConfiguration();
                    WLSTPlanImpl wlstPlan = new WLSTPlanImpl(wdc, this.ctx, plan.getAbsolutePath());
                    wlstPlan.getDeploymentPlan().setApplicationName(appName);
                    wlstPlan.save();
                }
                if (isInstallDir && plan == null && (_path = this.getExistingPlanPath(app.getAbsolutePath())) != null) {
                    plan = new File(_path);
                }
                String subModuleTargets = this.getSubModuleTargets(pyOptions);
                TargetModuleID[] tmids = this.getTMIDs(targets, dMgr, appName, subModuleTargets);
                if (pyOptions.items().__len__() > 0) {
                    depOptions = this.getDeploymentOptions(pyOptions);
                }
                depOptions.setStageMode(stageMode);
                depOptions.setName(appName);
                this.ctx.println(this.txtFmt.getDeployingApplication(app.getAbsolutePath(), targets, doUpload));
                if (plan != null) {
                    String msg = this.txtFmt.getDeployingApplicationWithPlan(app.getAbsolutePath(), plan.getAbsolutePath());
                    this.ctx.printDebug(msg);
                }
                po = dMgr.deploy(tmids, app, plan, depOptions);
            }
            catch (TargetException te) {
                this.ctx.throwWLSTException(this.txtFmt.getDeploymentFailed(), te);
            }
            catch (Throwable e) {
                if (this.ctx.debug) {
                    e.printStackTrace();
                }
                this.ctx.throwWLSTException(this.txtFmt.getUnexpectedError(e.getMessage()), e);
            }
            block = pyOptions.get(BLOCK).toString();
            if (block == null || block.equals(NONE)) {
                block = TRUE;
            }
            block = this.doBlock("deployment", block);
            WLSTProgressImpl progress = new WLSTProgressImpl(po, this.ctx);
            if (block.toLowerCase(Locale.US).toString().equals(TRUE)) {
                this.isDoneOrTimedOut(progress, pyOptions);
                if (progress.isFailed()) {
                    this.ctx.println(this.txtFmt.getFailedToDeployApp(progress.getState()));
                    progress.printStatus();
                    this.ctx.throwWLSTException(this.txtFmt.getDeploymentFailed());
                    return progress;
                }
                this.ctx.println(this.txtFmt.getAppDeploymentComplete(progress.getState()));
                progress.printStatus();
                return progress;
            }
            this.ctx.println(this.txtFmt.getDeploymentStarted());
            return progress;
        }
        catch (Throwable e) {
            this.ctx.throwWLSTException(this.txtFmt.getErrorDeployingApp(e.getMessage()), e);
            return null;
        }
    }

    private String getSubModuleTargets(PyDictionary pyOptions) {
        String tgts = pyOptions.get(SUB_MODULE_TARGETS).toString();
        if (tgts == null || tgts.equals(NONE)) {
            return null;
        }
        return tgts;
    }

    private String getTargets(PyDictionary pyOptions) {
        String tgts = pyOptions.get(TARGETS).toString();
        if (tgts == null || tgts.equals(NONE)) {
            return null;
        }
        return tgts;
    }

    private String[] getDeltas(PyDictionary pyOptions) {
        String deltaVal = pyOptions.get(DELTA).toString();
        if (deltaVal == null || deltaVal.equals(NONE)) {
            return null;
        }
        String[] deltas = StringUtils.splitCompletely((String)deltaVal, (String)",");
        return deltas;
    }

    private String getAppPath(String appname) {
        AppDeploymentMBean appMBean = this.ctx.editServiceMBean.getDomainConfiguration().lookupAppDeployment(appname);
        if (appMBean == null) {
            return null;
        }
        return appMBean.getAbsoluteSourcePath();
    }

    private void isDoneOrTimedOut(WLSTProgress progress, PyDictionary pyOptions) throws ScriptException {
        String msg;
        PyObject _timeout = pyOptions.get(TIME_OUT);
        int timeout = 300000;
        if (!_timeout.toString().equals(NONE) && _timeout != null) {
            timeout = (Integer)_timeout.__tojava__(Integer.class);
        }
        if ((msg = progress.getMessage()) != null) {
            this.ctx.print(msg);
        }
        if (timeout == 0) {
            try {
                while (progress.isRunning()) {
                    this.ctx.print(".");
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException ie) {}
        } else {
            Integer in = new Integer(timeout);
            long quitTime = System.currentTimeMillis() + in.longValue();
            do {
                try {
                    if (progress.isRunning()) {
                        this.ctx.print(".");
                        Thread.sleep(3000L);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (quitTime > System.currentTimeMillis()) continue;
                this.ctx.throwWLSTException(this.txtFmt.getActionTimedOut((long)timeout));
            } while ((timeout == 0 || quitTime > System.currentTimeMillis()) && progress.isRunning());
        }
    }

    public Object redeploy(PyObject[] args, String[] kw) throws ScriptException {
        ArgParser ap = new ArgParser("redeploy", args, kw, "appName");
        String appName = ap.getString(0);
        String planPath = ap.getString(1);
        File plan = null;
        if (planPath != null) {
            plan = new File(planPath);
        }
        PyDictionary pyOptions = (PyDictionary)ap.getPyObject(2);
        String upload = pyOptions.get(DEPLOY_UPLOAD).toString();
        boolean doUpload = new Boolean(upload);
        doUpload = new Boolean(upload);
        WebLogicDeploymentManager dMgr = this.getWLDM(doUpload);
        DeploymentOptions depOptions = this.getDeploymentOptions();
        if (pyOptions.items().__len__() > 0) {
            depOptions = this.getDeploymentOptions(pyOptions);
        }
        this.ctx.println(this.txtFmt.getRedeployingApp(appName));
        String subModuleTargets = this.getSubModuleTargets(pyOptions);
        String[] deltas = this.getDeltas(pyOptions);
        TargetModuleID[] modIds = this.getTMIDs(null, dMgr, appName, subModuleTargets);
        String appPath = pyOptions.get(APP_PATH).toString();
        File app = null;
        if (appPath != null && !appPath.equals(NONE)) {
            app = new File(appPath);
        }
        ProgressObject po = null;
        po = deltas != null ? dMgr.redeploy(modIds, app, deltas, depOptions) : dMgr.redeploy(modIds, app, plan, depOptions);
        String block = pyOptions.get(BLOCK).toString();
        WLSTProgressImpl progress = new WLSTProgressImpl(po, this.ctx);
        if (block == null || block.equals(NONE)) {
            block = TRUE;
        }
        if ((block = this.doBlock("redeployment", block)).toLowerCase(Locale.US).toString().equals(TRUE)) {
            this.isDoneOrTimedOut(progress, pyOptions);
            if (progress.isFailed()) {
                this.ctx.println(this.txtFmt.getFailedToRedeployApp(progress.getState()));
                progress.printStatus();
                this.ctx.throwWLSTException(this.txtFmt.getFailedToRedeployApp(progress.getState()));
                return progress;
            }
            this.ctx.println(this.txtFmt.getCompletedAppRedeploy(progress.getState()));
            progress.printStatus();
            return progress;
        }
        this.ctx.println(this.txtFmt.getRedeploymentStarted());
        return progress;
    }

    public Object undeploy(PyObject[] args, String[] kw) throws ScriptException {
        ArgParser ap = new ArgParser("undeploy", args, kw, "targets");
        String appName = ap.getString(0);
        String targets = ap.getString(1);
        PyDictionary pyOptions = (PyDictionary)ap.getPyObject(2);
        WebLogicDeploymentManager dMgr = this.getWLDM();
        this.ctx.println(this.txtFmt.getUndeployingApp(appName));
        DeploymentOptions depOptions = this.getDeploymentOptions();
        if (pyOptions.items().__len__() > 0) {
            depOptions = this.getDeploymentOptions(pyOptions);
        }
        String subModuleTargets = this.getSubModuleTargets(pyOptions);
        TargetModuleID[] modIds = this.getTMIDs(targets, dMgr, appName, subModuleTargets);
        String[] deltas = this.getDeltas(pyOptions);
        ProgressObject po = null;
        po = deltas != null ? dMgr.undeploy(modIds, null, deltas, depOptions) : dMgr.undeploy(modIds, depOptions);
        WLSTProgressImpl progress = new WLSTProgressImpl(po, this.ctx);
        String block = pyOptions.get(BLOCK).toString();
        if (block == null || block.equals(NONE)) {
            block = TRUE;
        }
        if ((block = this.doBlock("undeployment", block)).toLowerCase(Locale.US).toString().equals(TRUE)) {
            this.isDoneOrTimedOut(progress, pyOptions);
            if (progress.isFailed()) {
                this.ctx.println(this.txtFmt.getFailedToUndeployApp(progress.getState()));
                progress.printStatus();
                this.ctx.throwWLSTException(this.txtFmt.getFailedToUndeployApp(progress.getState()));
                return progress;
            }
            this.ctx.println(this.txtFmt.getCompletedAppUndeploy(progress.getState()));
            progress.printStatus();
            return progress;
        }
        this.ctx.println(this.txtFmt.getUndeploymentStarted());
        return progress;
    }

    public Object startApplication(PyObject[] args, String[] kw) throws ScriptException {
        ArgParser ap = new ArgParser("startApplication", args, kw, "appName");
        String appName = ap.getString(0);
        PyDictionary pyOptions = (PyDictionary)ap.getPyObject(1);
        WebLogicDeploymentManager dMgr = this.getWLDM();
        DeploymentOptions depOptions = this.getDeploymentOptions();
        if (pyOptions.items().__len__() > 0) {
            depOptions = this.getDeploymentOptions(pyOptions);
        }
        this.ctx.println(this.txtFmt.getStartingApplication(appName));
        String subModuleTargets = this.getSubModuleTargets(pyOptions);
        String targets = this.getTargets(pyOptions);
        TargetModuleID[] modIds = this.getTMIDs(targets, dMgr, appName, subModuleTargets);
        ProgressObject po = dMgr.start(modIds, depOptions);
        String block = pyOptions.get(BLOCK).toString();
        WLSTProgressImpl progress = new WLSTProgressImpl(po, this.ctx);
        if (block == null || block.equals(NONE)) {
            block = TRUE;
        }
        if ((block = this.doBlock("startApplication", block)).toLowerCase(Locale.US).toString().equals(TRUE)) {
            this.isDoneOrTimedOut(progress, pyOptions);
            if (progress.isFailed()) {
                this.ctx.println(this.txtFmt.getFailedToStartApp(progress.getState()));
                progress.printStatus();
                this.ctx.throwWLSTException(this.txtFmt.getFailedToStartApp(progress.getState()));
                return progress;
            }
            this.ctx.println(this.txtFmt.getCompletedAppStart(progress.getState()));
            progress.printStatus();
            return progress;
        }
        this.ctx.println(this.txtFmt.getApplicationStarted());
        return progress;
    }

    public Object stopApplication(PyObject[] args, String[] kw) throws ScriptException {
        ArgParser ap = new ArgParser("stopApplication", args, kw, "appName");
        String appName = ap.getString(0);
        PyDictionary pyOptions = (PyDictionary)ap.getPyObject(1);
        DeploymentOptions depOptions = this.getDeploymentOptions();
        if (pyOptions.items().__len__() > 0) {
            depOptions = this.getDeploymentOptions(pyOptions);
        }
        WebLogicDeploymentManager dMgr = this.getWLDM();
        this.ctx.println(this.txtFmt.getStoppingApplication(appName));
        String targets = this.getTargets(pyOptions);
        String subModuleTargets = this.getSubModuleTargets(pyOptions);
        TargetModuleID[] modIds = this.getTMIDs(targets, dMgr, appName, subModuleTargets);
        ProgressObject po = dMgr.stop(modIds, depOptions);
        WLSTProgressImpl progress = new WLSTProgressImpl(po, this.ctx);
        String block = pyOptions.get(BLOCK).toString();
        if (block == null || block.equals(NONE)) {
            block = TRUE;
        }
        if ((block = this.doBlock("stopApplication", block)).toLowerCase(Locale.US).toString().equals(TRUE)) {
            this.isDoneOrTimedOut(progress, pyOptions);
            if (progress.isFailed()) {
                this.ctx.println(this.txtFmt.getFailedToStopApp(progress.getState()));
                progress.printStatus();
                this.ctx.throwWLSTException(this.txtFmt.getFailedToStopApp(progress.getState()));
                return progress;
            }
            this.ctx.println(this.txtFmt.getCompletedAppStop(progress.getState()));
            progress.printStatus();
            return progress;
        }
        this.ctx.println(this.txtFmt.getStopStarted());
        return progress;
    }

    public Object updateApplication(PyObject[] args, String[] kw) throws ScriptException {
        ArgParser ap = new ArgParser("updateApplication", args, kw, "appName", "planPath");
        String appName = ap.getString(0);
        String planPath = ap.getString(1);
        File plan = null;
        if (planPath != null) {
            plan = new File(planPath);
        } else {
            this.ctx.throwWLSTException(this.txtFmt.getPlanPathNeededToUpdate());
        }
        PyDictionary pyOptions = (PyDictionary)ap.getPyObject(2);
        String upload = pyOptions.get(DEPLOY_UPLOAD).toString();
        boolean doUpload = new Boolean(upload);
        WebLogicDeploymentManager dMgr = this.getWLDM(doUpload);
        DeploymentOptions depOptions = this.getDeploymentOptions();
        if (pyOptions.items().__len__() > 0) {
            depOptions = this.getDeploymentOptions(pyOptions);
        }
        this.ctx.println(this.txtFmt.getUpdatingApp(appName));
        String subModuleTargets = this.getSubModuleTargets(pyOptions);
        TargetModuleID[] modIds = this.getTMIDs(null, dMgr, appName, subModuleTargets);
        ProgressObject po = dMgr.update(modIds, plan, depOptions);
        String block = pyOptions.get(BLOCK).toString();
        WLSTProgressImpl progress = new WLSTProgressImpl(po, this.ctx);
        if (block == null || block.equals(NONE)) {
            block = TRUE;
        }
        if ((block = this.doBlock("updateApplication", block)).toLowerCase(Locale.US).toString().equals(TRUE)) {
            this.isDoneOrTimedOut(progress, pyOptions);
            if (progress.isFailed()) {
                this.ctx.println(this.txtFmt.getFailedToUpdateApp(progress.getState()));
                progress.printStatus();
                this.ctx.throwWLSTException(this.txtFmt.getFailedToUpdateApp(progress.getState()));
                return progress;
            }
            this.ctx.println(this.txtFmt.getCompletedAppUpdate(progress.getState()));
            progress.printStatus();
            return progress;
        }
        this.ctx.println(this.txtFmt.getUpdateStarted());
        return progress;
    }

    public void listApplications() throws ScriptException {
        try {
            WebLogicDeploymentManager dMgr = this.getWLDM();
            HashSet<String> apps = new HashSet<String>();
            TargetModuleID[] tmids = null;
            Target[] targets = dMgr.getTargets();
            for (int i = 0; i < WebLogicModuleType.getModuleTypes(); ++i) {
                ModuleType mt = WebLogicModuleType.getModuleType(i);
                if (mt == null || (tmids = dMgr.getAvailableModules(mt, targets)) == null) continue;
                for (int j = 0; j < tmids.length; ++j) {
                    if (tmids[j].getParentTargetModuleID() != null) continue;
                    apps.add(tmids[j].getModuleID());
                }
            }
            for (String tmid : apps) {
                String str = " " + ApplicationVersionUtils.getDisplayName(tmid);
                this.ctx.println(str);
            }
        }
        catch (TargetException te) {
            this.ctx.throwWLSTException(this.txtFmt.getDeploymentFailed(), te);
        }
        catch (Throwable e) {
            if (this.ctx.debug) {
                e.printStackTrace();
            }
            this.ctx.throwWLSTException(this.txtFmt.getUnexpectedError(e.getMessage()), e);
        }
    }

    private boolean checkForUnrecognizedOptions(PyDictionary pyDic) {
        try {
            Set<String> unrecognizedOptions = this.getUnrecognizedOptions(pyDic);
            if (unrecognizedOptions != null) {
                for (String unrecognized : unrecognizedOptions) {
                    this.ctx.println(this.txtFmt.unrecognizedOption(unrecognized));
                }
                return true;
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        return false;
    }

    private DeploymentOptions getDeploymentOptions() {
        DeploymentOptions depOptions = new DeploymentOptions();
        if (this.ctx.isEditSessionInProgress) {
            depOptions.setUseExpiredLock(true);
        }
        return depOptions;
    }

    private DeploymentOptions getDeploymentOptions(PyDictionary pyDic) {
        PyObject deploymentOrder;
        DeploymentOptions depOptions = this.getDeploymentOptions();
        String option = pyDic.get(CLUSTER_DEPLOYMENT_TIMEOUT).toString();
        if (option != null && !option.equals(NONE)) {
            depOptions.setClusterDeploymentTimeout(Integer.parseInt(option));
        }
        if ((option = pyDic.get(GRACEFUL_IGNORE_SESSIONS).toString()) != null && !option.equals(NONE)) {
            if (option.toLowerCase(Locale.US).equals(TRUE)) {
                depOptions.setGracefulIgnoreSessions(true);
            } else if (option.toLowerCase(Locale.US).equals(FALSE)) {
                depOptions.setGracefulIgnoreSessions(false);
            }
        }
        if ((option = pyDic.get(GRACEFUL_PRODUCTION_TO_ADMIN).toString()) != null && !option.equals(NONE)) {
            if (option.toLowerCase(Locale.US).equals(TRUE)) {
                depOptions.setGracefulProductionToAdmin(true);
            } else if (option.toLowerCase(Locale.US).equals(FALSE)) {
                depOptions.setGracefulProductionToAdmin(false);
            }
        }
        if ((option = pyDic.get(IS_LIBRARY_MODULE).toString()) != null && !option.equals(NONE)) {
            if (option.toLowerCase(Locale.US).equals(TRUE)) {
                depOptions.setLibrary(true);
            } else if (option.toLowerCase(Locale.US).equals(FALSE)) {
                depOptions.setLibrary(false);
            }
        }
        if ((option = pyDic.get(RETIRE_GRACEFULLY).toString()) != null && !option.equals(NONE)) {
            if (option.toLowerCase(Locale.US).equals(TRUE)) {
                depOptions.setRetireGracefully(true);
            } else if (option.toLowerCase(Locale.US).equals(FALSE)) {
                depOptions.setRetireGracefully(false);
            }
        }
        if ((option = pyDic.get(RETIRE_TIMEOUT).toString()) != null && !option.equals(NONE)) {
            depOptions.setRetireTime(Integer.parseInt(option));
        }
        if ((option = pyDic.get(RMI_GRACE_PERIOD).toString()) != null && !option.equals(NONE)) {
            depOptions.setRMIGracePeriodSecs(Integer.parseInt(option));
        }
        if ((option = pyDic.get(SECURITY_MODEL).toString()) != null && !option.equals(NONE)) {
            depOptions.setSecurityModel(option);
        }
        if ((option = pyDic.get(SECURITY_VALIDATION_ENABLED).toString()) != null && !option.equals(NONE)) {
            if (option.toLowerCase(Locale.US).equals(TRUE)) {
                depOptions.setSecurityValidationEnabled(true);
            } else if (option.toLowerCase(Locale.US).equals(FALSE)) {
                depOptions.setSecurityValidationEnabled(false);
            }
        }
        if ((option = pyDic.get(STAGE_MODE).toString()) != null && !option.equals(NONE)) {
            depOptions.setStageMode(option);
        }
        if ((option = pyDic.get(TEST_MODE).toString()) != null && !option.equals(NONE)) {
            if (option.toLowerCase(Locale.US).equals(TRUE)) {
                depOptions.setTestMode(true);
            } else if (option.toLowerCase(Locale.US).equals(FALSE)) {
                depOptions.setTestMode(false);
            }
        }
        if ((option = pyDic.get(ARCHIVE_VERSION).toString()) != null && !option.equals(NONE)) {
            depOptions.setArchiveVersion(option);
        }
        if ((option = pyDic.get(PLAN_VERSION).toString()) != null && !option.equals(NONE)) {
            depOptions.setPlanVersion(option);
        }
        if ((option = pyDic.get(LIBRARY_SPEC_VERSION).toString()) != null && !option.equals(NONE)) {
            depOptions.setLibSpecVersion(option);
        }
        if ((option = pyDic.get(LIBRARY_IMPL_VERSION).toString()) != null && !option.equals(NONE)) {
            depOptions.setLibImplVersion(option);
        }
        if ((option = pyDic.get(ALT_DD).toString()) != null && !option.equals(NONE)) {
            depOptions.setAltDD(option);
        }
        if ((option = pyDic.get(ALT_WLS_DD).toString()) != null && !option.equals(NONE)) {
            depOptions.setAltWlsDD(option);
        }
        if ((option = pyDic.get(VERSION_IDENTIFIER).toString()) != null && !option.equals(NONE)) {
            depOptions.setVersionIdentifier(option);
        }
        if ((option = pyDic.get(FORCE_UNDEPLOYMENT_TIMEOUT).toString()) != null && !option.equals(NONE)) {
            depOptions.setForceUndeployTimeout(Long.parseLong(option));
        }
        if ((option = pyDic.get(DEFAULT_SUBMODULE_TARGETS).toString()) != null && !option.equals(NONE)) {
            if (option.toLowerCase(Locale.US).equals(TRUE)) {
                depOptions.setDefaultSubmoduleTargets(true);
            } else if (option.toLowerCase(Locale.US).equals(FALSE)) {
                depOptions.setDefaultSubmoduleTargets(false);
            }
        }
        if ((option = pyDic.get(DEPLOYMENT_PRINCIPAL_NAME).toString()) != null && !option.equals(NONE)) {
            depOptions.setDeploymentPrincipalName(option);
        }
        if (TRUE.equalsIgnoreCase(option = pyDic.get(REMOTE).toString())) {
            depOptions.setRemote(true);
        }
        if ((deploymentOrder = pyDic.get(DEPLOYMENT_ORDER)) instanceof PyInteger) {
            depOptions.setDeploymentOrder(((PyInteger)deploymentOrder).getValue());
        }
        this.checkForUnrecognizedOptions(pyDic);
        return depOptions;
    }
}

