/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.scripting;

import java.rmi.Remote;
import weblogic.management.scripting.WLScriptContext;
import weblogic.management.scripting.utils.WLSTMsgTextFormatter;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.spi.EndPoint;

public class ManagedServerMonitor
implements DisconnectListener {
    private EndPoint endPoint;
    private WLScriptContext ctx;
    private static WLSTMsgTextFormatter txtFmt;

    public ManagedServerMonitor() {
    }

    public ManagedServerMonitor(String name, EndPoint ep, WLScriptContext ctx) {
        this.endPoint = ep;
        this.ctx = ctx;
        txtFmt = ctx.getWLSTMsgFormatter();
    }

    public void onDisconnect(DisconnectEvent event) {
        try {
            this.ctx.println(txtFmt.getLostConnection());
            this.endPoint.removeDisconnectListener(null, (DisconnectListener)this);
            this.ctx.wlstHelper.disconnect();
            this.ctx.connected = "false";
            if (this.ctx.isEditSessionInProgress) {
                this.ctx.resetEditSession();
            }
            this.ctx.dc("true");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void initialize(String name, Object ep, WLScriptContext ctx) {
        try {
            this.endPoint = (EndPoint)ep;
            this.ctx = ctx;
            Remote rm = null;
            this.endPoint.addDisconnectListener(rm, (DisconnectListener)this);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void removeDisconnectListener() {
        try {
            this.endPoint.removeDisconnectListener(null, (DisconnectListener)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

