/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.scripting;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.python.core.ArgParser;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import weblogic.management.MBeanHome;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.mbeanservers.MBeanTypeService;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.mbeanservers.edit.EditServiceMBean;
import weblogic.management.mbeanservers.runtime.RuntimeServiceMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.scripting.ChangeListener;
import weblogic.management.scripting.EditListener;
import weblogic.management.scripting.ManagedServerMonitor;
import weblogic.management.scripting.ScriptException;
import weblogic.management.scripting.WLScriptContext;
import weblogic.management.scripting.utils.WLSTMsgTextFormatter;
import weblogic.management.scripting.utils.WLSTUtil;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.security.UserConfigFileManager;
import weblogic.security.UsernameAndPassword;
import weblogic.security.internal.BootProperties;

class WLSTHelper {
    WLScriptContext wlCtx = null;
    String connectionResult = "";
    ServerRuntimeMBean serverRuntime = null;
    boolean isIIOP = false;
    boolean usingInSecureProtocol = true;
    private final String SERVER_NAME = "adminServerName";
    private static String NONE = "None";
    private WLSTMsgTextFormatter txtFmt;
    private boolean addedCompatChangeListener = false;
    private boolean addedEditChangeListener = false;

    public WLSTHelper(WLScriptContext ctx) {
        this.wlCtx = ctx;
        this.txtFmt = ctx.getWLSTMsgFormatter();
    }

    public synchronized void connect(PyObject[] args, String[] kw) throws ScriptException {
        this.wlCtx.commandType = "connect";
        try {
            ArgParser ap = new ArgParser("connect", args, kw, "username", "password", "url");
            String username = null;
            if (ap.getString(0) != null) {
                username = ap.getString(0);
            }
            char[] pwd = null;
            if (ap.getString(1) != null) {
                pwd = ap.getString(1).toCharArray();
            }
            boolean usingBootProps = false;
            if (username.length() == 0 && pwd.length == 0) {
                usingBootProps = true;
                this.wlCtx.printDebug("Will check if userConfig and userKeyFile should be used to connect to the server");
            }
            String url = ap.getString(2);
            PyDictionary objs = null;
            try {
                objs = (PyDictionary)ap.getPyObject(4);
            }
            catch (PyException pe) {
                objs = (PyDictionary)ap.getPyObject(3);
            }
            String userConfig = null;
            String userKey = null;
            String adminServerName = null;
            this.wlCtx.commandType = "connect";
            this.wlCtx.connectTimeout = 0;
            PyString pyConnectTimeout = new PyString("timeout");
            if (objs.has_key(pyConnectTimeout)) {
                String connectTimeout = objs.get(pyConnectTimeout).toString();
                this.wlCtx.printDebug("The connect timeout is " + connectTimeout);
                if (connectTimeout != null && !connectTimeout.equals(NONE)) {
                    this.wlCtx.connectTimeout = Integer.parseInt(connectTimeout);
                }
            }
            if (usingBootProps) {
                UsernameAndPassword UAndP;
                PyString pyuserConfigFile = new PyString("userConfigFile");
                PyString pyuserKeyFile = new PyString("userKeyFile");
                PyString pyserverName = new PyString("adminServerName");
                if (objs.has_key(pyuserConfigFile)) {
                    userConfig = objs.get(pyuserConfigFile).toString();
                    this.wlCtx.printDebug("The userConfig file location is " + userConfig);
                }
                if (objs.has_key(pyuserKeyFile)) {
                    userKey = objs.get(pyuserKeyFile).toString();
                    this.wlCtx.printDebug("The user key location is " + userKey);
                }
                if ((UAndP = UserConfigFileManager.getUsernameAndPassword(userConfig, userKey, "weblogic.management")) != null && UAndP.isUsernameSet() && UAndP.isPasswordSet()) {
                    username = UAndP.getUsername();
                    this.wlCtx.printDebug("The username is " + new String(username));
                    pwd = UAndP.getPassword();
                    this.wlCtx.printDebug("The password is ******");
                }
                if (username.length() == 0 && pwd.length == 0 && (adminServerName = objs.get(pyserverName).toString()).equals(NONE)) {
                    adminServerName = null;
                }
            }
            if (username.length() == 0 && pwd.length == 0 && this.wlCtx.isExecutingFromDomainDir()) {
                this.wlCtx.printDebug("wlst is invoked from a domain directory, hence we will try to load username and password from boot.properties file");
                HashMap uap = this.getUsernameAndPassword(adminServerName);
                if (uap != null) {
                    if (uap.get("username") != null) {
                        username = (String)uap.get("username");
                    }
                    if (uap.get("password") != null) {
                        pwd = ((String)uap.get("password")).toCharArray();
                    }
                    this.wlCtx.printDebug("loaded username and pwd from the boot.properties file");
                }
            }
            if (username.length() == 0 && pwd.length == 0) {
                String username2 = this.wlCtx.promptValue(this.txtFmt.getEnterUsername(), true);
                String pwd2 = null;
                pwd2 = this.wlCtx.promptValue(this.txtFmt.getEnterPassword(), false);
                if (username2.length() == 0) {
                    this.wlCtx.throwWLSTException(this.txtFmt.getEmptyUsername());
                } else {
                    username = username2;
                }
                if (pwd2.trim().length() == 0 || this.hasUnicodeCharacters(pwd2)) {
                    this.wlCtx.throwWLSTException(this.txtFmt.getEmptyPassword());
                } else {
                    pwd = pwd2.toCharArray();
                }
                if (url.length() == 0) {
                    url = this.wlCtx.promptValue(this.txtFmt.getEnterURL("t3://localhost:7001"), true);
                }
            }
            this.wlCtx.username_bytes = username.getBytes();
            this.wlCtx.password_bytes = new String(pwd).getBytes();
            if (url.length() == 0) {
                url = "t3://localhost:7001";
                this.wlCtx.printDebug(this.txtFmt.getUseDefaultURL(url));
            }
            url = this.checkUrlSanity(url);
            if (this.isIIOP) {
                // empty if block
            }
            this.wlCtx.url = url;
            this.initConnections();
            this.wlCtx.newBrowseHandler.configRuntimeNavigatedBefore = true;
            this.wlCtx.newBrowseHandler.configRuntime();
        }
        catch (Throwable th) {
            if (th instanceof ScriptException) {
                throw (ScriptException)th;
            }
            if (th instanceof IllegalArgumentException) {
                this.wlCtx.throwWLSTException("Authentication Failed.", th);
            }
            this.wlCtx.throwWLSTException("Error connecting to the server", th);
        }
    }

    public synchronized void disconnect() {
        this.wlCtx.printDebug("OnDisconnect event occurred");
    }

    private boolean hasUnicodeCharacters(String s) {
        char[] cs = s.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            if (!Character.isUnicodeIdentifierPart(cs[i]) || cs.length != 4) continue;
            this.wlCtx.printDebug("Found a Unicode character in the string specified, hence this string will be considered empty");
            return true;
        }
        return false;
    }

    private HashMap getUsernameAndPassword(String adminServerName) {
        HashMap map = null;
        if (adminServerName == null) {
            File bootProps = new File("./boot.properties");
            if (bootProps.exists()) {
                map = this.loadUsernameAndPasswordFromBootProperties(bootProps);
                return map;
            }
            File serverDir = new File("./servers/myserver/security/boot.properties");
            if (serverDir.exists()) {
                map = this.loadUsernameAndPasswordFromBootProperties(serverDir);
                return map;
            }
        } else {
            File bootProps = new File("./servers/" + adminServerName + "/security/boot.properties");
            if (bootProps.exists()) {
                map = this.loadUsernameAndPasswordFromBootProperties(bootProps);
                return map;
            }
            return null;
        }
        return null;
    }

    private HashMap loadUsernameAndPasswordFromBootProperties(File bootProps) {
        return WLSTHelper.loadUsernameAndPasswordFromBootProperties(bootProps, ".");
    }

    public static HashMap loadUsernameAndPasswordFromBootProperties(File bootProps, String domainDir) {
        File saltFile = new File(domainDir + File.separator + "security" + File.separator + "SerializedSystemIni.dat");
        if (saltFile.exists()) {
            BootProperties.load(bootProps.getAbsolutePath(), false);
            BootProperties props = BootProperties.getBootProperties();
            if (props.getOneClient().length() == 0) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("username", props.getOneClient());
            map.put("password", props.getTwoClient());
            BootProperties.unload(false);
            return map;
        }
        return null;
    }

    private void initConnections() throws Throwable {
        String msg = this.txtFmt.getConnectingToURL(this.wlCtx.url, new String(this.wlCtx.username_bytes));
        this.wlCtx.println(msg);
        this.initDeprecatedConnection(new String(this.wlCtx.username_bytes), new String(this.wlCtx.password_bytes), this.wlCtx.url);
        this.initRuntimeServerConnection();
        if (this.wlCtx.isAdminServer) {
            this.initDomainRuntimeServerConnection();
            this.initEditServerConnection();
        }
        this.initJsr77ServerConnection();
        this.determineServerInfo(this.serverRuntime);
        this.verifyServerConections();
        this.setLoggingLevel();
    }

    public void addEditChangeListener() throws Throwable {
        if (!this.wlCtx.isAdminServer || this.isIIOP || this.addedEditChangeListener) {
            return;
        }
        this.addedEditChangeListener = true;
        this.wlCtx.printDebug("Adding the edit change listener ...");
        ChangeListener clForEditTree = new ChangeListener();
        ObjectName on = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        if (this.wlCtx.getMBSConnection("ConfigEdit") != null) {
            this.wlCtx.getMBSConnection("ConfigEdit").addNotificationListener(on, clForEditTree, null, null);
        }
        this.wlCtx.printDebug("Done adding the edit change listener ...");
    }

    public void addCompatChangeListener() throws Throwable {
        if (!this.wlCtx.isAdminServer || this.isIIOP || this.addedCompatChangeListener) {
            return;
        }
        this.addedCompatChangeListener = true;
        this.wlCtx.printDebug("Adding the compatibility change listener ...");
        ChangeListener clForDepTree = new ChangeListener();
        ObjectName on = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        if (this.wlCtx.getMBSConnection("Domain") != null) {
            this.wlCtx.getMBSConnection("Domain").addNotificationListener(on, clForDepTree, null, null);
        }
        this.wlCtx.printDebug("Done adding the compatibility change listener ...");
    }

    private void verifyServerConections() throws Throwable {
        this.wlCtx.println(this.txtFmt.getConnected(this.connectionResult));
        if (this.usingInSecureProtocol) {
            this.wlCtx.println(this.txtFmt.getInsecureProtocol());
        }
    }

    private String checkUrlSanity(String url) {
        if (url.startsWith("t3s") || url.startsWith("https")) {
            this.usingInSecureProtocol = false;
        } else if (url.startsWith("iiops")) {
            this.usingInSecureProtocol = false;
        }
        if (url.startsWith("t3") || url.startsWith("http")) {
            return url;
        }
        if (url.startsWith("iiop")) {
            this.isIIOP = true;
            return url;
        }
        url = "t3://" + url;
        return url;
    }

    void dumpAllMBeans(MBeanServerConnection connection, String server) throws Throwable {
        System.out.println("\n\n############ DUMPING ALL MBEANS FOR " + server + " ############\n\n");
        ObjectName pattern = new ObjectName("*:*");
        Set<ObjectName> set = connection.queryNames(pattern, null);
        System.out.println("There are " + set.size() + " MBeans in this MBeanServer");
        Iterator<ObjectName> i = set.iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
        System.out.println("\n\n############ DONE DUMPING ALL MBEANS FOR " + server + " ############\n\n");
    }

    void initRuntimeServerConnection() throws Throwable {
        this.wlCtx.printDebug("Initing the RuntimeServer Connection");
        try {
            this.wlCtx.runtimeMSC = this.lookupMBeanServerConnection("weblogic.management.mbeanservers.runtime");
            ObjectName rserviceON = new ObjectName(RuntimeServiceMBean.OBJECT_NAME);
            this.wlCtx.runtimeServiceMBean = (RuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)this.wlCtx.runtimeMSC, (ObjectName)rserviceON);
            this.wlCtx.runtimeDomainMBean = this.wlCtx.runtimeServiceMBean.getDomainConfiguration();
            this.serverRuntime = this.wlCtx.runtimeServerRuntimeMBean = this.wlCtx.runtimeServiceMBean.getServerRuntime();
            ObjectName typeON = new ObjectName(MBeanTypeService.OBJECT_NAME);
            this.wlCtx.mbeanTypeService = (MBeanTypeService)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)this.wlCtx.runtimeMSC, (ObjectName)typeON);
            this.wlCtx.printDebug("Got the RuntimeServiceMBean, the Domain Configuration and the ServerRuntime MBean");
            this.wlCtx.printDebug("Initialized the Runtime Server information");
            this.wlCtx.isRuntimeServerEnabled = true;
            this.wlCtx.connected = "true";
            this.wlCtx.atDomainLevel = true;
            this.wlCtx.serverName = this.serverRuntime.getName();
            this.wlCtx.domainName = this.wlCtx.runtimeDomainMBean.getName();
            WLSTUtil.disconnected = false;
        }
        catch (Exception inf) {
            this.wlCtx.println(this.txtFmt.getRuntimeMBSNotEnabled());
            this.wlCtx.stackTrace = inf;
            this.wlCtx.throwWLSTException(this.txtFmt.getFailedToConnect(), inf);
        }
    }

    void initDomainRuntimeServerConnection() throws Throwable {
        try {
            this.wlCtx.domainRTMSC = this.lookupMBeanServerConnection("weblogic.management.mbeanservers.domainruntime");
            ObjectName drsOn = new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME);
            this.wlCtx.domainRuntimeServiceMBean = (DomainRuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)this.wlCtx.domainRTMSC, (ObjectName)drsOn);
            this.wlCtx.configDomainRuntimeDRMBean = this.wlCtx.domainRuntimeServiceMBean.getDomainConfiguration();
            this.wlCtx.runtimeDomainRuntimeDRMBean = this.wlCtx.domainRuntimeServiceMBean.getDomainRuntime();
            this.wlCtx.isDomainRuntimeServerEnabled = true;
            if (this.serverRuntime == null) {
                this.wlCtx.printDebug("Only the DomainRuntimeServer is enabled.");
            }
            this.wlCtx.printDebug("Initialized the Domain Runtime connection");
        }
        catch (Exception inf) {
            inf.printStackTrace();
            this.wlCtx.println(this.txtFmt.getDomainRuntimeMBSNotEnabled());
            this.wlCtx.stackTrace = inf;
            this.wlCtx.throwWLSTException(this.txtFmt.getFailedToConnect(), inf);
        }
    }

    void initEditServerConnection() throws Throwable {
        this.wlCtx.printDebug("Initing the EditServer Connection");
        try {
            this.wlCtx.editMSC = this.lookupMBeanServerConnection("weblogic.management.mbeanservers.edit");
            ObjectName editServiceON = new ObjectName(EditServiceMBean.OBJECT_NAME);
            this.wlCtx.editServiceMBean = (EditServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)this.wlCtx.editMSC, (ObjectName)editServiceON);
            this.wlCtx.editDomainMBean = this.wlCtx.editServiceMBean.getDomainConfiguration();
            this.wlCtx.configurationManager = this.wlCtx.editServiceMBean.getConfigurationManager();
            this.wlCtx.printDebug("Got the EditServiceMBean, the Domain Configuration and the Configuration manager MBean");
            this.wlCtx.printDebug("Initialized the Edit Server information");
            this.wlCtx.isEditServerEnabled = true;
        }
        catch (Exception inf) {
            this.wlCtx.print(this.txtFmt.getEditMBSNotEnabled());
            this.wlCtx.stackTrace = inf;
            return;
        }
    }

    private void addEditListener() {
        try {
            ObjectName con = this.wlCtx.getObjectName(this.wlCtx.configurationManager);
            EditListener el = new EditListener();
            AttributeChangeNotificationFilter acf = new AttributeChangeNotificationFilter();
            acf.enableAttribute("CurrentEditor");
            this.wlCtx.editMSC.addNotificationListener(con, el, null, null);
            EditListener _el = new EditListener();
            this.wlCtx.runtimeMSC.addNotificationListener(con, _el, null, null);
        }
        catch (InstanceNotFoundException inf) {
            inf.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void initJsr77ServerConnection() throws Throwable {
    }

    private void populateInitialContext() throws ScriptException {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        h.put("java.naming.provider.url", this.wlCtx.url);
        h.put("java.naming.security.principal", new String(this.wlCtx.username_bytes));
        h.put("java.naming.security.credentials", new String(this.wlCtx.password_bytes));
        try {
            this.wlCtx.iContext = new InitialContext(h);
        }
        catch (CommunicationException ce) {
            this.wlCtx.throwWLSTException(this.getRightErrorMessage(ce), ce);
        }
        catch (NamingException ne) {
            if (ne instanceof CommunicationException) {
                Throwable th = ne.getRootCause();
                this.wlCtx.errorMsg = this.getRightErrorMessage(th);
            } else if (ne instanceof AuthenticationException) {
                AuthenticationException ae = (AuthenticationException)ne;
                SecurityException se = (SecurityException)ae.getRootCause();
                this.wlCtx.errorMsg = se.getMessage() != null ? se.getMessage() : "The username or password supplied are incorrect. Please try again";
            } else if (ne instanceof ConfigurationException) {
                this.wlCtx.errorMsg = "The url specified is malformed. Please correct it.";
            }
            this.wlCtx.throwWLSTException(this.wlCtx.errorMsg, ne);
        }
    }

    private String getRightErrorMessage(Throwable th) {
        String result = "";
        result = th.getMessage() != null && th.getMessage().indexOf("Tunneling result unspecified - is the HTTP server at host") != -1 && this.wlCtx.url.startsWith("http") ? "Cannot connect via http. Connecting through 'http' will require you to enable 'TunnellingEnabled' attribute on the ServerMBean to 'true'" : (th.getMessage() != null && th.getMessage().indexOf("javax.net.ssl.SSLKeyException") != -1 ? "Cannot connect via SSL.To connect via SSL, use the following two System properties as shown, java -Dweblogic.security.SSL.ignoreHostnameVerification=true -Dweblogic.security.TrustKeyStore=DemoTrust weblogic.WLST" : "Error getting the initial context. There is no server running at " + this.wlCtx.url);
        return result;
    }

    private void initDeprecatedConnection(String username, String pwd, String url) throws Throwable {
        try {
            this.populateInitialContext();
            this.wlCtx.home = (MBeanHome)this.wlCtx.iContext.lookup("weblogic.management.home.localhome");
            this.wlCtx.mbs = this.wlCtx.home.getMBeanServer();
            this.wlCtx.compatMBS = (MBeanServer)this.wlCtx.mbs;
            Set set = this.wlCtx.home.getMBeansByType("ServerRuntime");
            this.serverRuntime = (ServerRuntimeMBean)set.iterator().next();
            this.wlCtx.serverName = this.serverRuntime.getName();
            this.wlCtx.username_bytes = username.getBytes();
            this.wlCtx.password_bytes = pwd.getBytes();
            this.wlCtx.setHome(this.wlCtx.home);
            this.wlCtx.domainName = this.serverRuntime.getObjectName() == null ? this.wlCtx.home.getActiveDomain().getName() : this.serverRuntime.getObjectName().getDomain();
            this.wlCtx.version = this.serverRuntime.getWeblogicVersion();
            if (!this.isIIOP) {
                this.addPeerMonitor(this.wlCtx.serverName, this.wlCtx.home, 9);
            }
            ObjectName don = new ObjectName(this.wlCtx.domainName + ":Name=" + this.wlCtx.domainName + ",Type=DomainRuntime,Location=" + this.wlCtx.serverName);
            try {
                Object obj = this.wlCtx.home.getProxy(don);
            }
            catch (Exception e) {
                this.wlCtx.printDebug("Connecting to a server that is running in MSI mode");
                this.wlCtx.isAdminServer = false;
            }
            if (this.wlCtx.isAdminServer) {
                this.wlCtx.wlcmo = this.wlCtx.home.getAdminMBean(this.wlCtx.domainName, "Domain");
                this.wlCtx.compatDomainMBean = (DomainMBean)this.wlCtx.wlcmo;
                this.wlCtx.compatDomainRuntimeMBean = null;
                this.wlCtx.adminHome = (MBeanHome)this.wlCtx.iContext.lookup("weblogic.management.adminhome");
                this.wlCtx.printDebug("The domain type is going to be " + this.wlCtx.domainType);
                this.wlCtx.domainType = "Domain";
            } else {
                this.wlCtx.wlcmo = this.wlCtx.home.getConfigurationMBean(this.wlCtx.domainName, "DomainConfig");
                this.wlCtx.compatDomainMBean = (DomainMBean)this.wlCtx.wlcmo;
                this.wlCtx.compatServerRuntimeMBean = (ServerRuntimeMBean)this.wlCtx.home.getMBeansByType("ServerRuntime").iterator().next();
                this.wlCtx.printDebug("The domain type is going to be " + this.wlCtx.domainType);
                this.wlCtx.domainType = "DomainConfig";
            }
            this.wlCtx.mbs = this.wlCtx.home.getMBeanServer();
            this.wlCtx.connected = "true";
            this.wlCtx.atDomainLevel = true;
            this.wlCtx.beans.add(this.wlCtx.wlcmo);
            WLSTUtil.disconnected = false;
            this.wlCtx.isCompatabilityServerEnabled = true;
        }
        catch (Exception e) {
            if (e instanceof ScriptException) {
                throw e;
            }
            if (this.wlCtx.debug) {
                e.printStackTrace();
            }
            this.wlCtx.print(this.txtFmt.getCompatibilityMBSNotEnabled());
            this.wlCtx.isCompatabilityServerEnabled = false;
            this.wlCtx.stackTrace = e;
            return;
        }
    }

    private void determineServerInfo(ServerRuntimeMBean srbean) {
        if (this.wlCtx.isAdminServer) {
            if (this.wlCtx.domainName == null) {
                this.wlCtx.domainName = this.serverRuntime.getObjectName().getDomain();
            }
            this.connectionResult = "to Admin Server '" + this.wlCtx.serverName + "' that belongs to domain '" + this.wlCtx.domainName + "'.";
        } else {
            if (this.wlCtx.domainName == null) {
                this.wlCtx.domainName = this.serverRuntime.getObjectName().getDomain();
            }
            this.connectionResult = "to managed Server '" + this.wlCtx.serverName + "' that belongs to domain '" + this.wlCtx.domainName + "'.";
            this.wlCtx.printDebug("Checking if this server belongs to any cluster");
        }
    }

    private MBeanServerConnection lookupMBeanServerConnection(String jndiName) throws Exception {
        String host = this.wlCtx.getListenAddress(this.wlCtx.url);
        int port = Integer.parseInt(this.wlCtx.getListenPort(this.wlCtx.url));
        String protocol = this.wlCtx.getProtocol(this.wlCtx.url);
        JMXServiceURL serviceURL = new JMXServiceURL(protocol, host, port, "/jndi/" + jndiName);
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        h.put("java.naming.security.principal", new String(this.wlCtx.username_bytes));
        h.put("java.naming.security.credentials", new String(this.wlCtx.password_bytes));
        h.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        if (this.wlCtx.connectTimeout > 0) {
            h.put("jmx.remote.x.request.waiting.timeout", new Long(this.wlCtx.connectTimeout));
        } else {
            h.put("jmx.remote.x.request.waiting.timeout", new Long(0L));
        }
        JMXConnector connector = JMXConnectorFactory.connect(serviceURL, h);
        this.wlCtx.jmxConnectors.add(connector);
        return connector.getMBeanServerConnection();
    }

    private void addPeerMonitor(String serverName, Object remoteRef, int ver) {
        try {
            this.wlCtx.ep = RemoteHelper.getEndPoint((Object)remoteRef);
            this.wlCtx.msMonitor = new ManagedServerMonitor(serverName, this.wlCtx.ep, this.wlCtx);
            this.wlCtx.msMonitor.initialize(serverName, this.wlCtx.ep, this.wlCtx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setLoggingLevel() {
        WLSTHelper wLSTHelper = this;
        for (String log : wLSTHelper.wlCtx.getLoggersList()) {
            Logger.getLogger(log).setLevel(Level.OFF);
        }
    }
}

