/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.scripting;

import java.io.IOException;
import java.util.ArrayList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import weblogic.descriptor.DescriptorClassLoader;
import weblogic.utils.StringUtils;

public class WLSTPathUtil {
    private static final String JMS_SR = "JMSSystemResources";
    private static final String JDBC_SR = "JDBCSystemResources";
    private static final String WLDF_SR = "WLDFSystemResources";
    private static final String REALM_MBEAN = "weblogic.management.security.RealmMBean";
    private static final String SECURITY_STORE_MBEAN = "weblogic.management.security.RDBMSSecurityStoreMBean";
    private static final String ULM_MBEAN = "weblogic.management.security.authentication.UserLockoutManagerMBean";
    private static final String PROVIDER_MBEAN = "weblogic.management.security.ProviderMBean";

    public static String lookupPath(MBeanServerConnection mBeanServerConnection, String string, ObjectName objectName) throws Exception {
        String string2;
        Object object;
        Object object2;
        Object object3;
        String string3;
        ObjectName objectName2;
        String string4;
        ObjectName objectName3;
        block15: {
            objectName3 = objectName;
            string4 = objectName.getKeyProperty("Name");
            objectName2 = null;
            string3 = null;
            try {
                objectName2 = (ObjectName)mBeanServerConnection.getAttribute(objectName3, "Parent");
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                object3 = objectName3.getKeyProperty("Parent");
                if (object3 != null) {
                    if (((String)object3).indexOf("/") == -1) {
                        return null;
                    }
                    object2 = ((String)object3).substring(((String)object3).indexOf("/"), ((String)object3).length());
                    int n = ((String)object2).indexOf("[");
                    object = ((String)object2).substring(1, n);
                    string2 = ((String)object2).substring(n + 1, ((String)object2).length() - 1);
                    if (((String)object).equals(JMS_SR) || ((String)object).equals(JDBC_SR) || ((String)object).equals(WLDF_SR)) {
                        return WLSTPathUtil.getSystemResourcePath(objectName3.getKeyProperty("Path"), (String)object, string2);
                    }
                }
                object2 = (ModelMBeanInfo)((Object)mBeanServerConnection.getMBeanInfo(objectName));
                String string5 = object2.getClassName();
                object = DescriptorClassLoader.loadClass((String)string5);
                if (!WLSTPathUtil.isSecurityMBean((Class)object)) break block15;
                string2 = "SecurityConfiguration/" + string;
                if (WLSTPathUtil.isRealm((Class)object)) {
                    string2 = string2 + "/Realms/" + objectName.getKeyProperty("Name");
                    return string2;
                }
                if (WLSTPathUtil.isProvider((Class)object)) {
                    ObjectName objectName4 = WLSTPathUtil.findRealmON(objectName, mBeanServerConnection);
                    String string6 = WLSTPathUtil.getAttributeNameFromRealm(objectName4, objectName, mBeanServerConnection);
                    if (string6 != null) {
                        string2 = WLSTPathUtil.lookupPath(mBeanServerConnection, string, objectName4);
                        string2 = string2 + "/" + string6 + "/" + (String)mBeanServerConnection.getAttribute(objectName, "Name");
                        return string2;
                    }
                }
                if (!WLSTPathUtil.isUserLockOut((Class)object)) break block15;
                ObjectName objectName5 = WLSTPathUtil.findRealmON(objectName, mBeanServerConnection);
                string2 = WLSTPathUtil.lookupPath(mBeanServerConnection, string, objectName5);
                string2 = string2 + "/UserLockoutManager/UserLockoutManager";
                return string2;
            }
        }
        while (string4 == null && objectName2 != null) {
            string4 = objectName2.getKeyProperty("Name");
            objectName2 = (ObjectName)mBeanServerConnection.getAttribute(objectName3, "Parent");
        }
        String string7 = WLSTPathUtil.getRightType(objectName3.getKeyProperty("Type"), (ObjectName)mBeanServerConnection.getAttribute(objectName3, "Parent"), mBeanServerConnection);
        object3 = (ObjectName)mBeanServerConnection.getAttribute(objectName3, "Parent");
        if (object3 != null) {
            string7 = WLSTPathUtil.getTheRightAttributeName(mBeanServerConnection, (ObjectName)object3, string7);
        }
        object2 = string7 + "/" + string4;
        String string8 = "";
        while (!(object3 == null || mBeanServerConnection.isInstanceOf((ObjectName)object3, "weblogic.management.configuration.DomainMBean") || mBeanServerConnection.isInstanceOf((ObjectName)object3, "weblogic.management.runtime.DomainRuntimeMBean") || mBeanServerConnection.isInstanceOf((ObjectName)object3, "weblogic.management.runtime.ServerRuntimeMBean"))) {
            object = WLSTPathUtil.getRightType(((ObjectName)object3).getKeyProperty("Type"), (ObjectName)mBeanServerConnection.getAttribute((ObjectName)object3, "Parent"), mBeanServerConnection);
            if (mBeanServerConnection.getAttribute((ObjectName)object3, "Parent") != null) {
                object = WLSTPathUtil.getTheRightAttributeName(mBeanServerConnection, (ObjectName)mBeanServerConnection.getAttribute((ObjectName)object3, "Parent"), (String)object);
            }
            if (((String)object).equals("Application") || ((String)object).equals("ComponentRuntimes")) {
                string3 = objectName3.getKeyProperty("Name");
            }
            string8 = string8.length() == 0 ? (String)object + "/" + ((ObjectName)object3).getKeyProperty("Name") + string8 : (String)object + "/" + ((ObjectName)object3).getKeyProperty("Name") + "/" + string8;
            if (((String)object).equals("Application")) {
                string3 = ((ObjectName)object3).getKeyProperty("Name");
            }
            if (mBeanServerConnection.getAttribute((ObjectName)object3, "Parent") != null) {
                object3 = (ObjectName)mBeanServerConnection.getAttribute((ObjectName)object3, "Parent");
                continue;
            }
            object3 = objectName3;
        }
        object = "";
        object = string8.length() != 0 ? string8 + "/" + (String)object2 : object2;
        string2 = WLSTPathUtil.hackThePath((String)object, string3);
        return string2;
    }

    private static String getTheRightAttributeName(MBeanServerConnection mBeanServerConnection, ObjectName objectName, String string) throws Exception {
        ModelMBeanInfo modelMBeanInfo = (ModelMBeanInfo)((Object)mBeanServerConnection.getMBeanInfo(objectName));
        MBeanAttributeInfo[] mBeanAttributeInfoArray = modelMBeanInfo.getAttributes();
        String string2 = "";
        string2 = string.endsWith("Runtime") ? "weblogic.management.runtime." + string + "MBean" : "weblogic.management.configuration." + string + "MBean";
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            Descriptor descriptor = ((ModelMBeanAttributeInfo)mBeanAttributeInfoArray[i]).getDescriptor();
            String string3 = (String)((ModelMBeanAttributeInfo)mBeanAttributeInfoArray[i]).getDescriptor().getFieldValue("interfaceClassName");
            if (string3 == null) continue;
            if (string3.startsWith("[L")) {
                string3 = string3.substring(2, string3.length() - 1);
            }
            if (string2.equals(string3)) {
                return mBeanAttributeInfoArray[i].getName();
            }
            if (!string3.endsWith("MBean") || !Class.forName(string3).isAssignableFrom(Class.forName(string2)) || mBeanAttributeInfoArray[i].getName().equals("Parent") || mBeanAttributeInfoArray[i].getName().equals("Targets")) continue;
            return mBeanAttributeInfoArray[i].getName();
        }
        return string;
    }

    private static String getSystemResourcePath(String string, String string2, String string3) {
        String string4;
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n < string.length()) {
            int n3 = string.indexOf("[", n);
            if (n3 != -1) {
                n2 = string.indexOf("]", n3);
            }
            if (n3 == -1 || n2 == -1) {
                stringBuffer.append(string.substring(n));
                break;
            }
            string4 = string.substring(n3 + 1, n2);
            arrayList.add(string4);
            stringBuffer.append(string.substring(n, n3));
            stringBuffer.append("[]");
            n = n2 + 1;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string2);
        stringBuffer2.append("/");
        stringBuffer2.append(string3);
        string4 = string3;
        String[] stringArray = StringUtils.splitCompletely((String)stringBuffer.toString(), (String)"/");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer2.append("/");
            int n4 = stringArray[i].indexOf("[]");
            if (n4 != -1) {
                string4 = (String)arrayList.remove(0);
                stringBuffer2.append(stringArray[i].substring(0, n4));
            } else {
                stringBuffer2.append(stringArray[i]);
            }
            stringBuffer2.append("/");
            stringBuffer2.append(string4);
        }
        return stringBuffer2.toString();
    }

    private static String getAttributeNameFromRealm(ObjectName objectName, ObjectName objectName2, MBeanServerConnection mBeanServerConnection) throws Exception {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanServerConnection.getMBeanInfo(objectName).getAttributes();
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            ObjectName[] objectNameArray;
            MBeanAttributeInfo mBeanAttributeInfo = mBeanAttributeInfoArray[i];
            if (mBeanAttributeInfo.getType().equals("javax.management.ObjectName")) {
                objectNameArray = (ObjectName[])mBeanServerConnection.getAttribute(objectName, mBeanAttributeInfo.getName());
                if (objectNameArray == null || !objectNameArray.toString().equals(objectName2.toString())) continue;
                return mBeanAttributeInfo.getName();
            }
            if (!mBeanAttributeInfo.getType().equals("[Ljavax.management.ObjectName;") || (objectNameArray = (ObjectName[])mBeanServerConnection.getAttribute(objectName, mBeanAttributeInfo.getName())) == null || objectNameArray.length <= 0) continue;
            for (int j = 0; j < objectNameArray.length; ++j) {
                if (!objectNameArray[j].toString().equals(objectName2.toString())) continue;
                return mBeanAttributeInfo.getName();
            }
        }
        return null;
    }

    private static ObjectName findRealmON(ObjectName objectName, MBeanServerConnection mBeanServerConnection) throws MBeanException, AttributeNotFoundException, ReflectionException, InstanceNotFoundException, IOException {
        return (ObjectName)mBeanServerConnection.getAttribute(objectName, "Realm");
    }

    private static String hackThePath(String string, String string2) {
        if (string.startsWith("/Application/") || string.startsWith("Application/")) {
            String string3 = string.replaceFirst("Application/" + string2, "AppDeployments/" + string2 + "/AppMBean/" + string2);
            return string3;
        }
        if (string.indexOf("/EJBTransactionRuntime/") != -1) {
            String string4 = StringUtils.replaceGlobal((String)string, (String)"/EJBTransactionRuntime/", (String)("/EJBRuntimes/" + string2 + "/TransactionRuntime/"));
            return string4;
        }
        if (string.indexOf("/EJBCacheRuntime/") != -1) {
            String string5 = StringUtils.replaceGlobal((String)string, (String)"/EJBCacheRuntime/", (String)("/EJBRuntimes/" + string2 + "/CacheRuntime/"));
            return string5;
        }
        if (string.indexOf("/EJBLockingRuntime/") != -1) {
            String string6 = StringUtils.replaceGlobal((String)string, (String)"/EJBLockingRuntime/", (String)("/EJBRuntimes/" + string2 + "/LockingRuntime/"));
            return string6;
        }
        if (string.indexOf("/EJBPoolRuntime/") != -1) {
            String string7 = StringUtils.replaceGlobal((String)string, (String)"/EJBPoolRuntime/", (String)("/EJBRuntimes/" + string2 + "/PoolRuntime/"));
            return string7;
        }
        return string;
    }

    private static String getRightType(String string, ObjectName objectName, MBeanServerConnection mBeanServerConnection) {
        if (objectName == null) {
            return string + "s";
        }
        try {
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanServerConnection.getMBeanInfo(objectName).getAttributes();
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                Class<?> clazz;
                MBeanAttributeInfo mBeanAttributeInfo = mBeanAttributeInfoArray[i];
                String string2 = mBeanAttributeInfo.getName();
                String string3 = mBeanAttributeInfo.getType();
                String string4 = string;
                if (mBeanAttributeInfo.getName().startsWith(string)) {
                    if (mBeanAttributeInfo.getType().indexOf("MBean") == -1) continue;
                    return mBeanAttributeInfo.getName();
                }
                String string5 = mBeanAttributeInfo.getType();
                if (string5.startsWith("[L") && string5.indexOf("MBean") != -1) {
                    clazz = Class.forName(string5 = string5.substring(2, string5.length() - 1));
                    if (!clazz.isAssignableFrom(Class.forName(string4 = string4.endsWith("Runtime") ? "weblogic.management.runtime." + string4 + "MBean" : "weblogic.management.configuration." + string4 + "MBean"))) continue;
                    return mBeanAttributeInfo.getName();
                }
                if (mBeanAttributeInfo.getType().indexOf("MBean") == -1 || mBeanAttributeInfo.getType().equals("weblogic.management.WebLogicMBean")) continue;
                clazz = Class.forName(string5);
                if (!clazz.isAssignableFrom(Class.forName(string4 = string4.endsWith("Runtime") ? "weblogic.management.runtime." + string4 + "MBean" : "weblogic.management.configuration." + string4 + "MBean"))) continue;
                return mBeanAttributeInfo.getName();
            }
        }
        finally {
            return string;
        }
        {
        }
    }

    private static boolean isSecurityMBean(Class clazz) throws ClassNotFoundException {
        return Class.forName(REALM_MBEAN).isAssignableFrom(clazz) || Class.forName(PROVIDER_MBEAN).isAssignableFrom(clazz) || Class.forName(ULM_MBEAN).isAssignableFrom(clazz) || Class.forName(SECURITY_STORE_MBEAN).isAssignableFrom(clazz);
    }

    private static boolean isRealm(Class clazz) throws ClassNotFoundException {
        return Class.forName(REALM_MBEAN).isAssignableFrom(clazz);
    }

    private static boolean isProvider(Class clazz) throws ClassNotFoundException {
        return Class.forName(PROVIDER_MBEAN).isAssignableFrom(clazz);
    }

    private static boolean isUserLockOut(Class clazz) throws ClassNotFoundException {
        return Class.forName(ULM_MBEAN).isAssignableFrom(clazz);
    }
}

