/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.scripting;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;
import weblogic.management.WebLogicMBean;
import weblogic.management.commo.StandardInterface;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.scripting.ScriptException;
import weblogic.management.scripting.WLSTUtils;

public class WLSTTreeUtils
extends WLSTUtils {
    public String getTree() {
        if (this.domainType.equals("RuntimeConfigServerDomain")) {
            return "serverConfig";
        }
        if (this.domainType.equals("RuntimeRuntimeServerDomain")) {
            return "serverRuntime";
        }
        if (this.domainType.equals("ConfigDomainRuntime")) {
            return "domainConfig";
        }
        if (this.domainType.equals("RuntimeDomainRuntime")) {
            return "domainRuntime";
        }
        if (this.domainType.equals("Domain")) {
            return "config";
        }
        if (this.domainType.equals("DomainConfig")) {
            return "config";
        }
        if (this.domainType.equals("DomainRuntime")) {
            return "runtime";
        }
        if (this.domainType.equals("Custom_Domain")) {
            return "custom";
        }
        if (this.domainType.equals("DomainCustom_Domain")) {
            return "domainCustom";
        }
        if (this.domainType.equals("ConfigEdit")) {
            return "edit";
        }
        if (this.domainType.equals("JSR77")) {
            return "jsr77";
        }
        if (this.domainType.equals("JNDI")) {
            return "jndi";
        }
        return "serverConfig";
    }

    String getTreeFromArgument(String attr) {
        if (attr.startsWith("config:")) {
            return "config";
        }
        if (attr.startsWith("runtime:")) {
            return "runtime";
        }
        if (attr.startsWith("adminConfig:")) {
            return "adminConfig";
        }
        if (attr.startsWith("custom:")) {
            return "custom";
        }
        if (attr.startsWith("domainCustom:")) {
            return "domainCustom";
        }
        if (attr.startsWith("jndi:")) {
            return "jndi";
        }
        if (attr.startsWith("serverConfig:")) {
            return "serverConfig";
        }
        if (attr.startsWith("serverRuntime:")) {
            return "serverRuntime";
        }
        if (attr.startsWith("domainConfig:")) {
            return "domainConfig";
        }
        if (attr.startsWith("domainRuntime:")) {
            return "domainRuntime";
        }
        if (attr.startsWith("edit:")) {
            return "edit";
        }
        return null;
    }

    String removeTreeFromArgument(String attr) {
        if (attr.startsWith("config:") || attr.startsWith("runtime:") || attr.startsWith("adminConfig:") || attr.startsWith("custom:") || attr.startsWith("domainCustom:") || attr.startsWith("jndi:") || attr.startsWith("serverConfig:") || attr.startsWith("serverRuntime:") || attr.startsWith("domainConfig:") || attr.startsWith("domainRuntime:") || attr.startsWith("edit:")) {
            String _attr = attr.substring(attr.indexOf(":/") + 1, attr.length());
            return _attr;
        }
        return attr;
    }

    String getCurrentTree() {
        return this.getTree();
    }

    public String calculateTabSpace(String s) {
        String tabSpace = "";
        for (int k = 0; k < 45 - s.length(); ++k) {
            tabSpace = tabSpace + " ";
        }
        return tabSpace;
    }

    public String calculateTabSpace(String s, int i) {
        String tabSpace = "";
        for (int k = 0; k < i - s.length(); ++k) {
            tabSpace = tabSpace + " ";
        }
        return tabSpace;
    }

    boolean isMBeanExcluded(String bean) {
        return excludedMBeans.contains(bean);
    }

    boolean isAnythingInThisExcluded(String key) {
        if (key == null) {
            return false;
        }
        for (String excludedBean : excludedMBeans) {
            if (key.indexOf(excludedBean) == -1) continue;
            return true;
        }
        return false;
    }

    String printAttributes(TreeMap attrs) {
        String retString = "\n";
        for (String key : attrs.keySet()) {
            Iterator it = excludedMBeans.iterator();
            boolean isExcluded = false;
            while (it.hasNext()) {
                String excludedBean = (String)it.next();
                if (key.indexOf(excludedBean) == -1) continue;
                isExcluded = true;
            }
            if (isExcluded && !this.showExcluded()) continue;
            String permission = (String)attrs.get(key);
            this.println(permission + "   " + key);
            retString = retString + permission + "   " + key + "   " + "\n";
        }
        return retString;
    }

    boolean showExcluded() {
        return this.showExcluded;
    }

    public void setShowExcluded(String bool) {
        this.showExcluded = this.getBoolean(bool);
    }

    public String printNameValuePairs(TreeMap attrs) {
        String retString = "\n";
        for (String name : attrs.keySet()) {
            String value = (String)attrs.get(name);
            this.println(name + "   " + value);
            retString = retString + name + "   " + value + "   " + "\n";
        }
        return retString;
    }

    String printAttrs(TreeSet set) {
        Iterator iter = set.iterator();
        String result = "";
        while (iter.hasNext()) {
            String s = (String)iter.next();
            this.println(s);
            result = result + s;
        }
        return result;
    }

    boolean inNewTree() {
        return this.domainType.equals("RuntimeConfigServerDomain") || this.domainType.equals("RuntimeRuntimeServerDomain") || this.domainType.equals("ConfigDomainRuntime") || this.domainType.equals("RuntimeDomainRuntime") || this.domainType.equals("ConfigEdit") || this.domainType.equals("JNDI") || this.domainType.equals("JSR77");
    }

    ObjectName getObjectName() {
        return this.getObjectName(this.wlcmo);
    }

    Object getMBeanFromObjectName(ObjectName objName) throws Throwable {
        if (this.inNewTree()) {
            MBeanServerConnection connection = this.getMBSConnection(this.domainType);
            return MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)connection, (ObjectName)objName);
        }
        return this.home.getProxy(objName);
    }

    ObjectName getObjectName(Object cmo) {
        if (cmo == null) {
            cmo = this.wlcmo;
        }
        try {
            if (this.domainType.equals("Custom_Domain")) {
                String s = (String)this.prompts.peek();
                return new ObjectName(s);
            }
            if (this.domainType.equals("DomainCustom_Domain")) {
                String s = (String)this.prompts.peek();
                return new ObjectName(s);
            }
        }
        catch (MalformedObjectNameException mon) {
            return null;
        }
        if (cmo instanceof ObjectName) {
            return (ObjectName)cmo;
        }
        if (Proxy.isProxyClass(cmo.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(cmo);
            if (handler instanceof MBeanServerInvocationHandler) {
                return ((MBeanServerInvocationHandler)handler)._getObjectName();
            }
            if (cmo instanceof WebLogicMBean) {
                return ((WebLogicMBean)cmo).getObjectName();
            }
            if (cmo instanceof StandardInterface) {
                return ((StandardInterface)cmo).wls_getObjectName();
            }
        } else {
            if (cmo instanceof WebLogicMBean) {
                return ((WebLogicMBean)cmo).getObjectName();
            }
            if (cmo instanceof StandardInterface) {
                return ((StandardInterface)cmo).wls_getObjectName();
            }
        }
        return null;
    }

    ObjectName[] getObjectNames(Object cmo) {
        if (cmo instanceof ObjectName[]) {
            return (ObjectName[])cmo;
        }
        Object[] cmos = (Object[])cmo;
        ObjectName[] ons = new ObjectName[cmos.length];
        for (int i = 0; i < cmos.length; ++i) {
            if (Proxy.isProxyClass(cmos[i].getClass())) {
                InvocationHandler handler = Proxy.getInvocationHandler(cmos[i]);
                if (handler instanceof MBeanServerInvocationHandler) {
                    ons[i] = ((MBeanServerInvocationHandler)handler)._getObjectName();
                    continue;
                }
                if (cmos[i] instanceof WebLogicMBean) {
                    ons[i] = ((WebLogicMBean)cmo).getObjectName();
                    continue;
                }
                if (!(cmos[i] instanceof StandardInterface)) continue;
                ons[i] = ((StandardInterface)cmos[i]).wls_getObjectName();
                continue;
            }
            if (cmos[i] instanceof WebLogicMBean) {
                ons[i] = ((WebLogicMBean)cmos[i]).getObjectName();
                continue;
            }
            if (!(cmos[i] instanceof StandardInterface)) continue;
            ons[i] = ((StandardInterface)cmos[i]).wls_getObjectName();
        }
        return ons;
    }

    MBeanInfo getMBeanInfo(Object cmo) throws ScriptException {
        if (cmo == null) {
            cmo = this.wlcmo;
        }
        try {
            InvocationHandler handler;
            if (Proxy.isProxyClass(cmo.getClass()) && (handler = Proxy.getInvocationHandler(cmo)) instanceof MBeanServerInvocationHandler) {
                return this.getMBSConnection(this.domainType).getMBeanInfo(((MBeanServerInvocationHandler)handler)._getObjectName());
            }
            if (cmo instanceof WebLogicMBean) {
                return this.getMBSConnection(this.domainType).getMBeanInfo((ObjectName)((WebLogicMBean)cmo).getObjectName());
            }
            if (cmo instanceof StandardInterface) {
                return this.getMBSConnection(this.domainType).getMBeanInfo(((StandardInterface)cmo).wls_getObjectName());
            }
        }
        catch (Throwable th) {
            this.throwWLSTException("Error getting the MBeanInfo for MBean", th);
        }
        return null;
    }

    WebLogicMBean getCurrentRootMBean() {
        if (this.domainType.equals("RuntimeConfigServerDomain")) {
            return this.runtimeDomainMBean;
        }
        if (this.domainType.equals("RuntimeRuntimeServerDomain")) {
            return this.runtimeServerRuntimeMBean;
        }
        if (this.domainType.equals("ConfigDomainRuntime")) {
            return this.configDomainRuntimeDRMBean;
        }
        if (this.domainType.equals("RuntimeDomainRuntime")) {
            return this.runtimeDomainRuntimeDRMBean;
        }
        if (this.domainType.equals("Domain")) {
            return this.compatDomainMBean;
        }
        if (this.domainType.equals("DomainConfig")) {
            return this.compatDomainMBean;
        }
        if (this.domainType.equals("DomainRuntime")) {
            return this.compatDomainRuntimeMBean;
        }
        if (this.domainType.equals("ConfigEdit")) {
            return this.editDomainMBean;
        }
        if (this.domainType.equals("JSR77")) {
            return null;
        }
        return null;
    }

    WebLogicMBean getRootMBean(String domainType) {
        if (domainType.equals("RuntimeConfigServerDomain")) {
            return this.runtimeDomainMBean;
        }
        if (domainType.equals("RuntimeRuntimeServerDomain")) {
            return this.runtimeServerRuntimeMBean;
        }
        if (domainType.equals("ConfigDomainRuntime")) {
            return this.configDomainRuntimeDRMBean;
        }
        if (domainType.equals("RuntimeDomainRuntime")) {
            return this.runtimeDomainRuntimeDRMBean;
        }
        if (domainType.equals("Domain")) {
            return this.compatDomainMBean;
        }
        if (domainType.equals("DomainConfig")) {
            return this.compatDomainMBean;
        }
        if (domainType.equals("ConfigEdit")) {
            return this.editDomainMBean;
        }
        if (domainType.equals("JSR77")) {
            return null;
        }
        if (domainType.equals("DomainRuntime")) {
            if (this.isAdminServer) {
                return this.compatDomainRuntimeMBean;
            }
            return this.compatServerRuntimeMBean;
        }
        return null;
    }

    MBeanServerConnection getMBSConnection(String domainType) {
        if (domainType == null) {
            domainType = this.domainType;
        }
        if (domainType.equals("RuntimeConfigServerDomain")) {
            return this.runtimeMSC;
        }
        if (domainType.equals("RuntimeRuntimeServerDomain")) {
            return this.runtimeMSC;
        }
        if (domainType.equals("ConfigDomainRuntime")) {
            return this.domainRTMSC;
        }
        if (domainType.equals("RuntimeDomainRuntime")) {
            return this.domainRTMSC;
        }
        if (domainType.equals("Domain")) {
            return this.compatMBS;
        }
        if (domainType.equals("DomainConfig")) {
            return this.compatMBS;
        }
        if (domainType.equals("DomainRuntime")) {
            return this.compatMBS;
        }
        if (domainType.equals("Custom_Domain")) {
            return this.runtimeMSC;
        }
        if (domainType.equals("DomainCustom_Domain")) {
            return this.domainRTMSC;
        }
        if (domainType.equals("ConfigEdit")) {
            return this.editMSC;
        }
        if (domainType.equals("JSR77")) {
            return this.jsr77MSC;
        }
        return null;
    }

    String getMBeanServerNameFromTree(String treeName) {
        if (treeName.equals("RuntimeConfigServerDomain")) {
            return "RuntimeMBeanServer";
        }
        if (treeName.equals("RuntimeRuntimeServerDomain")) {
            return "RuntimeMBeanServer";
        }
        if (treeName.equals("ConfigDomainRuntime")) {
            return "DomainRuntimeMBeanServer";
        }
        if (treeName.equals("RuntimeDomainRuntime")) {
            return "DomainRuntimeMBeanServer";
        }
        if (treeName.equals("Domain")) {
            return "DeprecatedMBeanServer";
        }
        if (treeName.equals("DomainConfig")) {
            return "DeprecatedMBeanServer";
        }
        if (treeName.equals("DomainRuntime")) {
            return "DeprecatedMBeanServer";
        }
        if (treeName.equals("Custom_Domain")) {
            return "RuntimeMBeanServer";
        }
        if (treeName.equals("DomainCustom_Domain")) {
            return "DomainRuntimeMBeanServer";
        }
        if (treeName.equals("ConfigEdit")) {
            return "EditMBeanServer";
        }
        if (treeName.equals("JSR77")) {
            return "JSR77MBeanServer";
        }
        return null;
    }

    TreeSet getCustomMBeans(String objectNamePattern) throws ScriptException {
        if (this.customMBeanDomainObjNameMap.size() > 0) {
            TreeSet set = new TreeSet();
            Iterator ittt = this.customMBeanDomainObjNameMap.keySet().iterator();
            while (ittt.hasNext()) {
                set.add(ittt.next());
            }
            return set;
        }
        TreeSet customBeans = new TreeSet();
        try {
            ObjectName pattern = objectNamePattern != null ? new ObjectName(objectNamePattern) : new ObjectName("*:*");
            if (this.isCompatabilityServerEnabled) {
                MBeanServerConnection mbsc = this.getMBSConnection("Domain");
                Set<ObjectName> s = mbsc.queryNames(pattern, null);
                for (ObjectName objname : s) {
                    if (!this.isCustomMBean(objname, mbsc)) continue;
                    this.addCustomToMap(objname);
                }
            }
            MBeanServerConnection _mbsc = this.getMBSConnection("Custom_Domain");
            Set<ObjectName> _s = _mbsc.queryNames(pattern, null);
            for (ObjectName objname : _s) {
                if (!this.isCustomMBean(objname, _mbsc)) continue;
                this.addCustomToMap(objname);
            }
        }
        catch (Throwable th) {
            this.throwWLSTException("Error getting the Custom MBeans", th);
        }
        return customBeans;
    }

    TreeSet getDomainCustomMBeans(String objectNamePattern) throws ScriptException {
        if (this.domainCustomMBeanDomainObjNameMap.size() > 0) {
            TreeSet set = new TreeSet();
            Iterator ittt = this.domainCustomMBeanDomainObjNameMap.keySet().iterator();
            while (ittt.hasNext()) {
                set.add(ittt.next());
            }
            return set;
        }
        TreeSet domainCustomBeans = new TreeSet();
        try {
            ObjectName pattern = objectNamePattern != null ? new ObjectName(objectNamePattern) : new ObjectName("*:*");
            MBeanServerConnection _mbsc = this.getMBSConnection("DomainCustom_Domain");
            Set<ObjectName> _s = _mbsc.queryNames(pattern, null);
            for (ObjectName objname : _s) {
                if (!this.isCustomMBean(objname, _mbsc)) continue;
                this.addDomainCustomToMap(objname);
            }
        }
        catch (Throwable th) {
            this.throwWLSTException("Error getting the Domain Custom MBeans. ", th);
        }
        return domainCustomBeans;
    }

    private boolean isCustomMBean(ObjectName on, MBeanServerConnection mbsc) throws Throwable {
        try {
            MBeanInfo mbeanInfo = mbsc.getMBeanInfo(on);
            if (!(mbeanInfo instanceof ModelMBeanInfo)) {
                return true;
            }
            ModelMBeanInfo modelInfo = (ModelMBeanInfo)((Object)mbeanInfo);
            Boolean custom = (Boolean)modelInfo.getMBeanDescriptor().getFieldValue("com.bea.custom");
            if (custom != null && custom.booleanValue()) {
                return true;
            }
            String clzName = (String)modelInfo.getMBeanDescriptor().getFieldValue("interfaceclassname");
            if (clzName != null) {
                try {
                    ModelMBeanInfo info = this.mbeanTypeService.getMBeanInfo(clzName);
                    return false;
                }
                catch (Exception e) {
                    return true;
                }
            }
            return true;
        }
        catch (Throwable th) {
            return false;
        }
    }

    private void addCustomToMap(ObjectName oname) {
        Iterator it = this.customMBeanDomainObjNameMap.keySet().iterator();
        List<String> onames = new ArrayList<String>();
        if (this.customMBeanDomainObjNameMap.containsKey(oname.getDomain())) {
            onames = (List)this.customMBeanDomainObjNameMap.get(oname.getDomain());
            onames.add(oname.toString());
        } else {
            onames.add(oname.toString());
        }
        this.customMBeanDomainObjNameMap.put(oname.getDomain(), onames);
    }

    private void addDomainCustomToMap(ObjectName oname) {
        List<String> onames = new ArrayList<String>();
        if (this.domainCustomMBeanDomainObjNameMap.containsKey(oname.getDomain())) {
            onames = (List)this.domainCustomMBeanDomainObjNameMap.get(oname.getDomain());
            onames.add(oname.toString());
        } else {
            onames.add(oname.toString());
        }
        this.domainCustomMBeanDomainObjNameMap.put(oname.getDomain(), onames);
    }

    boolean inConfigRT() {
        return this.domainType.equals("RuntimeConfigServerDomain") || this.domainType.equals("RuntimeRuntimeServerDomain");
    }

    boolean inDomainRT() {
        return this.domainType.equals("ConfigDomainRuntime") || this.domainType.equals("RuntimeDomainRuntime");
    }
}

