/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.scripting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import weblogic.management.scripting.ScriptException;
import weblogic.management.scripting.WLSTWatchListener;
import weblogic.management.scripting.WLScriptContext;
import weblogic.management.scripting.WatchFilter;
import weblogic.management.scripting.WatchListener;
import weblogic.management.scripting.utils.WLSTMsgTextFormatter;
import weblogic.utils.StringUtils;

public class WatchUtil {
    WLScriptContext ctx = null;
    HashMap watchListeners = new HashMap();
    private WLSTMsgTextFormatter txtFmt;
    private int watchCounter = 0;
    private static String WLST_WATCH_NAME = "wlst-listener-";

    public WatchUtil(WLScriptContext ctx) {
        this.ctx = ctx;
        this.txtFmt = ctx.getWLSTMsgFormatter();
    }

    ObjectName getONFromObject(Object mbean) throws ScriptException {
        ObjectName oname = null;
        try {
            oname = mbean instanceof String ? new ObjectName((String)mbean) : (mbean instanceof ObjectName ? (ObjectName)mbean : this.ctx.getObjectName(mbean));
        }
        catch (MalformedObjectNameException mfe) {
            this.ctx.throwWLSTException(this.txtFmt.getMalformedObjectName(), mfe);
        }
        return oname;
    }

    public void watch(Object mbean, String attributeNames, String logFile, String watchName) throws ScriptException {
        ObjectName oname = null;
        String[] anames = null;
        watchName = this.getWatchName(watchName);
        try {
            if (attributeNames != null) {
                anames = StringUtils.splitCompletely((String)attributeNames, (String)",");
            }
            oname = this.getONFromObject(mbean);
            WatchFilter wfilter = new WatchFilter(anames);
            WatchListener wlistener = new WatchListener(logFile, this.ctx.stdOutputMedium, this.ctx.logToStandardOut, watchName, this.ctx);
            this.ctx.getMBSConnection(this.ctx.getDomainType()).addNotificationListener(oname, wlistener, (NotificationFilter)wfilter, null);
            String s = attributeNames;
            if (s == null) {
                s = "ALL";
            }
            String fullName = this.txtFmt.getWatchListenerName(watchName, this.asString(oname), s);
            WLSTWatchListener wl = new WLSTWatchListener(oname, wlistener, watchName, fullName);
            this.watchListeners.put(watchName, wl);
            this.ctx.println(this.txtFmt.getAddedWatchListener(watchName, this.asString(oname)));
        }
        catch (InstanceNotFoundException inf) {
            this.ctx.throwWLSTException(this.txtFmt.getMBeanNotFound(this.asString(oname)), inf);
        }
        catch (IOException ie) {
            String msg = this.txtFmt.getIOExceptionAddingWatchListener(this.asString(oname));
            this.ctx.throwWLSTException(msg, ie);
        }
    }

    public void removeWatch(Object mbean, String watchName) throws ScriptException {
        if (this.watchListeners.isEmpty()) {
            String msg = this.txtFmt.getNoWatchListenersFound(this.asString(mbean), watchName);
            this.ctx.throwWLSTException(msg);
        }
        try {
            if (mbean == null && watchName == null) {
                Iterator it = this.watchListeners.values().iterator();
                while (it.hasNext()) {
                    ObjectName on;
                    WLSTWatchListener wl = null;
                    try {
                        wl = (WLSTWatchListener)it.next();
                        this.ctx.runtimeMSC.removeNotificationListener(wl.getObjectName(), wl.getWL());
                        ObjectName on2 = wl.getObjectName();
                        this.ctx.println(this.txtFmt.getDeletedListener(wl.getWN(), this.asString(on2)));
                    }
                    catch (InstanceNotFoundException inf) {
                        on = wl.getObjectName();
                        this.ctx.println(this.txtFmt.getDeletedListener(watchName, this.asString(on)));
                    }
                    catch (IOException ie) {
                        on = wl.getObjectName();
                        this.ctx.throwWLSTException(this.txtFmt.getIOExceptionDeletingWatchListener(this.asString(on)));
                    }
                    catch (ListenerNotFoundException ie) {
                        on = wl.getObjectName();
                        this.ctx.throwWLSTException(this.txtFmt.getListenerNotFound(this.asString(on)));
                    }
                }
                this.watchListeners = new HashMap();
                return;
            }
            if (watchName != null) {
                WLSTWatchListener wl = (WLSTWatchListener)this.watchListeners.get(watchName);
                this.ctx.runtimeMSC.removeNotificationListener(wl.getObjectName(), wl.getWL());
                this.watchListeners.remove(watchName);
                this.ctx.println(this.txtFmt.getListenerRemoved(watchName, this.asString(mbean)));
            } else {
                ObjectName oname = this.getONFromObject(mbean);
                ArrayList<String> watches = new ArrayList<String>();
                for (WLSTWatchListener wl : this.watchListeners.values()) {
                    if (!wl.getObjectName().toString().equals(oname)) continue;
                    watches.add(wl.getWN());
                    this.ctx.runtimeMSC.removeNotificationListener(wl.getObjectName(), wl.getWL());
                }
                if (watches.isEmpty()) {
                    this.ctx.throwWLSTException(this.txtFmt.getListenerNotFound(this.asString(oname)));
                } else {
                    for (String watch : watches) {
                        this.watchListeners.remove(watch);
                    }
                    this.ctx.println(this.txtFmt.getListenerRemoved(watchName, this.asString(oname)));
                }
            }
        }
        catch (InstanceNotFoundException inf) {
            ObjectName oname = this.getONFromObject(mbean);
            this.ctx.throwWLSTException(this.txtFmt.getWatchRemoveMBeanNotFound(this.asString(oname)), inf);
        }
        catch (IOException ie) {
            ObjectName oname = this.getONFromObject(mbean);
            this.ctx.throwWLSTException(this.txtFmt.getIOExceptionRemoveingWatchListener(this.asString(oname)), ie);
        }
        catch (ListenerNotFoundException ie) {
            ObjectName oname = this.getONFromObject(mbean);
            this.ctx.throwWLSTException(this.txtFmt.getListenerNotFound(this.asString(oname)), ie);
        }
    }

    private String getWatchName(String watchName) throws ScriptException {
        if (watchName == null) {
            watchName = WLST_WATCH_NAME + this.watchCounter;
            ++this.watchCounter;
            return watchName;
        }
        if (!this.watchListeners.containsKey(watchName)) {
            return watchName;
        }
        this.ctx.throwWLSTException(this.txtFmt.getListenerAlreadyExists(watchName));
        return watchName;
    }

    void showWatches() throws ScriptException {
        if (this.watchListeners.isEmpty()) {
            this.ctx.println(this.txtFmt.getNoListenersConfigured());
            return;
        }
        for (WLSTWatchListener wl : this.watchListeners.values()) {
            this.ctx.println(wl.getDescription());
        }
    }

    private String asString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString();
    }
}

