/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.security;

import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanAlreadyExistsException;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.DistributedManagementException;
import weblogic.management.internal.mbean.SecurityReadOnlyMBeanBinder;
import weblogic.management.security.ProviderMBeanImpl;
import weblogic.utils.codegen.AttributeBinder;

public class ProviderMBeanBinder
extends SecurityReadOnlyMBeanBinder
implements AttributeBinder {
    private ProviderMBeanImpl bean;

    protected ProviderMBeanBinder(DescriptorBean descriptorBean) {
        super(descriptorBean);
        this.bean = (ProviderMBeanImpl)descriptorBean;
    }

    public ProviderMBeanBinder() {
        super((DescriptorBean)new ProviderMBeanImpl());
        this.bean = (ProviderMBeanImpl)this.getBean();
    }

    public AttributeBinder bindAttribute(String string, Object object) throws IllegalArgumentException {
        try {
            ProviderMBeanBinder providerMBeanBinder = this;
            if (!(providerMBeanBinder instanceof SecurityReadOnlyMBeanBinder) && object != null && object.toString().trim().length() == 0) {
                return providerMBeanBinder;
            }
            if (string != null) {
                if (string.equals("CompatibilityObjectName")) {
                    throw new AssertionError((Object)"can't set read-only property CompatibilityObjectName");
                }
                if (string.equals("Name")) {
                    try {
                        this.bean.setName((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else {
                    providerMBeanBinder = super.bindAttribute(string, object);
                }
            }
            return providerMBeanBinder;
        }
        catch (ClassCastException classCastException) {
            System.out.println(classCastException + " name: " + string + " class: " + object.getClass().getName());
            throw classCastException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            if (exception instanceof DistributedManagementException) {
                throw new AssertionError((Object)("impossible exception: " + exception));
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            throw new AssertionError((Object)("unexpected exception: " + exception));
        }
    }
}

