/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.security;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import javax.management.modelmbean.ModelMBean;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.AbstractSchemaHelper2;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.commo.AbstractCommoConfigurationBean;
import weblogic.management.commo.RequiredModelMBeanWrapper;
import weblogic.management.security.RDBMSSecurityStoreImpl;
import weblogic.management.security.RDBMSSecurityStoreMBean;
import weblogic.management.security.RDBMSSecurityStoreValidator;
import weblogic.management.security.RealmMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class RDBMSSecurityStoreMBeanImpl
extends AbstractCommoConfigurationBean
implements RDBMSSecurityStoreMBean,
Serializable {
    private String _CompatibilityObjectName;
    private String _ConnectionProperties;
    private String _ConnectionURL;
    private String _DriverName;
    private int _JMSExceptionReconnectAttempts;
    private String _JMSTopic;
    private String _JMSTopicConnectionFactory;
    private String _JNDIPassword;
    private byte[] _JNDIPasswordEncrypted;
    private String _JNDIUsername;
    private String _Name;
    private String _NotificationProperties;
    private String _Password;
    private byte[] _PasswordEncrypted;
    private RealmMBean _Realm;
    private String _Username;
    private RDBMSSecurityStoreImpl _customizer;
    private static SchemaHelper2 _schemaHelper;

    public RDBMSSecurityStoreMBeanImpl() {
        try {
            this._customizer = new RDBMSSecurityStoreImpl((ModelMBean)new RequiredModelMBeanWrapper((AbstractCommoConfigurationBean)this));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public RDBMSSecurityStoreMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new RDBMSSecurityStoreImpl((ModelMBean)new RequiredModelMBeanWrapper((AbstractCommoConfigurationBean)this));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getUsername() {
        return this._Username;
    }

    public boolean isUsernameSet() {
        return this._isSet(2);
    }

    public void setUsername(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Username", (String)string);
        LegalChecks.checkNonNull((String)"Username", (Object)string);
        String string2 = this._Username;
        this._Username = string;
        this._postSet(2, string2, string);
    }

    public String getPassword() {
        byte[] byArray = this.getPasswordEncrypted();
        return byArray == null ? null : this._decrypt("Password", byArray);
    }

    public boolean isPasswordSet() {
        return this.isPasswordEncryptedSet();
    }

    public void setPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setPasswordEncrypted(string == null ? null : this._encrypt("Password", string));
    }

    public byte[] getPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._PasswordEncrypted);
    }

    public String getPasswordEncryptedAsString() {
        byte[] byArray = this.getPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isPasswordEncryptedSet() {
        return this._isSet(4);
    }

    public void setPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getJNDIUsername() {
        return this._JNDIUsername;
    }

    public boolean isJNDIUsernameSet() {
        return this._isSet(5);
    }

    public void setJNDIUsername(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._JNDIUsername;
        this._JNDIUsername = string;
        this._postSet(5, string2, string);
    }

    public String getJNDIPassword() {
        byte[] byArray = this.getJNDIPasswordEncrypted();
        return byArray == null ? null : this._decrypt("JNDIPassword", byArray);
    }

    public boolean isJNDIPasswordSet() {
        return this.isJNDIPasswordEncryptedSet();
    }

    public void setJNDIPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setJNDIPasswordEncrypted(string == null ? null : this._encrypt("JNDIPassword", string));
    }

    public byte[] getJNDIPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._JNDIPasswordEncrypted);
    }

    public String getJNDIPasswordEncryptedAsString() {
        byte[] byArray = this.getJNDIPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isJNDIPasswordEncryptedSet() {
        return this._isSet(7);
    }

    public void setJNDIPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setJNDIPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getConnectionURL() {
        return this._ConnectionURL;
    }

    public boolean isConnectionURLSet() {
        return this._isSet(8);
    }

    public void setConnectionURL(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"ConnectionURL", (String)string);
        LegalChecks.checkNonNull((String)"ConnectionURL", (Object)string);
        String string2 = this._ConnectionURL;
        this._ConnectionURL = string;
        this._postSet(8, string2, string);
    }

    public String getDriverName() {
        return this._DriverName;
    }

    public boolean isDriverNameSet() {
        return this._isSet(9);
    }

    public void setDriverName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"DriverName", (String)string);
        LegalChecks.checkNonNull((String)"DriverName", (Object)string);
        String string2 = this._DriverName;
        this._DriverName = string;
        this._postSet(9, string2, string);
    }

    public String getConnectionProperties() {
        return this._ConnectionProperties;
    }

    public boolean isConnectionPropertiesSet() {
        return this._isSet(10);
    }

    public void setConnectionProperties(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        RDBMSSecurityStoreValidator.validateProperties(string);
        String string2 = this._ConnectionProperties;
        this._ConnectionProperties = string;
        this._postSet(10, string2, string);
    }

    public String getJMSTopic() {
        return this._JMSTopic;
    }

    public boolean isJMSTopicSet() {
        return this._isSet(11);
    }

    public void setJMSTopic(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._JMSTopic;
        this._JMSTopic = string;
        this._postSet(11, string2, string);
    }

    public String getJMSTopicConnectionFactory() {
        return this._JMSTopicConnectionFactory;
    }

    public boolean isJMSTopicConnectionFactorySet() {
        return this._isSet(12);
    }

    public void setJMSTopicConnectionFactory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._JMSTopicConnectionFactory;
        this._JMSTopicConnectionFactory = string;
        this._postSet(12, string2, string);
    }

    public int getJMSExceptionReconnectAttempts() {
        return this._JMSExceptionReconnectAttempts;
    }

    public boolean isJMSExceptionReconnectAttemptsSet() {
        return this._isSet(13);
    }

    public void setJMSExceptionReconnectAttempts(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"JMSExceptionReconnectAttempts", (int)n, (int)0);
        int n2 = this._JMSExceptionReconnectAttempts;
        this._JMSExceptionReconnectAttempts = n;
        this._postSet(13, n2, n);
    }

    public String getNotificationProperties() {
        return this._NotificationProperties;
    }

    public boolean isNotificationPropertiesSet() {
        return this._isSet(14);
    }

    public void setNotificationProperties(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        RDBMSSecurityStoreValidator.validateProperties(string);
        String string2 = this._NotificationProperties;
        this._NotificationProperties = string;
        this._postSet(14, string2, string);
    }

    public RealmMBean getRealm() {
        return this._customizer.getRealm();
    }

    public boolean isRealmSet() {
        return this._isSet(15);
    }

    public void setRealm(RealmMBean realmMBean) throws InvalidAttributeValueException {
        this._Realm = realmMBean;
    }

    public String getName() {
        return this._Name;
    }

    public boolean isNameSet() {
        return this._isSet(16);
    }

    public void setName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._Name;
        this._Name = string;
        this._postSet(16, string2, string);
    }

    public String getCompatibilityObjectName() {
        return this._customizer.getCompatibilityObjectName();
    }

    public boolean isCompatibilityObjectNameSet() {
        return this._isSet(17);
    }

    public void setCompatibilityObjectName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._CompatibilityObjectName;
        this._CompatibilityObjectName = string;
        this._postSet(17, string2, string);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        LegalChecks.checkIsSet((String)"ConnectionURL", (boolean)this.isConnectionURLSet());
        LegalChecks.checkIsSet((String)"DriverName", (boolean)this.isDriverNameSet());
        LegalChecks.checkIsSet((String)"Username", (boolean)this.isUsernameSet());
    }

    public void setJNDIPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._JNDIPasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: JNDIPasswordEncrypted of RDBMSSecurityStoreMBean");
        }
        this._getHelper()._clearArray(this._JNDIPasswordEncrypted);
        this._JNDIPasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(7, byArray2, byArray);
    }

    public void setPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._PasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: PasswordEncrypted of RDBMSSecurityStoreMBean");
        }
        this._getHelper()._clearArray(this._PasswordEncrypted);
        this._PasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(4, byArray2, byArray);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 6) {
                this._markSet(7, false);
            }
            if (n == 3) {
                this._markSet(4, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 17;
        }
        try {
            switch (n) {
                case 17: {
                    this._CompatibilityObjectName = null;
                    if (bl) break;
                }
                case 10: {
                    this._ConnectionProperties = null;
                    if (bl) break;
                }
                case 8: {
                    this._ConnectionURL = null;
                    if (bl) break;
                }
                case 9: {
                    this._DriverName = null;
                    if (bl) break;
                }
                case 13: {
                    this._JMSExceptionReconnectAttempts = 0;
                    if (bl) break;
                }
                case 11: {
                    this._JMSTopic = null;
                    if (bl) break;
                }
                case 12: {
                    this._JMSTopicConnectionFactory = null;
                    if (bl) break;
                }
                case 6: {
                    this._JNDIPasswordEncrypted = null;
                    if (bl) break;
                }
                case 7: {
                    this._JNDIPasswordEncrypted = null;
                    if (bl) break;
                }
                case 5: {
                    this._JNDIUsername = null;
                    if (bl) break;
                }
                case 16: {
                    this._Name = "RDBMSSecurityStore";
                    if (bl) break;
                }
                case 14: {
                    this._NotificationProperties = null;
                    if (bl) break;
                }
                case 3: {
                    this._PasswordEncrypted = null;
                    if (bl) break;
                }
                case 4: {
                    this._PasswordEncrypted = null;
                    if (bl) break;
                }
                case 15: {
                    this._Realm = null;
                    if (bl) break;
                }
                case 2: {
                    this._Username = null;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/security.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/security";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String wls_getInterfaceClassName() {
        return "weblogic.management.security.RDBMSSecurityStoreMBean";
    }

    public static class SchemaHelper2
    extends AbstractSchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 25: {
                    if (!string.equals("compatibility-object-name")) break;
                    return 17;
                }
                case 21: {
                    if (!string.equals("connection-properties")) break;
                    return 10;
                }
                case 14: {
                    if (!string.equals("connection-url")) break;
                    return 8;
                }
                case 11: {
                    if (!string.equals("driver-name")) break;
                    return 9;
                }
                case 32: {
                    if (!string.equals("jms-exception-reconnect-attempts")) break;
                    return 13;
                }
                case 9: {
                    if (!string.equals("jms-topic")) break;
                    return 11;
                }
                case 28: {
                    if (!string.equals("jms-topic-connection-factory")) break;
                    return 12;
                }
                case 13: {
                    if (string.equals("jndi-password")) {
                        return 6;
                    }
                    if (!string.equals("jndi-username")) break;
                    return 5;
                }
                case 23: {
                    if (string.equals("jndi-password-encrypted")) {
                        return 7;
                    }
                    if (!string.equals("notification-properties")) break;
                    return 14;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 16;
                }
                case 8: {
                    if (string.equals("password")) {
                        return 3;
                    }
                    if (!string.equals("username")) break;
                    return 2;
                }
                case 18: {
                    if (!string.equals("password-encrypted")) break;
                    return 4;
                }
                case 5: {
                    if (!string.equals("realm")) break;
                    return 15;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 17: {
                    return "compatibility-object-name";
                }
                case 10: {
                    return "connection-properties";
                }
                case 8: {
                    return "connection-url";
                }
                case 9: {
                    return "driver-name";
                }
                case 13: {
                    return "jms-exception-reconnect-attempts";
                }
                case 11: {
                    return "jms-topic";
                }
                case 12: {
                    return "jms-topic-connection-factory";
                }
                case 6: {
                    return "jndi-password";
                }
                case 7: {
                    return "jndi-password-encrypted";
                }
                case 5: {
                    return "jndi-username";
                }
                case 16: {
                    return "name";
                }
                case 14: {
                    return "notification-properties";
                }
                case 3: {
                    return "password";
                }
                case 4: {
                    return "password-encrypted";
                }
                case 15: {
                    return "realm";
                }
                case 2: {
                    return "username";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                default: 
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }
    }

    protected static class Helper
    extends AbstractCommoConfigurationBean.Helper {
        private RDBMSSecurityStoreMBeanImpl bean;

        protected Helper(RDBMSSecurityStoreMBeanImpl rDBMSSecurityStoreMBeanImpl) {
            super((AbstractCommoConfigurationBean)rDBMSSecurityStoreMBeanImpl);
            this.bean = rDBMSSecurityStoreMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 17: {
                    return "CompatibilityObjectName";
                }
                case 10: {
                    return "ConnectionProperties";
                }
                case 8: {
                    return "ConnectionURL";
                }
                case 9: {
                    return "DriverName";
                }
                case 13: {
                    return "JMSExceptionReconnectAttempts";
                }
                case 11: {
                    return "JMSTopic";
                }
                case 12: {
                    return "JMSTopicConnectionFactory";
                }
                case 6: {
                    return "JNDIPassword";
                }
                case 7: {
                    return "JNDIPasswordEncrypted";
                }
                case 5: {
                    return "JNDIUsername";
                }
                case 16: {
                    return "Name";
                }
                case 14: {
                    return "NotificationProperties";
                }
                case 3: {
                    return "Password";
                }
                case 4: {
                    return "PasswordEncrypted";
                }
                case 15: {
                    return "Realm";
                }
                case 2: {
                    return "Username";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("CompatibilityObjectName")) {
                return 17;
            }
            if (string.equals("ConnectionProperties")) {
                return 10;
            }
            if (string.equals("ConnectionURL")) {
                return 8;
            }
            if (string.equals("DriverName")) {
                return 9;
            }
            if (string.equals("JMSExceptionReconnectAttempts")) {
                return 13;
            }
            if (string.equals("JMSTopic")) {
                return 11;
            }
            if (string.equals("JMSTopicConnectionFactory")) {
                return 12;
            }
            if (string.equals("JNDIPassword")) {
                return 6;
            }
            if (string.equals("JNDIPasswordEncrypted")) {
                return 7;
            }
            if (string.equals("JNDIUsername")) {
                return 5;
            }
            if (string.equals("Name")) {
                return 16;
            }
            if (string.equals("NotificationProperties")) {
                return 14;
            }
            if (string.equals("Password")) {
                return 3;
            }
            if (string.equals("PasswordEncrypted")) {
                return 4;
            }
            if (string.equals("Realm")) {
                return 15;
            }
            if (string.equals("Username")) {
                return 2;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isCompatibilityObjectNameSet()) {
                    stringBuffer.append("CompatibilityObjectName");
                    stringBuffer.append(String.valueOf(this.bean.getCompatibilityObjectName()));
                }
                if (this.bean.isConnectionPropertiesSet()) {
                    stringBuffer.append("ConnectionProperties");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionProperties()));
                }
                if (this.bean.isConnectionURLSet()) {
                    stringBuffer.append("ConnectionURL");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionURL()));
                }
                if (this.bean.isDriverNameSet()) {
                    stringBuffer.append("DriverName");
                    stringBuffer.append(String.valueOf(this.bean.getDriverName()));
                }
                if (this.bean.isJMSExceptionReconnectAttemptsSet()) {
                    stringBuffer.append("JMSExceptionReconnectAttempts");
                    stringBuffer.append(String.valueOf(this.bean.getJMSExceptionReconnectAttempts()));
                }
                if (this.bean.isJMSTopicSet()) {
                    stringBuffer.append("JMSTopic");
                    stringBuffer.append(String.valueOf(this.bean.getJMSTopic()));
                }
                if (this.bean.isJMSTopicConnectionFactorySet()) {
                    stringBuffer.append("JMSTopicConnectionFactory");
                    stringBuffer.append(String.valueOf(this.bean.getJMSTopicConnectionFactory()));
                }
                if (this.bean.isJNDIPasswordSet()) {
                    stringBuffer.append("JNDIPassword");
                    stringBuffer.append(String.valueOf(this.bean.getJNDIPassword()));
                }
                if (this.bean.isJNDIPasswordEncryptedSet()) {
                    stringBuffer.append("JNDIPasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getJNDIPasswordEncrypted())));
                }
                if (this.bean.isJNDIUsernameSet()) {
                    stringBuffer.append("JNDIUsername");
                    stringBuffer.append(String.valueOf(this.bean.getJNDIUsername()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNotificationPropertiesSet()) {
                    stringBuffer.append("NotificationProperties");
                    stringBuffer.append(String.valueOf(this.bean.getNotificationProperties()));
                }
                if (this.bean.isPasswordSet()) {
                    stringBuffer.append("Password");
                    stringBuffer.append(String.valueOf(this.bean.getPassword()));
                }
                if (this.bean.isPasswordEncryptedSet()) {
                    stringBuffer.append("PasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getPasswordEncrypted())));
                }
                if (this.bean.isRealmSet()) {
                    stringBuffer.append("Realm");
                    stringBuffer.append(String.valueOf(this.bean.getRealm()));
                }
                if (this.bean.isUsernameSet()) {
                    stringBuffer.append("Username");
                    stringBuffer.append(String.valueOf(this.bean.getUsername()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                RDBMSSecurityStoreMBeanImpl rDBMSSecurityStoreMBeanImpl = (RDBMSSecurityStoreMBeanImpl)abstractDescriptorBean;
                this.computeDiff("CompatibilityObjectName", this.bean.getCompatibilityObjectName(), rDBMSSecurityStoreMBeanImpl.getCompatibilityObjectName(), false);
                this.computeDiff("ConnectionProperties", this.bean.getConnectionProperties(), rDBMSSecurityStoreMBeanImpl.getConnectionProperties(), false);
                this.computeDiff("ConnectionURL", this.bean.getConnectionURL(), rDBMSSecurityStoreMBeanImpl.getConnectionURL(), false);
                this.computeDiff("DriverName", this.bean.getDriverName(), rDBMSSecurityStoreMBeanImpl.getDriverName(), false);
                this.computeDiff("JMSExceptionReconnectAttempts", this.bean.getJMSExceptionReconnectAttempts(), rDBMSSecurityStoreMBeanImpl.getJMSExceptionReconnectAttempts(), false);
                this.computeDiff("JMSTopic", this.bean.getJMSTopic(), rDBMSSecurityStoreMBeanImpl.getJMSTopic(), false);
                this.computeDiff("JMSTopicConnectionFactory", this.bean.getJMSTopicConnectionFactory(), rDBMSSecurityStoreMBeanImpl.getJMSTopicConnectionFactory(), false);
                this.computeDiff("JNDIPasswordEncrypted", this.bean.getJNDIPasswordEncrypted(), rDBMSSecurityStoreMBeanImpl.getJNDIPasswordEncrypted(), false);
                this.computeDiff("JNDIUsername", this.bean.getJNDIUsername(), rDBMSSecurityStoreMBeanImpl.getJNDIUsername(), false);
                this.computeDiff("Name", this.bean.getName(), rDBMSSecurityStoreMBeanImpl.getName(), false);
                this.computeDiff("NotificationProperties", this.bean.getNotificationProperties(), rDBMSSecurityStoreMBeanImpl.getNotificationProperties(), false);
                this.computeDiff("PasswordEncrypted", this.bean.getPasswordEncrypted(), rDBMSSecurityStoreMBeanImpl.getPasswordEncrypted(), false);
                this.computeDiff("Username", this.bean.getUsername(), rDBMSSecurityStoreMBeanImpl.getUsername(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                RDBMSSecurityStoreMBeanImpl rDBMSSecurityStoreMBeanImpl = (RDBMSSecurityStoreMBeanImpl)beanUpdateEvent.getSourceBean();
                RDBMSSecurityStoreMBeanImpl rDBMSSecurityStoreMBeanImpl2 = (RDBMSSecurityStoreMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("CompatibilityObjectName")) {
                    rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("ConnectionProperties")) {
                    rDBMSSecurityStoreMBeanImpl.setConnectionProperties(rDBMSSecurityStoreMBeanImpl2.getConnectionProperties());
                    rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("ConnectionURL")) {
                    rDBMSSecurityStoreMBeanImpl.setConnectionURL(rDBMSSecurityStoreMBeanImpl2.getConnectionURL());
                    rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("DriverName")) {
                    rDBMSSecurityStoreMBeanImpl.setDriverName(rDBMSSecurityStoreMBeanImpl2.getDriverName());
                    rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("JMSExceptionReconnectAttempts")) {
                    rDBMSSecurityStoreMBeanImpl.setJMSExceptionReconnectAttempts(rDBMSSecurityStoreMBeanImpl2.getJMSExceptionReconnectAttempts());
                    rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("JMSTopic")) {
                    rDBMSSecurityStoreMBeanImpl.setJMSTopic(rDBMSSecurityStoreMBeanImpl2.getJMSTopic());
                    rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("JMSTopicConnectionFactory")) {
                    rDBMSSecurityStoreMBeanImpl.setJMSTopicConnectionFactory(rDBMSSecurityStoreMBeanImpl2.getJMSTopicConnectionFactory());
                    rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (!string.equals("JNDIPassword")) {
                    if (string.equals("JNDIPasswordEncrypted")) {
                        rDBMSSecurityStoreMBeanImpl.setJNDIPasswordEncrypted(rDBMSSecurityStoreMBeanImpl2.getJNDIPasswordEncrypted());
                        rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("JNDIUsername")) {
                        rDBMSSecurityStoreMBeanImpl.setJNDIUsername(rDBMSSecurityStoreMBeanImpl2.getJNDIUsername());
                        rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 5);
                    } else if (string.equals("Name")) {
                        rDBMSSecurityStoreMBeanImpl.setName(rDBMSSecurityStoreMBeanImpl2.getName());
                        rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else if (string.equals("NotificationProperties")) {
                        rDBMSSecurityStoreMBeanImpl.setNotificationProperties(rDBMSSecurityStoreMBeanImpl2.getNotificationProperties());
                        rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                    } else if (!string.equals("Password")) {
                        if (string.equals("PasswordEncrypted")) {
                            rDBMSSecurityStoreMBeanImpl.setPasswordEncrypted(rDBMSSecurityStoreMBeanImpl2.getPasswordEncrypted());
                            rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 4);
                        } else if (!string.equals("Realm")) {
                            if (string.equals("Username")) {
                                rDBMSSecurityStoreMBeanImpl.setUsername(rDBMSSecurityStoreMBeanImpl2.getUsername());
                                rDBMSSecurityStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                            } else {
                                super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                byte[] byArray;
                RDBMSSecurityStoreMBeanImpl rDBMSSecurityStoreMBeanImpl = (RDBMSSecurityStoreMBeanImpl)abstractDescriptorBean;
                super.finishCopy((AbstractDescriptorBean)rDBMSSecurityStoreMBeanImpl, bl, list);
                if (list != null && list.contains("CompatibilityObjectName") || this.bean.isCompatibilityObjectNameSet()) {
                    // empty if block
                }
                if ((list == null || !list.contains("ConnectionProperties")) && this.bean.isConnectionPropertiesSet()) {
                    rDBMSSecurityStoreMBeanImpl.setConnectionProperties(this.bean.getConnectionProperties());
                }
                if ((list == null || !list.contains("ConnectionURL")) && this.bean.isConnectionURLSet()) {
                    rDBMSSecurityStoreMBeanImpl.setConnectionURL(this.bean.getConnectionURL());
                }
                if ((list == null || !list.contains("DriverName")) && this.bean.isDriverNameSet()) {
                    rDBMSSecurityStoreMBeanImpl.setDriverName(this.bean.getDriverName());
                }
                if ((list == null || !list.contains("JMSExceptionReconnectAttempts")) && this.bean.isJMSExceptionReconnectAttemptsSet()) {
                    rDBMSSecurityStoreMBeanImpl.setJMSExceptionReconnectAttempts(this.bean.getJMSExceptionReconnectAttempts());
                }
                if ((list == null || !list.contains("JMSTopic")) && this.bean.isJMSTopicSet()) {
                    rDBMSSecurityStoreMBeanImpl.setJMSTopic(this.bean.getJMSTopic());
                }
                if ((list == null || !list.contains("JMSTopicConnectionFactory")) && this.bean.isJMSTopicConnectionFactorySet()) {
                    rDBMSSecurityStoreMBeanImpl.setJMSTopicConnectionFactory(this.bean.getJMSTopicConnectionFactory());
                }
                if ((list == null || !list.contains("JNDIPasswordEncrypted")) && this.bean.isJNDIPasswordEncryptedSet()) {
                    byArray = this.bean.getJNDIPasswordEncrypted();
                    rDBMSSecurityStoreMBeanImpl.setJNDIPasswordEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("JNDIUsername")) && this.bean.isJNDIUsernameSet()) {
                    rDBMSSecurityStoreMBeanImpl.setJNDIUsername(this.bean.getJNDIUsername());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    rDBMSSecurityStoreMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("NotificationProperties")) && this.bean.isNotificationPropertiesSet()) {
                    rDBMSSecurityStoreMBeanImpl.setNotificationProperties(this.bean.getNotificationProperties());
                }
                if ((list == null || !list.contains("PasswordEncrypted")) && this.bean.isPasswordEncryptedSet()) {
                    byArray = this.bean.getPasswordEncrypted();
                    rDBMSSecurityStoreMBeanImpl.setPasswordEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("Username")) && this.bean.isUsernameSet()) {
                    rDBMSSecurityStoreMBeanImpl.setUsername(this.bean.getUsername());
                }
                return rDBMSSecurityStoreMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getRealm(), clazz, object);
        }
    }
}

