/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.security;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.util.Vector;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.RequiredModelMBean;
import weblogic.descriptor.DescriptorClassLoader;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.provider.beaninfo.BeanInfoAccessFactory;
import weblogic.management.security.BaseMBeanImpl;
import weblogic.management.security.ProviderMBean;
import weblogic.management.security.RealmContainer;
import weblogic.management.security.RealmMBean;
import weblogic.management.security.audit.AuditorMBean;
import weblogic.management.security.authentication.AuthenticationProviderMBean;
import weblogic.management.security.authentication.PasswordValidatorMBean;
import weblogic.management.security.authorization.AdjudicatorMBean;
import weblogic.management.security.authorization.AuthorizerMBean;
import weblogic.management.security.authorization.RoleMapperMBean;
import weblogic.management.security.credentials.CredentialMapperMBean;
import weblogic.management.security.pk.CertPathProviderMBean;
import weblogic.management.security.pk.KeyStoreMBean;
import weblogic.management.utils.ErrorCollectionException;
import weblogic.security.SecurityMessagesTextFormatter;
import weblogic.security.internal.RealmValidatorImpl;

public class RealmImpl
extends BaseMBeanImpl {
    private boolean isInConstructor = true;
    private static final String MBEAN_SUFFIX = "MBean";

    public RealmImpl(ModelMBean modelMBean) throws MBeanException {
        super(modelMBean);
    }

    protected RealmImpl(RequiredModelMBean requiredModelMBean) throws MBeanException {
        super(requiredModelMBean);
    }

    public void validate() throws ErrorCollectionException {
        new RealmValidatorImpl().validate(this.getRealm());
    }

    private boolean constructed() {
        return !this.isInConstructor;
    }

    public void _postCreate() {
        this.isInConstructor = false;
    }

    private RealmMBean getRealm() {
        try {
            return (RealmMBean)this.getProxy();
        }
        catch (MBeanException mBeanException) {
            throw new AssertionError((Object)mBeanException);
        }
    }

    private RealmContainer getRealmContainer() {
        return (RealmContainer)this.getRealm().getParentBean();
    }

    private boolean amDefaultRealm() {
        RealmMBean realmMBean = this.getRealm();
        if (realmMBean == null) {
            throw new AssertionError((Object)"Realm customizer cannot get its RealmMBean");
        }
        String string = realmMBean.getName();
        if (string == null || string.length() < 1) {
            throw new AssertionError((Object)"RealmMBean has a null or empty name");
        }
        RealmMBean realmMBean2 = this.getRealmContainer().getDefaultRealmInternal();
        if (realmMBean2 == null) {
            return false;
        }
        return string.equals(realmMBean2.getName());
    }

    public boolean isDefaultRealm() {
        return this.constructed() ? this.amDefaultRealm() : false;
    }

    public void setDefaultRealm(boolean bl) throws InvalidAttributeValueException {
        if (this.constructed()) {
            if (this.amDefaultRealm()) {
                if (!bl) {
                    this.getRealmContainer().setDefaultRealmInternal(null);
                }
            } else if (bl) {
                this.getRealmContainer().setDefaultRealmInternal(this.getRealm());
            }
        }
    }

    public String getCompatibilityObjectName() {
        String string = "Security:Name=";
        String string2 = string + this.getRealm().getName();
        return string2;
    }

    private String[] getProviderTypes(String string) {
        String[] stringArray = BeanInfoAccessFactory.getBeanInfoAccess().getSubtypes(string + MBEAN_SUFFIX);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            boolean bl;
            String string2 = stringArray[i];
            BeanInfo beanInfo = BeanInfoAccessFactory.getBeanInfoAccess().getBeanInfoForInterface(string2, false, null);
            if (beanInfo == null) continue;
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            if (beanDescriptor == null) {
                throw new AssertionError((Object)("Could not get BeanDescriptor for provider type " + string2));
            }
            Boolean bl2 = (Boolean)beanDescriptor.getValue("abstract");
            boolean bl3 = bl = bl2 != null ? bl2 : false;
            if (bl) continue;
            if (!string2.endsWith(MBEAN_SUFFIX)) {
                throw new AssertionError((Object)("Provider type " + string2 + " should have ended with " + MBEAN_SUFFIX));
            }
            String string3 = string2.substring(0, string2.length() - MBEAN_SUFFIX.length());
            if (string3.startsWith("weblogic.security.providers.realmadapter.")) continue;
            vector.add(string3);
        }
        return vector.size() > 0 ? vector.toArray(new String[0]) : null;
    }

    public String[] getPasswordValidatorTypes() {
        return this.getProviderTypes("weblogic.management.security.authentication.PasswordValidator");
    }

    public String[] getAuditorTypes() {
        return this.getProviderTypes("weblogic.management.security.audit.Auditor");
    }

    public String[] getAuthenticationProviderTypes() {
        return this.getProviderTypes("weblogic.management.security.authentication.AuthenticationProvider");
    }

    public String[] getRoleMapperTypes() {
        return this.getProviderTypes("weblogic.management.security.authorization.RoleMapper");
    }

    public String[] getAuthorizerTypes() {
        return this.getProviderTypes("weblogic.management.security.authorization.Authorizer");
    }

    public String[] getAdjudicatorTypes() {
        return this.getProviderTypes("weblogic.management.security.authorization.Adjudicator");
    }

    public String[] getCredentialMapperTypes() {
        return this.getProviderTypes("weblogic.management.security.credentials.CredentialMapper");
    }

    public String[] getCertPathProviderTypes() {
        return this.getProviderTypes("weblogic.management.security.pk.CertPathProvider");
    }

    public String[] getKeyStoreTypes() {
        return this.getProviderTypes("weblogic.management.security.pk.KeyStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderMBean createProvider(String string, String[] stringArray, String string2, boolean bl, String string3, ProviderCreator providerCreator) throws JMException, ClassNotFoundException {
        boolean bl2 = false;
        for (int i = 0; !bl2 && stringArray != null && i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            bl2 = true;
        }
        if (!bl2) {
            String string4 = "";
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                if (i > 0) {
                    string4 = string4 + ",";
                }
                string4 = string4 + stringArray[i];
            }
            throw new IllegalArgumentException(SecurityMessagesTextFormatter.getInstance().getUnknownSecurityProviderTypeError(string2, string, string4));
        }
        Class<?> clazz = Class.forName(string2 + MBEAN_SUFFIX, true, DescriptorClassLoader.getClassLoader());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(DescriptorClassLoader.getClassLoader());
            ProviderMBean providerMBean = bl ? providerCreator.createProvider(clazz, string3) : providerCreator.createProvider(clazz);
            return providerMBean;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private AuditorMBean createAuditor(String string, boolean bl, String string2) throws JMException, ClassNotFoundException {
        return (AuditorMBean)this.createProvider("Auditor", this.getRealm().getAuditorTypes(), string, bl, string2, new ProviderCreator(){

            public ProviderMBean createProvider(Class clazz) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createAuditor(clazz);
            }

            public ProviderMBean createProvider(Class clazz, String string) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createAuditor(clazz, string);
            }
        });
    }

    public AuthenticationProviderMBean createAuthenticationProvider(String string, boolean bl, String string2) throws JMException, ClassNotFoundException {
        return (AuthenticationProviderMBean)this.createProvider("AutenticationProvider", this.getRealm().getAuthenticationProviderTypes(), string, bl, string2, new ProviderCreator(){

            public ProviderMBean createProvider(Class clazz) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createAuthenticationProvider(clazz);
            }

            public ProviderMBean createProvider(Class clazz, String string) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createAuthenticationProvider(clazz, string);
            }
        });
    }

    public RoleMapperMBean createRoleMapper(String string, boolean bl, String string2) throws JMException, ClassNotFoundException {
        return (RoleMapperMBean)this.createProvider("RoleMapper", this.getRealm().getRoleMapperTypes(), string, bl, string2, new ProviderCreator(){

            public ProviderMBean createProvider(Class clazz) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createRoleMapper(clazz);
            }

            public ProviderMBean createProvider(Class clazz, String string) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createRoleMapper(clazz, string);
            }
        });
    }

    public AuthorizerMBean createAuthorizer(String string, boolean bl, String string2) throws JMException, ClassNotFoundException {
        return (AuthorizerMBean)this.createProvider("Authorizer", this.getRealm().getAuthorizerTypes(), string, bl, string2, new ProviderCreator(){

            public ProviderMBean createProvider(Class clazz) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createAuthorizer(clazz);
            }

            public ProviderMBean createProvider(Class clazz, String string) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createAuthorizer(clazz, string);
            }
        });
    }

    public AdjudicatorMBean createAdjudicator(String string, boolean bl, String string2) throws JMException, ClassNotFoundException {
        return (AdjudicatorMBean)this.createProvider("Adjudicator", this.getRealm().getAdjudicatorTypes(), string, bl, string2, new ProviderCreator(){

            public ProviderMBean createProvider(Class clazz) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createAdjudicator(clazz);
            }

            public ProviderMBean createProvider(Class clazz, String string) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createAdjudicator(clazz, string);
            }
        });
    }

    public CredentialMapperMBean createCredentialMapper(String string, boolean bl, String string2) throws JMException, ClassNotFoundException {
        return (CredentialMapperMBean)this.createProvider("CredentialMapper", this.getRealm().getCredentialMapperTypes(), string, bl, string2, new ProviderCreator(){

            public ProviderMBean createProvider(Class clazz) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createCredentialMapper(clazz);
            }

            public ProviderMBean createProvider(Class clazz, String string) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createCredentialMapper(clazz, string);
            }
        });
    }

    public CertPathProviderMBean createCertPathProvider(String string, boolean bl, String string2) throws JMException, ClassNotFoundException {
        return (CertPathProviderMBean)this.createProvider("CertPathProvider", this.getRealm().getCertPathProviderTypes(), string, bl, string2, new ProviderCreator(){

            public ProviderMBean createProvider(Class clazz) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createCertPathProvider(clazz);
            }

            public ProviderMBean createProvider(Class clazz, String string) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createCertPathProvider(clazz, string);
            }
        });
    }

    public KeyStoreMBean createKeyStore(String string, boolean bl, String string2) throws JMException, ClassNotFoundException {
        return (KeyStoreMBean)this.createProvider("KeyStore", this.getRealm().getKeyStoreTypes(), string, bl, string2, new ProviderCreator(){

            public ProviderMBean createProvider(Class clazz) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createKeyStore(clazz);
            }

            public ProviderMBean createProvider(Class clazz, String string) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createKeyStore(clazz, string);
            }
        });
    }

    public PasswordValidatorMBean createPasswordValidator(String string, boolean bl, String string2) throws JMException, ClassNotFoundException {
        return (PasswordValidatorMBean)this.createProvider("PasswordValidator", this.getRealm().getPasswordValidatorTypes(), string, bl, string2, new ProviderCreator(){

            public ProviderMBean createProvider(Class clazz) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createPasswordValidator(clazz);
            }

            public ProviderMBean createProvider(Class clazz, String string) throws JMException, ClassNotFoundException {
                return RealmImpl.this.getRealm().createPasswordValidator(clazz, string);
            }
        });
    }

    public AuditorMBean createAuditor(String string, String string2) throws JMException, ClassNotFoundException {
        return this.createAuditor(string2, true, string);
    }

    public AuthenticationProviderMBean createAuthenticationProvider(String string, String string2) throws JMException, ClassNotFoundException {
        ConfigurationValidator.validateName(string);
        return this.createAuthenticationProvider(string2, true, string);
    }

    public RoleMapperMBean createRoleMapper(String string, String string2) throws JMException, ClassNotFoundException {
        return this.createRoleMapper(string2, true, string);
    }

    public AuthorizerMBean createAuthorizer(String string, String string2) throws JMException, ClassNotFoundException {
        return this.createAuthorizer(string2, true, string);
    }

    public AdjudicatorMBean createAdjudicator(String string, String string2) throws JMException, ClassNotFoundException {
        return this.createAdjudicator(string2, true, string);
    }

    public CredentialMapperMBean createCredentialMapper(String string, String string2) throws JMException, ClassNotFoundException {
        return this.createCredentialMapper(string2, true, string);
    }

    public CertPathProviderMBean createCertPathProvider(String string, String string2) throws JMException, ClassNotFoundException {
        return this.createCertPathProvider(string2, true, string);
    }

    public KeyStoreMBean createKeyStore(String string, String string2) throws JMException, ClassNotFoundException {
        return this.createKeyStore(string2, true, string);
    }

    public AuditorMBean createAuditor(String string) throws JMException, ClassNotFoundException {
        return this.createAuditor(string, false, null);
    }

    public AuthenticationProviderMBean createAuthenticationProvider(String string) throws JMException, ClassNotFoundException {
        return this.createAuthenticationProvider(string, false, null);
    }

    public RoleMapperMBean createRoleMapper(String string) throws JMException, ClassNotFoundException {
        return this.createRoleMapper(string, false, null);
    }

    public AuthorizerMBean createAuthorizer(String string) throws JMException, ClassNotFoundException {
        return this.createAuthorizer(string, false, null);
    }

    public AdjudicatorMBean createAdjudicator(String string) throws JMException, ClassNotFoundException {
        return this.createAdjudicator(string, false, null);
    }

    public CredentialMapperMBean createCredentialMapper(String string) throws JMException, ClassNotFoundException {
        return this.createCredentialMapper(string, false, null);
    }

    public CertPathProviderMBean createCertPathProvider(String string) throws JMException, ClassNotFoundException {
        return this.createCertPathProvider(string, false, null);
    }

    public KeyStoreMBean createKeyStore(String string) throws JMException, ClassNotFoundException {
        return this.createKeyStore(string, false, null);
    }

    public PasswordValidatorMBean createPasswordValidator(String string, String string2) throws JMException, ClassNotFoundException {
        return this.createPasswordValidator(string2, true, string);
    }

    public PasswordValidatorMBean createPasswordValidator(String string) throws JMException, ClassNotFoundException {
        return this.createPasswordValidator(string, false, null);
    }

    private static interface ProviderCreator {
        public ProviderMBean createProvider(Class var1) throws JMException, ClassNotFoundException;

        public ProviderMBean createProvider(Class var1, String var2) throws JMException, ClassNotFoundException;
    }
}

