/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.security;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.commo.AbstractCommoConfigurationBeanImplBeanInfo;
import weblogic.management.internal.mbean.BeanInfoHelper;
import weblogic.management.security.RealmMBean;
import weblogic.management.security.RealmMBeanImpl;
import weblogic.management.security.audit.AuditorMBean;
import weblogic.management.security.authentication.AuthenticationProviderMBean;
import weblogic.management.security.authentication.PasswordValidatorMBean;
import weblogic.management.security.authorization.AuthorizerMBean;
import weblogic.management.security.authorization.RoleMapperMBean;
import weblogic.management.security.credentials.CredentialMapperMBean;
import weblogic.management.security.pk.CertPathProviderMBean;
import weblogic.management.security.pk.KeyStoreMBean;

public class RealmMBeanImplBeanInfo
extends AbstractCommoConfigurationBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = RealmMBean.class;

    public RealmMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public RealmMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = RealmMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("package", "weblogic.management.security");
        String string = new String("The MBean that represents configuration attributes for the security realm. <p> A security realm contains a set of security configuration settings, including the list of security providers to use (for example, for authentication and authorization). <p> Code using security can either use the default security realm for the domain or refer to a particular security realm by name (by using the JMX display name of the security realm). <p> One security realm in the WebLogic domain must have the <code>DefaultRealm</code> attribute set to true. The security realm with the <code>DefaultRealm</code> attribute set to true is used as the default security realm for the WebLogic domain. Note that other available security realms must have the <code>DefaultRealm</code> attribute set to false. <p> When WebLogic Server boots, it locates and uses the default security realm. The security realm is considered active since it is used when WebLogic Server runs. Any security realm that is not used when WebLogic Server runs is considered inactive. All active security realms must be configured before WebLogic Server is boots. <p> Since security providers are scoped by realm, the <code>Realm</code> attribute on a security provider must be set to the realm that uses the provider.  <h3 class=\"TypeSafeDeprecation\">Deprecation of MBeanHome and Type-Safe Interfaces</h3>  <p class=\"TypeSafeDeprecation\">In addition to being used as a base class that provides functionality to security provider MBeans, JMX applications can use this class directly as a type-safe interface. When used as a type-safe interface, a JMX application imports this class and accesses it through <code>weblogic.management.MBeanHome</code>. As of 9.0, the <code>MBeanHome</code> interface and all type-safe interfaces for WebLogic Server MBeans are deprecated. Instead, JMX applications that interact with WebLogic Server MBeans should use standard JMX design patterns in which clients use the <code>javax.management.MBeanServerConnection</code> interface to discover MBeans, attributes, and attribute types at runtime.</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.security.RealmMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String[] stringArray;
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("Adjudicator")) {
            string2 = "getAdjudicator";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Adjudicator", RealmMBean.class, string2, string);
            map.put("Adjudicator", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the Adjudication provider for this security realm. ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("creator", "createAdjudicator");
            propertyDescriptor.setValue("creator", "createAdjudicator");
            propertyDescriptor.setValue("destroyer", "destroyAdjudicator");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("AdjudicatorTypes")) {
            string2 = "getAdjudicatorTypes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AdjudicatorTypes", RealmMBean.class, string2, string);
            map.put("AdjudicatorTypes", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the types of Adjudication providers that may be created in this security realm, for example, <code>weblogic.security.providers.authorization.DefaultAdjudicator</code>. Use this method to find the available types to pass to <code>createAdjudicator</code> ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("AuditorTypes")) {
            string2 = "getAuditorTypes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AuditorTypes", RealmMBean.class, string2, string);
            map.put("AuditorTypes", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the types of Auditing providers that may be created in this security realm, for example, <code>weblogic.security.providers.audit.DefaultAuditor</code>. Use this method to find the available types to pass to <code>createAuditor</code> ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("Auditors")) {
            string2 = "getAuditors";
            string = null;
            if (!this.readOnly) {
                string = "setAuditors";
            }
            propertyDescriptor = new PropertyDescriptor("Auditors", RealmMBean.class, string2, string);
            map.put("Auditors", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the Auditing providers for this security realm (in invocation order). ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("creator", "createAuditor");
            propertyDescriptor.setValue("creator", "createAuditor");
            propertyDescriptor.setValue("destroyer", "destroyAuditor");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.2.0.0", null, (String)this.targetVersion) && !map.containsKey("AuthMethods")) {
            string2 = "getAuthMethods";
            string = null;
            if (!this.readOnly) {
                string = "setAuthMethods";
            }
            propertyDescriptor = new PropertyDescriptor("AuthMethods", RealmMBean.class, string2, string);
            map.put("AuthMethods", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns a comma separated string of authentication methods that should be used when the Web application specifies \"REALM\" as its auth-method. The authentication methods will be applied in order in which they appear in the list. ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("since", "9.2.0.0");
        }
        if (!map.containsKey("AuthenticationProviderTypes")) {
            string2 = "getAuthenticationProviderTypes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AuthenticationProviderTypes", RealmMBean.class, string2, string);
            map.put("AuthenticationProviderTypes", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the types of Authentication providers that may be created in this security realm, for example, <code>weblogic.security.providers.authentication.DefaultAuthenticator</code>. Use this method to find the available types to pass to <code>createAuthenticationProvider</code> ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("AuthenticationProviders")) {
            string2 = "getAuthenticationProviders";
            string = null;
            if (!this.readOnly) {
                string = "setAuthenticationProviders";
            }
            propertyDescriptor = new PropertyDescriptor("AuthenticationProviders", RealmMBean.class, string2, string);
            map.put("AuthenticationProviders", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the Authentication providers for this security realm (in invocation order). ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("creator", "createAuthenticationProvider");
            propertyDescriptor.setValue("creator", "createAuthenticationProvider");
            propertyDescriptor.setValue("destroyer", "destroyAuthenticationProvider");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("AuthorizerTypes")) {
            string2 = "getAuthorizerTypes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AuthorizerTypes", RealmMBean.class, string2, string);
            map.put("AuthorizerTypes", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the types of Authorization providers that may be created in this security realm, for example, <code>weblogic.security.providers.authorization.DefaultAuthorizer</code>. Use this method to find the available types to pass to <code>createAuthorizer</code> ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("Authorizers")) {
            string2 = "getAuthorizers";
            string = null;
            if (!this.readOnly) {
                string = "setAuthorizers";
            }
            propertyDescriptor = new PropertyDescriptor("Authorizers", RealmMBean.class, string2, string);
            map.put("Authorizers", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the Authorization providers for this security realm (in invocation order). ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("destroyer", "destroyAuthorizer");
            propertyDescriptor.setValue("creator", "createAuthorizer");
            propertyDescriptor.setValue("creator", "createAuthorizer");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("CertPathBuilder")) {
            string2 = "getCertPathBuilder";
            string = null;
            if (!this.readOnly) {
                string = "setCertPathBuilder";
            }
            propertyDescriptor = new PropertyDescriptor("CertPathBuilder", RealmMBean.class, string2, string);
            map.put("CertPathBuilder", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the CertPath Builder provider in this security realm that will be used by the security system to build certification paths.  Returns null if none has been selected.  The provider will be one of this security realm's <code>CertPathProviders</code>. ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("CertPathProviderTypes")) {
            string2 = "getCertPathProviderTypes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CertPathProviderTypes", RealmMBean.class, string2, string);
            map.put("CertPathProviderTypes", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the types of Certification Path providers that may be created in this security realm, for example, <code>weblogic.security.providers.pk.WebLogicCertPathProvider</code>. Use this method to find the available types to pass to <code>createCertPathProvider</code> ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("CertPathProviders")) {
            string2 = "getCertPathProviders";
            string = null;
            if (!this.readOnly) {
                string = "setCertPathProviders";
            }
            propertyDescriptor = new PropertyDescriptor("CertPathProviders", RealmMBean.class, string2, string);
            map.put("CertPathProviders", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the Certification Path providers for this security realm (in invocation order). ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("destroyer", "destroyCertPathProvider");
            propertyDescriptor.setValue("creator", "createCertPathProvider");
            propertyDescriptor.setValue("creator", "createCertPathProvider");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("CredentialMapperTypes")) {
            string2 = "getCredentialMapperTypes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CredentialMapperTypes", RealmMBean.class, string2, string);
            map.put("CredentialMapperTypes", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the types of Credential Mapping providers that may be created in this security realm, for example, <code>weblogic.security.providers.credentials.DefaultCredentialMapper</code>. Use this method to find the available types to pass to <code>createCredentialMapper</code> ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("CredentialMappers")) {
            string2 = "getCredentialMappers";
            string = null;
            if (!this.readOnly) {
                string = "setCredentialMappers";
            }
            propertyDescriptor = new PropertyDescriptor("CredentialMappers", RealmMBean.class, string2, string);
            map.put("CredentialMappers", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the Credential Mapping providers for this security realm (in invocation order). ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("destroyer", "destroyCredentialMapper");
            propertyDescriptor.setValue("creator", "createCredentialMapper");
            propertyDescriptor.setValue("creator", "createCredentialMapper");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3", null, (String)this.targetVersion) && !map.containsKey("DeployableProviderSynchronizationTimeout")) {
            string2 = "getDeployableProviderSynchronizationTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setDeployableProviderSynchronizationTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("DeployableProviderSynchronizationTimeout", RealmMBean.class, string2, string);
            map.put("DeployableProviderSynchronizationTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the timeout value, in milliseconds, for the deployable security provider synchronization operation. This value is only used if <code>DeployableProviderSynchronizationEnabled</code> is set to <code>true</code> ");
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(60000));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("since", "10.3");
        }
        if (!map.containsKey("KeyStoreTypes")) {
            string2 = "getKeyStoreTypes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("KeyStoreTypes", RealmMBean.class, string2, string);
            map.put("KeyStoreTypes", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the types of KeyStore providers that may be created in this security realm, for example, <code>weblogic.security.providers.pk.DefaultKeyStore</code>. Use this method to find the available types to pass to <code>createKeyStore</code> ");
            propertyDescriptor.setValue("deprecated", "8.1.0.0 ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("KeyStores")) {
            string2 = "getKeyStores";
            string = null;
            if (!this.readOnly) {
                string = "setKeyStores";
            }
            propertyDescriptor = new PropertyDescriptor("KeyStores", RealmMBean.class, string2, string);
            map.put("KeyStores", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the KeyStore providers for this security realm (in invocation order). ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("destroyer", "destroyKeyStore");
            propertyDescriptor.setValue("creator", "createKeyStore");
            propertyDescriptor.setValue("creator", "createKeyStore");
            propertyDescriptor.setValue("deprecated", "8.1.0.0 ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("MaxWebLogicPrincipalsInCache")) {
            string2 = "getMaxWebLogicPrincipalsInCache";
            string = null;
            if (!this.readOnly) {
                string = "setMaxWebLogicPrincipalsInCache";
            }
            propertyDescriptor = new PropertyDescriptor("MaxWebLogicPrincipalsInCache", RealmMBean.class, string2, string);
            map.put("MaxWebLogicPrincipalsInCache", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the maximum size of the LRU cache for holding WebLogic Principal signatures. This value is only used if <code>EnableWebLogicPrincipalValidatorCache</code> is set to <code>true</code> ");
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(500));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("Name")) {
            string2 = "getName";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Name", RealmMBean.class, string2, string);
            map.put("Name", propertyDescriptor);
            propertyDescriptor.setValue("description", "The name of this configuration. WebLogic Server uses an MBean to implement and persist the configuration. ");
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"Realm");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("legal", "");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.0", null, (String)this.targetVersion) && !map.containsKey("PasswordValidatorTypes")) {
            string2 = "getPasswordValidatorTypes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("PasswordValidatorTypes", RealmMBean.class, string2, string);
            map.put("PasswordValidatorTypes", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the types of Password Validator providers that may be created in this security realm, for example, <code>com.bea.security.providers.authentication.passwordvalidator.SystemPasswordValidator</code>. Use this method to find the available types to pass to <code>createPasswordValidator</code> ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("since", "10.0");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.0", null, (String)this.targetVersion) && !map.containsKey("PasswordValidators")) {
            string2 = "getPasswordValidators";
            string = null;
            if (!this.readOnly) {
                string = "setPasswordValidators";
            }
            propertyDescriptor = new PropertyDescriptor("PasswordValidators", RealmMBean.class, string2, string);
            map.put("PasswordValidators", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the Password Validator providers for this security realm (in invocation order). ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("destroyer", "destroyPasswordValidator");
            propertyDescriptor.setValue("creator", "createPasswordValidator");
            propertyDescriptor.setValue("creator", "createPasswordValidator");
            propertyDescriptor.setValue("creator", "createPasswordValidator");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("since", "10.0");
        }
        if (!map.containsKey("RDBMSSecurityStore")) {
            string2 = "getRDBMSSecurityStore";
            string = null;
            propertyDescriptor = new PropertyDescriptor("RDBMSSecurityStore", RealmMBean.class, string2, string);
            map.put("RDBMSSecurityStore", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns RDBMSSecurityStoreMBean for this realm, which is a singleton MBean describing RDBMS security store configuration. ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#createRDBMSSecurityStore")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("destroyer", "destroyRDBMSSecurityStore");
            propertyDescriptor.setValue("creator", "createRDBMSSecurityStore");
            propertyDescriptor.setValue("creator", "createRDBMSSecurityStore");
        }
        if (!map.containsKey("RoleMapperTypes")) {
            string2 = "getRoleMapperTypes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("RoleMapperTypes", RealmMBean.class, string2, string);
            map.put("RoleMapperTypes", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the types of Role Mapping providers that may be created in this security realm, for example, <code>weblogic.security.providers.authorization.DefaultRoleMapper</code>. Use this method to find the available types to pass to <code>createRoleMapper</code> ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("RoleMappers")) {
            string2 = "getRoleMappers";
            string = null;
            if (!this.readOnly) {
                string = "setRoleMappers";
            }
            propertyDescriptor = new PropertyDescriptor("RoleMappers", RealmMBean.class, string2, string);
            map.put("RoleMappers", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the Role Mapping providers for this security realm (in invocation order). ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("creator", "createRoleMapper");
            propertyDescriptor.setValue("creator", "createRoleMapper");
            propertyDescriptor.setValue("destroyer", "destroyRoleMapper");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("SecurityDDModel")) {
            string2 = "getSecurityDDModel";
            string = null;
            if (!this.readOnly) {
                string = "setSecurityDDModel";
            }
            propertyDescriptor = new PropertyDescriptor("SecurityDDModel", RealmMBean.class, string2, string);
            map.put("SecurityDDModel", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies the default security model for Web applications or EJBs that are secured by this security realm. You can override this default during deployment.</p> <dl><dt>Note:</dt> <dd>If you deploy a module by modifying the domain's <code>config.xml</code> file and restarting the server, and if you do not specify a security model value for the module in <code>config.xml</code>, the module is secured with the default value of the <code>AppDeploymentMBean SecurityDDModel</code>  attribute (see {@link weblogic.management.AppDeploymentMBean#SecurityDDModel AppDeploymentMBean SecurityDDModel}). </dd> <p>Choose one of these security models:</p>  <ul> <li><code>Deployment Descriptors Only (DDOnly)</code> <ul> <li>For EJBs and URL patterns, this model uses only the roles and policies in the J2EE deployment descriptors (DD); the Administration Console allows only read access for this data. With this model, EJBs and URL patterns are not protected by roles and policies of a broader scope (such as a policy scoped to an entire Web application). If an EJB or URL pattern is not protected by a role or policy in the DD, then it is unprotected: anyone can access it. </li>  <li>For application-scoped <i>roles</i> in an EAR, this model uses only the roles defined in the WebLogic Server DD; the Administration Console allows only read access for this data. If the WebLogic Server DD does not define roles, then there will be no such scoped roles defined for this EAR.</li>  <li>For all other types of resources, you can use the Administration Console to create roles or policies. For example, with this model, you can use the Administration Console to create application-scoped <i>policies</i> for an EAR.</li>   <li>Applies for the life of the deployment. If you want to use a different model, you must delete the deployment and reinstall it.</li> </ul></li>  <li><code>Customize Roles Only (CustomRoles)</code> <ul> <li>For EJBs and URL patterns, this model uses only the <i>policies</i> in the J2EE deployment descriptors (DD). EJBs and URL patterns are not protected by policies of a broader scope (such as a policy scoped to an entire Web application). This model ignores any <i>roles</i> defined in the DDs; an administrator completes the role mappings using the Administration Console.</li>  <li>For all other types of resources, you can use the Administration Console to create roles or policies. For example, with this model, you can use the Administration Console to create application-scoped policies or roles for an EAR.</li>  <li>Applies for the life of the deployment. If you want to use a different model, you must delete the deployment and reinstall it.</li> </ul></li>  <li><code>Customize Roles and Policies (CustomRolesAndPolicies)</code> <ul> <li>Ignores any roles and policies defined in deployment descriptors. An administrator uses the Administration Console to secure the resources.</li>  <li>Performs security checks for <b>all</b> URLs or EJB methods in the module.</li>  <li>Applies for the life of the deployment. If you want to use a different model, you must delete the deployment and reinstall it.</li> </ul></li>  <li><code>Advanced (Advanced)</code> <p>You configure how this model behaves by setting values for the following options:</p> <ul> <li><code>When Deploying Web Applications or EJBs</code> <dl><dt>Note:</dt> <dd>When using the WebLogic Scripting Tool or JMX APIs, there is no single MBean attribute for this setting. Instead, you must set the values for the <code>DeployPolicyIgnored</code> and <code>DeployRoleIgnored</code> attributes of <code>RealmMBean</code>.</dd> </dl></li>  <li><code>Check Roles and Policies (FullyDelegateAuthorization)</code></li>  <li><code>Combined Role Mapping Enabled (CombinedRoleMappingEnabled)</code></li> </ul>You can change the configuration of this model. Any changes immediately apply to all modules that use the Advanced model. For example, you can specify that all modules using this model will copy roles and policies from their deployment descriptors into the appropriate provider databases upon deployment. After you deploy all of your modules, you can change this behavior to ignore roles and policies in deployment descriptors so that when you redeploy modules they will not re-copy roles and policies.<dl> <dt>Note:</dt>  <dd>Prior to WebLogic Server version 9.0 the Advanced model was the only security model available. Use this model if you want to continue to secure EJBs and Web Applications as in releases prior to 9.0.</dd> </dl></li> </ul> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#isDeployPolicyIgnored()"), BeanInfoHelper.encodeEntities((String)"#isDeployRoleIgnored()"), BeanInfoHelper.encodeEntities((String)"#isFullyDelegateAuthorization()"), BeanInfoHelper.encodeEntities((String)"#isCombinedRoleMappingEnabled()")};
            propertyDescriptor.setValue("see", stringArray);
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"DDOnly");
            propertyDescriptor.setValue("legalValues", new Object[]{"DDOnly", "CustomRoles", "CustomRolesAndPolicies", "Advanced"});
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("UserLockoutManager")) {
            string2 = "getUserLockoutManager";
            string = null;
            propertyDescriptor = new PropertyDescriptor("UserLockoutManager", RealmMBean.class, string2, string);
            map.put("UserLockoutManager", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the User Lockout Manager for this security realm. ");
            propertyDescriptor.setValue("relationship", "containment");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("CombinedRoleMappingEnabled")) {
            string2 = "isCombinedRoleMappingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setCombinedRoleMappingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("CombinedRoleMappingEnabled", RealmMBean.class, string2, string);
            map.put("CombinedRoleMappingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Determines how the role mappings in the Enterprise Application, Web application, and EJB containers interact. This setting is valid only for Web applications and EJBs that use the Advanced security model and that initialize roles from deployment descriptors.</p> <p>When enabled:</p>  <ul> <li>Application role mappings are combined with EJB and Web application mappings so that all principal mappings are included. The Security Service combines the role mappings with a logical <code>OR</code> operator.</li>  <li>If one or more policies in the <code>web.xml</code> file specify a role for which no mapping exists in the <code>weblogic.xml</code> file, the Web application container creates an empty map for the undefined role (that is, the role is explicitly defined as containing no principal). Therefore, no one can access URL patterns that are secured by such policies.</li>  <li>If one or more policies in the <code>ejb-jar.xml</code> file specify a role for which no mapping exists in the <code>weblogic-ejb-jar.xml</code> file, the EJB container creates an empty map for the undefined role (that is, the role is explicitly defined as containing no principal). Therefore, no one can access methods that are secured by such policies.</li> </ul>  <p>When disabled:</p>  <ul> <li>Role mappings for each container are exclusive to other containers unless defined by the <code>&lt;externally-defined&gt;</code> descriptor element.</li>  <li>If one or more policies in the <code>web.xml</code> file specify a role for which no role mapping exists in the <code>weblogic.xml</code> file, the Web application container assumes that the undefined role is the name of a principal. It therefore maps the assumed principal to the role name. For example, if the <code>web.xml</code> file contains the following stanza in one of its policies:<br /><code>&lt;auth-constraint&gt; &lt;role-name&gt;PrivilegedUser&lt;/role-name&gt; &lt;/auth-constraint&gt;</code><br />but the <code>weblogic.xml</code> file has no role mapping for <code>PrivilegedUser</code>, then the Web application container creates an in-memory mapping that is equivalent to the following stanza:<br /><code>&lt;security-role-assignment&gt; &lt;role-name&gt;PrivilegedUser&lt;/role-name&gt; &lt;principal-name&gt;PrivilegedUser&lt;/principal-name&gt; &lt;/security-role-assignment&gt;</code></li>  <li>Role mappings for EJB methods must be defined in the <code>weblogic-ejb-jar.xml</code> file. Role mappings defined in the other containers are not used unless defined by the <code>&lt;externally-defined&gt;</code> descriptor element.</li> </ul>  <dl> <dt>Note:</dt>  <dd>For all applications previously deployed in version 8.1 and upgraded to version 9.x, the combining role mapping is disabled by default.</dd> </dl> ");
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("DefaultRealm")) {
            string2 = "isDefaultRealm";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultRealm";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultRealm", RealmMBean.class, string2, string);
            map.put("DefaultRealm", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns whether this security realm is the Default realm for the WebLogic domain. Deprecated in this release of WebLogic Server and replaced by <code>weblogic.management.configuration.SecurityConfigurationMBean.getDefaultRealm</code>. ");
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 Replaced by {@link weblogic.management.configuration.SecurityConfigurationMBean#getDefaultRealm()} ");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.1.0.0", null, (String)this.targetVersion) && !map.containsKey("DelegateMBeanAuthorization")) {
            string2 = "isDelegateMBeanAuthorization";
            string = null;
            if (!this.readOnly) {
                string = "setDelegateMBeanAuthorization";
            }
            propertyDescriptor = new PropertyDescriptor("DelegateMBeanAuthorization", RealmMBean.class, string2, string);
            map.put("DelegateMBeanAuthorization", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Configures the WebLogic Server MBean servers to use the security realm's Authorization providers to determine whether a JMX client has permission to access an MBean attribute or invoke an MBean operation.</p> <p>You can continue to use WebLogic Server's default security settings or modify the defaults to suit your needs.</p> <p>If you do not delegate authorization to the realm's Authorization providers, the WebLogic MBean servers allow access only to the four default security roles (Admin, Deployer, Operator, and Monitor) and only as specified by WebLogic Server's default security settings.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"<a href=\"../html/mbeansecroles.html\">Default Security Policies for MBeans</a>")};
            propertyDescriptor.setValue("see", stringArray);
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("since", "9.1.0.0");
        }
        if (!map.containsKey("DeployCredentialMappingIgnored")) {
            string2 = "isDeployCredentialMappingIgnored";
            string = null;
            if (!this.readOnly) {
                string = "setDeployCredentialMappingIgnored";
            }
            propertyDescriptor = new PropertyDescriptor("DeployCredentialMappingIgnored", RealmMBean.class, string2, string);
            map.put("DeployCredentialMappingIgnored", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns whether credential mapping deployment calls on the security system are ignored or passed to the configured Credential Mapping providers. ");
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("DeployPolicyIgnored")) {
            string2 = "isDeployPolicyIgnored";
            string = null;
            if (!this.readOnly) {
                string = "setDeployPolicyIgnored";
            }
            propertyDescriptor = new PropertyDescriptor("DeployPolicyIgnored", RealmMBean.class, string2, string);
            map.put("DeployPolicyIgnored", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns whether policy deployment calls on the security system are ignored or passed to the configured Authorization providers. ");
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("DeployRoleIgnored")) {
            string2 = "isDeployRoleIgnored";
            string = null;
            if (!this.readOnly) {
                string = "setDeployRoleIgnored";
            }
            propertyDescriptor = new PropertyDescriptor("DeployRoleIgnored", RealmMBean.class, string2, string);
            map.put("DeployRoleIgnored", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns whether role deployment calls on the security system are ignored or passed to the configured Role Mapping providers. ");
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3", null, (String)this.targetVersion) && !map.containsKey("DeployableProviderSynchronizationEnabled")) {
            string2 = "isDeployableProviderSynchronizationEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setDeployableProviderSynchronizationEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("DeployableProviderSynchronizationEnabled", RealmMBean.class, string2, string);
            map.put("DeployableProviderSynchronizationEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "Specifies whether synchronization for deployable Authorization and Role Mapping providers is enabled. <p>The Authorization and Role Mapping providers may or may not support parallel security policy and role modification, respectively, in the security provider database. If the security providers do not support parallel modification, the WebLogic Security Framework enforces a synchronization mechanism that results in each application and module being placed in a queue and deployed sequentially. ");
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("since", "10.3");
        }
        if (!map.containsKey("EnableWebLogicPrincipalValidatorCache")) {
            string2 = "isEnableWebLogicPrincipalValidatorCache";
            string = null;
            if (!this.readOnly) {
                string = "setEnableWebLogicPrincipalValidatorCache";
            }
            propertyDescriptor = new PropertyDescriptor("EnableWebLogicPrincipalValidatorCache", RealmMBean.class, string2, string);
            map.put("EnableWebLogicPrincipalValidatorCache", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns whether the WebLogic Principal Validator caching is enabled. <p> The Principal Validator is used by Oracle supplied authentication providers and may be used by custom authentication providers. If enabled, the default principal validator will cache WebLogic Principal signatures. ");
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("FullyDelegateAuthorization")) {
            string2 = "isFullyDelegateAuthorization";
            string = null;
            if (!this.readOnly) {
                string = "setFullyDelegateAuthorization";
            }
            propertyDescriptor = new PropertyDescriptor("FullyDelegateAuthorization", RealmMBean.class, string2, string);
            map.put("FullyDelegateAuthorization", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns whether the Web and EJB containers should call the security framework on every access. <p> If false the containers are free to only call the security framework when security is set in the deployment descriptors. ");
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("deprecated", "9.0.0.0 ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("ValidateDDSecurityData")) {
            string2 = "isValidateDDSecurityData";
            string = null;
            if (!this.readOnly) {
                string = "setValidateDDSecurityData";
            }
            propertyDescriptor = new PropertyDescriptor("ValidateDDSecurityData", RealmMBean.class, string2, string);
            map.put("ValidateDDSecurityData", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Not used in this release.</p> ");
            RealmMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        String[] stringArray;
        MethodDescriptor methodDescriptor;
        Method method = RealmMBean.class.getMethod("createAuditor", String.class, String.class);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"- The name of this Auditing provider, for example, <code>DefaultAuditor</code> "), RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Auditing provider, for example, <code>weblogic.security.providers.audit.DefaultAuditor</code> Use <code>getAuditorTypes</code> to find the list of types that may be specified. ")};
        Object object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates an Auditing provider in this security realm. The new Auditing provider is added to the end of the list of Auditing providers  configured in this security realm. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "Auditors");
        }
        method = RealmMBean.class.getMethod("createAuditor", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Auditing provider, for example, <code>weblogic.security.providers.audit.DefaultAuditor</code> Use <code>getAuditorTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates an Auditing provider in this security realm. The new Auditing provider is added to the end of the list of Auditing providers  configured in this security realm. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "Auditors");
        }
        method = RealmMBean.class.getMethod("destroyAuditor", AuditorMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"auditor", (String)"- The Auditing provider to remove. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Removes the configuration for an Auditing provider in this security realm. It does not remove any persistent data for the Auditing provider (such as databases or files). <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code> automatically removes the security realm's Auditing providers. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "Auditors");
        }
        method = RealmMBean.class.getMethod("createAuthenticationProvider", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"- The name of this Authentication provider, for example, <code>DefaultAuthenticator</code> "), RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Authentication provider, for example, <code>weblogic.security.providers.authentication.DefaultAuthenticator</code> Use <code>getAuthenticationProviderTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates an Authentication provider in this security realm. The new Authentication provider is added to the end of the list of Authentication providers  configured in this security realm. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "AuthenticationProviders");
        }
        method = RealmMBean.class.getMethod("createAuthenticationProvider", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Authentication provider, for example, <code>weblogic.security.providers.authentication.DefaultAuthenticator</code> Use <code>getAuthenticationProviderTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates an Authentication provider in this security realm. The new Authentication provider is added to the end of the list of Authentication providers  configured in this security realm. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "AuthenticationProviders");
        }
        method = RealmMBean.class.getMethod("destroyAuthenticationProvider", AuthenticationProviderMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"authenticationProvider", (String)"- The Authentication provider to remove. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Removes the configuration for an Authentication provider in this security realm. It does not remove any persistent data for the Authentication provider (such as databases or files). <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code> automatically removes the security realm's Authentication providers. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "AuthenticationProviders");
        }
        method = RealmMBean.class.getMethod("createRoleMapper", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"- The name of this Role Mapping provider, for example, <code>DefaultRoleMapper</code> "), RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Role Mapping provider, for example, <code>weblogic.security.providers.authorization.DefaultRoleMapper</code> Use <code>getRoleMapperTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates a Role Mapping provider in this security realm. The new Role Mapping provider is added to the end of the list of Role Mapping providers  configured in this security realm. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "RoleMappers");
        }
        method = RealmMBean.class.getMethod("createRoleMapper", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Role Mapping provider, for example, <code>weblogic.security.providers.authorization.DefaultRoleMapper</code> Use <code>getRoleMapperTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates a Role Mapping provider in this security realm. The new Role Mapping provider is added to the end of the list of Role Mapping providers  configured in this security realm. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "RoleMappers");
        }
        method = RealmMBean.class.getMethod("destroyRoleMapper", RoleMapperMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"roleMapper", (String)"- The Role Mapping provider to remove. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Removes the configuration for a Role Mapping provider in this security realm. It does not remove any persistent data for the Role Mapping provider (such as databases or files). <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code> automatically removes the security realm's Role Mapping providers. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "RoleMappers");
        }
        method = RealmMBean.class.getMethod("createAuthorizer", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"- The name of this Authorization provider, for example, <code>DefaultAuthorizer</code> "), RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Authorization provider, for example, <code>weblogic.security.providers.authorization.DefaultAuthorizer</code> Use <code>getAuthorizerTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates an Authorization provider in this security realm. The new Authorization provider is added to the end of the list of Authorization providers  configured in this security realm. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "Authorizers");
        }
        method = RealmMBean.class.getMethod("createAuthorizer", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Authorization provider, for example, <code>weblogic.security.providers.authorization.DefaultAuthorizer</code> Use <code>getAuthorizerTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates an Authorization provider in this security realm. The new Authorization provider is added to the end of the list of Authorization providers  configured in this security realm. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "Authorizers");
        }
        method = RealmMBean.class.getMethod("destroyAuthorizer", AuthorizerMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"authorizer", (String)"- The Authorization provider to remove. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Removes the configuration for an Authorization provider in this security realm. It does not remove any persistent data for the Authorization provider (such as databases or files). <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code> automatically removes the security realm's Authorization providers. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "Authorizers");
        }
        method = RealmMBean.class.getMethod("createAdjudicator", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"- The name of this Adjudication provider, for example, <code>DefaultAdjudicator</code> "), RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Adjudication provider, for example, <code>weblogic.security.providers.authorization.DefaultAdjudicator</code> Use <code>getAdjudicatorTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates an Adjudication provider in this security realm and removes this security realm's previous Adjudication provider. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "Adjudicator");
        }
        method = RealmMBean.class.getMethod("createAdjudicator", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Adjudication provider, for example, <code>weblogic.security.providers.authorization.DefaultAdjudicator</code> Use <code>getAdjudicatorTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates an Adjudication provider in this security realm and removes this security realm's previous Adjudication provider. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "Adjudicator");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = RealmMBean.class.getMethod("destroyAdjudicator", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Removes the configuration this security realm's Adjudication provider (if there is one). It does not remove any persistent data for the Adjudication provider (such as databases or files). <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code> automatically removes the security realm's Adjudication provider. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "Adjudicator");
        }
        method = RealmMBean.class.getMethod("createCredentialMapper", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"- The name of this Credential Mapping provider, for example, <code>DefaultCredentialMapper</code> "), RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Credential Mapping provider, for example, <code>weblogic.security.providers.credentials.DefaultCredentialMapper</code> Use <code>getCredentialMapperTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates a Credential Mapping provider in this security realm. The new Credential Mapping provider is added to the end of the list of Credential Mapping providers  configured in this security realm. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "CredentialMappers");
        }
        method = RealmMBean.class.getMethod("createCredentialMapper", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Credential Mapping provider, for example, <code>weblogic.security.providers.credentials.DefaultCredentialMapper</code> Use <code>getCredentialMapperTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates a Credential Mapping provider in this security realm. The new Credential Mapping provider is added to the end of the list of Credential Mapping providers  configured in this security realm. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "CredentialMappers");
        }
        method = RealmMBean.class.getMethod("destroyCredentialMapper", CredentialMapperMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"credentialMapper", (String)"- The Credential Mapping provider to remove. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Removes the configuration for a Credential Mapping provider in this security realm. It does not remove any persistent data for the Credential Mapping provider (such as databases or files). <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code> automatically removes the security realm's Credential Mapping providers. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "CredentialMappers");
        }
        method = RealmMBean.class.getMethod("createCertPathProvider", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"- The name of this Certification Path provider, for example, <code>WebLogicCertPathProvider</code> "), RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Certification Path provider, for example, <code>weblogic.security.providers.pk.WebLogicCertPathProvider</code> Use <code>getCertPathProviderTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates a Certification Path provider in this security realm. The new Certification Path provider is added to the end of the list of Certification Path providers  configured in this security realm.  The active security realm must contain at least one Certification Path provider that is a CertPath Builder provider and at least one Certificate Path provider that is a CertPath Validator provider. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "CertPathProviders");
        }
        method = RealmMBean.class.getMethod("createCertPathProvider", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this Certification Path provider, for example, <code>weblogic.security.providers.pk.WebLogicCertPathProvider</code> Use <code>getCertPathProviderTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates a Certification Path provider in this security realm. The new Certification Path provider is added to the end of the list of Certification Path providers  configured in this security realm. <p> The active security realm must contain at least one Certification Path provider that is a CertPath Builder provider and at least one Certificate Path provider that is a CertPath Validator provider. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "CertPathProviders");
        }
        method = RealmMBean.class.getMethod("destroyCertPathProvider", CertPathProviderMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"certPathProvider", (String)"- The Certification Path provider to remove. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Removes the configuration for a Certification Path provider in this security realm. It does not remove any persistent data for the Certification Path provider (such as databases or files). <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code> automatically removes the security realm's Certification Path providers. <p> If <code>certPathProvider</code> has been selected as this security realm's <code>CertPathBuilder</code>, then this security realm's will have no <code>CertPathBuilder</code>. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "CertPathProviders");
        }
        method = RealmMBean.class.getMethod("createKeyStore", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"- The name of this KeyStore provider, for example, <code>DefaultKeyStore</code> "), RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this KeyStore provider, for example, <code>weblogic.security.providers.pk.DefaultKeyStore</code> Use <code>getKeyStoreTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "8.1.0.0 ");
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates a KeyStore provider in this security realm. The new KeyStore provider is added to the end of the list of KeyStore providers  configured in this security realm. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "KeyStores");
        }
        method = RealmMBean.class.getMethod("createKeyStore", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"- The type of this KeyStore provider, for example, <code>weblogic.security.providers.pk.DefaultKeyStore</code> Use <code>getKeyStoreTypes</code> to find the list of types that may be specified. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "8.1.0.0 ");
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates a KeyStore provider in this security realm. The new KeyStore provider is added to the end of the list of KeyStore providers  configured in this security realm. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "KeyStores");
        }
        method = RealmMBean.class.getMethod("destroyKeyStore", KeyStoreMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"keystore", (String)"- The KeyStore provider to remove. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "8.1.0.0 ");
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Removes the configuration for a KeyStore provider in this security realm. It does not remove any persistent data for the KeyStore provider (such as databases or files). <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code> automatically removes the security realm's KeyStore providers. ");
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "KeyStores");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = RealmMBean.class.getMethod("createRDBMSSecurityStore", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"JMException if an error occurs when creating a RDBMS security store")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Creates configuration for the RDBMS security store. This can be called only once unless the existing instance is destroyed by invoking <code>destroyRDBMSSecurityStore</code> operation. The new security store MBean will have this realm as its parent. ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#destroyRDBMSSecurityStore")};
            methodDescriptor.setValue("see", stringArray);
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "RDBMSSecurityStore");
        }
        method = RealmMBean.class.getMethod("createRDBMSSecurityStore", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"the name of this RDBMS security store ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"JMException if an error occurs when creating a RDBMS security store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Creates configuration for the RDBMS security store with the specified name. This can be called only once unless the existing instance is destroyed by invoking <code>destroyRDBMSSecurityStore</code> operation. The new security store MBean will have this realm as its parent. ");
            String[] stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#destroyRDBMSSecurityStore")};
            methodDescriptor.setValue("see", stringArray2);
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "RDBMSSecurityStore");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = RealmMBean.class.getMethod("destroyRDBMSSecurityStore", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Destroys and removes the existing RDBMS security store which is a child of this realm. It only removes the security store configuration, not any data persisted in the store. ");
            object = new String[]{BeanInfoHelper.encodeEntities((String)"#createRDBMSSecurityStore")};
            methodDescriptor.setValue("see", object);
            methodDescriptor.setValue("role", "factory");
            methodDescriptor.setValue("property", "RDBMSSecurityStore");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.0", null, (String)this.targetVersion)) {
            method = RealmMBean.class.getMethod("createPasswordValidator", Class.class, String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"subClass", (String)"Class The class of a Password Validator provider MBean implementation "), RealmMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"String The name for the given Password Validator provider MBean ")};
            object = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(object)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"JMException")};
                methodDescriptor.setValue("throws", stringArray);
                methodDescriptor.setValue("since", "10.0");
                map.put(object, methodDescriptor);
                methodDescriptor.setValue("description", "Creates a Password Validator provider in this security realm. The new Password Validator provider is added to the end of the list of Password Validator providers configured in this security realm. ");
                methodDescriptor.setValue("role", "factory");
                methodDescriptor.setValue("property", "PasswordValidators");
                methodDescriptor.setValue("since", "10.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.0", null, (String)this.targetVersion)) {
            method = RealmMBean.class.getMethod("createPasswordValidator", String.class, String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"String The name for the given Password Validator provider MBean "), RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"String The type of a Password Validator provider, all available types are in method <code>getPasswordValidatorTypes</code> ")};
            object = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(object)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"ClassNotFoundException"), BeanInfoHelper.encodeEntities((String)"JMException")};
                methodDescriptor.setValue("throws", stringArray);
                methodDescriptor.setValue("since", "10.0");
                map.put(object, methodDescriptor);
                methodDescriptor.setValue("description", "Creates a Password Validator provider in this security realm. The new Password Validator provider is added to the end of the list of Password Validator providers configured in this security realm. ");
                methodDescriptor.setValue("role", "factory");
                methodDescriptor.setValue("property", "PasswordValidators");
                methodDescriptor.setValue("since", "10.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.0", null, (String)this.targetVersion)) {
            method = RealmMBean.class.getMethod("createPasswordValidator", String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"String The type of a Password Validator provider, all available types are in method <code>getPasswordValidatorTypes</code> ")};
            object = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(object)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"ClassNotFoundException"), BeanInfoHelper.encodeEntities((String)"JMException")};
                methodDescriptor.setValue("throws", stringArray);
                methodDescriptor.setValue("since", "10.0");
                map.put(object, methodDescriptor);
                methodDescriptor.setValue("description", "Creates a Password Validator provider in this security realm. The new Password Validator provider is added to the end of the list of Password Validator providers configured in this security realm. ");
                methodDescriptor.setValue("role", "factory");
                methodDescriptor.setValue("property", "PasswordValidators");
                methodDescriptor.setValue("since", "10.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.0", null, (String)this.targetVersion)) {
            method = RealmMBean.class.getMethod("destroyPasswordValidator", PasswordValidatorMBean.class);
            parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"provider", (String)"PasswordValidatorMBean The Password Validator provider to remove ")};
            object = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(object)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("since", "10.0");
                map.put(object, methodDescriptor);
                methodDescriptor.setValue("description", "Removes the configuration for a Password Validator provider in this security realm. ");
                methodDescriptor.setValue("role", "factory");
                methodDescriptor.setValue("property", "PasswordValidators");
                methodDescriptor.setValue("since", "10.0");
            }
        }
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = RealmMBean.class.getMethod("lookupAuditor", String.class);
        ParameterDescriptor[] parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(parameterDescriptorArray)) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Finds an Auditing provider in this security realm. Returns null if this security realm has no Auditing provider of the specified name. ");
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "Auditors");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = RealmMBean.class.getMethod("lookupAuthenticationProvider", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Finds an Authentication provider in this security realm. Returns null if this security realm has no Authentication provider of the specified name. ");
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "AuthenticationProviders");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = RealmMBean.class.getMethod("lookupRoleMapper", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Finds a Role Mapping provider in this security realm. Returns null if this security realm has no Role Mapping provider of the specified name. ");
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "RoleMappers");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = RealmMBean.class.getMethod("lookupAuthorizer", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Finds an Authorization provider in this security realm. Returns null if this security realm has no Authorization provider of the specified name. ");
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "Authorizers");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = RealmMBean.class.getMethod("lookupCredentialMapper", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Finds a Credential Mapping provider in this security realm. Returns null if this security realm has no Credential Mapping provider of the specified name. ");
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "CredentialMappers");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = RealmMBean.class.getMethod("lookupCertPathProvider", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Finds a Certification Path provider in this security realm. Returns null if this security realm has no Certification Path provider of the specified name. ");
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "CertPathProviders");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = RealmMBean.class.getMethod("lookupKeyStore", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            methodDescriptor.setValue("deprecated", "8.1.0.0 ");
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Finds a KeyStore provider in this security realm. Returns null if this security realm has no KeyStore provider of the specified name. ");
            methodDescriptor.setValue("role", "finder");
            methodDescriptor.setValue("property", "KeyStores");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.0", null, (String)this.targetVersion)) {
            method = RealmMBean.class.getMethod("lookupPasswordValidator", String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{RealmMBeanImplBeanInfo.createParameterDescriptor((String)"name", (String)"String The name of a Password Validator provider MBean ")};
            String string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("since", "10.0");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "Finds an Password Validator provider in this security realm. Returns null if this security realm has no Password Validator provider with the specified name. ");
                methodDescriptor.setValue("role", "finder");
                methodDescriptor.setValue("property", "PasswordValidators");
                methodDescriptor.setValue("since", "10.0");
            }
        }
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        Method method = RealmMBean.class.getMethod("validate", new Class[0]);
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            MethodDescriptor methodDescriptor = new MethodDescriptor(method, null);
            methodDescriptor.setValue("deprecated", "9.0.0.0 This method is no longer required since activating a configuration transaction does this check automatically on the default realm, and will not allow the configuration to be saved if the domain does not have a valid default realm configured. ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "Checks that the realm is valid. ");
            methodDescriptor.setValue("role", "operation");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

