/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.security.authorization;

import com.bea.common.security.xacml.policy.Policy;
import com.bea.common.security.xacml.policy.PolicySet;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.internal.mbean.BeanInfoHelper;
import weblogic.management.security.authorization.PolicyStoreMBean;
import weblogic.management.security.authorization.PolicyStoreMBeanImpl;
import weblogic.management.utils.PropertiesListerMBeanImplBeanInfo;

public class PolicyStoreMBeanImplBeanInfo
extends PropertiesListerMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = PolicyStoreMBean.class;

    public PolicyStoreMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public PolicyStoreMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = PolicyStoreMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("abstract", Boolean.TRUE);
        beanDescriptor.setValue("since", "9.2.0.0");
        beanDescriptor.setValue("package", "weblogic.management.security.authorization");
        String string = new String("Provides a set of methods for managing policies in a policy store. An Authorization-provider or Role Mapping-provider MBean can optionally implement this MBean interface.  Policies are expressed as XACML 2.0 Policy or PolicySet documents.  Authorization-providers should expect standard <code>Policy</code> or <code>PolicySet</code> documents as described in the XACML 2.0 Core Specification.  Role Mapping-providers should expect <code>Policy</code> or <code>PolicySet</code> documents consistent with role assignment policies described by the Role Based Access Control Profile, specifically the <code>Target</code> must contain:<p> <ol> <li>An ActionAttributeDesignator with the id, urn:oasis:names:tc:xacml:1.0:action:action-id, and the value, urn:oasis:names:tc:xacml:2.0:actions:enableRole, according to anyURI-equal</li> <li>A ResourceAttributeDesignator with the id, urn:oasis:names:tc:xacml:2.0:subject:role, and a value naming the role being assigned, according to string-equal</li> </ol>  <h3 class=\"TypeSafeDeprecation\">Deprecation of MBeanHome and Type-Safe Interfaces</h3>  <p class=\"TypeSafeDeprecation\">In addition to being used as a base class that provides functionality to security provider MBeans, JMX applications can use this class directly as a type-safe interface. When used as a type-safe interface, a JMX application imports this class and accesses it through <code>weblogic.management.MBeanHome</code>. As of 9.0, the <code>MBeanHome</code> interface and all type-safe interfaces for WebLogic Server MBeans are deprecated. Instead, JMX applications that interact with WebLogic Server MBeans should use standard JMX design patterns in which clients use the <code>javax.management.MBeanServerConnection</code> interface to discover MBeans, attributes, and attribute types at runtime. </p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.security.authorization.PolicyStoreMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        Object var2_2 = null;
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        String[] stringArray;
        Object object;
        MethodDescriptor methodDescriptor;
        Method method = PolicyStoreMBean.class.getMethod("listAllPolicies", new Class[0]);
        ParameterDescriptor[] parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(parameterDescriptorArray)) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if no policies are found")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Returns cursor listing all policies ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = PolicyStoreMBean.class.getMethod("listAllPoliciesAsString", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if no policies are found")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Returns cursor listing all policies.  Policies are returned as java.lang.String. ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = PolicyStoreMBean.class.getMethod("listAllPolicySets", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if no policy sets are found")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Returns cursor listing all policy sets ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = PolicyStoreMBean.class.getMethod("listAllPolicySetsAsString", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if no policy sets are found")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Returns cursor listing all policy sets.  Policy sets are returned as java.lang.String. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("readPolicy", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"identifier", (String)"Policy identifier "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"version", (String)"Policy version ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy is not found")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Reads policy with specified identifier and version ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("readPolicyAsString", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"identifier", (String)"Policy identifier "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"version", (String)"Policy version ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy is not found")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Reads policy with specified identifier and version ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("readPolicySet", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"identifier", (String)"Policy set identifier "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"version", (String)"Policy set version ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy set is not found")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Reads policy set with specified identifier and version ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("readPolicySetAsString", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"identifier", (String)"Policy set identifier "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"version", (String)"Policy set version ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy set is not found")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Reads policy set with specified identifier and version ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("addPolicy", Policy.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"policy", (String)"Policy document ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"AlreadyExistsException Thrown if matching policy id and version already present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Adds policy.  Policy is set to ACTIVE status. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("addPolicy", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"policy", (String)"Policy document ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"AlreadyExistsException Thrown if matching policy id and version already present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Adds policy.  Policy is set to ACTIVE status. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("addPolicy", Policy.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"policy", (String)"Policy document "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"status", (String)"Policy status ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"AlreadyExistsException Thrown if matching policy id and version already present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Adds policy ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("addPolicy", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"policy", (String)"Policy document "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"status", (String)"Policy status ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"AlreadyExistsException Thrown if matching policy id and version already present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Adds policy ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("addPolicySet", PolicySet.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"set", (String)"Policy set document ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy set is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"AlreadyExistsException Thrown if matching policy set id and version already present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Adds policy set.  Policy set is set to ACTIVE status. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("addPolicySet", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"set", (String)"Policy set document ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy set is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"AlreadyExistsException Thrown if matching policy set id and version already present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Adds policy set.  Policy set is set to ACTIVE status. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("addPolicySet", PolicySet.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"set", (String)"Policy set document "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"status", (String)"Policy status enumeration ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy set is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"AlreadyExistsException Thrown if matching policy set id and version already present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Adds policy set. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("addPolicySet", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"set", (String)"Policy set document "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"status", (String)"Policy status enumeration ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy set is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"AlreadyExistsException Thrown if matching policy set id and version already present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Adds policy set. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("modifyPolicy", Policy.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"policy", (String)"Policy document ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy id and version not present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Updates policy.  This operation does not change the status of policy. already present in the store. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("modifyPolicy", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"policy", (String)"Policy document ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy id and version not present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Updates policy.  This operation does not change the status of policy. already present in the store. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("modifyPolicy", Policy.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"policy", (String)"Policy document "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"status", (String)"Policy status enumeration ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy id and version not present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Updates policy and status. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("modifyPolicy", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"policy", (String)"Policy document "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"status", (String)"Policy status enumeration ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy id and version not present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Updates policy and status. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("modifyPolicySet", PolicySet.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"set", (String)"Policy set document "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"status", (String)"Policy status enumeration ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy set is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy set id and version not present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Updates policy set.  This operation does not change the status of policy set. already present in the store. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("modifyPolicySet", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"set", (String)"Policy set document "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"status", (String)"Policy status enumeration ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy set is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy set id and version not present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Updates policy set.  This operation does not change the status of policy set. already present in the store. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("modifyPolicySet", PolicySet.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"set", (String)"Policy set document "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"status", (String)"Policy status enumeration ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy set is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy set id and version not present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Updates policy set and status. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("modifyPolicySet", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"set", (String)"Policy set document "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"status", (String)"Policy status enumeration ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if policy set is invalid or store cannot be updated"), BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy set id and version not present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Updates policy set and status. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("modifyPolicyStatus", String.class, String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"identifier", (String)"Policy identifier "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"version", (String)"Policy version "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"status", (String)"Policy status enumeration ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if store cannot be updated"), BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy id and version not present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Sets status for policy identified by identifier and version ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("getPolicyStatus", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"identifier", (String)"Policy identifier "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"version", (String)"Policy version ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundExeption Thrown if matching policy id and version not present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Returns status for policy identified by identifier and version ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("modifyPolicySetStatus", String.class, String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"identifier", (String)"Policy set identifier "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"version", (String)"Policy set version "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"status", (String)"Policy status enumeration ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"CreateException Thrown if store cannot be updated"), BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy set id and version not present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Sets status for policy set identified by identifier and version ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("getPolicySetStatus", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"identifier", (String)"Policy set identifier "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"version", (String)"Policy set version ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundExeption Thrown if matching policy set id and version not present in store")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Returns status for policy set identified by identifier and version ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("deletePolicy", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"identifier", (String)"Policy identifier "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"version", (String)"Policy version ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy id and version not present in store"), BeanInfoHelper.encodeEntities((String)"RemoveException Thrown if store cannot be updated")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Deletes policy with given identifier and version. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PolicyStoreMBean.class.getMethod("deletePolicySet", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"identifier", (String)"Policy set identifier "), PolicyStoreMBeanImplBeanInfo.createParameterDescriptor((String)"version", (String)"Policy set version ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundException Thrown if matching policy set id and version not present in store"), BeanInfoHelper.encodeEntities((String)"RemoveException Thrown if store cannot be updated")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "Deletes policy set with given identifier and version. ");
            methodDescriptor.setValue("role", "operation");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

