/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.security.credentials;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.internal.mbean.BeanInfoHelper;
import weblogic.management.security.credentials.PKICredentialMapReaderMBean;
import weblogic.management.security.credentials.PKICredentialMapReaderMBeanImpl;
import weblogic.management.utils.ListerMBeanImplBeanInfo;

public class PKICredentialMapReaderMBeanImplBeanInfo
extends ListerMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = PKICredentialMapReaderMBean.class;

    public PKICredentialMapReaderMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public PKICredentialMapReaderMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = PKICredentialMapReaderMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("abstract", Boolean.TRUE);
        beanDescriptor.setValue("package", "weblogic.management.security.credentials");
        String string = new String("Provides a set of methods for reading a credential map that matches users and resources to aliases and their corresponding passwords that can then be used to retrieve key information or public certificate information from the configured keystores. ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.security.credentials.PKICredentialMapReaderMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        Object var2_2 = null;
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = PKICredentialMapReaderMBean.class.getMethod("getKeystoreAlias", String.class, String.class, Boolean.TYPE, String.class, String.class);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"resourceId", (String)"- The resource id that is used to map user names to keystore alias and password. A resource object such as <code>weblogic.security.service.ResourceManager</code> assigns IDs to external sources. "), PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"userName", (String)"- The username that is mapped to the alias and password. "), PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"isInitiatorUserName", (String)"- Set true if the initiator name passed in is the username. False otherwise. "), PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"credAction", (String)"- The credential action for which the mapping is created for. "), PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"credType", (String)"- The credential type. ")};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"NotFoundException - This exception is thrown if                             the keystore alias is not found.")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "Gets the keystore alias that is mapped to a username for a particular resource and credential action. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PKICredentialMapReaderMBean.class.getMethod("getCurrentInitiatorName", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"cursor", (String)"- The cursor that has been returned from the <code>listMappings</code> method or the <code>listMappingsByPattern</code>. ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "Gets an username from a list that has been returned from the <code>listMappings</code> or the <code>listMappingsByPattern()</code> method. This method returns the username that corresponds to current location in the list. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PKICredentialMapReaderMBean.class.getMethod("isInitiatorUserName", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"cursor", (String)"- The cursor that has been returned from the <code>listMappings</code> method or the <code>listMappingsByPattern</code>. ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "Returns whether the initiator name from a list that has been returned from the <code>listMappings</code> or the <code>listMappingsByPattern()</code>method is a user name or a group name. Method returns true if the username returned by the getCurrentInitiatorName is a user name. If the initiator name returned is a Group name this method returns false. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PKICredentialMapReaderMBean.class.getMethod("getCurrentCredAction", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"cursor", (String)"- The cursor that has been returned from the <code>listMappings</code> method or the <code>listMappingsByPattern</code>. ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "Gets an credential action from a list that has been returned from the <code>listMappings</code> or the <code>listMappingsByPattern()</code> method. This method returns the credential action that corresponds to current location in the list. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PKICredentialMapReaderMBean.class.getMethod("getCurrentCredential", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"cursor", (String)"- The cursor that has been returned from the <code>listMappings</code> or the <code>listMappingsByPattern</code> method. ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "Gets the keystore alias from a credentials map that has been returned from the <code>listMappings</code> or the <code>listMappingsByPattern()</code> method. This method returns the keystore alias that corresponds to current location in the list. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PKICredentialMapReaderMBean.class.getMethod("listMappings", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"resourceId", (String)"- the resource id that the credential mappings are created for. A resource object such as <code>weblogic.security.service.ResourceManager</code> assigns IDs to external sources. ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "Gets a list of usernames, credential actions, keystore aliases and their passwords. Returns  a cursor as a string. Use the <code>getCurrentUserName()</code>,<code>getCurrentCredential()</code>, <code>getCurrentCredAction()</code> methods to get the username, keystore alias and credential action for the current item in the list. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PKICredentialMapReaderMBean.class.getMethod("getCurrentResourceId", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"cursor", (String)"- The cursor that has been returned from the <code> listMappingsByPattern</code> method. ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "Gets the current resource id from a list that has been returned from the and <code>listMappingsByPattern()</code> method. This method returns the resource id that corresponds to current location in the list. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PKICredentialMapReaderMBean.class.getMethod("listMappingsByPattern", String.class, Integer.TYPE, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"resourceIdPattern", (String)"- the resource id pattern to filter the records to be returned. If you pass null or * the method will not filter and return all records. "), PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"maxToReturn", (String)"- The maximum number of records to return "), PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"credType", (String)"- The credential type ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "Gets a list of all the configured credential mappings. Returns a cursor as a string. Use the <code>getCurrentUserName()</code>,<code> getCurrentCredAction()</code>, <code> getCurrentResourceId()</code>, <code> getCurrentCredential()</code> methods to get the username, credential action, resource id and keystore alias for the current item in the list. ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = PKICredentialMapReaderMBean.class.getMethod("listAllCertEntryAliases", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Returns a list of all the public certificate aliases currently configured in the keystore. Console can call this method to display a list of all possible certificate aliases. ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = PKICredentialMapReaderMBean.class.getMethod("listAllKeypairEntryAliases", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Returns a list of all the key pair aliases that currently configured in the keystore. Console can call this method to display a list of all possible keypair aliases. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = PKICredentialMapReaderMBean.class.getMethod("getCertificate", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{PKICredentialMapReaderMBeanImplBeanInfo.createParameterDescriptor((String)"keystoreAlias", (String)"- The keystore alias. ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "For a certificate entry this method will return the certificate corresponding to the alias. For a keyentry it will return the first Certificate entry in a CertificateChain. ");
            methodDescriptor.setValue("role", "operation");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

