/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.security.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import weblogic.Home;
import weblogic.management.commo.JarFile;
import weblogic.management.commo.WebLogicMBeanMaker;
import weblogic.management.scripting.utils.WLSTProcess;
import weblogic.management.security.internal.SecurityProviderUpgradeLogger;
import weblogic.management.security.internal.SecurityProviderUpgradeTextTextFormatter;
import weblogic.utils.FileUtils;
import weblogic.utils.JavaExec;
import weblogic.utils.StringUtils;
import weblogic.utils.jars.JarFileUtils;

public class MigrateOldProviders {
    static String LIB_DIR = "/server/lib";
    static String TYPES_DIR = LIB_DIR + "/mbeantypes";
    static String TYPES_DIR_WO_SERVER = "lib" + File.separator + "mbeantypes";
    static String COMMO_DTD = "commo.dtd";
    static String beaHome = "";
    static String newBeaHome = null;
    static String typesDir = "";
    static int counter = 0;
    static String OLD_TEMP_FILES = "SecUpgrade_oldTempFiles";
    static String NEW_TEMP_FILES = "SecUpgrade_newTempFiles";
    static String newJarName = "";
    static String oldJarName = "";
    static String WL_MANAGEMENT = "wlManagement.jar";
    static String WL_MANAGEMENT_MBEAN = "wlManagementMBean.jar";
    static String WL_SECURITY_PROVIDERS = "wlSecurityProviders.jar";
    static String WL_MANAGEMENT_SOURCE_IMPL = "wlManagementImplSource.jar";
    static String WL_MEDREC_SAMPLE = "wlMedRecSampleAuthProvider.jar";
    static String WL_AI = "wlai-mbean.jar";
    static String WLI_PLUGIN_MGR = "wli-plugin-mgr-mbean.jar";
    static String WL_RDBMS_ATN = "rdbmsAtnProvider.jar";
    static String WL_WSRP_SP = "wsrp-security-providers.jar";
    static String TEMP_MDF_DIR = "SecUpgrade_mdfDir";
    static String TEMP_TEMP_MDF_DIR = "SecUpgrade_tempMDFDir";
    static File mdfDir = null;
    static File tempMDFDir = null;
    static File oldTempFilesDir = null;
    static File newTempFilesDir = null;
    static File classesDir = null;
    static String MIGRATED = "_Upgraded.jar";
    static boolean verbose = false;
    static List providerJars = new ArrayList();
    static List oldProviderJars = new ArrayList();
    static List existingProviderJars = new ArrayList();
    static boolean migrationDone = false;
    static boolean argsSatisfied = false;
    static boolean cleanup = true;
    static List messages = new ArrayList();
    static String BINDER_SUFFIX = "MBeanBinder.class";
    static String INFO_SUFFIX = "MBeanImplBeanInfo.class";
    static String XSD_SUFFIX = ".xsd";
    static String XSB_SUFFIX = ".xsd";
    private static boolean invokedFromInstaller = false;
    private static String weblogicJarPath = null;
    private static String toolsJarPath = null;
    private static String wlMgtMBeanJarPath = null;
    private static String wlMgmtMBeanImplJarPath = null;
    private static String antJarPath = null;
    private static String xbeanJarPath = null;
    private static String bindingJarPath = null;

    public static void main(String[] stringArray) throws Exception {
        MigrateOldProviders.run(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List run(String[] stringArray) throws Exception {
        MigrateOldProviders.processArgs(stringArray);
        if (!argsSatisfied) {
            return messages;
        }
        try {
            MigrateOldProviders.execute();
            migrationDone = true;
        }
        finally {
            if (migrationDone) {
                MigrateOldProviders.cleanup();
                MigrateOldProviders.copyJars();
            } else {
                MigrateOldProviders.cleanup();
            }
        }
        return messages;
    }

    public static boolean isInternalProvider(String string) {
        return string.equals(WL_MANAGEMENT) || string.equals(WL_SECURITY_PROVIDERS) || string.equals(WL_MANAGEMENT_SOURCE_IMPL) || string.equals(WL_MANAGEMENT_MBEAN) || string.equals(WL_AI) || string.equals(WLI_PLUGIN_MGR) || string.equals(WL_WSRP_SP) || string.equals(WL_MEDREC_SAMPLE) || string.equals(WL_RDBMS_ATN);
    }

    static void initVariables(String[] stringArray) {
        beaHome = stringArray[0];
        typesDir = beaHome + TYPES_DIR;
        if (!new File(typesDir).exists()) {
            typesDir = beaHome;
        }
        argsSatisfied = true;
    }

    public static String installerUpgradeSecurityProvider(String string, String string2, String string3) throws Exception {
        String[] stringArray = new String[]{string, string2};
        invokedFromInstaller = true;
        weblogicJarPath = string2 + "/server/lib/weblogic.jar";
        toolsJarPath = string3;
        wlMgtMBeanJarPath = string2 + "/server/lib/mbeantypes/wlManagementMBean.jar";
        wlMgmtMBeanImplJarPath = string2 + "/server/lib/mbeantypes/wlManagementImplSource.jar";
        antJarPath = string2 + "/server/lib/ant/ant.jar";
        xbeanJarPath = string2 + "/server/lib/xbean.jar";
        bindingJarPath = string2 + "/server/lib/schema/weblogic-domain-binding.jar";
        MigrateOldProviders.run(stringArray);
        String[] stringArray2 = new String[messages.size()];
        return StringUtils.join((String[])messages.toArray(stringArray2), (String)"\n");
    }

    static void processArgs(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            stringArray = new String[]{};
            stringArray[0] = Home.getFile().getParent();
        }
        if (stringArray.length > 3) {
            if (!invokedFromInstaller) {
                SecurityProviderUpgradeLogger.logIncorrectArgs();
            }
            MigrateOldProviders.printUsage();
            return;
        }
        if (stringArray.length == 1) {
            if (!invokedFromInstaller) {
                SecurityProviderUpgradeLogger.logMigratingOldProvidersFrom1Arg((String)stringArray[0]);
            }
            MigrateOldProviders.initVariables(stringArray);
        } else if (stringArray.length == 2) {
            MigrateOldProviders.initVariables(stringArray);
            if (stringArray[1].equalsIgnoreCase("-verbose")) {
                verbose = true;
            } else {
                newBeaHome = stringArray[1];
            }
            if (!invokedFromInstaller) {
                SecurityProviderUpgradeLogger.logMigratingOldProvidersFrom1Arg((String)stringArray[0]);
            }
        } else if (stringArray.length == 3) {
            if (!invokedFromInstaller) {
                SecurityProviderUpgradeLogger.logMigratingOldProvidersFrom1Arg((String)stringArray[0]);
            }
            MigrateOldProviders.initVariables(stringArray);
            newBeaHome = stringArray[1];
            if (stringArray[2].equalsIgnoreCase("-verbose")) {
                verbose = true;
            }
        } else {
            MigrateOldProviders.printUsage();
            return;
        }
        MigrateOldProviders.populateExistingProviderJars();
        String string = System.getProperty("weblogic.Installing", "false");
        if (string.toLowerCase(Locale.US).equals("true")) {
            MigrateOldProviders.printDebug("Invoked while installing hence upgrade of OOTB providers will be skipped");
        }
    }

    private static void populateExistingProviderJars() {
        File[] fileArray;
        File file = null;
        if (newBeaHome != null) {
            file = new File(newBeaHome);
            fileArray = new File(newBeaHome + "/server/lib/mbeantypes");
            File file2 = new File(newBeaHome + "/server/lib/compatibility");
            if (fileArray.exists() && file2.exists()) {
                file = new File(newBeaHome + "/server/lib/mbeantypes");
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            Home.getHome();
            file = new File(stringBuilder.append(Home.getPath()).append(File.separator).append(TYPES_DIR_WO_SERVER).toString());
        }
        fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                existingProviderJars.add(fileArray[i].getName());
            }
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java weblogic.management.security.internal.MigrateOldProviders <OLD_BEA_HOME_DIR> <NEW_BEA_HOME_DIR>");
        System.out.println("OR");
        System.out.println("Usage: java weblogic.management.security.internal.MigrateOldProviders <NEW_BEA_HOME_DIR>");
    }

    private static void copyJars() throws IOException {
        SecurityProviderUpgradeTextTextFormatter securityProviderUpgradeTextTextFormatter = new SecurityProviderUpgradeTextTextFormatter();
        if (providerJars.isEmpty()) {
            MigrateOldProviders.printDebug(securityProviderUpgradeTextTextFormatter.NoJarsUpgraded());
            messages.add(securityProviderUpgradeTextTextFormatter.NoJarsUpgraded());
            if (!invokedFromInstaller) {
                SecurityProviderUpgradeLogger.logNoJarsUpgraded();
            }
            return;
        }
        for (String string : providerJars) {
            File file = new File(string);
            File file2 = null;
            if (newBeaHome != null) {
                file2 = new File(newBeaHome + File.separator + TYPES_DIR).exists() ? new File(newBeaHome + File.separator + TYPES_DIR, file.getName()) : new File(newBeaHome, file.getName());
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                Home.getHome();
                file2 = new File(stringBuilder.append(Home.getPath()).append(File.separator).append(TYPES_DIR_WO_SERVER).toString(), file.getName());
            }
            MigrateOldProviders.printDebug("Moving " + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
            if (!invokedFromInstaller) {
                SecurityProviderUpgradeLogger.logCopyProviderTo((String)file2.getAbsolutePath());
            }
            if (file.getAbsoluteFile().equals(file2.getAbsoluteFile())) continue;
            FileUtils.copy((File)file, (File)file2);
            FileUtils.remove((File)file);
        }
        MigrateOldProviders.printDebug(securityProviderUpgradeTextTextFormatter.completedUpgradeOf(providerJars.size()));
        messages.add(securityProviderUpgradeTextTextFormatter.completedUpgradeOf(providerJars.size()));
        if (!invokedFromInstaller) {
            SecurityProviderUpgradeLogger.logCompletedJars((int)providerJars.size());
        }
    }

    public static boolean verifyOldJar(String string) throws Exception {
        MigrateOldProviders.printDebug("Verifying if " + string + " is an old provider jar");
        boolean bl = true;
        JarFile jarFile = new JarFile(new File(typesDir + File.separator + string));
        Enumeration enumeration = jarFile.getEntries();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            if (zipEntry.getName().endsWith(BINDER_SUFFIX) || zipEntry.getName().endsWith(INFO_SUFFIX) || zipEntry.getName().endsWith(XSD_SUFFIX)) {
                ++n;
            }
            if (n != 3) continue;
            bl = false;
            break;
        }
        if (bl) {
            MigrateOldProviders.printDebug("Yes " + string + " is a valid old security provider jar");
        } else {
            MigrateOldProviders.printDebug("Not an Old security jar, its new!!, will skip this file ... ");
            if (!invokedFromInstaller) {
                SecurityProviderUpgradeLogger.logSkippedCount((String)string);
            }
        }
        return bl;
    }

    static void execute() throws Exception {
        MigrateOldProviders.printDebug("The types dir is " + typesDir);
        String[] stringArray = new File(typesDir).list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (invokedFromInstaller && MigrateOldProviders.isInternalProvider(stringArray[i])) {
                if (invokedFromInstaller) continue;
                SecurityProviderUpgradeLogger.logSkippingJar((String)stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(WL_MANAGEMENT) || stringArray[i].equals(WL_SECURITY_PROVIDERS) || stringArray[i].equals(WL_MANAGEMENT_SOURCE_IMPL) || stringArray[i].equals(WL_MANAGEMENT_MBEAN) || !stringArray[i].endsWith(".jar") || stringArray[i].endsWith("Upgraded.jar") || stringArray[i].startsWith("SecUpgrade_")) {
                if (invokedFromInstaller) continue;
                SecurityProviderUpgradeLogger.logSkippingJar((String)stringArray[i]);
                continue;
            }
            String string = stringArray[i].substring(0, stringArray[i].length() - 4);
            if (existingProviderJars.contains(string + ".jar") || existingProviderJars.contains(string + "_Upgraded.jar")) {
                if (invokedFromInstaller) continue;
                SecurityProviderUpgradeLogger.logSkippingJar((String)stringArray[i]);
                continue;
            }
            newJarName = stringArray[i];
            if (!invokedFromInstaller) {
                SecurityProviderUpgradeLogger.logNowProcessing((String)stringArray[i]);
            }
            MigrateOldProviders.cleanup();
            OLD_TEMP_FILES = "SecUpgrade_" + ++counter + "_oldTempFiles";
            NEW_TEMP_FILES = "SecUpgrade_" + counter + "_newTempFiles";
            TEMP_MDF_DIR = "SecUpgrade_" + counter + "mdfDir";
            TEMP_TEMP_MDF_DIR = "SecUpgrade_" + counter + "tempMDFDir";
            mdfDir = new File(TEMP_MDF_DIR);
            if (mdfDir.exists()) {
                FileUtils.remove((File)mdfDir);
            }
            mdfDir.mkdir();
            oldTempFilesDir = new File(OLD_TEMP_FILES);
            if (oldTempFilesDir.exists()) {
                FileUtils.remove((File)oldTempFilesDir);
            }
            oldTempFilesDir.mkdir();
            newTempFilesDir = new File(NEW_TEMP_FILES);
            if (newTempFilesDir.exists()) {
                FileUtils.remove((File)newTempFilesDir);
            }
            newTempFilesDir.mkdir();
            classesDir = new File(newTempFilesDir.getAbsolutePath() + "ClassesDir");
            Thread.sleep(5000L);
            if (!MigrateOldProviders.verifyOldJar(stringArray[i]) || !MigrateOldProviders.generateMDF(stringArray[i])) continue;
            try {
                MigrateOldProviders.runWLMaker();
                oldProviderJars.add(new File(typesDir, stringArray[i]));
                continue;
            }
            catch (Exception exception) {
                if (invokedFromInstaller) continue;
                System.out.println("Could not convert from MDF " + stringArray[i] + ". This file " + "may not be a valid MDF file " + exception);
                SecurityProviderUpgradeLogger.logCannotConvert((String)stringArray[i]);
            }
        }
    }

    private static boolean isValidMDF(File file) throws Exception {
        try {
            MigrateOldProviders.printDebug("checking xml file " + file.getAbsolutePath());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            DocumentType documentType = document.getDoctype();
            return documentType != null && documentType.getSystemId().equals("commo.dtd");
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            return false;
        }
    }

    private static void getFileNames(List list, String string, String string2, String string3, boolean bl) {
        String string4 = null;
        string4 = string2 == null ? string : string + File.separator + string2;
        File file = new File(string4);
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string5 = null;
            string5 = string2 != null ? string2 + File.separator + stringArray[i] : stringArray[i];
            File file2 = new File(string + File.separator + string5);
            if (file2.isDirectory()) {
                MigrateOldProviders.getFileNames(list, string, string5, string3, bl);
                continue;
            }
            if (!file2.getName().endsWith(string3)) continue;
            if (!bl) {
                list.add(string5);
                continue;
            }
            list.add(file2);
        }
    }

    private static boolean generateMDF(String string) throws Exception {
        File[] fileArray2;
        SecurityProviderUpgradeTextTextFormatter securityProviderUpgradeTextTextFormatter = new SecurityProviderUpgradeTextTextFormatter();
        JarFileUtils.extract((File)new File(typesDir + File.separator + string), (File)oldTempFilesDir);
        ArrayList arrayList = new ArrayList();
        MigrateOldProviders.getFileNames(arrayList, oldTempFilesDir.getAbsolutePath(), null, ".xml", false);
        String[] stringArray = new String[arrayList.size()];
        tempMDFDir = new File("./" + TEMP_TEMP_MDF_DIR);
        tempMDFDir.mkdir();
        mdfDir = new File(TEMP_MDF_DIR);
        mdfDir.mkdir();
        for (File[] fileArray2 : arrayList) {
            File file = new File(oldTempFilesDir.getAbsolutePath() + "/" + (String)fileArray2);
            FileUtils.copy((File)file, (File)tempMDFDir);
        }
        MigrateOldProviders.copyCommoDTD(tempMDFDir);
        fileArray2 = tempMDFDir.listFiles();
        if (fileArray2.length == 1) {
            if (!invokedFromInstaller) {
                SecurityProviderUpgradeLogger.logNoMDF((String)string);
            }
            messages.add(securityProviderUpgradeTextTextFormatter.NoMDFs(string));
            FileUtils.remove((File)oldTempFilesDir);
            FileUtils.remove((File)tempMDFDir);
            return false;
        }
        int n = 0;
        for (int i = 0; i < fileArray2.length; ++i) {
            stringArray[n] = fileArray2[i].getAbsolutePath();
            if (!stringArray[n].endsWith(".xml")) continue;
            File file = new File(stringArray[n]);
            if (!MigrateOldProviders.isValidMDF(file)) {
                if (invokedFromInstaller) continue;
                SecurityProviderUpgradeLogger.logInvalidMDF((String)file.getAbsolutePath());
                continue;
            }
            MigrateOldProviders.printDebug("Copying " + stringArray[n] + " to " + mdfDir.getAbsolutePath());
            FileUtils.copy((File)file, (File)mdfDir);
        }
        mdfDir.mkdir();
        MigrateOldProviders.copyCommoDTD(null);
        FileUtils.remove((File)tempMDFDir);
        return true;
    }

    private static void copyCommoDTD(File file) throws Exception {
        InputStream inputStream = null;
        MigrateOldProviders.printDebug("Getting commo.dtd from resource as stream ... ");
        inputStream = MigrateOldProviders.class.getResourceAsStream("commo.dtd");
        File file2 = null;
        file2 = file == null ? new File(mdfDir, COMMO_DTD) : new File(file, COMMO_DTD);
        FileUtils.writeToFile((InputStream)inputStream, (File)file2);
        MigrateOldProviders.printDebug("copied sucessfully from input stream");
        MigrateOldProviders.printDebug("Copied the commo.dtd to " + file2.getAbsolutePath());
    }

    private static void runWLMaker() throws Exception {
        String string;
        String string2;
        Object object2;
        SecurityProviderUpgradeTextTextFormatter securityProviderUpgradeTextTextFormatter = new SecurityProviderUpgradeTextTextFormatter();
        String string3 = newJarName;
        if (mdfDir.list().length == 1) {
            MigrateOldProviders.printDebug("No MDF's found in the Provider Jar " + string3 + ". Migration Failed!!");
            if (!invokedFromInstaller) {
                SecurityProviderUpgradeLogger.logNoMDF((String)string3);
            }
            return;
        }
        ArrayList arrayList = new ArrayList();
        MigrateOldProviders.getFileNames(arrayList, oldTempFilesDir.getAbsolutePath(), null, "Impl.class", true);
        for (Object object2 : arrayList) {
            MigrateOldProviders.printDebug("copying " + ((File)object2).getAbsolutePath() + " to " + newTempFilesDir.getAbsolutePath());
            FileUtils.copy((File)object2, (File)newTempFilesDir);
        }
        object2 = newTempFilesDir.getAbsolutePath();
        String string4 = "-doBeanGen";
        String[] stringArray = new String[]{"-files", object2, "-MDFDIR", mdfDir.getAbsolutePath(), string4};
        MigrateOldProviders.printDebug("Running the first Phase of WebLogicMBeanMaker ... ");
        if (!invokedFromInstaller) {
            SecurityProviderUpgradeLogger.logRunningFirstPhase((String)string3);
        }
        MigrateOldProviders.printDebug("Copying from " + oldTempFilesDir.getAbsolutePath() + " to " + classesDir.getAbsolutePath());
        System.setProperty("weblogic.FromSPUpgrade", "true");
        WebLogicMBeanMaker.main((String[])stringArray);
        FileUtils.copy((File)oldTempFilesDir, (File)classesDir);
        if (newJarName.endsWith(".jar")) {
            newJarName = newJarName.substring(0, newJarName.length() - 4);
            newJarName = newJarName + MIGRATED;
        } else {
            newJarName = newJarName + MIGRATED;
        }
        String[] stringArray2 = new String[]{"-files", MigrateOldProviders.quoteIfContainsSpaces(newTempFilesDir.getAbsolutePath()), "-mjf", newJarName, string4};
        String string5 = StringUtils.join((String[])stringArray2, (String)" ");
        if (!invokedFromInstaller) {
            SecurityProviderUpgradeLogger.logRunningSecondPhase((String)string3);
        }
        MigrateOldProviders.printDebug("Running the second Phase of WebLogicMBeanMaker ... ");
        JavaExec javaExec = JavaExec.createCommand((String)("weblogic.management.commo.WebLogicMBeanMaker " + string5));
        String string6 = System.getProperty("weblogic.DebugMigrateProviders", "false");
        javaExec.addDefaultClassPath();
        javaExec.addClassPath(classesDir);
        if (invokedFromInstaller) {
            javaExec.addClassPath(new File(weblogicJarPath));
            javaExec.addClassPath(new File(toolsJarPath));
            javaExec.addClassPath(new File(antJarPath));
            javaExec.addClassPath(new File(xbeanJarPath));
            javaExec.addSystemProp("weblogic.SPUpgrade.FromInstaller", "true");
            javaExec.addSystemProp("weblogic.SPUpgrade.MBeanJarPath", wlMgtMBeanJarPath);
            javaExec.addSystemProp("weblogic.SPUpgrade.MBeanImplJarPath", wlMgmtMBeanImplJarPath);
            javaExec.addSystemProp("weblogic.SPUpgrade.BindingJarPath", bindingJarPath);
            javaExec.addSystemProp("weblogic.SPUpgrade.AntJarPath", antJarPath);
            javaExec.addSystemProp("weblogic.SPUpgrade.XbeanJarPath", xbeanJarPath);
            javaExec.addSystemProp("weblogic.SPUpgrade.WLSJarPath", weblogicJarPath);
            javaExec.addSystemProp("weblogic.SPUpgrade.ToolsJarPath", toolsJarPath);
        }
        if ((string2 = System.getProperty("targetNameSpace")) != null) {
            javaExec.addSystemProp("targetNameSpace", string2);
        }
        if ((string = System.getProperty("com.sun.xml.namespace.QName.useCompatibleSerialVersionUID")) != null) {
            javaExec.addSystemProp("com.sun.xml.namespace.QName.useCompatibleSerialVersionUID", string);
        }
        Process process = javaExec.getProcess();
        boolean bl = false;
        if (string6.toLowerCase(Locale.US).equals("true")) {
            bl = true;
        }
        WLSTProcess.startIOThreads(process, "MigrateProviders - SubProcess: ", bl);
        if (process.waitFor() != 0) {
            System.out.println("Code generation failed. Use -Dweblogic.DebugMigrateProviders=true and rerun the provider migration to see the real error");
            MigrateOldProviders.cleanup();
            return;
        }
        MigrateOldProviders.printDebug("Created new Security provider jar " + newJarName + " from " + string3);
        messages.add(securityProviderUpgradeTextTextFormatter.createdNew(newJarName, string3));
        if (!invokedFromInstaller) {
            SecurityProviderUpgradeLogger.logNewFromOld((String)newJarName, (String)string3);
        }
        providerJars.add(newJarName);
    }

    public static void cleanup() {
        if (!cleanup) {
            return;
        }
        MigrateOldProviders.printDebug("Cleaning up all the temporary files that are created ");
        File[] fileArray = new File(".").listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getName().indexOf("SecUpgrade") == -1) continue;
            FileUtils.remove((File)fileArray[i]);
        }
        FileUtils.remove((File)new File("velocity.log"));
        File file = new File("./tempFileDirForSchema");
        FileUtils.remove((File)file);
    }

    private static String quoteIfContainsSpaces(String string) {
        if (string != null && string.indexOf(" ") != -1) {
            return '\"' + string + '\"';
        }
        return string;
    }

    static void printDebug(String string) {
        if (verbose) {
            System.out.println("<ProviderMigration> " + string);
        }
    }
}

