/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.security.internal.compatibility;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.apache.xml.serialize.DOMSerializer;
import weblogic.apache.xml.serialize.OutputFormat;
import weblogic.apache.xml.serialize.SerializerFactory;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.security.internal.compatibility.ConfigFileHandler;
import weblogic.management.security.internal.compatibility.XMLAttributeList;

public class ConfigXMLFile {
    Document doc = null;
    int level = 0;

    public ConfigXMLFile(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.load(inputStream);
    }

    protected Document getDocument() {
        return this.doc;
    }

    public int getLevel() {
        return this.level;
    }

    private void load(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.doc = documentBuilder.parse(new InputSource(bufferedReader));
    }

    public InputStream getInputStream() throws IOException, SAXException, ParserConfigurationException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
        OutputFormat outputFormat = new OutputFormat(this.doc);
        outputFormat.setIndenting(true);
        DOMSerializer dOMSerializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)outputStreamWriter, outputFormat).asDOMSerializer();
        dOMSerializer.serialize(this.doc);
        outputStreamWriter.flush();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        outputStreamWriter.close();
        return byteArrayInputStream;
    }

    protected synchronized void parse(ConfigFileHandler configFileHandler) throws ConfigurationException {
        Element element = this.doc.getDocumentElement();
        configFileHandler.setDocument(this.doc);
        configFileHandler.startDocument();
        this.processElements(configFileHandler, element);
        configFileHandler.endDocument();
    }

    private void processElements(ConfigFileHandler configFileHandler, Node node) {
        String string = node.getNodeName();
        XMLAttributeList xMLAttributeList = new XMLAttributeList(node);
        configFileHandler.startElement(string, xMLAttributeList, node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            ++this.level;
            this.processElements(configFileHandler, node2);
            --this.level;
        }
        configFileHandler.endElement(node);
    }

    class DumpHandler
    extends ConfigFileHandler {
        DumpHandler() {
        }

        protected void startElement(String string, XMLAttributeList xMLAttributeList, Node node) {
            int n;
            String string2 = "";
            for (n = 0; n < ConfigXMLFile.this.getLevel(); ++n) {
                string2 = string2 + "  ";
            }
            System.out.println(string2 + "Element: " + string);
            for (n = 0; n < xMLAttributeList.getLength(); ++n) {
                String string3 = xMLAttributeList.getName(n);
                String string4 = xMLAttributeList.getValue(n);
                System.out.println(string2 + "   " + string3 + "=" + string4);
            }
        }
    }
}

