/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.security.internal.compatibility;

import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.management.ManagementRuntimeException;
import weblogic.management.commo.Commo;
import weblogic.management.commo.SecurityMBeanData;
import weblogic.management.security.internal.compatibility.ConfigFileHandler;
import weblogic.management.security.internal.compatibility.ConfigXMLFile;
import weblogic.management.security.internal.compatibility.XMLAttributeList;
import weblogic.utils.Debug;
import weblogic.utils.StringUtils;

public class ProviderMigrationDriver {
    String configFileLocation = null;
    List secMBeanData = null;
    static boolean debugInit = false;
    static String _debugInit = System.getProperty("weblogic.DebugUserConfigLoad", "false");

    public ProviderMigrationDriver(String string, List list) {
        this.configFileLocation = string;
        this.secMBeanData = list;
        if (_debugInit.equals("true")) {
            debugInit = true;
        }
    }

    void printDebug(String string) {
        if (debugInit) {
            Debug.say((String)string);
        }
    }

    private Element setAttributes(Element element, Vector vector) {
        for (Commo.Pair pair : vector) {
            String string = pair.getName();
            String string2 = "";
            Object object = pair.getValue();
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                String[] stringArray = new String[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = objectArray[i];
                    stringArray[i] = object2 instanceof ObjectName ? ((ObjectName)object2).toString() : object2.toString();
                }
                string2 = StringUtils.join((String[])stringArray, (String)"|");
                element.setAttribute(string, string2);
                continue;
            }
            element.setAttribute(string, object.toString());
        }
        return element;
    }

    private String getDisplayNameFromData(SecurityMBeanData securityMBeanData) {
        try {
            Commo.Pair[] pairArray = securityMBeanData.getAdditionalDescriptorElements();
            if (pairArray == null) {
                return null;
            }
            for (int i = 0; i < pairArray.length; ++i) {
                Commo.Pair pair = pairArray[i];
                if (!pair.getName().equals("displayname")) continue;
                return (String)pair.getValue();
            }
        }
        catch (Exception exception) {
            throw new ManagementRuntimeException(exception);
        }
        return null;
    }

    public InputStream convert(InputStream inputStream) {
        ConfigXMLFile configXMLFile = null;
        try {
            configXMLFile = new ConfigXMLFile(inputStream);
            configXMLFile.parse(new InsertSecurityMBeansHandler(this.secMBeanData));
            return configXMLFile.getInputStream();
        }
        catch (Exception exception) {
            throw new ManagementRuntimeException(exception);
        }
    }

    class InsertSecurityMBeansHandler
    extends ConfigFileHandler {
        List secData = null;

        protected InsertSecurityMBeansHandler(List list) {
            this.secData = list;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void startElement(String string, XMLAttributeList xMLAttributeList, Node node) {
            if (!string.equals("Security")) {
                return;
            }
            try {
                Node node2 = node;
                ProviderMigrationDriver.this.printDebug("Found security node.  Adding providers nodes as children.");
                for (SecurityMBeanData securityMBeanData : this.secData) {
                    String string2 = securityMBeanData.getInstanceName();
                    String string3 = ProviderMigrationDriver.this.getDisplayNameFromData(securityMBeanData);
                    ObjectName objectName = new ObjectName(securityMBeanData.getTypeName());
                    String string4 = Commo.getTypeShortName((ObjectName)objectName);
                    ProviderMigrationDriver.this.printDebug("Type : " + string4);
                    ProviderMigrationDriver.this.printDebug("Name : " + string2);
                    Vector vector = securityMBeanData.getAttrValues();
                    try {
                        Element element = this.getDocument().createElement(string4);
                        if (string3 != null) {
                            element.setAttribute("DisplayName", string3);
                        }
                        if (string2 != null) {
                            element.setAttribute("Name", string2);
                        }
                        element = ProviderMigrationDriver.this.setAttributes(element, vector);
                        node2.appendChild(element);
                        ProviderMigrationDriver.this.printDebug("Provider node that is added. " + string4);
                    }
                    catch (Exception exception) {
                        throw new ManagementRuntimeException(exception);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                throw new ManagementRuntimeException(exception);
            }
        }
    }
}

