/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.security.internal.compatibility;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;
import weblogic.management.DomainDir;
import weblogic.management.ManagementRuntimeException;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.commo.Commo;
import weblogic.management.commo.SecurityMBeanData;
import weblogic.management.security.internal.compatibility.ObjectNameString;
import weblogic.management.security.internal.compatibility.ProviderMigrationDriver;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.ClasspathClassLoader;

public class SecurityDataInUserConfigMigrationProcessor {
    static final String NAME_OF_COMPATIBILITY_DIRECTORY = "compatibility";
    static final String NAME_OF_COMPATIBILITY_JAR = "wlUserConfigCompatibility.jar";
    static final String REALM_TYPE = "weblogic.management.security.Realm";
    static final String ULM_TYPE = "weblogic.management.security.authentication.UserLockoutManager";
    static boolean debugInit = false;
    static String _debugInit = System.getProperty("weblogic.DebugUserConfigLoad", "false");
    HashMap beansCreated = new HashMap();

    public InputStream updateConfiguration(InputStream inputStream, File file) {
        if (_debugInit.equals("true")) {
            debugInit = true;
        }
        try {
            Object object;
            if (debugInit) {
                Debug.say((String)("Will be loading COMMO instances from: " + file.getAbsolutePath()));
            }
            List list = SecurityDataInUserConfigMigrationProcessor.getMBeans(file);
            if (debugInit) {
                Debug.say((String)("We loaded " + list.size() + " mbeans ... "));
            }
            Iterator iterator = list.iterator();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (iterator.hasNext()) {
                Object object2;
                Commo.Pair[] pairArray;
                object = (SecurityMBeanData)iterator.next();
                if (debugInit) {
                    Debug.say((String)("The instance name loaded is " + object.getInstanceName() + " of type " + object.getTypeName()));
                }
                Iterator iterator2 = object.getAttrValues().iterator();
                Vector<Object> vector = new Vector<Object>();
                Commo.Pair pair = null;
                while (iterator2.hasNext()) {
                    pairArray = (Commo.Pair[])iterator2.next();
                    if (pairArray.getValue() instanceof ObjectNameString) {
                        object2 = new ObjectName(((ObjectNameString)pairArray.getValue()).getStringObjectName());
                        pair = new Commo.Pair(pairArray.getKey(), object2);
                        vector.add(pair);
                        continue;
                    }
                    if (pairArray.getValue() instanceof ObjectNameString[]) {
                        object2 = (ObjectNameString[])pairArray.getValue();
                        ObjectName[] objectNameArray = new ObjectName[((Commo.Pair[])object2).length];
                        for (int i = 0; i < ((Commo.Pair[])object2).length; ++i) {
                            objectNameArray[i] = new ObjectName(object2[i].getStringObjectName());
                        }
                        pair = new Commo.Pair(pairArray.getKey(), (Object)objectNameArray);
                        vector.add(pair);
                        continue;
                    }
                    vector.add(pairArray);
                }
                object.setAttrValues(vector);
                pairArray = object.getAdditionalDescriptorElements();
                if (pairArray != null) {
                    object2 = new Commo.Pair[pairArray.length];
                    for (int i = 0; i < pairArray.length; ++i) {
                        ObjectNameString[] objectNameStringArray;
                        Commo.Pair pair2 = pairArray[i];
                        if (pair2.getValue() instanceof ObjectNameString) {
                            objectNameStringArray = new ObjectName(((ObjectNameString)pair2.getValue()).getStringObjectName());
                            object2[i] = new Commo.Pair(pair2.getKey(), (Object)objectNameStringArray);
                            continue;
                        }
                        if (pair2.getValue() instanceof ObjectNameString[]) {
                            objectNameStringArray = (ObjectNameString[])pair2.getValue();
                            ObjectName[] objectNameArray = new ObjectName[objectNameStringArray.length];
                            for (int j = 0; j < objectNameStringArray.length; ++j) {
                                objectNameArray[j] = new ObjectName(objectNameStringArray[j].toString());
                            }
                            object2[i] = new Commo.Pair(pair2.getKey(), (Object)objectNameArray);
                            continue;
                        }
                        object2[i] = pair2;
                    }
                    object.setAdditionalDescriptorValues(object2);
                }
                arrayList.add(object);
            }
            object = new ProviderMigrationDriver(DomainDir.getRootDir(), arrayList);
            return ((ProviderMigrationDriver)object).convert(inputStream);
        }
        catch (Exception exception) {
            throw new ManagementRuntimeException(exception);
        }
    }

    public static final List getMBeans(File file) {
        ArrayList<Object> arrayList;
        block13: {
            if (debugInit) {
                Debug.say((String)("get mbeans from " + file.getAbsolutePath()));
            }
            arrayList = new ArrayList<Object>();
            try {
                String[] stringArray;
                File file2 = new File(file, "userConfig");
                if (debugInit) {
                    Debug.say((String)("user config dir is  " + file2.getAbsolutePath()));
                }
                if (debugInit) {
                    Debug.say((String)("Will be loading COMMO instances from: " + file2));
                }
                if ((stringArray = file2.list()) == null) break block13;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = file2 + File.separator + stringArray[i];
                    String[] stringArray2 = new File(string).list();
                    if (debugInit) {
                        Debug.say((String)("There are " + stringArray2.length + " COMMO instances in domain " + stringArray[i]));
                    }
                    for (int j = 0; j < stringArray2.length; ++j) {
                        String string2;
                        block14: {
                            string2 = stringArray2[j];
                            try {
                                if (!debugInit) break block14;
                                Debug.say((String)("Process " + string2));
                            }
                            catch (Exception exception) {
                                if (string2.trim().endsWith("X")) {
                                    if (!debugInit) continue;
                                    Debug.say((String)(string2 + " ends with X so skip it"));
                                    continue;
                                }
                                if (!debugInit) continue;
                                Debug.say((String)("Skip " + string2 + " because of exception " + exception));
                                exception.printStackTrace();
                                continue;
                            }
                        }
                        try {
                            Object object = SecurityDataInUserConfigMigrationProcessor.readMBeanDataFromFile(string2);
                            arrayList.add(object);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception exception) {
                throw new ManagementRuntimeException(exception);
            }
        }
        return arrayList;
    }

    protected static Object readMBeanDataFromFile(String string) throws Exception {
        Object object;
        if (debugInit) {
            Debug.say((String)("Reading data from " + string));
        }
        Object object2 = null;
        String string2 = "Security";
        String string3 = "userConfig";
        String string4 = new String(DomainDir.getRootDir() + File.separator + string3 + File.separator + string2 + File.separator + string);
        String string5 = null;
        String string6 = null;
        File file = new File(string4);
        String[] stringArray = file.list();
        switch (stringArray.length) {
            case 0: {
                file.delete();
                break;
            }
            case 1: {
                string5 = stringArray[0];
                string6 = null;
                break;
            }
            case 3: {
                int n;
                object = new String[2];
                int n2 = 0;
                String string7 = null;
                for (n = 0; n < 3; ++n) {
                    if (stringArray[n].indexOf(46) == -1) continue;
                    object[n2] = stringArray[n];
                    ++n2;
                }
                if (n2 == 2) {
                    int n3;
                    n = object[0].indexOf(46);
                    String string8 = object[0].substring(n + 1);
                    int n4 = object[1].indexOf(46);
                    String string9 = object[1].substring(n4 + 1);
                    int n5 = Integer.parseInt(string8);
                    string7 = n5 < (n3 = Integer.parseInt(string9)) ? object[1] : object[0];
                    File file2 = new File(string4 + File.separator + string7);
                    file2.delete();
                } else {
                    int n6;
                    n2 = 0;
                    for (n = 0; n < 3; ++n) {
                        if (stringArray[n].indexOf(46) != -1) continue;
                        object[n2] = stringArray[n];
                        ++n2;
                    }
                    n = Integer.parseInt(object[0]);
                    string7 = n < (n6 = Integer.parseInt(object[1])) ? object[1] : object[0];
                    File file3 = new File(string4 + File.separator + string7);
                    file3.delete();
                }
                String[] stringArray2 = new String[2];
                n2 = 0;
                for (int i = 0; i < 3; ++i) {
                    if (stringArray[i].equals(string7)) continue;
                    stringArray2[n2] = stringArray[i];
                    ++n2;
                }
                stringArray = stringArray2;
            }
            case 2: {
                int n;
                string5 = null;
                if (stringArray[0].indexOf(46) != -1) {
                    if (stringArray[1].indexOf(46) == -1) {
                        string5 = stringArray[1];
                        string6 = stringArray[0];
                    } else {
                        float f;
                        float f2 = Float.parseFloat(stringArray[0]);
                        if (f2 > (f = Float.parseFloat(stringArray[1]))) {
                            string5 = stringArray[0];
                            string6 = stringArray[1];
                        } else {
                            string5 = stringArray[1];
                            string6 = stringArray[0];
                        }
                    }
                } else if (stringArray[1].indexOf(46) != -1 && stringArray[0].indexOf(46) == -1) {
                    string5 = stringArray[0];
                    string6 = stringArray[1];
                }
                if (string5 != null) break;
                object = null;
                int n7 = Integer.parseInt(stringArray[0]);
                if (n7 < (n = Integer.parseInt(stringArray[1]))) {
                    object = stringArray[1];
                    string5 = stringArray[0];
                    string6 = null;
                } else {
                    object = stringArray[0];
                    string5 = stringArray[1];
                    string6 = null;
                }
                String[] stringArray2 = new File(string4 + File.separator + (String)object);
                stringArray2.delete();
                break;
            }
            default: {
                throw new Exception("Error loading userConfig directory");
            }
        }
        object = null;
        for (int i = 0; i < 2; ++i) {
            try {
                object = string4 + File.separator + string5;
                object2 = SecurityDataInUserConfigMigrationProcessor.loadData((String)object);
                break;
            }
            catch (Exception exception) {
                string5 = string6;
                string6 = null;
                continue;
            }
        }
        return object2;
    }

    public static final Object loadData(String string) throws Exception {
        String string2 = new File(BootStrap.getPathRelativeWebLogicHome((String)"lib") + File.separator + NAME_OF_COMPATIBILITY_DIRECTORY + File.separator + NAME_OF_COMPATIBILITY_JAR).getAbsolutePath();
        File file = new File(string);
        WLUserConfigCompatabilityClassLoader wLUserConfigCompatabilityClassLoader = new WLUserConfigCompatabilityClassLoader(string2);
        Class<?> clazz = ((ClassLoader)((Object)wLUserConfigCompatabilityClassLoader)).loadClass("weblogic.management.commo.SecurityObjectInputStream");
        FileInputStream fileInputStream = new FileInputStream(file);
        Constructor<?> constructor = clazz.getConstructor(InputStream.class, ClassLoader.class, Boolean.TYPE, Boolean.TYPE);
        ObjectInputStream objectInputStream = (ObjectInputStream)constructor.newInstance(new Object[]{fileInputStream, wLUserConfigCompatabilityClassLoader, new Boolean("false"), new Boolean("false")});
        Object object = null;
        try {
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            if (debugInit) {
                exception.printStackTrace();
            }
            throw exception;
        }
        objectInputStream.close();
        ((InputStream)fileInputStream).close();
        return object;
    }

    static class WLUserConfigCompatabilityClassLoader
    extends ClasspathClassLoader {
        HashMap map = new HashMap();

        WLUserConfigCompatabilityClassLoader(String string) {
            super(string);
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            Class clazz = null;
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = super.loadClass(string);
                this.map.put(string, clazz);
            }
            return clazz;
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            Class clazz = (Class)this.map.get(string);
            if (clazz != null) {
                return clazz;
            }
            clazz = super.findClass(string);
            if (clazz != null) {
                this.map.put(string, clazz);
            }
            return clazz;
        }
    }
}

