/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.security.pk;

import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanAlreadyExistsException;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.DistributedManagementException;
import weblogic.management.internal.mbean.SecurityReadOnlyMBeanBinder;
import weblogic.management.security.ProviderMBeanBinder;
import weblogic.management.security.pk.KeyStoreMBeanImpl;
import weblogic.utils.codegen.AttributeBinder;

public class KeyStoreMBeanBinder
extends ProviderMBeanBinder
implements AttributeBinder {
    private KeyStoreMBeanImpl bean;

    protected KeyStoreMBeanBinder(DescriptorBean descriptorBean) {
        super(descriptorBean);
        this.bean = (KeyStoreMBeanImpl)descriptorBean;
    }

    public KeyStoreMBeanBinder() {
        super(new KeyStoreMBeanImpl());
        this.bean = (KeyStoreMBeanImpl)this.getBean();
    }

    public AttributeBinder bindAttribute(String string, Object object) throws IllegalArgumentException {
        try {
            KeyStoreMBeanBinder keyStoreMBeanBinder = this;
            if (!(keyStoreMBeanBinder instanceof SecurityReadOnlyMBeanBinder) && object != null && object.toString().trim().length() == 0) {
                return keyStoreMBeanBinder;
            }
            if (string != null) {
                if (string.equals("PrivateKeyStoreLocation")) {
                    try {
                        this.bean.setPrivateKeyStoreLocation((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else if (string.equals("PrivateKeyStorePassPhrase")) {
                    try {
                        if (this.bean.isPrivateKeyStorePassPhraseEncryptedSet()) {
                            throw new IllegalArgumentException("Encrypted attribute corresponding to PrivateKeyStorePassPhrase [ KeyStoreMBean ] is also present in the config file. For encrypted properties either encrypted or unencrypted attribute can be present in 8.x config.");
                        }
                        this.bean.setPrivateKeyStorePassPhrase((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else if (string.equals("PrivateKeyStorePassPhraseEncrypted")) {
                    if (this.bean.isPrivateKeyStorePassPhraseEncryptedSet()) {
                        throw new IllegalArgumentException("Unencrypted attribute corresponding to PrivateKeyStorePassPhraseEncrypted [ KeyStoreMBean ] is also present in the config file. For encrypted properties either encrypted or unencrypted attribute can be present in 8.x config.");
                    }
                    this.bean.setPrivateKeyStorePassPhraseEncryptedAsString((String)object);
                } else if (string.equals("RootCAKeyStoreLocation")) {
                    try {
                        this.bean.setRootCAKeyStoreLocation((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else if (string.equals("RootCAKeyStorePassPhrase")) {
                    try {
                        if (this.bean.isRootCAKeyStorePassPhraseEncryptedSet()) {
                            throw new IllegalArgumentException("Encrypted attribute corresponding to RootCAKeyStorePassPhrase [ KeyStoreMBean ] is also present in the config file. For encrypted properties either encrypted or unencrypted attribute can be present in 8.x config.");
                        }
                        this.bean.setRootCAKeyStorePassPhrase((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else if (string.equals("RootCAKeyStorePassPhraseEncrypted")) {
                    if (this.bean.isRootCAKeyStorePassPhraseEncryptedSet()) {
                        throw new IllegalArgumentException("Unencrypted attribute corresponding to RootCAKeyStorePassPhraseEncrypted [ KeyStoreMBean ] is also present in the config file. For encrypted properties either encrypted or unencrypted attribute can be present in 8.x config.");
                    }
                    this.bean.setRootCAKeyStorePassPhraseEncryptedAsString((String)object);
                } else {
                    keyStoreMBeanBinder = super.bindAttribute(string, object);
                }
            }
            return keyStoreMBeanBinder;
        }
        catch (ClassCastException classCastException) {
            System.out.println(classCastException + " name: " + string + " class: " + object.getClass().getName());
            throw classCastException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            if (exception instanceof DistributedManagementException) {
                throw new AssertionError((Object)("impossible exception: " + exception));
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            throw new AssertionError((Object)("unexpected exception: " + exception));
        }
    }
}

