/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.mail.internet.MimeUtility;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.Loggable;
import weblogic.management.internal.BootStrapStruct;
import weblogic.management.internal.ConfigLogger;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerChannelManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.ServerResource;
import weblogic.security.spi.Resource;

public final class BootstrapServlet
extends HttpServlet
implements PrivilegedExceptionAction {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugBootstrapServlet");
    private AuthorizationManager authorizer;
    private PrincipalAuthenticator authenticator;
    private AuthenticatedSubject kernelId;
    private ServletConfig config = null;

    public String getServletInfo() {
        return "Managed server bootstrap servlet";
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.config = servletConfig;
        this.kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        if (this.kernelId == null) {
            throw new ServletException("Security Services Unavailable");
        }
        String string = "weblogicDEFAULT";
        this.authenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)this.kernelId, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        this.authorizer = (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)this.kernelId, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE);
        if (this.authenticator == null || this.authorizer == null) {
            throw new ServletException("Security Services Unavailable");
        }
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)this.kernelId, (AuthenticatedSubject)this.kernelId, (PrivilegedExceptionAction)this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ServletException)((Object)privilegedActionException.getException());
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("BootstrapServlet initialized");
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("BootstrapServlet invoked");
        }
        this.processGet(httpServletRequest, httpServletResponse);
    }

    public void processGet(final HttpServletRequest httpServletRequest, final HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)this.kernelId, (AuthenticatedSubject)this.kernelId, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    Loggable loggable;
                    WLObjectOutputStream wLObjectOutputStream = null;
                    OutputStream outputStream = null;
                    PeerInfo peerInfo = BootstrapServlet.this.checkClientVersion(httpServletRequest, httpServletResponse);
                    if (peerInfo == null) {
                        return null;
                    }
                    String string = BootstrapServlet.mimeDecode(httpServletRequest.getHeader("username"));
                    String string2 = BootstrapServlet.mimeDecode(httpServletRequest.getHeader("password"));
                    String string3 = BootstrapServlet.mimeDecode(httpServletRequest.getHeader("servername"));
                    if (string3.equals(ManagementService.getRuntimeAccess(BootstrapServlet.this.kernelId).getServerName())) {
                        Loggable loggable2 = ConfigLogger.logServerNameSameAsAdminLoggable((String)string3);
                        loggable2.log();
                        httpServletResponse.addHeader("MatchMsg", loggable2.getMessageText());
                        httpServletResponse.sendError(404);
                        return null;
                    }
                    if (ManagementService.getRuntimeAccess(BootstrapServlet.this.kernelId).getDomain().lookupServer(string3) == null) {
                        Loggable loggable3 = ConfigLogger.logServerNameDoesNotExistLoggable((String)string3);
                        loggable3.log();
                        httpServletResponse.addHeader("UnkSvrMsg", loggable3.getMessageText());
                        httpServletResponse.sendError(404);
                        return null;
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    wLObjectOutputStream = new WLObjectOutputStream(byteArrayOutputStream);
                    wLObjectOutputStream.setServerChannel(ServerChannelManager.findDefaultLocalServerChannel());
                    try {
                        if (string == null || string2 == null) {
                            ConfigLogger.logBootstrapMissingCredentials((String)string3);
                            httpServletResponse.sendError(401);
                            Object var8_10 = null;
                            return var8_10;
                        }
                        AuthenticatedSubject authenticatedSubject = null;
                        try {
                            authenticatedSubject = BootstrapServlet.this.authenticator.authenticate((CallbackHandler)new MyCallbackHandler(string, string2));
                        }
                        catch (LoginException loginException) {
                            ConfigLogger.logBootstrapInvalidCredentials((String)string3, (String)string);
                            httpServletResponse.sendError(401);
                            Object var10_15 = null;
                            if (wLObjectOutputStream != null) {
                                wLObjectOutputStream.close();
                            }
                            if (outputStream != null) {
                                outputStream.close();
                            }
                            return var10_15;
                        }
                        loggable = new ServerResource(null, string3, "boot");
                        if (!BootstrapServlet.this.authorizer.isAccessAllowed(authenticatedSubject, (Resource)loggable, null)) {
                            ConfigLogger.logBootstrapUnauthorizedUser((String)string3, (String)string);
                            httpServletResponse.sendError(401);
                            Object var10_16 = null;
                            return var10_16;
                        }
                        String string4 = ManagementService.getRuntimeAccess(BootstrapServlet.this.kernelId).getDomain().getDomainVersion();
                        if (string4 != null) {
                            httpServletResponse.addHeader("DomainVersion", string4);
                        }
                        BootstrapServlet.this.writeStructToStream(wLObjectOutputStream);
                        wLObjectOutputStream.flush();
                        httpServletResponse.setContentLength(byteArrayOutputStream.size());
                        outputStream = httpServletResponse.getOutputStream();
                        byteArrayOutputStream.writeTo(outputStream);
                        outputStream.flush();
                        ConfigLogger.logManagedServerConfigWritten((String)string3);
                    }
                    catch (Exception exception) {
                        loggable = ConfigLogger.logBootStrapExceptionLoggable((Exception)exception);
                        loggable.log();
                        httpServletResponse.addHeader("ErrorMsg", loggable.getMessageText());
                        httpServletResponse.sendError(500, loggable.getMessage());
                        Object var10_18 = null;
                        return var10_18;
                    }
                    finally {
                        if (wLObjectOutputStream != null) {
                            wLObjectOutputStream.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception == null) {
                exception = privilegedActionException;
            }
            ConfigLogger.logBootStrapException((Exception)exception);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new ServletException((Throwable)exception);
        }
    }

    public Object run() throws ServletException {
        super.init(this.config);
        return null;
    }

    private void writeStructToStream(ObjectOutputStream objectOutputStream) throws RemoteException, IOException {
        String string = ManagementService.getRuntimeAccess(this.kernelId).getAdminServerName();
        BootStrapStruct bootStrapStruct = new BootStrapStruct(string);
        objectOutputStream.writeObject(bootStrapStruct);
    }

    private PeerInfo checkClientVersion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getHeader("Version");
        String string2 = httpServletRequest.getHeader("servername");
        if (string == null || string.length() == 0) {
            Loggable loggable = ConfigLogger.logUnknownReleaseLevelLoggable();
            loggable.log();
            httpServletResponse.addHeader("ErrorMsg", loggable.getMessageText());
            httpServletResponse.sendError(409);
            return null;
        }
        PeerInfo peerInfo = PeerInfo.getPeerInfo((String)string);
        PeerInfo peerInfo2 = PeerInfo.getPeerInfo();
        if (peerInfo != null && peerInfo2 != null && peerInfo2.getMajor() <= peerInfo.getMajor()) {
            return peerInfo;
        }
        String string3 = peerInfo2 == null ? "null" : peerInfo2.getVersionAsString();
        Loggable loggable = ConfigLogger.logInvalidReleaseLevelLoggable((String)string2, (String)string, (String)string3);
        loggable.log();
        httpServletResponse.addHeader("ErrorMsg", loggable.getMessageText());
        httpServletResponse.sendError(409);
        return null;
    }

    private static String mimeDecode(String string) {
        String string2 = null;
        try {
            string2 = MimeUtility.decodeText((String)string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    class MyCallbackHandler
    implements CallbackHandler {
        private String username;
        private String password;

        public MyCallbackHandler(String string, String string2) {
            this.username = string;
            this.password = string2;
        }

        public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
            for (int i = 0; i < callbackArray.length; ++i) {
                Callback callback;
                if (callbackArray[i] instanceof NameCallback) {
                    callback = (NameCallback)callbackArray[i];
                    ((NameCallback)callback).setName(this.username);
                    continue;
                }
                if (callbackArray[i] instanceof PasswordCallback) {
                    callback = (PasswordCallback)callbackArray[i];
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized Callback");
            }
        }
    }
}

