/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.servlet;

import com.bea.security.utils.random.SecureRandomData;
import java.io.IOException;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.http.HttpServletRequest;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.HMAC;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.encoders.BASE64Encoder;

public class ConnectionSigner {
    public static final String REQUEST_SALT = "wls_salt";
    public static final String REQUEST_SIGNATURE = "wls_signature";
    private static byte[] domainWideSecret = null;
    private static boolean gotSecret = false;
    private static byte[] credentialBytes = new byte[]{78, 19, 9, 37, 37, 7, 81, 99, 37, 36, 7, 91, 5};
    private static String signatureString = null;
    private static String saltString = null;
    private static boolean isSaltInitialized = false;
    private static AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] getSecret() {
        if (gotSecret) return domainWideSecret;
        Class<ConnectionSigner> clazz = ConnectionSigner.class;
        synchronized (ConnectionSigner.class) {
            if (gotSecret) return domainWideSecret;
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    SecurityConfigurationMBean securityConfigurationMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().getSecurityConfiguration();
                    return securityConfigurationMBean.getCredential();
                }
            };
            String string = (String)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedAction)privilegedAction);
            domainWideSecret = string.getBytes();
            gotSecret = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return domainWideSecret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void signConnection(URLConnection uRLConnection, AuthenticatedSubject authenticatedSubject) {
        SecurityServiceManager.checkKernelIdentity((AuthenticatedSubject)authenticatedSubject);
        if (!isSaltInitialized) {
            Class<ConnectionSigner> clazz = ConnectionSigner.class;
            // MONITORENTER : weblogic.management.servlet.ConnectionSigner.class
            if (!isSaltInitialized) {
                byte[] byArray = SecureRandomData.getInstance().getRandomBytes(16);
                BASE64Encoder bASE64Encoder = new BASE64Encoder();
                saltString = bASE64Encoder.encodeBuffer(byArray);
                signatureString = bASE64Encoder.encodeBuffer(HMAC.digest((byte[])credentialBytes, (byte[])ConnectionSigner.getSecret(), (byte[])byArray));
                isSaltInitialized = true;
            }
            // MONITOREXIT : clazz
        }
        uRLConnection.setRequestProperty(REQUEST_SALT, saltString);
        uRLConnection.setRequestProperty(REQUEST_SIGNATURE, signatureString);
    }

    public static boolean authenticate(String string, String string2) {
        byte[] byArray;
        byte[] byArray2;
        try {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byArray2 = bASE64Decoder.decodeBuffer(string);
            byArray = bASE64Decoder.decodeBuffer(string2);
        }
        catch (IOException iOException) {
            return false;
        }
        return HMAC.verify((byte[])byArray, (byte[])credentialBytes, (byte[])ConnectionSigner.getSecret(), (byte[])byArray2);
    }

    public static boolean isConnectionSigned(HttpServletRequest httpServletRequest) {
        try {
            String string = httpServletRequest.getHeader(REQUEST_SALT);
            if (string != null) {
                String string2 = httpServletRequest.getHeader(REQUEST_SIGNATURE);
                if (string2 == null) {
                    return false;
                }
                return ConnectionSigner.authenticate(string, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

