/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.servlet;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.mail.internet.MimeUtility;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.Kernel;
import weblogic.ldap.EmbeddedLDAP;
import weblogic.management.DomainDir;
import weblogic.management.ManagementLogger;
import weblogic.management.provider.PropertyService;
import weblogic.management.servlet.ConnectionSigner;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.FileRealm;
import weblogic.security.service.AdminResource;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;
import weblogic.servlet.security.Utils;
import weblogic.utils.io.StreamUtils;
import weblogic.xml.registry.XMLRegistryDir;
import weblogic.xml.registry.XMLRegistryException;

public class FileDistributionServlet
extends HttpServlet {
    public static final String OAM_APPNAME = "bea_wls_management_internal2";
    public static final String NAME = "bea_wls_management_internal2/wl_management";
    public static final String REQUEST_TYPE = "wl_request_type";
    public static final String REQUEST_USERNAME = "username";
    public static final String REQUEST_PASSWORD = "password";
    public static final String FILE_REALM_REQUEST = "wl_file_realm_request";
    public static final String INIT_REPLICA_REQUEST = "wl_init_replica_request";
    public static final String INIT_REPLICA_SERVER_NAME = "init-replica_server-name";
    public static final String INIT_REPLICA_SERVER_URL = "init-replica_server-url";
    public static final String INIT_REPLICA_VALIDATE = "init-replica-validate";
    public static final String XML_ENTITY_REQUEST = "wl_xml_entity_request";
    public static final String XML_ENTITY_PATH = "xml-entity-path";
    public static final String XML_REGISTRY_NAME = "xml-registry-name";
    public static final String JSP_UPLOAD_REQUEST = "wl_jsp_upload_request";
    public static final String JSP_REFRESH_REQUEST = "wl_jsp_refresh_request";
    public static final String SERVER_NAME = "server_name";
    public static final String MSI_REQUEST = "wl_managed_server_independence_request";
    public static final String MSI_REQUEST_FILE = "wl_managed_server_independence_request_filename";
    public static final String MSI_REQUEST_DOMAIN = "wl_managed_server_independence_request_domain";
    public static final String FILE_REQUEST = "file";
    public static final String FILE_REQUESTED = "file_name";
    private static final long serialVersionUID = -8473442547994280015L;
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugFileDistributionServlet");
    private AuthorizationManager am = null;
    private PrincipalAuthenticator pa = null;
    private static AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static URL getURL() throws MalformedURLException {
        String string = PropertyService.getAdminHttpUrl();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return new URL(string + NAME);
    }

    private AuthenticatedSubject authenticateRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        AuthenticatedSubject authenticatedSubject = null;
        String string = httpServletRequest.getHeader("wls_salt");
        if (string != null) {
            String string2 = httpServletRequest.getHeader("wls_signature");
            if (string2 == null) {
                ManagementLogger.logErrorFDSMissingCredentials();
            }
            if (!ConnectionSigner.authenticate(string, string2)) {
                ManagementLogger.logErrorFDSAuthenticationFailedDueToDomainWideSecretMismatch((String)string, (String)string2);
                return null;
            }
            return KERNEL_ID;
        }
        String string3 = httpServletRequest.getHeader(REQUEST_USERNAME);
        String string4 = httpServletRequest.getHeader(REQUEST_PASSWORD);
        if (string3 == null || string4 == null) {
            ManagementLogger.logErrorFDSMissingCredentials();
            httpServletResponse.sendError(401);
            return null;
        }
        try {
            authenticatedSubject = this.pa.authenticate((CallbackHandler)new MyCallbackHandler(string3, string4));
        }
        catch (LoginException loginException) {
            ManagementLogger.logErrorFDSAuthenticationFailed((String)string3);
            httpServletResponse.sendError(401);
            return null;
        }
        return authenticatedSubject;
    }

    public String getServletInfo() {
        return "Management files distribution servlet";
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        if (KERNEL_ID == null) {
            throw new ServletException("Security Services Unavailable");
        }
        String string = "weblogicDEFAULT";
        this.pa = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        this.am = (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE);
        if (this.pa == null || this.am == null) {
            throw new ServletException("Security Services Unavailable");
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("FileDistributionServlet initialized");
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        AuthenticatedSubject authenticatedSubject = this.authenticateRequest(httpServletRequest, httpServletResponse);
        if (authenticatedSubject == null) {
            return;
        }
        final HttpServletRequest httpServletRequest2 = httpServletRequest;
        final HttpServletResponse httpServletResponse2 = httpServletResponse;
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    FileDistributionServlet.this.internalDoPost(httpServletRequest2, httpServletResponse2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            ManagementLogger.logErrorFDSUnauthorizedUploadAttempt((String)authenticatedSubject.getName());
            httpServletResponse.sendError(401);
        }
    }

    private void internalDoPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block12: {
            Object object;
            AuthenticatedSubject authenticatedSubject = this.authenticateRequest(httpServletRequest, httpServletResponse);
            if (authenticatedSubject == null) {
                return;
            }
            String string = httpServletRequest.getHeader(REQUEST_TYPE);
            if (authenticatedSubject != KERNEL_ID && !this.am.isAccessAllowed(authenticatedSubject, (Resource)(object = new AdminResource("FileDownload", null, string)), null)) {
                ManagementLogger.logErrorFDSUnauthorizedDownloadAttempt((String)authenticatedSubject.getName(), (String)string);
                httpServletResponse.sendError(401);
                return;
            }
            try {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("---- >doGet incoming request: " + string);
                }
                if (string.equals(XML_ENTITY_REQUEST)) {
                    this.doGetXMLEntityRequest(httpServletRequest, httpServletResponse);
                    break block12;
                }
                if (string.equals(JSP_REFRESH_REQUEST)) {
                    this.doGetJspRefreshRequest(httpServletRequest, httpServletResponse);
                    break block12;
                }
                if (string.equals(FILE_REQUEST)) {
                    this.doGetFile(httpServletRequest, httpServletResponse);
                    break block12;
                }
                if (string.equals(INIT_REPLICA_REQUEST) || string.equals(FILE_REALM_REQUEST) || string.equals(MSI_REQUEST)) {
                    try {
                        object = string;
                        HttpServletRequest httpServletRequest2 = httpServletRequest;
                        HttpServletResponse httpServletResponse2 = httpServletResponse;
                        SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction((String)object, httpServletRequest2, httpServletResponse2){
                            final /* synthetic */ String val$authRequestType;
                            final /* synthetic */ HttpServletRequest val$authReq;
                            final /* synthetic */ HttpServletResponse val$authRes;
                            {
                                this.val$authRequestType = string;
                                this.val$authReq = httpServletRequest;
                                this.val$authRes = httpServletResponse;
                            }

                            public Object run() throws IOException {
                                if (this.val$authRequestType.equals(FileDistributionServlet.INIT_REPLICA_REQUEST)) {
                                    FileDistributionServlet.this.doGetInitReplicaRequest(this.val$authReq, this.val$authRes);
                                } else if (this.val$authRequestType.equals(FileDistributionServlet.FILE_REALM_REQUEST)) {
                                    FileDistributionServlet.this.doGetFileRealmRequest(this.val$authRes);
                                } else if (this.val$authRequestType.equals(FileDistributionServlet.MSI_REQUEST)) {
                                    FileDistributionServlet.this.doGetMSIRequest(this.val$authReq, this.val$authRes);
                                }
                                return null;
                            }
                        });
                        break block12;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        throw exception;
                    }
                }
                httpServletResponse.addHeader("ErrorMsg", "Bad request type");
                object = Utils.encodeXSS(string);
                httpServletResponse.sendError(400, "Bad request type: " + (String)object);
                ManagementLogger.logBadRequestInFileDistributionServlet((String)string);
            }
            catch (Exception exception) {
                if (Kernel.isInitialized()) {
                    ManagementLogger.logErrorInFileDistributionServlet((String)string, (Throwable)exception);
                }
                throw new AssertionError((Object)"kernel not initialized");
            }
        }
    }

    private void returnInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamUtils.writeTo((InputStream)inputStream, (OutputStream)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnFile(String string, HttpServletResponse httpServletResponse, boolean bl, FileNotFoundHandler fileNotFoundHandler) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            String string2 = fileNotFoundHandler.purpose() + " file not found at configured location";
            httpServletResponse.addHeader("ErrorMsg", string2);
            httpServletResponse.sendError(500, string2 + ": " + Utils.encodeXSS(file.toString()));
            if (Kernel.isInitialized()) {
                fileNotFoundHandler.log(file.toString());
            }
            return;
        }
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
        try {
            if (bl) {
                dataOutputStream.writeUTF(Utils.encodeXSS(string));
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.returnInputStream(fileInputStream, dataOutputStream);
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            dataOutputStream.close();
            throw throwable;
        }
        dataOutputStream.close();
    }

    private void doGetFileRealmRequest(HttpServletResponse httpServletResponse) throws IOException {
        this.returnFile(FileRealm.getPath(), httpServletResponse, false, new FileNotFoundHandler(){

            public void log(String string) {
                ManagementLogger.logFileNotFoundProcessingFileRealmRequest((String)string);
            }

            public String purpose() {
                return "Security";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doGetXMLEntityRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        BufferedOutputStream bufferedOutputStream;
        block11: {
            String string = httpServletRequest.getHeader(XML_REGISTRY_NAME);
            String string2 = httpServletRequest.getHeader(XML_ENTITY_PATH);
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("wl_xml_entity_request: registryName = " + string + ", entityPath = " + string2);
            }
            if (string == null || string.length() == 0) {
                String string3 = "Registry Name not specified";
                httpServletResponse.addHeader("ErrorMsg", string3);
                httpServletResponse.sendError(500, string3);
                return;
            }
            if (string2 == null || string2.length() == 0) {
                String string4 = "Entity path not specified";
                httpServletResponse.addHeader("ErrorMsg", string4);
                httpServletResponse.sendError(500, string4);
                return;
            }
            XMLRegistryDir xMLRegistryDir = new XMLRegistryDir(string);
            InputStream inputStream = null;
            bufferedOutputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
            try {
                try {
                    inputStream = xMLRegistryDir.getEntity(string2);
                    StreamUtils.writeTo((InputStream)inputStream, (OutputStream)bufferedOutputStream);
                }
                catch (XMLRegistryException xMLRegistryException) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Exception in FileDistributionServlet", (Throwable)((Object)xMLRegistryException));
                    }
                    String string5 = xMLRegistryException.getMessage();
                    httpServletResponse.addHeader("ErrorMsg", string5);
                    httpServletResponse.sendError(500, string5);
                    Object var11_11 = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    bufferedOutputStream.close();
                    return;
                }
                Object var11_10 = null;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                bufferedOutputStream.close();
                throw throwable;
            }
            inputStream.close();
        }
        bufferedOutputStream.close();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("entity written to servlet output stream");
        }
    }

    private void doGetInitReplicaRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = FileDistributionServlet.mimeDecode(httpServletRequest.getHeader(INIT_REPLICA_SERVER_NAME));
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("wl_init_replica_request: serverName = " + string);
        }
        if (string == null) {
            String string2 = "Server Name not specified";
            ManagementLogger.logErrorProcessingInitReplicaRequest((String)string2);
            httpServletResponse.addHeader("ErrorMsg", string2);
            httpServletResponse.sendError(500, string2);
            return;
        }
        String string3 = httpServletRequest.getHeader(INIT_REPLICA_SERVER_URL);
        String string4 = httpServletRequest.getHeader(INIT_REPLICA_VALIDATE);
        EmbeddedLDAP embeddedLDAP = EmbeddedLDAP.getEmbeddedLDAP();
        if (embeddedLDAP == null) {
            String string5 = "Embedded LDAP not available";
            ManagementLogger.logErrorProcessingInitReplicaRequest((String)string5);
            httpServletResponse.addHeader("ErrorMsg", string5);
            httpServletResponse.sendError(500, string5);
            return;
        }
        try {
            if (string4 != null && embeddedLDAP.isValidReplica(string, string3)) {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
                bufferedOutputStream.close();
                return;
            }
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in FileDistributionServlet", (Throwable)exception);
            }
            String string6 = "" + exception.getMessage();
            ManagementLogger.logErrorProcessingInitReplicaRequest((String)string6);
            httpServletResponse.addHeader("ErrorMsg", string6);
            httpServletResponse.sendError(500, string6);
            return;
        }
        String string7 = null;
        try {
            string7 = embeddedLDAP.initReplicaForNewServer(string, string3);
            if (string7 == null) {
                String string8 = "Initial replica not available";
                ManagementLogger.logErrorProcessingInitReplicaRequest((String)string8);
                httpServletResponse.addHeader("ErrorMsg", string8);
                httpServletResponse.sendError(500, string8);
                return;
            }
        }
        catch (Exception exception) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Exception in FileDistributionServlet", (Throwable)exception);
            }
            String string9 = "" + exception.getMessage();
            ManagementLogger.logErrorProcessingInitReplicaRequest((String)string9);
            httpServletResponse.addHeader("ErrorMsg", string9);
            httpServletResponse.sendError(500, string9);
            return;
        }
        this.returnFile(string7, httpServletResponse, false, new FileNotFoundHandler(){

            public void log(String string) {
                ManagementLogger.logFileNotFoundProcessingInitReplicaRequest((String)string);
            }

            public String purpose() {
                return "Embedded LDAP initial replica";
            }
        });
    }

    private static String mimeDecode(String string) {
        String string2 = null;
        try {
            string2 = MimeUtility.decodeText((String)string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetJspRefreshRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getHeader("adminPath");
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            try {
                httpServletResponse.setContentType("text/plain");
                httpServletResponse.setStatus(200);
                this.returnInputStream(fileInputStream, (OutputStream)httpServletResponse.getOutputStream());
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            {
            }
        }
        catch (IOException iOException) {
            String string2 = "I/O Exception getting resource: " + iOException.getMessage();
            httpServletResponse.addHeader("ErrorMsg", string2);
            httpServletResponse.sendError(500, string2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doGetMSIRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getHeader(MSI_REQUEST_FILE);
        String string2 = File.separator;
        String string3 = DomainDir.getRootDir() + string2 + string;
        File file = new File(string3);
        if (!file.exists()) {
            String string4 = file.getAbsolutePath() + " doesn't exist in AdminServer";
            httpServletResponse.addHeader("ErrorMsg", string4);
            httpServletResponse.sendError(404, string4);
            return;
        }
        try {
            InputStream inputStream = null;
            try {
                httpServletResponse.setContentType("text/plain");
                httpServletResponse.setStatus(200);
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
                    objectOutputStream.writeObject(fileArray);
                } else {
                    inputStream = new FileInputStream(file);
                    this.returnInputStream(inputStream, (OutputStream)httpServletResponse.getOutputStream());
                }
                Object var11_13 = null;
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            this.log("Interal I/0 Exception on AdminServer getting resource " + (string == null ? "null" : string), iOException);
            String string5 = "I/O Exception getting resource: " + iOException.getMessage();
            httpServletResponse.addHeader("ErrorMsg", string5);
            httpServletResponse.sendError(500, string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        File file;
        String string = httpServletRequest.getHeader(FILE_REQUESTED);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug(" File requested : " + string);
        }
        if (!(file = new File(string)).exists()) {
            String string2 = file.getAbsolutePath() + " doesn't exist";
            httpServletResponse.addHeader("ErrorMsg", string2);
            httpServletResponse.sendError(404, string2);
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                httpServletResponse.setContentType("text/plain");
                httpServletResponse.setStatus(200);
                this.returnInputStream(fileInputStream, (OutputStream)httpServletResponse.getOutputStream());
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            {
            }
        }
        catch (IOException iOException) {
            this.log("Interal I/0 Exception on AdminServer getting resource " + (string == null ? "null" : string), iOException);
            String string3 = "I/O Exception getting resource: " + iOException.getMessage();
            httpServletResponse.addHeader("ErrorMsg", string3);
            httpServletResponse.sendError(500, string3);
        }
    }

    private static interface FileNotFoundHandler {
        public void log(String var1);

        public String purpose();
    }

    class MyCallbackHandler
    implements CallbackHandler {
        private String username;
        private String password;

        public MyCallbackHandler(String string, String string2) {
            this.username = string;
            this.password = string2;
        }

        public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
            for (int i = 0; i < callbackArray.length; ++i) {
                Callback callback;
                if (callbackArray[i] instanceof NameCallback) {
                    callback = (NameCallback)callbackArray[i];
                    ((NameCallback)callback).setName(this.username);
                    continue;
                }
                if (callbackArray[i] instanceof PasswordCallback) {
                    callback = (PasswordCallback)callbackArray[i];
                    if (this.password != null) {
                        ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                        continue;
                    }
                    ((PasswordCallback)callback).setPassword(null);
                    continue;
                }
                throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized Callback");
            }
        }
    }
}

