/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.snmp;

import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SNMPAgentMBean;
import weblogic.management.configuration.SNMPAttributeChangeMBean;
import weblogic.management.configuration.SNMPCounterMonitorMBean;
import weblogic.management.configuration.SNMPGaugeMonitorMBean;
import weblogic.management.configuration.SNMPLogFilterMBean;
import weblogic.management.configuration.SNMPProxyMBean;
import weblogic.management.configuration.SNMPStringMonitorMBean;
import weblogic.management.configuration.SNMPTrapDestinationMBean;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.UpdateException;

public class SNMPCompatibilityProcessor
implements ConfigurationProcessor {
    private static final boolean DEBUG = false;

    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        SNMPAgentMBean sNMPAgentMBean = domainMBean.getSNMPAgent();
        SNMPProxyMBean[] sNMPProxyMBeanArray = domainMBean.getSNMPProxies();
        for (int i = 0; i < sNMPProxyMBeanArray.length; ++i) {
            SNMPCompatibilityProcessor.upgradeSNMPProxyConfiguration(sNMPAgentMBean, sNMPProxyMBeanArray[i]);
        }
        SNMPTrapDestinationMBean[] sNMPTrapDestinationMBeanArray = domainMBean.getSNMPTrapDestinations();
        for (int i = 0; i < sNMPTrapDestinationMBeanArray.length; ++i) {
            SNMPCompatibilityProcessor.upgradeSNMPTrapDestinationConfiguration(sNMPAgentMBean, sNMPTrapDestinationMBeanArray[i]);
        }
        SNMPCounterMonitorMBean[] sNMPCounterMonitorMBeanArray = domainMBean.getSNMPCounterMonitors();
        for (int i = 0; i < sNMPCounterMonitorMBeanArray.length; ++i) {
            SNMPCompatibilityProcessor.upgradeSNMPCounterMonitorConfiguration(sNMPAgentMBean, sNMPCounterMonitorMBeanArray[i]);
        }
        SNMPGaugeMonitorMBean[] sNMPGaugeMonitorMBeanArray = domainMBean.getSNMPGaugeMonitors();
        for (int i = 0; i < sNMPGaugeMonitorMBeanArray.length; ++i) {
            SNMPCompatibilityProcessor.upgradeSNMPGaugeMonitorConfiguration(sNMPAgentMBean, sNMPGaugeMonitorMBeanArray[i]);
        }
        SNMPStringMonitorMBean[] sNMPStringMonitorMBeanArray = domainMBean.getSNMPStringMonitors();
        for (int i = 0; i < sNMPStringMonitorMBeanArray.length; ++i) {
            SNMPCompatibilityProcessor.upgradeSNMPStringMonitorConfiguration(sNMPAgentMBean, sNMPStringMonitorMBeanArray[i]);
        }
        SNMPAttributeChangeMBean[] sNMPAttributeChangeMBeanArray = domainMBean.getSNMPAttributeChanges();
        for (int i = 0; i < sNMPAttributeChangeMBeanArray.length; ++i) {
            SNMPCompatibilityProcessor.upgradeSNMPAttributeChangeConfiguration(sNMPAgentMBean, sNMPAttributeChangeMBeanArray[i]);
        }
        SNMPLogFilterMBean[] sNMPLogFilterMBeanArray = domainMBean.getSNMPLogFilters();
        for (int i = 0; i < sNMPLogFilterMBeanArray.length; ++i) {
            SNMPCompatibilityProcessor.upgradeSNMPLogFilterConfiguration(sNMPAgentMBean, sNMPLogFilterMBeanArray[i]);
        }
    }

    private static void upgradeSNMPProxyConfiguration(SNMPAgentMBean sNMPAgentMBean, SNMPProxyMBean sNMPProxyMBean) {
        sNMPAgentMBean.createSNMPProxy(sNMPProxyMBean.getName(), sNMPProxyMBean);
    }

    private static void upgradeSNMPTrapDestinationConfiguration(SNMPAgentMBean sNMPAgentMBean, SNMPTrapDestinationMBean sNMPTrapDestinationMBean) {
        sNMPAgentMBean.createSNMPTrapDestination(sNMPTrapDestinationMBean.getName(), sNMPTrapDestinationMBean);
    }

    private static void upgradeSNMPCounterMonitorConfiguration(SNMPAgentMBean sNMPAgentMBean, SNMPCounterMonitorMBean sNMPCounterMonitorMBean) {
        sNMPAgentMBean.createSNMPCounterMonitor(sNMPCounterMonitorMBean.getName(), sNMPCounterMonitorMBean);
    }

    private static void upgradeSNMPGaugeMonitorConfiguration(SNMPAgentMBean sNMPAgentMBean, SNMPGaugeMonitorMBean sNMPGaugeMonitorMBean) {
        sNMPAgentMBean.createSNMPGaugeMonitor(sNMPGaugeMonitorMBean.getName(), sNMPGaugeMonitorMBean);
    }

    private static void upgradeSNMPStringMonitorConfiguration(SNMPAgentMBean sNMPAgentMBean, SNMPStringMonitorMBean sNMPStringMonitorMBean) {
        sNMPAgentMBean.createSNMPStringMonitor(sNMPStringMonitorMBean.getName(), sNMPStringMonitorMBean);
    }

    private static void upgradeSNMPLogFilterConfiguration(SNMPAgentMBean sNMPAgentMBean, SNMPLogFilterMBean sNMPLogFilterMBean) {
        sNMPAgentMBean.createSNMPLogFilter(sNMPLogFilterMBean.getName(), sNMPLogFilterMBean);
    }

    private static void upgradeSNMPAttributeChangeConfiguration(SNMPAgentMBean sNMPAgentMBean, SNMPAttributeChangeMBean sNMPAttributeChangeMBean) {
        sNMPAgentMBean.createSNMPAttributeChange(sNMPAttributeChangeMBean.getName(), sNMPAttributeChangeMBean);
    }
}

