/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.timer;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.timer.TimerMBean;
import weblogic.management.timer.TimerListener;
import weblogic.management.timer.TimerNotification;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;

public final class Timer
extends javax.management.timer.Timer
implements TimerMBean,
NotificationBroadcaster,
Serializable {
    private Object listenerLock = new Object();
    private Map allNotifications = new HashMap(11);
    private TimerListener[] allListeners = new TimerListener[0];
    private int notificationCount = 0;
    private int listenerCount = 0;
    private boolean sendPastNotifications = false;
    TimerManager timerManager;
    private int Id = 0;
    private volatile boolean isActive = true;
    private Set pastNotifications = new HashSet(7);

    public Timer() {
        this.timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("TimerMBean");
    }

    public int getNbNotifications() {
        return this.notificationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllNotificationIDs() {
        Vector vector = new Vector();
        Map map = this.allNotifications;
        synchronized (map) {
            Iterator iterator = this.allNotifications.keySet().iterator();
            while (iterator.hasNext()) {
                vector.addElement(iterator.next());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getNotificationIDs(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        Map map = this.allNotifications;
        synchronized (map) {
            for (Integer n : this.allNotifications.keySet()) {
                TimerNotification timerNotification = (TimerNotification)this.allNotifications.get(n);
                if (timerNotification == null || !string.equals(timerNotification.getType())) continue;
                vector.addElement(new Integer(timerNotification.getTriggerID()));
            }
        }
        return vector;
    }

    public String getNotificationType(Integer n) {
        TimerNotification timerNotification = this.getNotification(n);
        return timerNotification != null ? timerNotification.getType() : null;
    }

    public String getNotificationMessage(Integer n) {
        TimerNotification timerNotification = this.getNotification(n);
        return timerNotification != null ? timerNotification.getMessage() : null;
    }

    public Object getNotificationUserData(Integer n) {
        TimerNotification timerNotification = this.getNotification(n);
        return timerNotification != null ? timerNotification.getUserData() : null;
    }

    public Date getDate(Integer n) {
        TimerNotification timerNotification = this.getNotification(n);
        return timerNotification != null ? timerNotification.getDate() : null;
    }

    public Long getPeriod(Integer n) {
        TimerNotification timerNotification = this.getNotification(n);
        if (timerNotification != null) {
            return new Long(timerNotification.getTimeStamp());
        }
        return null;
    }

    public Long getNbOccurences(Integer n) {
        TimerNotification timerNotification = this.getNotification(n);
        if (timerNotification != null) {
            return new Long(timerNotification.getNbOccurences());
        }
        return null;
    }

    public Boolean getFixedRate(Integer n) {
        TimerNotification timerNotification = this.getNotification(n);
        return timerNotification != null ? new Boolean(timerNotification.isFixedRate()) : null;
    }

    public boolean getSendPastNotifications() {
        return this.sendPastNotifications;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public synchronized boolean isEmpty() {
        return this.notificationCount == 0;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    public void setSendPastNotifications(boolean bl) {
        this.sendPastNotifications = bl;
    }

    public void start() {
        this.isActive = true;
        this.firePastNotifications();
    }

    public void stop() {
        this.isActive = false;
    }

    public Integer addNotification(String string, String string2, Object object, Date date, long l, long l2) throws IllegalArgumentException {
        return this.addNotification(string, string2, object, date, l, l2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer addNotification(String string, String string2, Object object, Date date, long l, long l2, boolean bl) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("Null notification date.");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative period value: " + l);
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative occurances: " + l2);
        }
        TimerNotification timerNotification = new TimerNotification(string, string2, object, date, l, l2, bl, this);
        weblogic.timers.Timer timer = null;
        timer = !bl ? this.timerManager.schedule((weblogic.timers.TimerListener)timerNotification, date, l) : this.timerManager.scheduleAtFixedRate((weblogic.timers.TimerListener)timerNotification, date, l);
        timerNotification.setTracker(timer);
        Integer n = this.getNextId();
        Map map = this.allNotifications;
        synchronized (map) {
            this.allNotifications.put(n, timerNotification);
            ++this.notificationCount;
        }
        return n;
    }

    public Integer addNotification(String string, String string2, Object object, Date date, long l) throws IllegalArgumentException {
        return this.addNotification(string, string2, object, date, l, 0L);
    }

    public Integer addNotification(String string, String string2, Object object, Date date) throws IllegalArgumentException {
        return this.addNotification(string, string2, object, date, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotification(Integer n) throws InstanceNotFoundException {
        Map map = this.allNotifications;
        synchronized (map) {
            TimerNotification timerNotification = (TimerNotification)this.allNotifications.remove(n);
            if (timerNotification != null) {
                timerNotification.getTracker().cancel();
                --this.notificationCount;
            } else {
                throw new InstanceNotFoundException("Notification with id=" + n + " could not be found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotifications(String string) throws InstanceNotFoundException {
        Vector<Integer> vector = new Vector<Integer>();
        Map map = this.allNotifications;
        synchronized (map) {
            for (Integer n : this.allNotifications.keySet()) {
                TimerNotification timerNotification = (TimerNotification)this.allNotifications.get(n);
                if (!string.equals(timerNotification.getType())) continue;
                vector.add(n);
                timerNotification.getTracker().cancel();
            }
            if (vector.size() == 0) {
                throw new InstanceNotFoundException("No notification of type=" + string + " found");
            }
            for (int i = 0; i < vector.size(); ++i) {
                this.allNotifications.remove(vector.get(i));
                --this.notificationCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNotifications() {
        Map map = this.allNotifications;
        synchronized (map) {
            Iterator iterator = this.allNotifications.keySet().iterator();
            while (iterator.hasNext()) {
                TimerNotification timerNotification = (TimerNotification)this.allNotifications.get((Integer)iterator.next());
                timerNotification.getTracker().cancel();
            }
            this.allNotifications.clear();
            this.allNotifications = new HashMap(11);
            this.notificationCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        Object object2 = this.listenerLock;
        synchronized (object2) {
            TimerListener timerListener;
            if (this.listenerCount == this.allListeners.length) {
                int n = this.listenerCount == 0 ? 1 : this.listenerCount * 2;
                TimerListener[] timerListenerArray = new TimerListener[n];
                System.arraycopy(this.allListeners, 0, timerListenerArray, 0, this.listenerCount);
                this.allListeners = timerListenerArray;
            }
            this.allListeners[this.listenerCount] = timerListener = new TimerListener(notificationListener, notificationFilter, object);
            ++this.listenerCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        Object object = this.listenerLock;
        synchronized (object) {
            for (int i = 0; i < this.listenerCount; ++i) {
                if (!this.allListeners[i].getListener().equals(notificationListener)) continue;
                --this.listenerCount;
                System.arraycopy(this.allListeners, i + 1, this.allListeners, i, this.listenerCount - i);
                this.allListeners[this.listenerCount] = null;
                break;
            }
        }
    }

    public void deliverNotifications(Notification notification) {
        for (int i = 0; i < this.listenerCount; ++i) {
            this.allListeners[i].deliverNotification(notification);
        }
    }

    private synchronized Integer getNextId() {
        return new Integer(this.Id++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerNotification getNotification(Integer n) {
        Map map = this.allNotifications;
        synchronized (map) {
            return (TimerNotification)this.allNotifications.get(n);
        }
    }

    void addPastNotification(TimerNotification timerNotification) {
        this.pastNotifications.add(timerNotification);
    }

    private void firePastNotifications() {
        for (TimerNotification timerNotification : this.pastNotifications) {
            for (int i = timerNotification.getPastNotificationCount(); i > 0; --i) {
                this.deliverNotifications(timerNotification.getNotificationObject());
            }
            timerNotification.unsetPastNotificationCount();
        }
    }
}

