/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.timer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public class TimerListener {
    private NotificationListener listener;
    private NotificationFilter filter;
    private Object handback;
    private AuthenticatedSubject subject;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public TimerListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.listener = notificationListener;
        this.filter = notificationFilter;
        this.handback = object;
        this.subject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
    }

    public NotificationListener getListener() {
        return this.listener;
    }

    public void deliverNotification(Notification notification) {
        final Notification notification2 = notification;
        final NotificationFilter notificationFilter = this.filter;
        final Object object = this.handback;
        final NotificationListener notificationListener = this.listener;
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                if (notificationFilter == null || notificationFilter.isNotificationEnabled(notification2)) {
                    notificationListener.handleNotification(notification2, object);
                }
                return null;
            }
        });
    }
}

