/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.timer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import javax.management.Notification;
import weblogic.management.timer.Timer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.timers.TimerListener;

class TimerNotification
implements TimerListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final long period;
    private final long nbOccurences;
    private long executeCount = 0L;
    private final Timer timer;
    private boolean removed = false;
    private boolean fixedRate = false;
    private final Notification notificationEvent;
    private final AuthenticatedSubject subject;
    private ClassLoader initClassLoader;
    private long time;
    private volatile int pastNotificationCount = 0;
    private weblogic.timers.Timer tracker = null;
    private int instance = -1;

    public TimerNotification(String string, String string2, Object object, Date date, long l, long l2, Timer timer) {
        this(string, string2, object, date, l, l2, false, timer);
    }

    public TimerNotification(String string, String string2, Object object, Date date, long l, long l2, boolean bl, Timer timer) {
        this.time = date.getTime();
        this.period = l;
        this.nbOccurences = l2;
        this.fixedRate = bl;
        this.timer = timer;
        this.notificationEvent = new Notification(string, timer, 0L, this.time, string2);
        this.notificationEvent.setUserData(object);
        this.subject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        this.initClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public Date getDate() {
        return new Date(this.time);
    }

    public long getPeriod() {
        return this.period;
    }

    public long getNbOccurences() {
        return this.nbOccurences;
    }

    public int getTriggerID() {
        return this.instance;
    }

    public void setTriggerID(int n) {
        this.instance = n;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }

    public void setRemoved(boolean bl) {
        this.removed = bl;
    }

    public String getType() {
        return this.notificationEvent.getType();
    }

    public String getMessage() {
        return this.notificationEvent.getMessage();
    }

    public Object getUserData() {
        return this.notificationEvent.getUserData();
    }

    public long getTimeStamp() {
        return this.time;
    }

    public void timerExpired(weblogic.timers.Timer timer) {
        ++this.executeCount;
        if (this.executeCount == this.nbOccurences) {
            timer.cancel();
        }
        if (!this.timer.isActive()) {
            if (this.timer.getSendPastNotifications()) {
                ++this.pastNotificationCount;
                this.timer.addPastNotification(this);
            }
            return;
        }
        if (this.initClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.initClassLoader);
        }
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                TimerNotification.this.timer.deliverNotifications(TimerNotification.this.notificationEvent);
                return null;
            }
        });
    }

    void setTracker(weblogic.timers.Timer timer) {
        this.tracker = timer;
    }

    weblogic.timers.Timer getTracker() {
        return this.tracker;
    }

    Notification getNotificationObject() {
        return this.notificationEvent;
    }

    int getPastNotificationCount() {
        return this.pastNotificationCount;
    }

    void unsetPastNotificationCount() {
        this.pastNotificationCount = 0;
    }
}

