/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.tools;

import java.lang.reflect.Array;
import javax.management.MBeanAttributeInfo;
import weblogic.management.info.ExtendedAttributeInfo;

public class AttributeInfo
extends MBeanAttributeInfo
implements ExtendedAttributeInfo {
    static final long serialVersionUID = 1876948055092590334L;
    private static String[] primitiveTypes = new String[]{"byte", "short", "int", "long", "float", "double", "boolean"};
    transient Class typeClass;
    transient Class collectionTypeClass;
    private String collectionType = null;
    private Object clientDefault = null;
    private boolean configurable = true;
    private boolean isIs = false;
    private String oldProp = null;
    private boolean dynamic = false;
    private Object[] legalValues = null;
    private boolean isLegalValuesExtensible = false;
    private Long legalMax = null;
    private Long legalMin = null;
    private boolean legalNull = true;
    private Object defaultValue = null;
    private Object productionModeDefaultValue = null;
    private boolean isExcluded = false;
    private boolean isEncrypted = false;
    private String units = null;
    private String[] legalChecks = null;
    private String[] legalResponses = null;
    private Integer protectionLevel = null;
    private boolean overrideDynamic = false;
    private boolean deploymentDescriptor = false;
    private boolean isContained = false;
    private transient Boolean productionModeEnabled;
    private transient boolean initializedClasses = false;

    public AttributeInfo(String string, String string2, String string3, Object object, Object object2, Object object3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string5, boolean bl5, String[] stringArray, Object[] objectArray, boolean bl6, Long l, Long l2, boolean bl7, boolean bl8, boolean bl9, String string6, String[] stringArray2, Integer n, boolean bl10, boolean bl11, boolean bl12) {
        super(string, string2, string3, bl, bl2, bl4);
        this.defaultValue = object;
        this.productionModeDefaultValue = object2;
        this.clientDefault = object3;
        this.configurable = bl3;
        this.collectionType = string4;
        this.oldProp = string5;
        this.isIs = bl4;
        this.dynamic = bl5;
        this.legalChecks = stringArray;
        this.legalValues = objectArray;
        this.isLegalValuesExtensible = bl6;
        this.legalMax = l;
        this.legalMin = l2;
        this.legalNull = bl7;
        this.isExcluded = bl8;
        this.isEncrypted = bl9;
        this.units = string6;
        this.legalResponses = stringArray2;
        this.protectionLevel = n;
        this.overrideDynamic = bl10;
        this.deploymentDescriptor = bl11;
        this.isContained = bl12;
        if (AttributeInfo.isPrimitive(string2)) {
            this.legalNull = false;
        }
        this.initializeClasses();
    }

    private static boolean isPrimitive(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < primitiveTypes.length; ++i) {
            if (!string.equals(primitiveTypes[i])) continue;
            return true;
        }
        return false;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getProductionModeDefaultValue() {
        if (this.productionModeDefaultValue != null) {
            return this.productionModeDefaultValue;
        }
        return this.defaultValue;
    }

    public Class getTypeClass() {
        if (!this.initializedClasses) {
            this.initializeClasses();
        }
        return this.typeClass;
    }

    public Class getCollectionTypeClass() {
        if (!this.initializedClasses) {
            this.initializeClasses();
        }
        return this.collectionTypeClass;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public String getLegalCheck() {
        if (this.legalChecks != null && this.legalChecks.length > 0) {
            return this.legalChecks[0];
        }
        return null;
    }

    public Object[] getLegalValues() {
        return this.legalValues;
    }

    public Long getLegalMax() {
        return this.legalMax;
    }

    public Long getLegalMin() {
        return this.legalMin;
    }

    public boolean getLegalNull() {
        return this.legalNull;
    }

    public Object getClientDefault() {
        return this.clientDefault;
    }

    public boolean isConfigurable() {
        return this.configurable;
    }

    public String getOldProp() {
        return this.oldProp;
    }

    public boolean isIs() {
        return this.isIs;
    }

    public boolean isContained() {
        return this.isContained;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public String getUnits() {
        return this.units;
    }

    public boolean isLegalValuesExtensible() {
        return this.isLegalValuesExtensible;
    }

    public String[] getLegalChecks() {
        return this.legalChecks;
    }

    public String[] getLegalResponses() {
        return this.legalResponses;
    }

    public String getLegalResponse() {
        if (this.legalResponses != null && this.legalResponses.length > 0) {
            return this.legalResponses[0];
        }
        return null;
    }

    public Integer getProtectionLevel() {
        return this.protectionLevel;
    }

    public boolean isOverrideDynamic() {
        return this.overrideDynamic;
    }

    public boolean isDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("name=" + this.getName());
        stringBuffer.append(", type=" + this.getType());
        stringBuffer.append(", readable=" + this.isReadable());
        stringBuffer.append(", writable=" + this.isWritable());
        stringBuffer.append(", dynamic=" + this.isDynamic());
        stringBuffer.append(", configurable=" + this.isConfigurable());
        stringBuffer.append(", encrypted=" + this.isEncrypted());
        stringBuffer.append(", protection level=" + this.getProtectionLevel());
        stringBuffer.append(", overrideDynamic=" + this.isOverrideDynamic());
        stringBuffer.append(", deploymentDescriptor=" + this.isDeploymentDescriptor());
        stringBuffer.append(", oldprop=" + this.oldProp);
        String string = "<null>";
        if (this.defaultValue != null) {
            string = this.defaultValue.toString();
        }
        stringBuffer.append(", defaultValue=[" + string + "]");
        stringBuffer.append(", production-mode-default=[" + this.productionModeDefaultValue + "]");
        stringBuffer.append(", legalValuesExtensible=" + this.isLegalValuesExtensible());
        if (this.legalChecks != null && this.legalChecks.length > 0) {
            for (n = 0; n < this.legalChecks.length; ++n) {
                stringBuffer.append(", @legal-" + new Integer(n).toString() + "=" + this.legalChecks[n]);
            }
        } else {
            stringBuffer.append(", @legal=" + string);
        }
        if (this.legalResponses != null && this.legalResponses.length > 0) {
            for (n = 0; n < this.legalResponses.length; ++n) {
                stringBuffer.append(", @legalResponse-" + new Integer(n).toString() + "=" + this.legalResponses[n]);
            }
        } else {
            stringBuffer.append(", @legalResponse=" + string);
        }
        if (this.defaultValue != null) {
            string = this.defaultValue.toString();
        }
        stringBuffer.append(", max: " + this.legalMax);
        stringBuffer.append(", min: " + this.legalMin);
        stringBuffer.append(", null ok: " + this.legalNull);
        if (this.legalValues != null) {
            stringBuffer.append("legalValues: ");
            for (n = 0; n < this.legalValues.length; ++n) {
                stringBuffer.append("" + this.legalValues[n]);
                if (n == this.legalValues.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    private void initializeClasses() {
        if (this.initializedClasses) {
            return;
        }
        try {
            this.typeClass = Helper.findClass(this.getType());
            if (this.collectionType != null) {
                this.collectionTypeClass = Helper.findClass(this.collectionType);
            }
            this.initializedClasses = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }

    public static class Helper {
        public static Class findClass(String string) throws ClassNotFoundException {
            if (string.equals(Long.class.getName())) {
                return Long.TYPE;
            }
            if (string.equals(Double.class.getName())) {
                return Double.TYPE;
            }
            if (string.equals(Float.class.getName())) {
                return Float.TYPE;
            }
            if (string.equals(Integer.class.getName())) {
                return Integer.TYPE;
            }
            if (string.equals(Character.class.getName())) {
                return Character.TYPE;
            }
            if (string.equals(Short.class.getName())) {
                return Short.TYPE;
            }
            if (string.equals(Byte.class.getName())) {
                return Byte.TYPE;
            }
            if (string.equals(Boolean.class.getName())) {
                return Boolean.TYPE;
            }
            if (string.equals(Void.class.getName())) {
                return Void.TYPE;
            }
            if (string.equals("long")) {
                return Long.TYPE;
            }
            if (string.equals("double")) {
                return Double.TYPE;
            }
            if (string.equals("float")) {
                return Float.TYPE;
            }
            if (string.equals("int")) {
                return Integer.TYPE;
            }
            if (string.equals("char")) {
                return Character.TYPE;
            }
            if (string.equals("short")) {
                return Short.TYPE;
            }
            if (string.equals("byte")) {
                return Byte.TYPE;
            }
            if (string.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (string.equals("void")) {
                return Void.TYPE;
            }
            if (string.endsWith("[]")) {
                Class clazz = Helper.findClass(string.substring(0, string.length() - 2));
                return Array.newInstance(clazz, 0).getClass();
            }
            return Class.forName(string);
        }

        public static Class wrapClass(Class clazz) {
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Double.TYPE) {
                return Double.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            return clazz;
        }

        public static String trimPackage(String string) {
            int n = string.lastIndexOf(46);
            int n2 = string.length();
            if (n != -1) {
                string = string.substring(n + 1, n2);
            }
            return string;
        }
    }
}

