/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.tools;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.InstanceNotFoundException;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import weblogic.management.Helper;
import weblogic.management.MBeanHome;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.deploy.AutoRefreshPoller;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.tools.AutoRefreshPollerFileFilter;
import weblogic.utils.compiler.Tool;

public class AutoRefresher
extends Tool {
    public static final int DEFAULT_SLEEP_INTERVAL = 5000;
    public static final boolean DEFAULT_RECURSIVE = true;
    private static final boolean debug = false;
    private static boolean verbose = false;
    private AutoRefreshPoller poller;
    private DeployerRuntimeMBean deployer;
    private ApplicationMBean appMBean;
    private WebAppComponentMBean compMBean;
    private MBeanHome adminMBeanHome;
    private String adminURL;
    private String username;
    private String password;
    private String startDir;

    public AutoRefresher(String[] stringArray) {
        super(stringArray);
    }

    public static void main(String[] stringArray) {
        try {
            AutoRefresher autoRefresher = new AutoRefresher(stringArray);
            autoRefresher.run();
        }
        catch (Exception exception) {
            System.out.println("exception caught: " + exception.getClass().getName());
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void prepare() throws InstanceNotFoundException, NamingException {
        String string = "t3://localhost:7001";
        this.opts.addOption("adminURL", "adminURL", "(required) The URL for admin server, default is " + string);
        this.opts.addOption("username", "username", "(required) The username to connect with.");
        this.opts.addOption("password", "password", "(required) The password to connect with.");
        this.opts.addOption("sleepInterval", "sleepInterval", "(optional) The frequency of the poller runs (in seconds). Enter 0 to run once. Default sleepInterval is 5 seconds.");
        this.opts.addOption("filter", "filter", "(optional) filename extension filter. If specified, the tool will only look for files with a given extention. You may specify more than one filter in a comma separated list. Ex: -filter jsp will look for only files matching *.jsp Ex: -filter jsp,html,gif will look for only files matching *.jsp, *.html, and *.gif");
        this.opts.addFlag("recursive", "(optional) Should this tool search subdirectories.");
        this.opts.addFlag("verbose", "(optional) If specified, prints out status information. ");
        this.opts.addOption("application", "application", "The name of the Application to which your WebAppComponent belongs.");
        this.opts.addOption("component", "component", "The name of the WebAppComponent.");
        this.opts.addArgFlag("path", "path", "The path to the directory containing the application you want to monitor. This should point to the root level of the application. The path may be specified as either an absolute or a relative path");
        this.opts.setUsageArgs("path\n");
    }

    public void runBody() throws InstanceNotFoundException, NamingException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.hasRequiredParameters(stringBuffer)) {
                this.opts.setUsageHeader(stringBuffer.toString());
                this.opts.usageAndExit("weblogic.AutoRefresher");
            }
            String[] stringArray = this.opts.args();
            String string = stringArray[0];
            this.init(this.opts.getOption("adminURL"), this.opts.getOption("username"), this.opts.getOption("password"), this.opts.getOption("sleepInterval"), this.opts.getOption("application"), this.opts.getOption("component"), this.opts.getOption("filter"), this.opts.getOption("recursive"), this.opts.getOption("verbose"), string);
            this.poller.runInSameThread();
        }
        catch (AuthenticationException authenticationException) {
            throw new AuthenticationException("\nUnable to connect as user: " + this.opts.getOption("username") + ". Make sure the username and password are correct.");
        }
        catch (NamingException namingException) {
            throw new NamingException("\nUnable to connect to: " + this.opts.getOption("adminURL") + ". Make sure that the url is correct, and that the admin server is running");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.err.println(instanceNotFoundException.getMessage());
        }
        catch (Throwable throwable) {
            System.err.println("\nCaught unexpected exception: " + throwable.getClass().getName() + " " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    private void init(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws NamingException, InstanceNotFoundException {
        Object object;
        boolean bl;
        Object object2;
        Object object3;
        verbose = false;
        if (string9 != null) {
            verbose = true;
        }
        this.adminURL = string;
        this.username = string2;
        this.password = string3;
        this.startDir = string10;
        try {
            if (verbose) {
                System.out.println("");
            }
            if (verbose) {
                System.out.println("connecting to admin server: <" + string + "> application: <" + string5 + "> component: <" + string6 + ">");
            }
            this.adminMBeanHome = Helper.getAdminMBeanHome(string2, string3, string);
            object3 = this.adminMBeanHome.getMBeanServer();
            String string11 = this.adminMBeanHome.getActiveDomain().getName();
            this.appMBean = (ApplicationMBean)this.adminMBeanHome.getAdminMBean(string5, "Application", string11);
            object2 = this.appMBean.getComponents();
            for (bl = false; bl < ((ComponentMBean[])object2).length; bl += 1) {
                object = object2[bl];
                if (!object.getName().equals(string6)) continue;
                this.compMBean = (WebAppComponentMBean)object;
            }
            if (this.compMBean == null) {
                throw new InstanceNotFoundException("no web app component " + string6 + " in application " + string5);
            }
        }
        catch (ClassCastException classCastException) {
            System.err.println("no web app component " + string6 + " in application " + string5);
            this.opts.usageAndExit("weblogic.AutoRefresher");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            this.opts.usageAndExit("weblogic.AutoRefresher");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.err.println(instanceNotFoundException.getMessage());
            this.opts.usageAndExit("weblogic.AutoRefresher");
        }
        object3 = new StringBuffer();
        if (!this.workingDirMatchesDeployDir(string10, (StringBuffer)object3)) {
            System.err.println(((StringBuffer)object3).toString());
            this.opts.usageAndExit("weblogic.AutoRefresher");
        }
        int n = 5000;
        if (string4 != null && string4.length() != 0) {
            n = Integer.parseInt(string4);
        }
        object2 = null;
        if (string7 != null && string7.length() != 0) {
            object2 = new AutoRefreshPollerFileFilter(string7);
        }
        bl = true;
        if (string8 == null) {
            bl = false;
        }
        object = new File(string10);
        try {
            object = ((File)object).getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.poller = new AutoRefreshPoller((File)object, bl, n, (FileFilter)object2, this.appMBean, this.compMBean, this.adminMBeanHome, string, string2, string3, verbose);
    }

    private boolean workingDirMatchesDeployDir(String string, StringBuffer stringBuffer) {
        String string2 = this.appMBean.getPath();
        String string3 = this.compMBean.getURI();
        File file = new File(string + File.separatorChar + string3);
        if (!file.exists()) {
            stringBuffer.append("Error: Working directory stucture is inconsistent with application directory Component directory specified does not exist on the client.\nComponent path on server: " + string3 + "\n");
            return false;
        }
        String string4 = new String(new File(string2).getName());
        String string5 = new String(new File(string).getName());
        if (string5.equals(string4)) {
            return true;
        }
        stringBuffer.append("Error: Working directory stucture is inconsistent with application directory struture on the server.\nApplication directory is inconsistent\nApplication path name on server: " + string4 + "\n" + "Application path name on client: " + string5 + "\n");
        return false;
    }

    private boolean hasRequiredParameters(StringBuffer stringBuffer) {
        File file;
        String[] stringArray = this.opts.args();
        boolean bl = true;
        if (!this.opts.hasOption("adminURL")) {
            bl = false;
            stringBuffer.append("  Error: Missing required flag: adminURL.\n");
        }
        if (!this.opts.hasOption("username")) {
            bl = false;
            stringBuffer.append("  Error: Missing required flag: username.\n");
        }
        if (!this.opts.hasOption("password")) {
            bl = false;
            stringBuffer.append("  Error: Missing required flag: password.\n");
        }
        if (!this.opts.hasOption("application")) {
            bl = false;
            stringBuffer.append("  Error: Missing required flag: application.\n");
        }
        if (!this.opts.hasOption("component")) {
            bl = false;
            stringBuffer.append("  Error: Missing required flag: component.\n");
        }
        if (stringArray.length != 1) {
            bl = false;
            stringBuffer.append("  Error: Missing required argument: <path>\n");
        }
        if (stringArray.length > 1) {
            bl = false;
            stringBuffer.append("  Error: Too many args: ");
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(" ");
            }
            stringBuffer.append("\n");
        }
        if (stringArray.length > 0 && !(file = new File(stringArray[0])).exists()) {
            stringBuffer.append("  Error: Path to application does not exist:  " + file + "\n");
            bl = false;
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "\n");
        }
        return bl;
    }

    private void dumpArrayList(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer("DUMPING ARRAY LIST\n");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            stringBuffer.append("\n");
        }
        System.out.println(stringBuffer.toString());
    }

    private void dumpStringArray(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("DUMPING STRING ARRAY\n");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + "\n");
        }
        System.out.println(stringBuffer.toString());
    }
}

