/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.NotificationBroadcaster;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.tools.AttributeInfo;
import weblogic.management.tools.MBeanReflector;
import weblogic.utils.AssertionError;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.BadOutputException;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;

public class CachingMBeanGenerator
extends CodeGenerator {
    public static final String CLASS_SUFFIX = "_Stub";
    private static final String VERBOSE = "verbose";
    private static final String PACKAGE = "package";
    private static final Set excludeClassList = new HashSet<Object>(Arrays.asList((Object[])new String[]{"weblogic.management.configuration.AdminMBean"}));
    private static final Set excludeOperationsList = new HashSet<Object>(Arrays.asList((Object[])new String[]{"registerConfigMBean", "unRegisterConfigMBean"}));
    private boolean verbose;
    private Output currentOutput;
    private Method method;
    private MBeanReflector.Attribute attribute;
    private MBeanReflector reflector;
    private Set attributeSet;
    private String attributeName;
    private String attributeFieldName;

    public CachingMBeanGenerator(Getopt2 getopt2) {
        super(getopt2);
        getopt2.addFlag(VERBOSE, "Verbose output.");
        getopt2.setUsageArgs("[directory|file]");
    }

    public Enumeration outputs(Object[] objectArray) throws Exception {
        try {
            Hashtable<Output, Output> hashtable = new Hashtable<Output, Output>();
            ArrayList<File> arrayList = new ArrayList<File>();
            for (int i = 0; i < objectArray.length; ++i) {
                File file = new File((String)objectArray[i]);
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getPath());
                }
                if (file.isDirectory()) {
                    this.addSourceFilesFromDir(file, arrayList);
                    continue;
                }
                arrayList.add(file);
            }
            for (File file : arrayList) {
                Class clazz;
                String string = file.getPath().replace(File.separatorChar, '.');
                if (excludeClassList.contains(string = string.substring(0, string.length() - 5)) || Throwable.class.isAssignableFrom(clazz = AttributeInfo.Helper.findClass(string))) continue;
                int n = string.lastIndexOf(46);
                String string2 = n != -1 ? string.substring(0, n) : "";
                Output output = new Output(clazz, string2);
                String string3 = output.getOutputFile().replace('/', File.separatorChar);
                File file2 = this.targetFile(string3, output.getPackage());
                if (file.lastModified() <= file2.lastModified()) continue;
                this.verbose(file + " has changed, regenerating.");
                hashtable.put(output, output);
            }
            return hashtable.elements();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public String genAuthor() {
        return "@author";
    }

    public String genPackageDeclaration() {
        String string = this.currentOutput.getPackage();
        return string == null ? "" : "package " + string + ";";
    }

    public String genClassName() {
        return this.currentOutput.getClassName();
    }

    public String genInterfaceName() {
        return this.currentOutput.getInterface().getName();
    }

    public String genOptionalSVUID() {
        try {
            return "private static final long serialVersionUID = " + this.currentOutput.getInterface().getDeclaredField("CACHING_STUB_SVUID").getLong(null) + "L;";
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Throwable)illegalAccessException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return "";
        }
    }

    public String genAccessors() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        MBeanReflector.Attribute[] attributeArray = this.reflector.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            this.attribute = attributeArray[i];
            stringBuffer.append(this.parse(this.getProductionRule("attributeDeclaration")));
            this.method = this.reflector.getAttributeGetMethod(this.attribute);
            if (this.method != null) {
                stringBuffer.append(this.parse(this.getProductionRule("getter")));
            }
            this.method = this.reflector.getAttributeSetMethod(this.attribute);
            if (this.method == null) continue;
            stringBuffer.append(this.parse(this.getProductionRule("setter")));
        }
        return stringBuffer.toString();
    }

    public String genOperations() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        MBeanReflector.Operation[] operationArray = this.reflector.getOperations();
        for (int i = 0; i < operationArray.length; ++i) {
            this.method = operationArray[i].getMethod();
            if (this.method.getDeclaringClass() == NotificationBroadcaster.class || excludeOperationsList.contains(this.method.getName())) continue;
            stringBuffer.append(this.parse(this.getProductionRule("operation")));
        }
        return stringBuffer.toString();
    }

    public String genOperationBody() throws CodeGenerationException {
        if (this.method.getReturnType() == Void.TYPE) {
            return this.parse(this.getProductionRule("voidOperationBody"));
        }
        return this.parse(this.getProductionRule("operationBody"));
    }

    public String genAttributeCacheInvalidatorFragment() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        MBeanReflector.Attribute[] attributeArray = this.reflector.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            this.attribute = attributeArray[i];
            stringBuffer.append(this.parse(this.getProductionRule("attributeCacheInvalidator")));
        }
        return stringBuffer.toString();
    }

    public String genAttributeName() {
        return this.attribute.getName();
    }

    public String genAttributeFieldName() {
        return this.attribute.getFieldName();
    }

    public String genAttributeTempName() {
        return this.attribute.getFieldName() + "Temp";
    }

    public String genAttributeType() {
        return this.prettyPrintType(this.attribute.getType());
    }

    public String genAttributeIsCached() {
        return this.attribute.getFieldName() + "IsCached";
    }

    public String genMethodName() {
        return this.method.getName();
    }

    public String genParameterList() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getParameterTypes();
        if (classArray.length > 0) {
            for (int i = 0; i < classArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.prettyPrintType(classArray[i]) + " arg" + i);
            }
        }
        return stringBuffer.toString();
    }

    public String genTypeCastedExpressionforReturnedObject() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = this.method.getReturnType();
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                stringBuffer.append("((Integer)returnedObject).intValue()");
            } else if (clazz == Long.TYPE) {
                stringBuffer.append("((Long)returnedObject).longValue()");
            } else if (clazz == Boolean.TYPE) {
                stringBuffer.append("((Boolean)returnedObject).booleanValue()");
            } else if (clazz == Double.TYPE) {
                stringBuffer.append("((Double)returnedObject).doubleValue()");
            }
        } else if (clazz.isArray()) {
            stringBuffer.append("(" + clazz.getComponentType().getName() + "[]) returnedObject");
        } else {
            stringBuffer.append("(" + clazz.getName() + ") returnedObject");
        }
        return stringBuffer.toString();
    }

    public String resetAttributeField() {
        if (this.attribute.getType() == Integer.TYPE) {
            return "0";
        }
        if (this.attribute.getType() == Long.TYPE) {
            return "0";
        }
        if (this.attribute.getType() == Double.TYPE) {
            return "0";
        }
        if (this.attribute.getType() == Boolean.TYPE) {
            return "false";
        }
        return "null";
    }

    public String genParameters() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getParameterTypes();
        if (classArray.length > 0) {
            for (int i = 0; i < classArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                if (classArray[i].isPrimitive()) {
                    stringBuffer.append("new " + AttributeInfo.Helper.wrapClass(classArray[i]).getName() + "(");
                }
                stringBuffer.append("arg" + i);
                if (!classArray[i].isPrimitive()) continue;
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    public String genReturnType() {
        return this.prettyPrintType(this.method.getReturnType());
    }

    public String genSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getParameterTypes();
        if (classArray.length > 0) {
            for (int i = 0; i < classArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("\"" + classArray[i].getName() + "\"");
            }
        }
        return stringBuffer.toString();
    }

    public String genThrowsClause() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getExceptionTypes();
        if (classArray.length != 0) {
            stringBuffer.append("throws ");
            for (int i = 0; i < classArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(classArray[i].getName());
            }
        }
        return stringBuffer.toString();
    }

    public String genThrowException() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getExceptionTypes();
        if (classArray.length != 0) {
            String string;
            int n;
            for (n = 0; n < classArray.length; ++n) {
                string = classArray[n].getName();
                if (this.method.getDeclaringClass() == ServerRuntimeMBean.class && (this.method.getName().equals("shutdown") || this.method.getName().equals("forceShutdown"))) {
                    stringBuffer.append("\n\tif (thr instanceof weblogic.rmi.extensions.RemoteRuntimeException) {return;}");
                }
                stringBuffer.append("\n\tif (thr instanceof RuntimeException) throw (RuntimeException)thr; ");
                stringBuffer.append("\n\tif (thr instanceof " + string + ") throw (" + string + ")thr;");
            }
            stringBuffer.append("\n\tif (thr instanceof MBeanException) {");
            stringBuffer.append("\n\t\tThrowable target = ((MBeanException)thr).getTargetException();");
            for (n = 0; n < classArray.length; ++n) {
                string = classArray[n].getName();
                stringBuffer.append("\n\t\tif (target instanceof " + string + ") throw (" + string + ")target;");
            }
            stringBuffer.append("\n\t}");
        }
        stringBuffer.append("\n\tthrow new ManagementRuntimeException(thr);");
        return stringBuffer.toString();
    }

    protected void extractOptionValues(Getopt2 getopt2) {
        this.verbose = getopt2.hasOption(VERBOSE);
    }

    protected void prepare(CodeGenerator.Output output) throws BadOutputException {
        this.currentOutput = (Output)output;
        this.reflector = new MBeanReflector(this.currentOutput.getInterface());
    }

    private void addSourceFilesFromDir(File file, List list) throws Exception {
        this.verbose("Looking in " + file.getCanonicalPath());
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toLowerCase().endsWith("mbean.java")) continue;
            File file2 = new File(file, stringArray[i]);
            list.add(file2);
        }
    }

    private String prettyPrintType(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getComponentType().getName() + "[]";
        }
        return clazz.getName();
    }

    private void verbose(String string) {
        if (this.verbose) {
            this.info(string);
        }
    }

    private void info(String string) {
        System.out.println("<MBean Compiler>" + string);
    }

    private static class Output
    extends CodeGenerator.Output {
        private Class ifc;
        private String clazz;

        public Output(Class clazz, String string) {
            super(Output.getFileName(clazz), "CachingMBean.j", string);
            this.ifc = clazz;
        }

        public static String getClassName(Class clazz) {
            String string = clazz.getName();
            int n = string.lastIndexOf(46);
            if (n > -1) {
                return string.substring(n + 1) + CachingMBeanGenerator.CLASS_SUFFIX;
            }
            return string + CachingMBeanGenerator.CLASS_SUFFIX;
        }

        private static String getFileName(Class clazz) {
            return Output.getClassName(clazz) + ".java";
        }

        public String getClassName() {
            return Output.getClassName(this.ifc);
        }

        public Class getInterface() {
            return this.ifc;
        }
    }
}

