/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.tools;

import java.util.Locale;
import java.util.StringTokenizer;
import weblogic.management.tools.DefaultValue;
import weblogic.management.tools.TaggedMethod;
import weblogic.utils.Debug;

class DTDMethod
implements Comparable {
    private TaggedMethod m_taggedMethod;
    private String m_signature;
    private String m_methodName;
    private String m_dtdTag;
    private String m_returnType;
    private DefaultValue m_defaultValue;

    public DTDMethod(TaggedMethod taggedMethod, String string, String string2, DefaultValue defaultValue) {
        this.m_taggedMethod = taggedMethod;
        this.m_signature = string;
        this.m_dtdTag = string2;
        this.m_defaultValue = defaultValue;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = stringTokenizer.nextToken();
        this.m_returnType = stringTokenizer.nextToken();
        this.m_methodName = stringTokenizer.nextToken();
        int n = this.m_methodName.indexOf("(");
        if (n != -1) {
            this.m_methodName = this.m_methodName.substring(0, n);
        }
    }

    public DTDMethod(String string) {
        this.m_methodName = string;
    }

    public static String toElementName(String string) {
        String string2 = new String();
        int n = string.indexOf("MBean");
        if (-1 != n) {
            string = string.substring(0, n);
        }
        string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = n2;
            while (n2 < string.length() && Character.isUpperCase(string.charAt(n2))) {
                ++n2;
            }
            if (n2 - n3 <= 1) {
                while (n2 < string.length() && !Character.isUpperCase(string.charAt(n2))) {
                    ++n2;
                }
            } else {
                --n2;
            }
            if (n3 > 0 && n3 < string.length() - 1) {
                string2 = string2 + "-";
            }
            string2 = string2 + string.substring(n3, n2).toLowerCase(Locale.US);
        }
        return string2;
    }

    static String getFieldName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
        for (int i = 1; !(i >= string.length() || Character.isLowerCase(stringBuffer.charAt(i)) || i + 1 < string.length() && Character.isLowerCase(stringBuffer.charAt(i + 1))); ++i) {
            stringBuffer.setCharAt(i, Character.toLowerCase(stringBuffer.charAt(i)));
        }
        return stringBuffer.toString();
    }

    private static String unprefixField(String string, String string2) {
        if (0 != string2.indexOf(string)) {
            throw new RuntimeException("Field '" + string2 + "' does not start with '" + string + "'");
        }
        int n = string.length();
        char c = Character.toLowerCase(string2.charAt(n));
        return c + string2.substring(n + 1);
    }

    public TaggedMethod getTaggedMethod() {
        return this.m_taggedMethod;
    }

    public boolean isBoolean() {
        return -1 != this.m_returnType.indexOf("boolean");
    }

    public boolean isString() {
        return -1 != this.m_returnType.indexOf("tring");
    }

    public boolean isPrimitiveStrict() {
        return this.isBoolean() || -1 != this.m_returnType.indexOf("int");
    }

    public boolean isPrimitiveOrString() {
        return this.isPrimitiveStrict() || this.isString();
    }

    public String getDTDTag() {
        return this.m_dtdTag;
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public String getReturnType() {
        return this.m_returnType;
    }

    public boolean isMBean() {
        return -1 != this.getReturnType().indexOf("MBean");
    }

    public boolean isOr() {
        return -1 != this.getDTDTag().indexOf("|");
    }

    public boolean isOptional() {
        return -1 != this.getDTDTag().indexOf("?");
    }

    public boolean isMandatory() {
        return !this.isOr() && !this.isOptional();
    }

    public boolean isArray() {
        return -1 != this.getSignature().indexOf("[]");
    }

    public int getDTDOrder() {
        String string = this.getDTDTag();
        int n = string.length();
        if (this.isOr()) {
            n = string.indexOf("|");
        } else if (this.isOptional()) {
            n = string.indexOf("?");
        }
        Debug.assertion((-1 != n ? 1 : 0) != 0, (String)(this.getMethodName() + " tag:" + string));
        return new Integer(string.substring(0, n));
    }

    public int compareTo(Object object) {
        DTDMethod dTDMethod = (DTDMethod)object;
        return this.getDTDTag().compareTo(dTDMethod.getDTDTag());
    }

    public String capitalizeIfBoolean(String string) {
        String string2 = string + "()";
        if (this.isBoolean()) {
            string2 = "ToXML.capitalize(Boolean.valueOf(" + string2 + ").toString())";
        }
        return string2;
    }

    public StringBuffer toXMLIfNotNullAndNotDefault(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isBoolean() || !this.isPrimitiveOrString()) {
            if (!this.isPrimitiveOrString()) {
                stringBuffer.append(string).append("if (" + this.testForNull() + ") {\n");
            }
            if (null != this.m_defaultValue) {
                stringBuffer.append(string).append("  ").append("if (" + this.testForDefault() + ") {\n");
            }
            stringBuffer.append(string).append("    ").append(this.toXML());
            if (null != this.m_defaultValue) {
                stringBuffer.append(string).append("  ").append("}\n");
            }
            if (!this.isPrimitiveOrString()) {
                stringBuffer.append(string).append("}\n");
            }
        } else {
            if (null != this.m_defaultValue) {
                stringBuffer.append(string).append("if (" + this.testForDefault() + ") {\n");
            }
            stringBuffer.append(string).append("  ").append(this.toXML());
            if (null != this.m_defaultValue) {
                stringBuffer.append(string).append("}\n");
            }
        }
        return stringBuffer;
    }

    public StringBuffer toXMLForOr(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append("  if (" + this.testForNotNullForOr() + ") {\n");
        stringBuffer.append(string).append("    ").append(this.toXML());
        stringBuffer.append(string).append("  }\n");
        return stringBuffer;
    }

    public StringBuffer toXMLIfNotNull(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isBoolean() || !this.isPrimitiveOrString()) {
            stringBuffer.append(string).append("if (" + this.testForNull() + ") {\n");
            stringBuffer.append(string).append("    ").append(this.toXML());
            stringBuffer.append(string).append("}\n");
        } else {
            stringBuffer.append(string).append(this.toXML());
        }
        return stringBuffer;
    }

    public String toXML() {
        String string = "";
        boolean bl = this.getTaggedMethod().containsTag("@cdata");
        boolean bl2 = this.getTaggedMethod().containsTag("@empty");
        if (this.getMethodName().indexOf("get") != 0 && this.getMethodName().indexOf("is") != 0) {
            throw new RuntimeException("Illegal @dtd-order found on a  method that is not a getter:" + this.getMethodName());
        }
        String string2 = this.getMethodName().substring("get".length());
        if (0 == this.getMethodName().indexOf("is")) {
            string2 = this.getMethodName().substring("is".length());
        }
        if (!this.isMBean()) {
            String string3 = DTDMethod.toElementName(string2);
            if (this.isArray()) {
                if ('s' == string3.charAt(string3.length() - 1)) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                string = string + "for (int i = 0; i < " + this.getMethodName() + "().length; i++) {\n";
                string = string + "        result";
                string = string + ".append(ToXML.indent(indentLevel + 2))";
                if (!bl2) {
                    string = string + ".append(\"<" + string3 + ">\")";
                    string = string + ".append(" + this.wrap(bl, this.getMethodName() + "()[i]") + ")";
                    string = string + ".append(\"</" + string3 + ">\\n\");\n";
                } else {
                    string = string + ".append((" + this.getMethodName() + "() ? \"<" + string3 + "/>\\n\" : \"\")" + ");\n";
                }
                string = string + "    }\n";
            } else {
                if (this.isString()) {
                    string = string + "if (" + this.testForNull() + ") {\n    ";
                }
                string = string + "  result";
                string = string + ".append(ToXML.indent(indentLevel + 2))";
                if (!bl2) {
                    String string4 = this.capitalizeIfBoolean(this.getMethodName());
                    string = string + ".append(\"<" + string3 + ">\")";
                    string = string + ".append(" + this.wrap(bl, string4) + ")";
                    string = string + ".append(\"</" + string3 + ">\\n\");\n";
                } else {
                    string = string + ".append((" + this.getMethodName() + "() ? \"<" + string3 + "/>\\n\" : \"\")" + ");\n";
                }
                if (this.isString()) {
                    string = string + "    }\n";
                }
            }
        } else if (this.isArray()) {
            string = string + "for (int i = 0; i < " + this.getMethodName() + "().length; i++) {\n";
            string = string + "          result.append(" + this.getMethodName() + "()[i].toXML(indentLevel + 2));\n";
            string = string + "}\n";
        } else {
            string = "result.append(" + this.getMethodName() + "().toXML(indentLevel + 2)).append(\"\\n\");\n";
        }
        return string;
    }

    public String testForNull() {
        if (this.isBoolean()) {
            return this.getMethodName() + "()";
        }
        return "null != " + this.getMethodName() + "()";
    }

    public String toElementName() {
        return DTDMethod.toElementName(this.getMethodName());
    }

    public String toString() {
        return "[Method:" + this.getMethodName() + " dtd:" + this.getDTDTag() + "]";
    }

    private String wrap(boolean bl, String string) {
        String string2 = string;
        if (bl) {
            string2 = "\"<![CDATA[\" + " + string + " + \"]]>\"";
        }
        return string2;
    }

    private String testForDefault() {
        String string = null;
        String string2 = null;
        if (this.getMethodName().startsWith("get")) {
            string = "get";
        } else if (this.getMethodName().startsWith("is")) {
            string = "is";
        }
        string2 = DTDMethod.getFieldName(this.getMethodName().substring(string.length()));
        if (null != this.m_defaultValue) {
            return "((isSet_" + string2 + ")" + " || " + " ! (" + this.m_defaultValue.testForEquality(this.getMethodName() + "())") + ")";
        }
        return "";
    }

    private String testForNotNullForOr() {
        String string = null;
        String string2 = null;
        if (this.getMethodName().startsWith("get")) {
            string = "get";
        } else if (this.getMethodName().startsWith("is")) {
            string = "is";
        }
        string2 = DTDMethod.getFieldName(this.getMethodName().substring(string.length()));
        if (this.isPrimitiveOrString()) {
            if (null != this.m_defaultValue) {
                return "((isSet_" + string2 + ")" + " || " + " ! (" + this.m_defaultValue.testForEquality(this.getMethodName() + "())") + ")";
            }
            return "isSet_" + string2;
        }
        if (this.isBoolean()) {
            return this.getMethodName();
        }
        return this.testForNull();
    }
}

