/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

class FileString {
    private String[] m_file;
    private String m_fileName;
    private int m_current;

    public FileString(String string) throws FileNotFoundException, IOException {
        this.m_fileName = string;
        this.m_file = FileString.readFileInBuffer(string);
        this.m_current = 0;
    }

    private static String[] readFileInBuffer(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = bufferedReader.readLine();
        while (null != string2) {
            arrayList.add(string2);
            string2 = bufferedReader.readLine();
        }
        String[] stringArray = new String[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)iterator.next();
        }
        return stringArray;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public int getCurrentIndex() {
        return this.m_current;
    }

    public String getPackageName() {
        String string = null;
        String[] stringArray = this.grep("package");
        if (stringArray.length > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0]);
            stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            int n = string.indexOf(";");
            string = string.substring(0, n);
        }
        return string;
    }

    public String getImportClass(String string) {
        String[] stringArray = this.grep("import");
        for (int i = 0; i < stringArray.length; ++i) {
            if (-1 == stringArray[i].indexOf(string)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i]);
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(";");
            return string2.substring(0, n);
        }
        return null;
    }

    public String getSuperClassName() {
        String string = null;
        String string2 = new String();
        Integer[] integerArray = this.grepByLineNumber("extends");
        if (integerArray.length > 0) {
            int n = integerArray[0];
            String string3 = this.readLine(n++);
            string2 = string2 + string3;
            while (-1 == string3.indexOf("{")) {
                string3 = this.readLine(n++);
                string2 = string2 + " " + string3;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            boolean bl = false;
            while (!bl && stringTokenizer.hasMoreTokens()) {
                bl = stringTokenizer.nextToken().equals("extends");
            }
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    public String toString() {
        return this.getFileName();
    }

    public String readAndAdvance() {
        String string = this.readCurrent();
        ++this.m_current;
        return string;
    }

    public String readCurrent() {
        String string = this.m_file[this.m_current];
        return string;
    }

    public String readLine(int n) {
        return this.m_file[n];
    }

    public void advance() {
        ++this.m_current;
    }

    public String[] grep(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_file.length; ++i) {
            if (-1 == this.m_file[i].indexOf(string)) continue;
            arrayList.add(this.m_file[i]);
        }
        String[] stringArray = new String[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)iterator.next();
        }
        return stringArray;
    }

    public Integer[] grepByLineNumber(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.m_file.length; ++i) {
            if (-1 == this.m_file[i].indexOf(string)) continue;
            arrayList.add(new Integer(i));
        }
        Integer[] integerArray = new Integer[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        for (int i = 0; i < integerArray.length; ++i) {
            integerArray[i] = (Integer)iterator.next();
        }
        return integerArray;
    }

    public boolean eof() {
        return this.m_current >= this.m_file.length;
    }
}

