/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import weblogic.management.info.ExtendedAttributeInfo;
import weblogic.management.info.ExtendedInfo;
import weblogic.management.info.ExtendedOperationInfo;
import weblogic.management.tools.AttributeInfo;
import weblogic.utils.StringUtils;

public class Info
extends ExtendedInfo {
    static final long serialVersionUID = 1L;
    private static boolean listProtectedAttributesInfo = Boolean.getBoolean("weblogic.management.tools.Info.listProtectedAttributesInfo");
    private static boolean verbose = false;
    private static boolean replacedChars = false;
    private static PrintStream infoOut = System.out;
    private String[] interfaces;
    private String shortInterfaceName = null;

    public Info(String string, String[] stringArray, String string2, ExtendedAttributeInfo[] extendedAttributeInfoArray, MBeanConstructorInfo[] mBeanConstructorInfoArray, ExtendedOperationInfo[] extendedOperationInfoArray, MBeanNotificationInfo[] mBeanNotificationInfoArray, boolean bl, boolean bl2, boolean bl3, String string3, String string4, String string5, boolean bl4, String string6) {
        super(string, string2, Info.permute(string, (AttributeInfo[])extendedAttributeInfoArray), mBeanConstructorInfoArray, (MBeanOperationInfo[])extendedOperationInfoArray, mBeanNotificationInfoArray, bl, bl2, bl3, string3, string4, string5, bl4, string6);
        this.interfaces = stringArray;
    }

    public static void main(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-verbose".equals(stringArray[i])) {
                verbose = true;
                continue;
            }
            if (stringArray[i].charAt(0) == '-') {
                System.err.println("Usage: java weblogic.management.tools.Info [-verbose] [<filename>]\nThis tool ASSUMES it is being run from the src root and it assumes that all MBeans live under weblogic/management\nerrors are printed on System.err and all the \"results\" go to .out or the file specified as an argument\neg. java -Dweblogic.management.tools.Info.listProtectedAttributesInfo=true weblogic.management.tools.Info > /temp/protectedAttributeNames.properties\neg. java weblogic.management.tools.Info > /temp/attributeNames.properties");
                System.exit(0);
            }
            infoOut = new PrintStream(new FileOutputStream(stringArray[i]));
        }
        infoOut.println("#Please do not Edit this file, use \"java -Dweblogic.management.tools.Info.listProtectedAttributesInfo=<true/false> weblogic.management.tools.Info\" to recreate this file");
        infoOut.println("#Generated on " + new Date());
        Info.walk(new File("weblogic/management"));
    }

    private static AttributeInfo[] permute(String string, AttributeInfo[] attributeInfoArray) {
        int n;
        Properties properties = new Properties();
        try {
            properties.load(Info.class.getResourceAsStream("attributeNames.properties"));
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            string2 = "";
        }
        String[] stringArray = StringUtils.splitCompletely((String)string2, (String)",");
        AttributeInfo[] attributeInfoArray2 = new AttributeInfo[attributeInfoArray.length];
        TreeMap<String, AttributeInfo> treeMap = new TreeMap<String, AttributeInfo>();
        for (n = 0; n < attributeInfoArray.length; ++n) {
            treeMap.put(attributeInfoArray[n].getName(), attributeInfoArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            attributeInfoArray2[n] = (AttributeInfo)treeMap.remove(stringArray[n]);
            if (attributeInfoArray2[n] != null) continue;
            throw new Error("deleted attribute: " + stringArray[n]);
        }
        n = stringArray.length;
        Iterator iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            attributeInfoArray2[n++] = (AttributeInfo)iterator.next();
        }
        return attributeInfoArray2;
    }

    private static String printAttribute(MBeanAttributeInfo mBeanAttributeInfo) {
        return ((Object)mBeanAttributeInfo).toString();
    }

    private static void walk(File file) {
        final String string = file.getPath() + File.separatorChar;
        if (verbose) {
            System.err.println("walking : " + file);
        }
        if (file.isDirectory() && file.getName().indexOf("console") < 0) {
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string2) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    Info.checkFileName(string + string2);
                    return false;
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                Info.walk(fileArray[i]);
            }
        } else {
            Info.checkFileName(file.getPath());
        }
    }

    private static void checkFileName(String string) {
        if (string.endsWith("MBean.java") && (string.indexOf("descriptors") < 0 || listProtectedAttributesInfo)) {
            if (verbose) {
                System.err.println("checkFileName : " + string);
            }
            string = string.substring(0, string.length() - ".java".length()) + ".mbi";
            if (File.separatorChar != '/') {
                string = string.replace(File.separatorChar, '/');
                replacedChars = true;
            }
            Info.listAttributesForInfo(string);
        }
    }

    private static void listAttributesForInfo(String string) {
        InputStream inputStream = Info.class.getClassLoader().getResourceAsStream(string);
        try {
            if (inputStream != null) {
                char c;
                Info info = (Info)new ObjectInputStream(inputStream).readObject();
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = ",";
                MBeanAttributeInfo[] mBeanAttributeInfoArray = info.getAttributes();
                for (c = '\u0000'; c < mBeanAttributeInfoArray.length; ++c) {
                    ExtendedAttributeInfo extendedAttributeInfo;
                    if (!listProtectedAttributesInfo) {
                        stringBuffer.append(mBeanAttributeInfoArray[c].getName()).append(string2);
                        continue;
                    }
                    if (!listProtectedAttributesInfo || !(extendedAttributeInfo = (ExtendedAttributeInfo)((Object)mBeanAttributeInfoArray[c])).isEncrypted() && extendedAttributeInfo.getProtectionLevel() <= 0) continue;
                    stringBuffer.append(mBeanAttributeInfoArray[c].getName()).append(string2);
                }
                if (stringBuffer.toString().endsWith(string2)) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                string = string.substring(0, string.indexOf(".mbi"));
                c = File.separatorChar;
                if (replacedChars) {
                    c = '/';
                }
                string = string.replace(c, '.');
                if (listProtectedAttributesInfo && stringBuffer.toString().trim().length() != 0) {
                    infoOut.println(string + "=" + stringBuffer);
                } else if (!listProtectedAttributesInfo) {
                    infoOut.println(string + "=" + stringBuffer);
                }
            } else if (verbose) {
                System.err.println("Did not find : " + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public String getShortInterfaceName() {
        if (this.shortInterfaceName == null) {
            this.shortInterfaceName = AttributeInfo.Helper.trimPackage(this.getClassName());
        }
        return this.shortInterfaceName;
    }

    public String toString(boolean bl) {
        if (!bl) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MBeanInfo for " + this.getClassName());
        stringBuffer.append("\n\n description: " + this.getDescription());
        stringBuffer.append("\n\n customizer: " + this.getCustomizerClass());
        stringBuffer.append("\n\n Attributes:");
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.getAttributes();
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            stringBuffer.append("\n\t" + Info.printAttribute(mBeanAttributeInfoArray[i]));
        }
        stringBuffer.append("\n\n operations:");
        MBeanOperationInfo[] mBeanOperationInfoArray = this.getOperations();
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            stringBuffer.append("\n\t" + mBeanOperationInfoArray[i].getName());
        }
        return stringBuffer.toString();
    }
}

